/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.springframework.ide.eclipse.beans.ui.BeansUILabelDecorator;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.core.SpringCoreUtils;

public class MigrateSpringBeansProject
implements IObjectActionDelegate {
    private static final String BEANS_CORE_PLUGIN_ID = "org.springframework.ide.eclipse.beans.core";
    private static final String BEANS_NATURE_ID = "org.springframework.ide.eclipse.beans.core.beansnature";
    private static final String BEANS_BUILDER_ID = "org.springframework.ide.eclipse.beans.core.beansvalidator";
    private static final String BEANS_PROJECT_DESCRIPTION = ".springBeansProject";
    private List selected = new ArrayList();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selected.clear();
        if (selection instanceof IStructuredSelection) {
            boolean enabled = true;
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof IJavaProject) {
                    obj = ((IJavaProject)obj).getProject();
                }
                if (obj instanceof IProject) {
                    IProject project = (IProject)obj;
                    if (!project.isOpen()) {
                        enabled = false;
                        break;
                    }
                    this.selected.add(project);
                    continue;
                }
                enabled = false;
                break;
            }
            action.setEnabled(enabled);
        }
    }

    public void run(IAction action) {
        Iterator iter = this.selected.iterator();
        while (iter.hasNext()) {
            IProject project = (IProject)iter.next();
            this.migrateProject(project);
        }
        BeansUILabelDecorator.update();
    }

    private void migrateProject(IProject project) {
        SpringCoreUtils.removeProjectBuilder((IProject)project, (String)BEANS_BUILDER_ID);
        SpringCoreUtils.removeProjectNature((IProject)project, (String)BEANS_NATURE_ID);
        IFile file = project.getFile((IPath)new Path(BEANS_PROJECT_DESCRIPTION));
        if (file.isAccessible()) {
            try {
                file.move((IPath)new Path(".springBeans"), true, null);
            }
            catch (CoreException e) {
                BeansUIPlugin.log(e);
            }
        }
        SpringCoreUtils.addProjectNature((IProject)project, (String)"org.springframework.ide.eclipse.core.springnature");
    }
}

