
#include "replaygain_plugins.h"
#include "tools.h"

#include <qfile.h>
#include <qfileinfo.h>
#include <qdir.h>

#include <klocale.h>
#include <kstandarddirs.h>


ReplayGainPlugins::PluginStructure::PluginStructure()
{
    PluginStructure(i18n("Unnamed"));
}

ReplayGainPlugins::PluginStructure::PluginStructure(QString name)
{
    info.name=name;
}

ReplayGainPlugins::PluginStructure::~PluginStructure()
{
}

ReplayGainPlugins::ReplayGainPlugins()
{
    load();
}

bool ReplayGainPlugins::loadFile(QString fileName)
{
    QString inFiles;
    QString info_about, info_short_info, info_author, info_version, info_name;
    QString replaygain_bin, replaygain_track, replaygain_force, replaygain_param, replaygain_max_version, replaygain_remove, replaygain_min_version, replaygain_album, replaygain_mime_types, replaygain_formats, replaygain_level, replaygain_silent_param;
    QString replaygain_test_param, replaygain_test_output_yes, replaygain_test_output_no, replaygain_test_enabled;
    int t_int;

    QFile opmlFile( fileName );
    if ( !opmlFile.open( IO_ReadOnly ) ) {
        return false;
    }
    if ( !domTree.setContent( &opmlFile ) ) {
        return false;
    }
    opmlFile.close();

    QDomElement root = domTree.documentElement();
    if( root.attribute("type") != "replaygain" ) return false;
    inFiles=root.attribute("inFiles");
    QDomNode node;
    node = root.firstChild();
    while ( !node.isNull() ) {
        if ( node.isElement() && node.nodeName() == "info" ) {
            info_about=node.toElement().attribute("about");
            info_short_info=node.toElement().attribute("short_info");
            info_author=node.toElement().attribute("author");
            info_version=node.toElement().attribute("version");
            info_name=node.toElement().attribute("name");
            break;
        }
        node = node.nextSibling();
    }
    while ( !node.isNull() ) {
        if ( node.isElement() && node.nodeName() == "replaygain" ) {
            replaygain_bin=node.toElement().attribute("bin");
            replaygain_track=node.toElement().attribute("track");
            replaygain_force=node.toElement().attribute("force");
            replaygain_param=node.toElement().attribute("param");
            replaygain_max_version=node.toElement().attribute("max_version");
            replaygain_remove=node.toElement().attribute("remove");
            replaygain_min_version=node.toElement().attribute("min_version");
            replaygain_album=node.toElement().attribute("album");
            replaygain_mime_types=node.toElement().attribute("mimeTypes");
            replaygain_formats=node.toElement().attribute("formats");
            replaygain_level=node.toElement().attribute("level");
            replaygain_silent_param=node.toElement().attribute("silent_param");
            node = node.toElement().firstChild();
            while ( !node.isNull() ) {
                if ( node.isElement() && node.nodeName() == "test" ) {
                    replaygain_test_param=node.toElement().attribute("param");
                    replaygain_test_output_yes=node.toElement().attribute("output_yes");
                    replaygain_test_output_no=node.toElement().attribute("output_no");
                    replaygain_test_enabled=node.toElement().attribute("enabled");
                    break;
                }
                node = node.nextSibling();
            }
            break;
        }
        node = node.nextSibling();
    }

    PluginStructureList::Iterator it=plugins.append(PluginStructure(info_name));
    (*it).inFiles=inFiles;
    (*it).file_name=fileName;
    (*it).info.about=info_about;
    (*it).info.short_info=info_short_info;
    (*it).info.author=info_author;
    sscanf(info_version,"%i",&t_int);
    (*it).info.version=t_int;
    (*it).replaygain.bin=replaygain_bin;
    (*it).replaygain.track=replaygain_track;
    (*it).replaygain.force=replaygain_force;
    (*it).replaygain.param=replaygain_param;
    sscanf(replaygain_max_version,"%i",&t_int);
    (*it).replaygain.max_version=t_int;
    (*it).replaygain.remove=replaygain_remove;
    sscanf(replaygain_min_version,"%i",&t_int);
    (*it).replaygain.min_version=t_int;
    (*it).replaygain.album=replaygain_album;
    (*it).replaygain.mime_types=replaygain_mime_types;
    (*it).replaygain.formats=QStringList::split(',',replaygain_formats);
    if( replaygain_level == "Full" ) (*it).replaygain.level=Full;
    else if( replaygain_level == "Most" ) (*it).replaygain.level=Most;
    else (*it).replaygain.level=Basic;
    (*it).replaygain.silent_param=replaygain_silent_param;
    (*it).replaygain.test.param=replaygain_test_param;
    (*it).replaygain.test.output_yes=replaygain_test_output_yes;
    (*it).replaygain.test.output_no=replaygain_test_output_no;
    if( replaygain_test_enabled == "true" ) (*it).replaygain.test.enabled=true;
    else if( replaygain_test_enabled == "false" ) (*it).replaygain.test.enabled=false;

    return true;
}

void ReplayGainPlugins::load()
{
    QStringList list;
    QDir dir;
    QFileInfo file;
    bool add;

    KStandardDirs stddir;
    QStringList directories = stddir.findDirs("data","soundkonverter/plugins");
    for( QStringList::Iterator jt=directories.begin(); jt!=directories.end(); ++jt )
    {
        dir.setPath(*jt);
        list=dir.entryList("*",QDir::All,QDir::Name);
        for( QStringList::Iterator it=list.begin(); it!=list.end(); ++it )
        {
            if( *it != "." && *it != ".." && (*it).find("soundkonverter.xml") != -1 )
            {
                add=true;

                for( PluginStructureList::Iterator kt=plugins.begin(); kt!=plugins.end(); ++kt )
                {
                    //if( tools.fileName((*kt).file_name) == (*it) )
                    if( tools.fileName((*kt).file_name).left(3) == (*it).left(3) )
                    {
                        add=false;
                        break;
                    }
                }

                if(add)
                {
                    file.setFile((*jt)+(*it));
                    if( file.isFile() ) {
                        loadFile((*jt)+(*it));
                    }
                }
            }
        }
    }
}

void ReplayGainPlugins::reload()
{
    plugins.clear();
    load();
    //prefs.rebuildFormatList(); // Not required here only in backend_plugins.cpp
}

void ReplayGainPlugins::unload(QString plugin)
{
    for( PluginStructureList::Iterator it=plugins.begin(); it!=plugins.end(); ++it )
    {
        if( (*it).info.name == plugin ) { plugins.remove(it); break; }
    }
}

void ReplayGainPlugins::remove(QString plugin)
{
    for( PluginStructureList::Iterator it=plugins.begin(); it!=plugins.end(); ++it )
    {
        if( (*it).info.name == plugin ) {
            plugins.remove(it);
            QFile::remove((*it).file_name); // TODO fehlermeldung bei fehlschlag
            break;
        }
    }
}

QStringList ReplayGainPlugins::loadedPlugins()
{
    QStringList list;

    for( PluginStructureList::Iterator it=plugins.begin(); it!=plugins.end(); ++it )
    {
        list.append((*it).info.name);
    }

    return list;
}

ReplayGainPlugins::PluginStructure ReplayGainPlugins::plugin(QString bin)
{
    for( PluginStructureList::Iterator it=plugins.begin(); it!=plugins.end(); ++it )
    {
        if( (*it).replaygain.bin == bin ) return *it;
    }

    return ReplayGainPlugins::PluginStructure(i18n("Unnamed")); // NOTE irgendwo wird ein ungültiger Parameter übergeben -> fehler
}

ReplayGainPlugins::PluginStructure ReplayGainPlugins::pluginByFormat(QString format)
{
    for( PluginStructureList::Iterator it=plugins.begin(); it!=plugins.end(); ++it )
    {
        if( (*it).replaygain.formats.findIndex(format) != -1 ) return *it;
    }

    return ReplayGainPlugins::PluginStructure(i18n("Unnamed")); // NOTE irgendwo wird ein ungültiger Parameter übergeben -> fehler
}

