

#ifndef _OPTIONS_DETAILED_H_
#define _OPTIONS_DETAILED_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>

class QLabel;
class QComboBox;
class QSpinBox;
class QCheckBox;
//class QPushButton;
class QStringList;

/**
 * @short Options detailed
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class OptionsDetailed : public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    OptionsDetailed( QWidget *parent=0, const char *name=0 );

    /**
     * Default Destructor
     */
    virtual ~OptionsDetailed();

    QLabel *lConvert;
    QComboBox *cFormat;
    QStringList sFormat;
    QComboBox *cQualityMode;
    QStringList sQualityMode;
    QSpinBox *sQuality;
    QComboBox *cBitrateMode;
    QStringList sBitrateMode;

    QCheckBox *cBitrateRange;
    QSpinBox *sMinBitrate;
    QLabel *lBitrateRangeTo;
    QSpinBox *sMaxBitrate;
    QLabel *lBitrateRangeUnit;

    QCheckBox *cResample;
    QComboBox *cSampleRate;
    QLabel *lSampleRateUnit;
    QCheckBox *cChannels;
    QComboBox *cNumChannels;
    QStringList sNumChannels;
    QCheckBox *cReplayGain;
    //QPushButton *pMoreOptions;

    QString getFormat();
    QString getQualityMode();
    int getQuality();
    bool getBitrateRange();
    bool getResample();
    int getSampleRate();
    bool getChannels();
    QString getNumChannels();
    int formatIndex( QString string );

public slots:
    void formatChanged();
    void qualityModeChanged();
    void bitrateModeChanged();
    void bitrateRangeToggled();
    void resampleToggled();
    void channelsToggled();
    //void moreOptionsClicked();

    void setFormat( QString format );
    void setQualityMode( QString qualityMode );
    void setQuality( int quality );
    //void setBitrateMode( QString bitrateMode );
    void setBitrateRange( bool enabled );
    void setResample( bool enabled );
    void setSampleRate( int sampleRate );
    void setChannels( bool enabled );
    void setNumChannels( QString channels );

signals:
    //void showMoreOptions();


private:
    QString lastQualityMode;

    int qualityModeIndex( QString string );
    int bitrateModeIndex( QString string );
    int numChannelsIndex( QString string );

};

#endif // _OPTIONS_DETAILED_H_
