/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.repository.query;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.webclient.repository.query.BooleanQueryInfo;
import org.openrdf.http.webclient.repository.query.QueryFormController;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPBooleanQuery;
import org.openrdf.repository.http.HTTPQueryEvaluationException;
import org.openrdf.repository.http.HTTPRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanQueryFormController
extends QueryFormController {
    final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Override
    protected Map<String, Object> referenceData(HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        TreeMap<String, QueryLanguage> queryLanguages = new TreeMap<String, QueryLanguage>();
        queryLanguages.put(QueryLanguage.SPARQL.getName().toUpperCase(), QueryLanguage.SPARQL);
        result.put("queryLanguages", queryLanguages);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        ModelAndView result = null;
        HTTPRepository repo = (HTTPRepository)request.getSession().getAttribute("openrdf-repository");
        BooleanQueryInfo qInfo = (BooleanQueryInfo)command;
        boolean queryResult = false;
        RepositoryConnection conn = null;
        try {
            conn = repo.getConnection();
            HTTPBooleanQuery query = (HTTPBooleanQuery)conn.prepareBooleanQuery(qInfo.getQueryLanguage(), qInfo.getQueryString());
            query.setIncludeInferred(qInfo.isIncludeInferred());
            try {
                queryResult = query.evaluate();
            }
            catch (HTTPQueryEvaluationException e) {
                if (e.isCausedByMalformedQueryException()) {
                    throw e.getCauseAsMalformedQueryException();
                }
                if (e.isCausedByRepositoryException()) {
                    throw e.getCauseAsRepositoryException();
                }
                if (e.isCausedByIOException()) {
                    throw e.getCauseAsIOException();
                }
                throw e;
            }
        }
        catch (RepositoryException e) {
            this.logger.info("Unable to process query", (Throwable)e);
            errors.reject("repository.error");
        }
        catch (MalformedQueryException e) {
            errors.rejectValue("queryString", "repository.query.error.malformed", (Object[])new String[]{e.getMessage()}, "Malformed query");
        }
        catch (QueryEvaluationException e) {
            errors.reject("repository.query.error.evaluation");
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                }
            }
        }
        if (errors.hasErrors()) {
            result = this.showForm(request, response, errors, errors.getModel());
        } else {
            Map model = errors.getModel();
            model.put("answer", queryResult);
            result = new ModelAndView(this.getSuccessView(), model);
        }
        return result;
    }
}

