/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "keys.h"
#include <qkeysequence.h>
#include <qevent.h>
#include <qsettings.h>
#include "global.h"

// KeyAccel
KeyAccel::KeyAccel() {
	_function = "";
}

KeyAccel::KeyAccel( QString function, QKeySequence seq ) {
	_function = function;
	_seq = seq;
}

KeyAccel::~KeyAccel() {
}

QKeySequence KeyAccel::convertKey( QKeyEvent *e ) {
	int m = 0;
	switch (e->state()) {
		//case (Qt::ShiftButton) : m = SHIFT; break;
		case (Qt::ControlButton) : m = Qt::CTRL; break;
		case (Qt::AltButton) : m = Qt::ALT; break;
		default : m=0;
	}
	return QKeySequence( m | e->key() );
}

bool KeyAccel::check( QKeyEvent *e ) {
    #if QT_VERSION < 0x040000
    return ( _seq.matches( convertKey(e) ) == Qt::Identical );
    #else
    return ( _seq.matches( convertKey(e) ) == QKeySequence::ExactMatch );
    #endif
}


// Keys

KeyShortcuts::KeyShortcuts() {
	kl.append( KeyAccel( "OSD", Qt::Key_O ) );

	kl.append( KeyAccel( "PAUSE", Qt::Key_P ) );
	kl.append( KeyAccel( "PAUSE", Qt::Key_Space ) );

	//kl.append( KeyAccel( "PLAY_PAUSE", Qt::Key_G ) );
	kl.append( KeyAccel( "PLAY_PAUSE", Qt::Key_MediaPlay ) );

	kl.append( KeyAccel( "FRAME_STEP", Qt::Key_Period ) );
	kl.append( KeyAccel( "STOP", Qt::Key_MediaStop ) );

	kl.append( KeyAccel( "FORWARD1", Qt::Key_Right ) ); // + 10 secs
	kl.append( KeyAccel( "FORWARD1", Qt::Key_MediaNext ) ); // + 10 secs
	kl.append( KeyAccel( "FORWARD2", Qt::Key_Up ) ); // + 1 minute
	kl.append( KeyAccel( "FORWARD3", Qt::Key_Prior ) ); // + 10 minutes

	kl.append( KeyAccel( "REWIND1", Qt::Key_Left ) ); // - 10 secs
	kl.append( KeyAccel( "REWIND1", Qt::Key_MediaPrev ) ); // - 10 secs
	kl.append( KeyAccel( "REWIND2", Qt::Key_Down ) ); // - 1 minute
	kl.append( KeyAccel( "REWIND3", Qt::Key_Next ) ); // - 10 minutes

	kl.append( KeyAccel( "MUTE", Qt::Key_M ) );

	kl.append( KeyAccel( "INC_VOLUME", Qt::Key_0 ) );
	kl.append( KeyAccel( "INC_VOLUME", Qt::Key_Asterisk ) );
	kl.append( KeyAccel( "DEC_VOLUME", Qt::Key_9 ) );
	kl.append( KeyAccel( "DEC_VOLUME", Qt::Key_Slash ) );

	kl.append( KeyAccel( "INC_AUDIO_DELAY", Qt::Key_Plus ) );
	kl.append( KeyAccel( "DEC_AUDIO_DELAY", Qt::Key_Minus ) );

	kl.append( KeyAccel( "INC_SUB_DELAY", Qt::Key_X ) );
	kl.append( KeyAccel( "DEC_SUB_DELAY", Qt::Key_Z ) );

	kl.append( KeyAccel( "DEC_CONTRAST", Qt::Key_1 ) );
	kl.append( KeyAccel( "INC_CONTRAST", Qt::Key_2 ) );

	kl.append( KeyAccel( "DEC_BRIGHTNESS", Qt::Key_3 ) );
	kl.append( KeyAccel( "INC_BRIGHTNESS", Qt::Key_4 ) );

	kl.append( KeyAccel( "DEC_HUE", Qt::Key_5 ) );
	kl.append( KeyAccel( "INC_HUE", Qt::Key_6 ) );

	kl.append( KeyAccel( "DEC_SATURATION", Qt::Key_7 ) );
	kl.append( KeyAccel( "INC_SATURATION", Qt::Key_8 ) );

	kl.append( KeyAccel( "DEC_GAMMA", QKeySequence("Alt+1") ) );
	kl.append( KeyAccel( "INC_GAMMA", QKeySequence("Alt+2") ) );

	kl.append( KeyAccel( "DEC_SUBPOS", Qt::Key_R ) );
	kl.append( KeyAccel( "INC_SUBPOS", Qt::Key_T ) );

	kl.append( KeyAccel( "DEC_SPEED", Qt::Key_BracketLeft ) );
	kl.append( KeyAccel( "INC_SPEED", Qt::Key_BracketRight ) );

	kl.append( KeyAccel( "HALVE_SPEED", Qt::Key_BraceLeft ) );
	kl.append( KeyAccel( "DOUBLE_SPEED", Qt::Key_BraceRight ) );

	kl.append( KeyAccel( "NORMAL_SPEED", Qt::Key_Backspace ) );

	kl.append( KeyAccel( "SCREENSHOT", Qt::Key_S ) );

	//kl.append( KeyAccel( "AUDIO_NEXT", Qt::Key_NumberSign ) );
	kl.append( KeyAccel( "AUDIO_NEXT", Qt::Key_H ) );
	kl.append( KeyAccel( "SUBTITLE_NEXT", Qt::Key_J ) );
	kl.append( KeyAccel( "CHAPTER_NEXT", Qt::Key_At ) );
	kl.append( KeyAccel( "CHAPTER_PREV", Qt::Key_Exclam ) );
	//kl.append( KeyAccel( "CHAPTER_PREV", Qt::Key_Exclam, KeyAccel::Shift ) );

	kl.append( KeyAccel( "PLAYLIST_NEXT", Qt::Key_Greater ) );
	//kl.append( KeyAccel( "PLAYLIST_NEXT", Qt::Key_Greater, KeyAccel::Shift ) );
	kl.append( KeyAccel( "PLAYLIST_PREV", Qt::Key_Less ) );

	kl.append( KeyAccel( "FULLSCREEN", Qt::Key_F ) );
	kl.append( KeyAccel( "EXIT_FULLSCREEN", Qt::Key_Escape ) );

	//kl.append( KeyAccel( "STAY_ON_TOP", Qt::Key_T ) );

	// Options in menus
	kl.append( KeyAccel( "OPEN_FILE", QKeySequence("Ctrl+F") ) );
	kl.append( KeyAccel( "OPEN_URL", QKeySequence("Ctrl+U") ) );
	kl.append( KeyAccel( "EXIT", QKeySequence("Ctrl+X") ) );
	kl.append( KeyAccel( "EXIT", QKeySequence("Q") ) );

	kl.append( KeyAccel( "MPLAYER_LOG", QKeySequence("Ctrl+M") ) );
	kl.append( KeyAccel( "SMPLAYER_LOG", QKeySequence("Ctrl+S") ) );
	
	kl.append( KeyAccel( "INFO", QKeySequence("Ctrl+I") ) );
	kl.append( KeyAccel( "PREFERENCES", QKeySequence("Ctrl+P") ) );

	kl.append( KeyAccel( "VIDEO_EQUALIZER", QKeySequence("Ctrl+E") ) );
	kl.append( KeyAccel( "PLAYLIST", QKeySequence("Ctrl+L") ) );

	kl.append( KeyAccel( "COMPACT_MODE", QKeySequence("Ctrl+C") ) );

	load();
	/*list();*/
}

KeyShortcuts::~KeyShortcuts() {
	save();
}

void KeyShortcuts::list() {
	qDebug("KeyShortcuts::list");
	KeyAccelList::Iterator it;
	for ( it = kl.begin(); it != kl.end(); ++it ) {
		qDebug( "  key: '%s' = '%s'", QString( (*it).keySequence() ).utf8().data(), 
               (*it).function().utf8().data() );
	}
}

QStringList KeyShortcuts::functionList() {
	qDebug("KeyShortcuts::functionList");

	QStringList l;

	KeyAccelList::Iterator it;
	for ( it = kl.begin(); it != kl.end(); ++it ) {
		QString function = (*it).function();

		QStringList::iterator l_it = l.find( function );
        if (l_it == l.end()) l.append(function);

	}

	return l;
}

QString KeyShortcuts::function(QKeyEvent *e) {
	KeyAccelList::Iterator it;
	for ( it = kl.begin(); it != kl.end(); ++it ) {
		if ( (*it).check(e) ) return (*it).function();
	}
	return "";
}

QKeySequence KeyShortcuts::find( QString function ) {
	KeyAccelList::Iterator it;
	for ( it = kl.begin(); it != kl.end(); ++it ) {
		if ( (*it).function()==function ) return (*it).keySequence();
	}
	return 0;
}

void KeyShortcuts::save() {
	qDebug("KeyShortcuts::save");

	QSettings * set = settings;

	set->beginGroup( "key_shortcuts");

	int n = 0;
	KeyAccelList::Iterator it;
	for ( it = kl.begin(); it != kl.end(); ++it ) {
		set->writeEntry( "accel_"+ QString::number(n) +"_key", QString( (*it).keySequence() ) );
		set->writeEntry( "accel_"+ QString::number(n) +"_function", (*it).function() );
		n++;
	}
	set->writeEntry( "entries", n);
	set->endGroup();
}

void KeyShortcuts::load() {
	qDebug("KeyShortcuts::load");

	QSettings * set = settings;

	set->beginGroup( "key_shortcuts");

	int num_entries = set->readNumEntry("entries", 0);
	if (num_entries > 0) {
		kl.clear();

		for (int n=0; n < num_entries; n++) {
			QString seq = set->readEntry( "accel_"+ QString::number(n) +"_key", "" );
			QString function = set->readEntry( "accel_"+ QString::number(n) +"_function", "" );
			kl.append( KeyAccel( function, QKeySequence(seq) ) );
		}
	}

	set->endGroup();
}

