/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "mysystemtrayicon.h"

#if KDE_SUPPORT
#include <qtooltip.h>
#include <qpopupmenu.h>

MySystemTrayIcon::MySystemTrayIcon( QPixmap icon, QWidget *parent, 
                                    const char *name )
	: KSystemTray(parent, name )
{
	setPixmap(icon);
}

MySystemTrayIcon::~MySystemTrayIcon() {
}

void MySystemTrayIcon::setVisible( bool visible ) {
	if (visible) show(); else hide();
}

void MySystemTrayIcon::mousePressEvent( QMouseEvent *e  ) {
	if ( !rect().contains( e->pos() ) )
		return;

	switch ( e->button() ) {
		case LeftButton:	emit activated(QSystemTrayIcon::Trigger); break;
		case MidButton:		emit activated(QSystemTrayIcon::MiddleClick); break;
		case RightButton:	context_menu->popup( e->globalPos() ); break;
		default:			// nothing
							break;
	}
}

void MySystemTrayIcon::setToolTip( const QString & tip ) {
	tool_tip = tip;
	QToolTip::add(this, tip);
}

#endif
