/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "myaction.h"

MyAction::MyAction ( QObject * parent, const char * name )
	: QACTION(parent, name)
{
	_parameter = 0;
}

MyAction::MyAction(const QString & menuText, QKeySequence accel, 
                   QObject * parent, const char * name )
	: QACTION(menuText, accel, parent, name)
{
	_parameter = 0;
}

MyAction::MyAction(QKeySequence accel, 
                   QObject * parent, const char * name )
	: QACTION(QString::null, accel, parent, name)
{
	_parameter = 0;
}

MyAction::~MyAction() {
}

void MyAction::change(const QIconSet & icon, const QString & menuText, 
                      QKeySequence accel, const QString & text)
{
	setIconSet( icon );
	change( menuText, accel, text );
}

void MyAction::change(const QIconSet & icon, const QString & menuText) {
	setIconSet( icon );
	change(menuText);
}

void MyAction::change(const QString & menuText, const QString & text ) {
	setMenuText( menuText );

	QString accel_text = QString(accel());

	if (text.isEmpty()) {
		QString s = menuText;
		s = s.replace("&","");
		setText( s );

		if (!accel_text.isEmpty())
			setToolTip( s + " ("+ accel_text +")");
	} else {
		setText( text );
		if (!accel_text.isEmpty())
			setToolTip( text + " ("+ accel_text +")");
	}
}

void MyAction::change(const QString & menuText, 
                      QKeySequence accel, const QString & text)
{
	setAccel( accel );
	change( menuText, text );
}

void MyAction::setParameter(int p) {
	_parameter = p;
	connect(this, SIGNAL(activated()), this, SLOT(activated_slot()));
	connect(this, SIGNAL(toggled()), this, SLOT(toggled_slot()));
}

void MyAction::activated_slot() {
	emit activated(_parameter);
}

void MyAction::toggled_slot() {
	emit toggled(_parameter);
}
