/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "aboutdialog.h"

#include <qlabel.h>
#include <qtextedit.h>
#include <qpushbutton.h>
#include "images.h"
#include <qlayout.h>

#include "version.h"

AboutDialog::AboutDialog(QWidget * parent, const char * name, bool modal, WFlags f)
	: QDialog(parent, name, modal, f) 
{
	setCaption( tr("About SMPlayer") );

	logo = new QLabel(this);
	logo->setPixmap( Images::icon("logo", 64) );

	intro = new QLabel(this);
#if QT_VERSION >= 0x040000
	intro->setWordWrap(true);
#endif

	foot = new QLabel(this),
	credits = new QTextEdit(this);
	credits->setReadOnly(true);
	ok_button = new QPushButton( tr("&Ok"), this );
	ok_button->setDefault(true);
	ok_button->setAutoDefault(true);
	ok_button->setFocus();
	connect( ok_button, SIGNAL(clicked()), this, SLOT(accept()) );

	QVBoxLayout * lright = new QVBoxLayout(0, 4, 2);
	lright->addWidget( intro );
	lright->addWidget( credits );
	lright->addWidget( foot );

	QVBoxLayout * lleft = new QVBoxLayout(0, 4, 2);
	lleft->addWidget( logo );
	lleft->addStretch(1);
	
	QHBoxLayout * lmain = new QHBoxLayout(0, 4, 2);
	lmain->addLayout( lleft );
	lmain->addLayout( lright );

	QHBoxLayout * lbutton = new QHBoxLayout(0, 4, 2);
	lbutton->addStretch(1);
	lbutton->addWidget( ok_button );
	lbutton->addStretch(1);

	QVBoxLayout * lwidget = new QVBoxLayout(this, 4, 2);
	lwidget->addLayout( lmain );
	//lwidget->addWidget( foot );
	lwidget->addLayout( lbutton );

	intro->setText( 
		"<b>SMPlayer</b> &copy; 2006-2007 RVM &lt;rvm@escomposlinux.org&gt;<br><br>"
		"<b>" + tr("Version: %1").arg(VERSION) + "</b><br>" +
#if KDE_SUPPORT
        tr("Compiled with KDE support") + "<br>" +
#endif
        "<br>" +
        tr("Qt version: %1").arg(QT_VERSION_STR) + "<br><br>" 
		"<i>" +
		tr("This program is free software; you can redistribute it and/or modify "
	    "it under the terms of the GNU General Public License as published by "
	    "the Free Software Foundation; either version 2 of the License, or "
  	    "(at your option) any later version.") + "</i>");

	credits->setText(
		 tr("Translators:") + "<br>"
         "<ul>"
         "<li>Henrikx <i>&lt;forum.gleitz.info&gt;</i> (" + tr("German") + ")</li>"
         "<li>Sweto &lt;peter.mendel@gmail.com&gt; (" +tr("Slovak") + ")</li>"
         "<li>Giancarlo Scola &lt;giancarlo@codexcoop.it&gt; (" +tr("Italian") + ")</li>"
         "<li>" + tr("%1 and %2 (%3)").arg("Olivier g &lt;1got@caramail.com&gt;").arg("Temet &lt;goondy@free.fr&gt;").arg(tr("French")) + "</li>"
         "<li>Tim Green &lt;iamtimgreen@gmail.com&gt; (" +tr("Simplified-Chinese") + ")</li>"
         "<li>Yurkovsky Andrey &lt;anyr@tut.by&gt; (" +tr("Russian") + ")</li>"
         "<li>Charles Barcza &lt;kbarcza@blackpanther.hu&gt; (" +tr("Hungarian") + ")</li>"
         "<li>" + tr("%1 and %2 (%3)").arg("qla &lt;qla0@vp.pl&gt;").arg("Jarek &lt;ajep9691@wp.pl&gt;").arg(tr("Polish")) +"</li>"
         "<li>Nardog &lt;nardog@e2umail.com&gt; (" +tr("Japanese") + ")</li>"
         "<li>Wesley S. &lt;wesley@ubuntu-nl.org&gt; (" +tr("Dutch") + ")</li>"
         "<li>Motsyo Gennadi &lt;drool@altlinux.ru&gt; (" +tr("Ukrainian") + ")</li>"
         "<li>Ventura &lt;ventura.barbeiro@terra.com.br&gt; (" +tr("Portuguese - Brazil") + ")</li>"
         "<li>George Machitidze &lt;giomac@gmail.com&gt; (" +tr("Georgian") + ")</li>"
         "<li>" + QString::fromUtf8("Martin Dvořák") + " &lt;martin.dvorak@centrum.cz&gt; (" +tr("Czech") + ")</li>"
         "<li>&lt;marzeliv@mail.bg&gt; (" +tr("Bulgarian") + ")</li>"
         "<li> alper er &lt;alperer@gmail.com&gt; (" +tr("Turkish") + ")</li>"
         "<li>Leif Larsson &lt;leif.larsson@gmail.com&gt; (" +tr("Swedish") + ")</li>"
         "<li>Kunalagon Umuhanik &lt;kunalagon@gmail.com&gt; (" +tr("Serbian") + ")</li>"
         "<li>Hoopoe &lt;dai715.tw@yahoo.com.tw&gt; (" +tr("Traditional Chinese") + ")</li>"
         "<li>DoruH &lt;doruhushhush@hotmail.com&gt; (" +tr("Romanian") + ")</li>"
         "<li>Waxman &lt;waxman.pt@gmail.com&gt; (" +tr("Portuguese - Portugal") + ")</li>"
         "</ul>" +
		 tr("Logo designed by %1").arg("Charles Barcza &lt;kbarcza@blackpanther.hu&gt;")
		);

	foot->setText(
		 tr("Get updates at: %1")
         .arg("<a href=\"http://smplayer.sourceforge.net/\">http://smplayer.sourceforge.net/</a>")
		);

	adjustSize();
	setFixedSize( sizeHint() );
}

AboutDialog::~AboutDialog() {
}

