# -*- coding: utf-8 -*-

# Copyright (c) 2008 - 2009 Lukas Hetzenecker <LuHe@gmx.at>

import os
import sys
from PyQt4.QtCore import *
from PyQt4.QtGui import *
import lib.obex_wrapper

USE_PYBLUEZ = False
USE_LIGHTBLUE = False

try:
   # PyBluez module for Linux and Windows
   import bluetooth
   from bluetooth import BluetoothError
   USE_PYBLUEZ = True
except ImportError:
   # Lightblue for Mac OS X
   import lightblue
   from lib.obex_wrapper import BluetoothError
   USE_LIGHTBLUE = True

class Helper(QObject):
    def __init__(self,  parent,  main):
        """Often used functions"""
        super(Helper,  self).__init__(parent)

        self.parent = parent
        self.main = main

        if main != None:
            self.log = main.log

    def addContactsToMenu(self,  contacts,  menu,  start=0):
        i = 0
        for contact in contacts:
            if i + 1 + start < 10:
                action = QAction("&%d: %s" % (i + 1 + start,  contact.name()),  menu)
            else:
                action = QAction("%d: %s" % (i + 1 + start,  contact.name()),  menu)
            action.setData(QVariant(contact))
            action.setProperty("type",  QVariant("contact"))
            menu.addAction(action)
            i += 1
        return i+1

    def pretty_filesize(self,  bytes):
        """Function to convert bytes to KB/MB/GB/TB"""
        bytes = float(bytes)
        if bytes >= 1099511627776:
            terabytes = bytes / 1099511627776
            size = '%.1f TB' % terabytes
        elif bytes >= 1073741824:
            gigabytes = bytes / 1073741824
            size = '%.1f GB' % gigabytes
        elif bytes >= 1048576:
            megabytes = bytes / 1048576
            size = '%.1f MB' % megabytes
        elif bytes >= 1024:
            kilobytes = bytes / 1024
            size = '%.1f KB' % kilobytes
        else:
            size = '%.0f B' % bytes
        return size
    
    def countMessages(self,  chars):
        """Return number of messages and remaining chars of an text message
        A tuple of the format (number_of_messages, remeining_chars)
        is returned"""
        # The first part of a text message can be up tp 160 chars
        if chars <= 160:
            return 160-chars,  1

        # The second part up to 145 chars
        elif chars <= 160+145:
            return (160+146)-chars,  2

        # All the others can have 152 chars
        else:
            rest = chars-(160+146)
            sms = rest/152+1
            ch = (sms)*152-rest
            return ch,  sms+2

    def findFolder(self,  regexp,  root="data",  folders=list()):
        # root can be data or mobile
        def find(directory,  regexp):
            files = directory.entryList(QStringList(regexp))
            if not files.isEmpty():
                last = files.takeLast()
                return unicode(directory.absoluteFilePath(last))
            return None
        
        directorys = list()
        
        # Path of executable file (could be the python executable or the application if it was compiled)
        directorys.append(QDir(self.main.app.applicationDirPath())) 
        
        # Path of current script file
        directorys.append(QDir(sys.path[0]))

        # Path of helper script
        directorys.append(QDir(sys.path[0]+ os.sep + 'pc'))

        if root == "mobile":
            dir = QDir.current()
            if dir.cdUp():
                directorys.append(dir)
        else:
            directorys.append(QDir.current())
        if os.name == 'posix':
            # Linux and Mac OS X
            directorys.append(QDir("/usr/share/series60-remote"))
            directorys.append(QDir("/usr/local/share/series60-remote"))
        #if sys.platform == 'darwin':
            # Mac OS X
            # for bundled application
            # QDir() is current working directory (Series60-Remote.app/Contents/Resources)
            #directorys.append(QDir().absolutePath())
        
        for directory in directorys:
            directory = QDir(directory.absolutePath() + os.sep + root + os.sep + os.sep.join(folders))
            path = find(directory,  regexp)
            if path != None:
                return path
    
    def openFolder(self):
        folder = self.findFolder(self.main.applicationSisRegexp,  "mobile") or self.findFolder(self.main.pythonSisRegexp,  "mobile")
        if folder == None:
            message = QMessageBox.critical(self,
            self.tr("Can't find file!"),
            self.tr("""The file %1 couldn't be found!\n
If you're using the SVN version of the application you have to create the file yourself\n
If you downloaded a pre-built package please report the error to series60-remote-devel@lists.sourceforge.net !""").arg(file),
            QMessageBox.StandardButtons(\
                QMessageBox.Ok),
            QMessageBox.Ok)
        else:
            dir = QFileInfo(folder).absoluteDir().absolutePath()
            QDesktopServices.openUrl(QUrl.fromLocalFile(dir))

    def sendFile(self,  parent,  device,  file,  regexp=None):
        if self.main == None:
            return
        
        if regexp == None:
            regexp = file
        
        try:
            assert device.bluetoothAddress()
        except:
            message = QMessageBox.critical(parent,
            self.tr("File transfer failed!"),
            self.tr("""File transer failed!\n
No device was specified!\n
You have to send the file %1 in the folder mobile manuelly to your mobile phone!""").arg(file),
            QMessageBox.StandardButtons(\
                    QMessageBox.Ok),
            QMessageBox.Ok)

            return

        found = False
        
        path = self.findFolder(regexp,  "mobile")
        if path == None:
            message = QMessageBox.critical(parent,
            self.tr("Can't find file!"),
            self.tr("""The file %1 couldn't be found!\n
If you're using the SVN version of the application you have to create the file yourself\n
If you downloaded a pre-built package please report the error to series60-remote-devel@lists.sourceforge.net !""").arg(file),
            QMessageBox.StandardButtons(\
                QMessageBox.Ok),
            QMessageBox.Ok)
            return
        
        port = 11
        try:
            if USE_PYBLUEZ:
                services = bluetooth.find_service(address=address, name="OBEX File Transfer")
                
                # Windows (Widcomm) seems to ignore the name argument...
                for service in services:
                    if service["name"] == "OBEX File Transfer":
                        port = service["port"]
            elif USE_LIGHTBLUE:
                services = lightblue.findservices(addr=address, name="OBEX File Transfer")
                if service:
                    port = services[0][1]
        except:
            pass

        self.log.info(QString("Sending file %1 to host %2 on port %3").arg(path).arg(device.bluetoothAddress()).arg(port))

        errormsg = None
        client = lib.obex_wrapper.ObexClient(device.bluetoothAddress(),  port)
        try:
            ret = client.connect()
        except BluetoothError,  msg:
            try:
                error = eval(str(msg)) # Doesn't work on Windows, why?
                errormsg = error[1]
                errormsg = unicode(errormsg,  "utf8")
            except:
                errormsg = "None"
        except IOError,  msg:
            errormsg = msg.message
            
        if errormsg:
            message = QMessageBox.critical(parent,
            self.tr("File transfer failed!"),
            self.tr("""File transer failed!\n
I could not connect to the file transfer service of your mobile phone!\n
The error message was: %1\n
You have to send the file %2 in the folder mobile manuelly to your mobile phone!\n
The absolute filepath is: %3""").arg(errormsg,  file,  path),
            QMessageBox.StandardButtons(\
                    QMessageBox.Ok),
            QMessageBox.Ok)
            return
        
        if not isinstance(ret, lib.obex_wrapper.ConnectSuccess):
            message = QMessageBox.critical(parent,
            self.tr("File transfer failed!"),
            self.tr("""File transer failed!\n
I could not connect to the file transfer service of your mobile phone!\n
You have to send the file %1 in the folder mobile manuelly to your mobile phone!\n
The absolute filepath is: %2""").arg(file,  path),
            QMessageBox.StandardButtons(\
                    QMessageBox.Ok),
            QMessageBox.Ok)
            return

        self.log.info(QString("Connection returned %1").arg(repr(ret)))

        ret = client.put_file(path)
        self.log.info(QString("Sending file returned %1").arg(repr(ret)))

        client.disconnect()

        message = QMessageBox.information(parent,
        self.trUtf8("File succesfully transfered to mobile phone!"),
        self.trUtf8("""The file was transfered successfully to your mobile phone!\n
Please open your messages and continue with the installation!"""),
        QMessageBox.StandardButtons(\
                QMessageBox.Ok),
        QMessageBox.Ok)

    def getModel(self,  firmware):
        """Translates the firmware version to the model"""
        #
        # Firmware.py for S60 Nokia Phones
        #
        # source code by Cyke64 (Forum Nokia Champion http://www.forum.nokia.com/main/forum_nokia_champion/who_is_a_forum_nokia_champion.html)
        # original idea from Korakotc
        # Apache license 2.0
        # version 07 http://homepage.mac.com/alvinmok/nokia/firmware.html
        #            http://www.nokiaport.de/index.php?mid=3&pid=processor
        # modified by Lukas Hetzenecker

        mapping_firmware={
        'RM-51': '3230',
        'RM-52': '3230b',
        'RM-38': '3250',
        'RM-40': '3250b',
        'NHM-10': '3600',
        'NAM-1': '3610',
        'NHM-10X': '3620',
        'NHL-8': '3650',
        'NHL-8X': '3660',
        'RM-86': '5500d',
        'RM-87': '5500',
        'RM-230': '5700',
        'RM-302': '5700b',
        'NSE-3':'6110',
        'RM-122':'6110n-1',
        'RM-186':'6110n-5',
        'NSC-3': '6120',
        'RM-243': '6120c-1',
        'RM-310': '6120c-5',
        'RM-308': '6121c',
        'RM-25': '6260',
        'RM-29': '6260b',
        'RM-176': '6290',
        'RM-175': '6290b',
        'NHL-10': '6600',
        'NHL-12': '6620',
        'NHL-12X': '6620',
        'RM-1': '6630',
        'RM-109': '6631',
        'RH-67': '6670',
        'RH-68': '6670b',
        'RM-36': '6680',
        'RM-57': '6681',
        'RM-58': '6682',
        'RH-51': '7610',
        'RH-52': '7610b',
        'NHL-2NA': '7650',
        'RM-170': 'E50-1',
        'RM-171': 'E50-2',
        'RM-244': 'E51-1',
        'RM-49': 'E60-1',
        'RM-89': 'E61-1',
        'RM-227':'E61i-1',
        'RM-294':'E61i-2',
        'RM-88': 'E62-1',
        'RM-88A': 'E62-1',
        'RM-208': 'E65-1',
        'RM-10': 'E70-1',
        'RM-24': 'E70-2',
        'NEM-4': 'N-Gage',
        'RH-29': 'N-Gage QD (asia/europe)',
        'RH-47': 'N-Gage QD (americas)',
        'RM-84': 'N70-1',
        'RM-99': 'N70-5',
        'RM-67': 'N71-1',
        'RM-112': 'N71-5',
        'RM-180': 'N72-5',
        'RM-133': 'N73-1',
        'RM-132': 'N73-5',
        'RM-128': 'N75-3',
        'RM-135': 'N76-1',
        'RM-149': 'N76-5',
        'RM-194': 'N77-1',
        'RM-195': 'N77-2 or N77-5',
        'RM-92': 'N80-1',
        'RM-93': 'N80-2',
        'RM-91': 'N80-3',
        'RM-179': 'N81-1',
        'RM-223': 'N81-3',
        'RM-256': 'N81-5',
        'RM-42': 'N90-1',
        'RM-43': 'N91-1 or N91-2',
        'RM-158': 'N91-5 or N91-6',
        'RM-100': 'N92-1',
        'RM-101': 'N92-2',
        'RM-55': 'N93-1',
        'RM-153': 'N93-5',
        'RM-156': 'N93i-1',
        'RM-157': 'N93i-5',
        'RM-159': 'N95-1',
        'RM-160': 'N95-3',
        'RM-245': 'N95-5',
        'RM-320': 'N95-2 8GB',
        'RA-6': 'E90-1',
        'RA-7': 'E90', 
        'RM-346': 'E71-1',
        'RM-357': 'E71-2',
        'RM-407': 'E71-3',
        'RM-462': 'E71x'
        }

        code = firmware.split(' ')
        if code[3] in mapping_firmware:
            return "Nokia " + mapping_firmware[code[3]]
        elif code[2] in mapping_firmware:
            return "Nokia " + mapping_firmware[code[2]]
        else:
            return "unknown (" + firmware + ")"
