/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.INContainingEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.NodeLogEntry;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INDeleteInfo;
import com.sleepycat.je.tree.INDupDeleteInfo;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.utilint.DbLsn;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class INFileReader
extends FileReader {
    private boolean lastEntryWasDelete;
    private boolean lastEntryWasDupDelete;
    private LogEntryType fromLogType;
    private boolean isProvisional;
    private Map targetEntryMap;
    private LogEntry targetLogEntry;
    private Map dbIdTrackingMap;
    private LNLogEntry dbIdTrackingEntry;
    private Map txnIdTrackingMap;
    private LNLogEntry txnIdTrackingEntry;
    private Map otherNodeTrackingMap;
    private NodeLogEntry nodeTrackingEntry;
    private INLogEntry inTrackingEntry;
    private LNLogEntry fsTrackingEntry;
    private boolean trackIds;
    private long maxNodeId;
    private int maxDbId;
    private long maxTxnId;
    private boolean mapDbOnly;
    private long partialCkptStart;
    private UtilizationTracker tracker;
    private Map fileSummaryLsns;
    static final /* synthetic */ boolean $assertionsDisabled;

    public INFileReader(EnvironmentImpl env, int readBufferSize, long startLsn, long finishLsn, boolean trackIds, boolean mapDbOnly, long partialCkptStart, Map fileSummaryLsns) throws IOException, DatabaseException {
        super(env, readBufferSize, true, startLsn, null, -1L, finishLsn);
        this.trackIds = trackIds;
        this.mapDbOnly = mapDbOnly;
        this.targetEntryMap = new HashMap();
        if (trackIds) {
            this.maxNodeId = 0L;
            this.maxDbId = 0;
            this.tracker = env.getUtilizationTracker();
            this.partialCkptStart = partialCkptStart;
            this.fileSummaryLsns = fileSummaryLsns;
            this.fsTrackingEntry = (LNLogEntry)LogEntryType.LOG_FILESUMMARYLN.getNewLogEntry();
            this.dbIdTrackingMap = new HashMap();
            this.txnIdTrackingMap = new HashMap();
            this.otherNodeTrackingMap = new HashMap();
            this.dbIdTrackingMap.put(LogEntryType.LOG_MAPLN_TRANSACTIONAL, LogEntryType.LOG_MAPLN_TRANSACTIONAL.getNewLogEntry());
            this.dbIdTrackingMap.put(LogEntryType.LOG_MAPLN, LogEntryType.LOG_MAPLN.getNewLogEntry());
            this.txnIdTrackingMap.put(LogEntryType.LOG_LN_TRANSACTIONAL, LogEntryType.LOG_LN_TRANSACTIONAL.getNewLogEntry());
            this.txnIdTrackingMap.put(LogEntryType.LOG_MAPLN_TRANSACTIONAL, LogEntryType.LOG_MAPLN_TRANSACTIONAL.getNewLogEntry());
            this.txnIdTrackingMap.put(LogEntryType.LOG_NAMELN_TRANSACTIONAL, LogEntryType.LOG_NAMELN_TRANSACTIONAL.getNewLogEntry());
            this.txnIdTrackingMap.put(LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL, LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL.getNewLogEntry());
            this.txnIdTrackingMap.put(LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL, LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL.getNewLogEntry());
        }
    }

    public void addTargetType(LogEntryType entryType) throws DatabaseException {
        this.targetEntryMap.put(entryType, entryType.getNewLogEntry());
    }

    protected boolean isTargetEntry(byte entryTypeNum, byte entryTypeVersion) throws DatabaseException {
        this.lastEntryWasDelete = false;
        this.lastEntryWasDupDelete = false;
        this.targetLogEntry = null;
        this.dbIdTrackingEntry = null;
        this.txnIdTrackingEntry = null;
        this.nodeTrackingEntry = null;
        this.inTrackingEntry = null;
        this.fsTrackingEntry = null;
        this.isProvisional = LogEntryType.isProvisional(entryTypeVersion);
        this.fromLogType = LogEntryType.findType(entryTypeNum, entryTypeVersion);
        LogEntry possibleTarget = (LogEntry)this.targetEntryMap.get(this.fromLogType);
        if (!this.isProvisional) {
            this.targetLogEntry = possibleTarget;
        }
        if (LogEntryType.LOG_IN_DELETE_INFO.equals(this.fromLogType)) {
            this.lastEntryWasDelete = true;
        }
        if (LogEntryType.LOG_IN_DUPDELETE_INFO.equals(this.fromLogType)) {
            this.lastEntryWasDupDelete = true;
        }
        if (this.trackIds) {
            if (!this.isProvisional) {
                this.dbIdTrackingEntry = (LNLogEntry)this.dbIdTrackingMap.get(this.fromLogType);
                this.txnIdTrackingEntry = (LNLogEntry)this.txnIdTrackingMap.get(this.fromLogType);
            }
            if (this.fromLogType.isNodeType()) {
                if (possibleTarget != null) {
                    this.nodeTrackingEntry = (NodeLogEntry)possibleTarget;
                } else if (this.dbIdTrackingEntry != null) {
                    this.nodeTrackingEntry = this.dbIdTrackingEntry;
                } else if (this.txnIdTrackingEntry != null) {
                    this.nodeTrackingEntry = this.txnIdTrackingEntry;
                } else {
                    this.nodeTrackingEntry = (NodeLogEntry)this.otherNodeTrackingMap.get(this.fromLogType);
                    if (this.nodeTrackingEntry == null) {
                        this.nodeTrackingEntry = (NodeLogEntry)this.fromLogType.getNewLogEntry();
                        this.otherNodeTrackingMap.put(this.fromLogType, this.nodeTrackingEntry);
                    }
                }
                if (this.nodeTrackingEntry instanceof INLogEntry) {
                    this.inTrackingEntry = (INLogEntry)this.nodeTrackingEntry;
                }
                if (LogEntryType.LOG_FILESUMMARYLN.equals(this.fromLogType)) {
                    this.fsTrackingEntry = (LNLogEntry)this.nodeTrackingEntry;
                }
            }
            this.tracker.countNewLogEntry(this.getLastLsn(), this.fromLogType, 14 + this.currentEntrySize);
            return this.targetLogEntry != null || this.dbIdTrackingEntry != null || this.txnIdTrackingEntry != null || this.nodeTrackingEntry != null;
        }
        return this.targetLogEntry != null;
    }

    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        boolean useEntry = false;
        boolean entryLoaded = false;
        if (this.targetLogEntry != null) {
            this.targetLogEntry.readEntry(entryBuffer, this.currentEntrySize, this.currentEntryTypeVersion, true);
            DatabaseId dbId = this.getDatabaseId();
            boolean isMapDb = dbId.equals(DbTree.ID_DB_ID);
            useEntry = !this.mapDbOnly || isMapDb;
            entryLoaded = true;
        }
        if (this.trackIds) {
            LNLogEntry lnEntry = null;
            if (this.dbIdTrackingEntry != null) {
                lnEntry = this.dbIdTrackingEntry;
                lnEntry.readEntry(entryBuffer, this.currentEntrySize, this.currentEntryTypeVersion, true);
                entryLoaded = true;
                MapLN mapLN = (MapLN)lnEntry.getMainItem();
                int dbId = mapLN.getDatabase().getId().getId();
                if (dbId > this.maxDbId) {
                    this.maxDbId = dbId;
                }
            }
            if (this.txnIdTrackingEntry != null) {
                long txnId;
                if (lnEntry == null) {
                    lnEntry = this.txnIdTrackingEntry;
                    lnEntry.readEntry(entryBuffer, this.currentEntrySize, this.currentEntryTypeVersion, true);
                    entryLoaded = true;
                }
                if ((txnId = lnEntry.getTxnId().longValue()) > this.maxTxnId) {
                    this.maxTxnId = txnId;
                }
            }
            if (this.fsTrackingEntry != null) {
                if (!entryLoaded) {
                    this.nodeTrackingEntry.readEntry(entryBuffer, this.currentEntrySize, this.currentEntryTypeVersion, true);
                    entryLoaded = true;
                }
                byte[] keyBytes = this.fsTrackingEntry.getKey();
                FileSummaryLN fsln = (FileSummaryLN)this.fsTrackingEntry.getMainItem();
                long fileNum = fsln.getFileNumber(keyBytes);
                TrackedFileSummary trackedLN = this.tracker.getTrackedFile(fileNum);
                if (trackedLN != null) {
                    trackedLN.reset();
                }
                this.fileSummaryLsns.put(new Long(fileNum), new Long(this.getLastLsn()));
            }
            if (this.nodeTrackingEntry != null) {
                long nodeId;
                if (!entryLoaded) {
                    this.nodeTrackingEntry.readEntry(entryBuffer, this.currentEntrySize, this.currentEntryTypeVersion, false);
                    entryLoaded = true;
                }
                long l = this.maxNodeId = (nodeId = this.nodeTrackingEntry.getNodeId()) > this.maxNodeId ? nodeId : this.maxNodeId;
            }
            if (this.inTrackingEntry != null) {
                long newLsn;
                if (!$assertionsDisabled && !entryLoaded) {
                    throw new AssertionError((Object)"All nodes should have been loaded");
                }
                long oldLsn = this.inTrackingEntry.getObsoleteLsn();
                if (oldLsn != -1L && !this.isObsoleteLsnAlreadyCounted(oldLsn, newLsn = this.getLastLsn())) {
                    this.tracker.countObsoleteNodeInexact(oldLsn, this.fromLogType);
                }
                if (this.isProvisional && this.partialCkptStart != -1L && DbLsn.compareTo(this.partialCkptStart, oldLsn = this.getLastLsn()) < 0) {
                    this.tracker.countObsoleteNodeInexact(oldLsn, this.fromLogType);
                }
            }
        }
        return useEntry;
    }

    private boolean isObsoleteLsnAlreadyCounted(long oldLsn, long newLsn) {
        Long fileNum = new Long(DbLsn.getFileNumber(oldLsn));
        long fileSummaryLsn = DbLsn.longToLsn((Long)this.fileSummaryLsns.get(fileNum));
        int cmpFsLsnToNewLsn = fileSummaryLsn != -1L ? DbLsn.compareTo(fileSummaryLsn, newLsn) : -1;
        return cmpFsLsnToNewLsn >= 0;
    }

    public IN getIN() throws DatabaseException {
        return ((INContainingEntry)((Object)this.targetLogEntry)).getIN(this.env);
    }

    public DatabaseId getDatabaseId() {
        if (this.lastEntryWasDelete) {
            return ((INDeleteInfo)this.targetLogEntry.getMainItem()).getDatabaseId();
        }
        if (this.lastEntryWasDupDelete) {
            return ((INDupDeleteInfo)this.targetLogEntry.getMainItem()).getDatabaseId();
        }
        return ((INContainingEntry)((Object)this.targetLogEntry)).getDbId();
    }

    public long getMaxNodeId() {
        return this.maxNodeId;
    }

    public int getMaxDbId() {
        return this.maxDbId;
    }

    public long getMaxTxnId() {
        return this.maxTxnId;
    }

    public boolean isDeleteInfo() {
        return this.lastEntryWasDelete;
    }

    public boolean isDupDeleteInfo() {
        return this.lastEntryWasDupDelete;
    }

    public long getDeletedNodeId() {
        return ((INDeleteInfo)this.targetLogEntry.getMainItem()).getDeletedNodeId();
    }

    public byte[] getDeletedIdKey() {
        return ((INDeleteInfo)this.targetLogEntry.getMainItem()).getDeletedIdKey();
    }

    public long getDupDeletedNodeId() {
        return ((INDupDeleteInfo)this.targetLogEntry.getMainItem()).getDeletedNodeId();
    }

    public byte[] getDupDeletedMainKey() {
        return ((INDupDeleteInfo)this.targetLogEntry.getMainItem()).getDeletedMainKey();
    }

    public byte[] getDupDeletedDupKey() {
        return ((INDupDeleteInfo)this.targetLogEntry.getMainItem()).getDeletedDupKey();
    }

    public long getLsnOfIN() {
        return ((INContainingEntry)((Object)this.targetLogEntry)).getLsnOfIN(this.getLastLsn());
    }

    public LogEntryType getLogEntryType() {
        return LogEntryType.findType(this.currentEntryTypeNum, this.currentEntryTypeVersion);
    }

    static {
        $assertionsDisabled = !INFileReader.class.desiredAssertionStatus();
    }
}

