/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.management.mbeans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import org.apache.hivemind.management.impl.PerformanceCollector;
import org.apache.hivemind.management.mbeans.AbstractDynamicMBean;
import org.apache.hivemind.management.mbeans.AttributeToCounterLink;
import org.apache.hivemind.management.mbeans.Counter;
import org.apache.hivemind.service.MethodSignature;

public class PerformanceMonitorMBean
extends AbstractDynamicMBean
implements PerformanceCollector {
    protected static final String DATA_TYPE_MAXIMUM_TIME = "Maximum time";
    protected static final String DATA_TYPE_MINIMUM_TIME = "Minimum time";
    protected static final String DATA_TYPE_LAST_TIME = "Last time";
    protected static final String DATA_TYPE_AVERAGE_TIME = "Average time";
    protected static final String DATA_TYPE_COUNT = "Count";
    private Set _methods;
    private Map _countersByMethodSignature = new HashMap();
    private Map _countersByMethodId = new HashMap();
    private MBeanAttributeInfo[] _mBeanAttributeInfos;
    private Map _mBeanAttributeNameToCounterMap = new HashMap();
    static /* synthetic */ Class class$java$lang$Long;

    public PerformanceMonitorMBean(Set methods) {
        this._methods = methods;
        this.initCounters();
    }

    protected void initCounters() {
        ArrayList mBeanAttributeInfoList = new ArrayList();
        Iterator methodIterator = this._methods.iterator();
        while (methodIterator.hasNext()) {
            MethodSignature method = (MethodSignature)methodIterator.next();
            Counter counter = new Counter();
            this._countersByMethodSignature.put(method, counter);
            this._countersByMethodId.put(method.getUniqueId(), counter);
            this.initAttributes(mBeanAttributeInfoList, counter, method);
        }
        this._mBeanAttributeInfos = mBeanAttributeInfoList.toArray(new MBeanAttributeInfo[mBeanAttributeInfoList.size()]);
    }

    protected void initAttributes(List mBeanAttributeInfoList, Counter counter, MethodSignature method) {
        this.addAttribute(mBeanAttributeInfoList, counter, method, class$java$lang$Long == null ? (class$java$lang$Long = PerformanceMonitorMBean.class$("java.lang.Long")) : class$java$lang$Long, DATA_TYPE_COUNT, "Number of method calls for method " + method);
        this.addAttribute(mBeanAttributeInfoList, counter, method, class$java$lang$Long == null ? (class$java$lang$Long = PerformanceMonitorMBean.class$("java.lang.Long")) : class$java$lang$Long, DATA_TYPE_AVERAGE_TIME, "Average execution time in ms of method " + method);
        this.addAttribute(mBeanAttributeInfoList, counter, method, class$java$lang$Long == null ? (class$java$lang$Long = PerformanceMonitorMBean.class$("java.lang.Long")) : class$java$lang$Long, DATA_TYPE_LAST_TIME, "Last execution time in ms of method " + method);
        this.addAttribute(mBeanAttributeInfoList, counter, method, class$java$lang$Long == null ? (class$java$lang$Long = PerformanceMonitorMBean.class$("java.lang.Long")) : class$java$lang$Long, DATA_TYPE_MINIMUM_TIME, "Minimum execution time in ms of method " + method);
        this.addAttribute(mBeanAttributeInfoList, counter, method, class$java$lang$Long == null ? (class$java$lang$Long = PerformanceMonitorMBean.class$("java.lang.Long")) : class$java$lang$Long, DATA_TYPE_MAXIMUM_TIME, "Maximum execution time in ms of method " + method);
    }

    private void addAttribute(List mBeanAttributeInfoList, Counter counter, MethodSignature method, Class attributeType, String performanceDataType, String description) {
        String attributeName = null;
        MBeanAttributeInfo attributeInfo = null;
        try {
            attributeName = this.buildAttributeName(method, performanceDataType);
            attributeInfo = new MBeanAttributeInfo(attributeName, attributeType.getName(), description, true, false, false);
        }
        catch (IllegalArgumentException e) {
            attributeName = this.buildAttributeNameDefensive(method, performanceDataType);
            attributeInfo = new MBeanAttributeInfo(attributeName, attributeType.getName(), description, true, false, false);
        }
        mBeanAttributeInfoList.add(attributeInfo);
        AttributeToCounterLink atcLink = new AttributeToCounterLink(counter, performanceDataType);
        this._mBeanAttributeNameToCounterMap.put(attributeName, atcLink);
    }

    private String makeValidJavaIdentifier(String attributeName) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < attributeName.length(); ++i) {
            char currentChar = attributeName.charAt(i);
            if (Character.isJavaIdentifierPart(currentChar)) {
                result.append(currentChar);
                continue;
            }
            result.append('_');
        }
        return result.toString();
    }

    protected String buildAttributeName(MethodSignature method, String performanceDataType) {
        String attributeName = method.getUniqueId() + " : " + performanceDataType;
        return attributeName;
    }

    protected String buildAttributeNameDefensive(MethodSignature method, String performanceDataType) {
        String attributeName = method.getUniqueId() + "$[" + performanceDataType;
        return this.makeValidJavaIdentifier(attributeName);
    }

    public void addMeasurement(MethodSignature method, long executionTime) {
        Counter counter = (Counter)this._countersByMethodSignature.get(method);
        counter.addMeasurement(executionTime);
    }

    protected MBeanAttributeInfo[] createMBeanAttributeInfo() {
        return this._mBeanAttributeInfos;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        AttributeToCounterLink atcLink = (AttributeToCounterLink)this._mBeanAttributeNameToCounterMap.get(attribute);
        if (atcLink == null) {
            throw new AttributeNotFoundException("Attribute '" + attribute + "' not found");
        }
        String type = atcLink.type;
        Counter counter = atcLink.counter;
        if (type.equals(DATA_TYPE_COUNT)) {
            return new Long(counter.count);
        }
        if (type.equals(DATA_TYPE_AVERAGE_TIME)) {
            return new Long(counter.average);
        }
        if (type.equals(DATA_TYPE_LAST_TIME)) {
            return new Long(counter.last);
        }
        if (type.equals(DATA_TYPE_MINIMUM_TIME)) {
            return new Long(counter.min);
        }
        if (type.equals(DATA_TYPE_MAXIMUM_TIME)) {
            return new Long(counter.max);
        }
        throw new IllegalArgumentException("Unknown performance data type");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

