/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.Db;
import com.sleepycat.db.internal.DbTxn;
import com.sleepycat.db.internal.Dbc;

public class CursorConfig
implements Cloneable {
    public static final CursorConfig DEFAULT = new CursorConfig();
    public static final CursorConfig DIRTY_READ = new CursorConfig();
    public static final CursorConfig DEGREE_2;
    public static final CursorConfig WRITECURSOR;
    private boolean dirtyRead = false;
    private boolean degree2 = false;
    private boolean writeCursor = false;

    static CursorConfig checkNull(CursorConfig cursorConfig) {
        return cursorConfig == null ? DEFAULT : cursorConfig;
    }

    public void setDegree2(boolean bl) {
        this.degree2 = bl;
    }

    public boolean getDegree2() {
        return this.degree2;
    }

    public void setDirtyRead(boolean bl) {
        this.dirtyRead = bl;
    }

    public boolean getDirtyRead() {
        return this.dirtyRead;
    }

    public void setWriteCursor(boolean bl) {
        this.writeCursor = bl;
    }

    public boolean getWriteCursor() {
        return this.writeCursor;
    }

    Dbc openCursor(Db db, DbTxn dbTxn) throws DatabaseException {
        int n = 0;
        n |= this.dirtyRead ? 0x4000000 : 0;
        n |= this.degree2 ? 0x2000000 : 0;
        return db.cursor(dbTxn, n |= this.writeCursor ? 35 : 0);
    }

    static {
        DIRTY_READ.setDirtyRead(true);
        DEGREE_2 = new CursorConfig();
        DEGREE_2.setDegree2(true);
        WRITECURSOR = new CursorConfig();
        WRITECURSOR.setWriteCursor(true);
    }
}

