#!/usr/bin/wishx -f

# need to set this to include the shuffle controls */
set SHUFFLE 0

proc shutdown {} {
puts stdout +
exit

}

proc external {} {
puts stdout " "

}

wm title . "LiveIce"

frame .ch1 -relief sunken
frame .ch2 -relief sunken
frame .exit

pack .ch1 .ch2 .exit -side top
button .exit.exit -text "Quit" -command shutdown -relief raised
button .exit.external -text "External" -command external -relief raised
button .exit.playlist -text "Re-Read Playlist" -command "puts stdout #" -relief raised
pack .exit.external .exit.playlist .exit.exit -side left -fill both



frame .ch1.track
frame .ch1.name
frame .ch1.volume
frame .ch1.speed
frame .ch1.misc

pack .ch1.name .ch1.track .ch1.volume .ch1.speed .ch1.misc -side left

label .ch1.name.track -text "Track"
label .ch1.name.name -text "1"


pack .ch1.name.track .ch1.name.name -side top -fill both

button .ch1.track.up -text "Next" -command "puts stdout 1" -relief raised
button .ch1.track.down -text "Prev" -command "puts stdout q" -relief raised
button .ch1.track.reset -text "Reset" -command "puts stdout w" -relief raised
button .ch1.track.random -text "Random" -command "puts stdout u" -relief raised

pack .ch1.track.up .ch1.track.down .ch1.track.reset .ch1.track.random -side top -fill both

label .ch1.volume.label -text "Vol"
button .ch1.volume.up -text "+" -relief raised -command "puts stdout 3"
button .ch1.volume.down -text "-" -relief raised -command "puts stdout e"
button .ch1.volume.mon -text "Monitor" -relief raised -command "puts stdout t"

pack .ch1.volume.up .ch1.volume.label .ch1.volume.down .ch1.volume.mon -side top -fill both

label .ch1.speed.label -text "Speed"
button .ch1.speed.up -text "+" -relief raised -command "puts stdout 4"
button .ch1.speed.down -text "-" -relief raised -command "puts stdout r"
button .ch1.speed.stop -text "On/Off" -relief raised -command "puts stdout 2"

pack .ch1.speed.up .ch1.speed.label  .ch1.speed.down .ch1.speed.stop -side top -fill both

button .ch1.misc.sticky -text "Sticky" -relief raised -command "puts stdout 5"
if { $SHUFFLE } {
button .ch1.misc.fwd -text "FFwd" -relief raised -command "puts stdout 6"
button .ch1.misc.rew -text "Rew" -relief raised -command "puts stdout y"
} else {
label .ch1.misc.fwd -text "FFwd" -relief raised 
label .ch1.misc.rew -text "Rew" -relief raised 
}
label .ch1.misc.skip -text "Skip"


pack .ch1.misc.fwd .ch1.misc.skip .ch1.misc.rew .ch1.misc.sticky -side top -fill both

frame .ch2.track
frame .ch2.name
frame .ch2.volume
frame .ch2.speed
frame .ch2.misc

pack .ch2.name .ch2.track .ch2.volume .ch2.speed .ch2.misc -side left

label .ch2.name.track -text "Track"
label .ch2.name.name -text "2"

pack .ch2.name.track .ch2.name.name -side top -fill both


button .ch2.track.up -text "Next" -command "puts stdout a" -relief raised
button .ch2.track.down -text "Prev" -command "puts stdout z" -relief raised
button .ch2.track.reset -text "Reset" -command "puts stdout x" -relief raised
button .ch2.track.random -text "Random" -command "puts stdout m" -relief raised

pack .ch2.track.up .ch2.track.down .ch2.track.reset .ch2.track.random -side top -fill both

label .ch2.volume.label -text "Vol"
button .ch2.volume.up -text "+" -relief raised -command "puts stdout d"
button .ch2.volume.down -text "-" -relief raised -command "puts stdout c"
button .ch2.volume.mon -text "Monitor" -relief raised -command "puts stdout b"

pack .ch2.volume.up .ch2.volume.label .ch2.volume.down .ch2.volume.mon -side top -fill both

label .ch2.speed.label -text "Speed"
button .ch2.speed.up -text "+" -relief raised -command "puts stdout f"
button .ch2.speed.down -text "-" -relief raised -command "puts stdout v"
button .ch2.speed.stop -text "On/Off" -relief raised -command "puts stdout s"

pack .ch2.speed.up .ch2.speed.label  .ch2.speed.down .ch2.speed.stop -side top -fill both


button .ch2.misc.sticky -text "Sticky" -relief raised -command "puts stdout g"
if { $SHUFFLE } {
button .ch2.misc.fwd -text "FFwd" -relief raised -command "puts stdout h"
button .ch2.misc.rew -text "Rew" -relief raised -command "puts stdout n"
} else {
label .ch2.misc.fwd -text "FFwd" -relief raised 
label .ch2.misc.rew -text "Rew" -relief raised 
}

label .ch2.misc.skip -text "Skip"

pack .ch2.misc.fwd .ch2.misc.skip .ch2.misc.rew .ch2.misc.sticky -side top -fill both

update

set IOPAIR [ pipe  PIPER PIPEW ]

puts $PIPEW "Blah"
flush $PIPEW

gets $PIPER BLAH

puts stdout $BLAH













