/****************************************************************************
 **
 ** Copyright (C) 2001-2004 The LinCVS development team.
 **    Tilo Riemer <riemer@lincvs.org>
 **    Falk Brettschneider <gigafalk@yahoo.com>
 **    Frank Hemer <frank@hemer.org>
 **    Wim Delvaux <wim.delvaux@chello.be>
 **    Jose Hernandez <joseh@tesco.net>
 **    Helmut Koll <HelmutKoll@web.de>
 **    Tom Mishima <tmishima@mail.at-m.or.jp>
 **    Joerg Preiss <auba@auba.de>
 **    Sven Trogisch <trogisch@iapp.de>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/

#include "config.h"

#include <qgroupbox.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qwhatsthis.h>
#include <qfiledialog.h>

#include "globals.h"
#include "SshKeyDialogImpl.h"

SshKeyDialogImpl::SshKeyDialogImpl( QStringList & keyFileList,
      const QIconSet &whatsThisIconSet,
      QString caption,
      QWidget* parent,
      const char* name,
      bool modal,
      WFlags f)
   : SshKeyDialog( parent, name, modal,f),
     m_keyFileList(&keyFileList),m_Caption(caption)
{
   m_pWhatsThis->setIconSet(whatsThisIconSet);
#ifdef Q_WS_MAC
  m_pWhatsThis->setMaximumWidth(m_pWhatsThis->height() * 2);
#else
  m_pWhatsThis->setMaximumWidth(m_pWhatsThis->height());
#endif

   setCaption(m_Caption);
   m_GroupBox->setTitle(m_Caption);
   resetClicked();

   m_ListBox->setCurrentItem(m_ListBox->count()-1);
   m_ListBox->ensureCurrentVisible();

   connect(m_ListBox,SIGNAL(clicked(QListBoxItem*)),this,SLOT(edited(QListBoxItem*)));
   connect(m_ListBox,SIGNAL(returnPressed(QListBoxItem*)),this,SLOT(edited(QListBoxItem*)));
   connect(m_ListBox,SIGNAL(selectionChanged(QListBoxItem*)),this,SLOT(selectionChanged(QListBoxItem*)));
   m_EnterField->setFocus();

   setTabOrder(m_EnterField,BrowseButton);
   setTabOrder(BrowseButton,AddButton);
   setTabOrder(AddButton,m_ListBox);
   setTabOrder(m_ListBox,ModifyButton);
   setTabOrder(ModifyButton,RemoveButton);
   setTabOrder(RemoveButton,m_pWhatsThis);
   setTabOrder(m_pWhatsThis,OkButton);
   setTabOrder(OkButton,ResetButton);
   setTabOrder(ResetButton,CancelButton);
   setTabOrder(CancelButton,m_EnterField);

}

/*  
 *  Destroys the object and frees any allocated resources
 */
SshKeyDialogImpl::~SshKeyDialogImpl()
{
   // no need to delete child widgets, Qt does it all for us
}

void SshKeyDialogImpl::resetClicked() {
   m_ListBox->clear();
   m_ListBox->insertStringList(*m_keyFileList);
   m_ListBox->setCurrentItem(m_ListBox->count()-1);
   m_ListBox->ensureCurrentVisible();
}

void SshKeyDialogImpl::browseClicked() {
   QString defDir = m_EnterField->text().left(m_EnterField->text().findRev('/'));
   if (defDir.isEmpty() || !QDir(defDir).exists()) {
      defDir = QDir::homeDirPath();
      if (!WINVERSION) defDir += "/.ssh";
   }
   QString fn = QFileDialog::getOpenFileName(defDir, NULL, this, 0,
	 tr("Choose ssh private key file"),
	 NULL, true);
   
   if ( !fn.isEmpty() ) {
      m_EnterField->setText(fn);
   }
}

void SshKeyDialogImpl::addClicked() {
   QString tmp = m_EnterField->text();
   if (tmp.isEmpty()) return;
   QListBoxItem * item = m_ListBox->selectedItem();
   int pos = -1;
   if (item) {
      pos = m_ListBox->currentItem()+1;
   }
   if (pos < 0) pos = m_ListBox->count();
   m_ListBox->insertItem(tmp,pos);
   m_ListBox->setSelected(pos,true);
   m_ListBox->ensureCurrentVisible();
   m_ListBox->centerCurrentItem();
   m_EnterField->clear();
}

void SshKeyDialogImpl::modifyClicked() {
   QString tmp = m_EnterField->text();
   if (tmp.isEmpty()) return;
   int pos = m_ListBox->currentItem();
   if (pos >=0) {
      m_ListBox->changeItem(tmp,pos);
      m_EnterField->clear();
   }
}

void SshKeyDialogImpl::removeClicked() {
   QListBoxItem * item = m_ListBox->selectedItem();
   if (item) {
      int pos = m_ListBox->currentItem();
      m_ListBox->removeItem(pos);
      if ((int)m_ListBox->count()<=pos) {
	 pos--;
      }
      if (pos<0) {
	 m_EnterField->clear();
	 return;
      }
      m_ListBox->setSelected(pos,true);
   }
}

void SshKeyDialogImpl::listClicked(QListBoxItem* item) {
   if (!item) return;
   m_EnterField->setText(item->text());
   m_EnterField->selectAll();
}

void SshKeyDialogImpl::selectionChanged(QListBoxItem* item) {
   if (!item) return;
   m_EnterField->setText(item->text());
   m_EnterField->selectAll();
}

void SshKeyDialogImpl::edited(QListBoxItem*) {
   m_EnterField->setFocus();
}

void SshKeyDialogImpl::accept() {
   SshKeyDialog::accept();

   //set entrylist
   m_keyFileList->clear();
   QListBoxItem* item;
   item = m_ListBox->firstItem();
   while (item) {
      m_keyFileList->append(item->text());
      item = item->next();
   }
}

void SshKeyDialogImpl::enterWhatsThisMode()
{
   QWhatsThis::enterWhatsThisMode();
}
