/****************************************************************************
 **
 ** Copyright (C) 2001-2004 The LinCVS development team.
 **    Tilo Riemer <riemer@lincvs.org>
 **    Falk Brettschneider <gigafalk@yahoo.com>
 **    Frank Hemer <frank@hemer.at>
 **    Wim Delvaux <wim.delvaux@chello.be>
 **    Jose Hernandez <joseh@tesco.net>
 **    Helmut Koll <HelmutKoll@web.de>
 **    Tom Mishima <tmishima@mail.at-m.or.jp>
 **    Joerg Preiss <auba@auba.de>
 **    Sven Trogisch <trogisch@iapp.de>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/

#include "config.h"

#include <qfileinfo.h>
#include <qlistview.h>
#include <qwhatsthis.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qsizegrip.h>

#include "globals.h"
#include "CvsFileViewer.h"
#include "AnnotateDialogImpl.h"

AnnotateDialogImpl::AnnotateDialogImpl (const QIconSet &whatsThisIconSet,
      QWidget* parent, const char* name,
      WFlags fl )
   : AnnotateDialog( LookAndFeel::g_b0AsParent ? 0 : parent, name, fl )
{
   m_pWhatsThis->setIconSet(whatsThisIconSet);
#ifdef Q_WS_MAC
  m_pWhatsThis->setMaximumWidth(m_pWhatsThis->height() * 2);
#else
  m_pWhatsThis->setMaximumWidth(m_pWhatsThis->height());
#endif
   ButtonLayout->addWidget(new QSizeGrip(this),0,Qt::AlignRight|Qt::AlignBottom);
}


AnnotateDialogImpl::~AnnotateDialogImpl()
{
}


void AnnotateDialogImpl::parseCvsAnnotate ( QString name,
      CvsBuffer *pCvsBuffer, QString rev)
{
   QString caption;
   QString line;
   int lineNum = 1;

   caption = tr ("CVS Annotate") + " - " + name;
  
   if (!rev.isEmpty()) {
      caption += " (" + rev + ")";
   }
  
   setCaption (caption);

   unsigned int len = (*pCvsBuffer).numLines();

   int skiplines = outputLineOffset + 1;// must skip some lines
   for ( unsigned int i = skiplines;i<len;i++) {
      line = (*pCvsBuffer).textLine(i);
      if (line.isEmpty()) continue;
      else if (line.find("?") == 0) continue;
      else if (line.find("Annotations for ") == 0) {
	 FileViewer->append ("","","","",0);
	 FileViewer->append ("","","","",0);
	 FileViewer->append ("     --------------------" + line.mid(16) + "--------------------","","","next file:",0);
	 FileViewer->append ("","","","",0);
	 FileViewer->append ("","","","",0);
	 lineNum = 1;
	 continue;
      }
      else if (line.find("*************") == 0) continue;
      else if (line.find("Skipping binary file") == 0) {
	 FileViewer->append (line,"","","",0);
	 continue;
      }
      FileViewer->append (line.mid(35),
	    line.left(13).stripWhiteSpace(),
	    line.mid(14, 8).stripWhiteSpace(),
	    line.mid(23, 9),
	    lineNum);
    
      lineNum++;
   }
}


void AnnotateDialogImpl::parseCvsAnnotateGrepLine( QString name,
      CvsBuffer *pCvsBuffer, QString rev,
      QString searchLine, bool caseSensitive)
{

   QString caption;
   QString line;
   int lineNum = 1;

   caption = tr ("CVS Annotate") + " - " + name;
  
   if (!rev.isEmpty()) {
      caption += " (" + rev + ")";
   }
   setCaption (caption);

   unsigned int len = (*pCvsBuffer).numLines();
   int skiplines = outputLineOffset + 1;// must skip some lines

   for ( unsigned int i = skiplines;i<len;i++) {
      line = (*pCvsBuffer).textLine(i);
      if ( line.isEmpty() || (line.find("?") == 0) || (line.find("*************") == 0) ) continue;
      int pos = line.find(':')+1;
      if (line.find("Annotations for ") == 0) {
	 FileViewer->append ("","","","",0);
	 FileViewer->append ("","","","",0);
	 FileViewer->append ("     --------------------" + line.mid(16) + "--------------------","","","next file:",0);
	 FileViewer->append ("","","","",0);
	 FileViewer->append ("","","","",0);
	 lineNum = 1;
	 continue;
      } else if (line.find(searchLine, pos, caseSensitive) > -1) {
	 FileViewer->append (line.mid(35),
	       line.left(13).stripWhiteSpace(),
	       line.mid(14, 8).stripWhiteSpace(),
	       line.mid(23, 9),
	       lineNum);
      }
      lineNum++;
   }
}

void AnnotateDialogImpl::parseCvsAnnotateGrepLines( QString name,
      CvsBuffer *pCvsBuffer, QString rev,
      QStringList *searchLines, bool caseSensitive)
{

   QString caption;
   QString line;
   int lineNum = 1;

   caption = tr ("CVS Annotate") + " - " + name;
  
   if (!rev.isEmpty()) {
      caption += " (" + rev + ")";
   }
   setCaption (caption);

   unsigned int len = (*pCvsBuffer).numLines();
   int skiplines = outputLineOffset + 1;// must skip some lines

   for ( unsigned int i = skiplines;i<len;i++) {
      line = (*pCvsBuffer).textLine(i);
      if ( line.isEmpty() || (line.find("?") == 0) || (line.find("*************") == 0) ) continue;
      int pos = line.find(':')+1;
      if (line.find("Annotations for ") == 0) {
	 FileViewer->append ("","","","",0);
	 FileViewer->append ("","","","",0);
	 FileViewer->append ("     --------------------" + line.mid(16) + "--------------------","","","next file:",0);
	 FileViewer->append ("","","","",0);
	 FileViewer->append ("","","","",0);
	 lineNum = 1;
	 continue;
      } else {
	 for (unsigned int lineNb = 0; lineNb < searchLines->count(); lineNb++) {
	    if (line.find((*searchLines)[lineNb], pos, caseSensitive) > -1) {
	       FileViewer->append (line.mid(35),
		     line.left(13).stripWhiteSpace(),
		     line.mid(14, 8).stripWhiteSpace(),
		     line.mid(23, 9),
		     lineNum);
	       break;
	    }
	 }
      }
      lineNum++;
   }
}

void AnnotateDialogImpl::enterWhatsThisMode()
{
   QWhatsThis::enterWhatsThisMode();
}
