/****************************************************************************
**
** $Id: cvscontrol.h,v 1.52 2004/05/03 14:52:37 hemer Exp $
**
** Copyright (C) 1999-2004 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Frank Hemer <frank@hemer.org>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Tom Mishima <tmishima@mail.at-m.or.jp>
**    Joerg Preiss <auba@auba.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/


#ifndef CVSCONTROL_H
#define CVSCONTROL_H

#include "config.h"

#include <qpixmap.h>

#include "globals.h"
#include "cmainwindow.h"
#include "CvsBuffer.h"
#include "CCvsOutput.h"
#include "CommitDialogImpl.h"

#include "InteractiveCmdThread.h"
#include "CommandInterface.h"
#include "Timer.h"

class CvsDirListView;
class CvsIgnoreListView;
class NonCvsListView;
class CvsListView;
class Directory;
class InteractiveCmdThread;
class QListView;
class ColorTabWidget;
class CPixmapTimer;
class cvsToolbar;


class CvsControl: public CMainWindow, public CommandInterface

/* class CvsControl: private QObject, public CommandInterface */

{
  Q_OBJECT

 signals:
  void tagListFetched();

 public:
  CvsControl( QString);
  ~CvsControl();
 
  bool addProject(const char * fileName = 0, bool expand = false);
  bool addNewProject(const QString fileName, bool expand = false);
  void callInteractiveCmd( QString& topModule,
			   QString& dir,
			   QString& cvsRoot,
			   QString& repository,
			   int cmd,
			   QString& cvsRsh,
			   bool noroot=false,
			   CommandInterface *instance = NULL);
  void afterCall(int,CvsBuffer*,bool);

 public slots:

  virtual void slot_checkStatus(bool override=FALSE);
  virtual void slot_checkStatusOfTree(Directory *,bool override=FALSE);
  virtual bool slot_checkAutoUpdate();

  void removeProjectSlot();
  void dirConnectorDataNotify();

  /** only for testing purpose, not for release */
  virtual void test();
	
 protected:

  void callCVS(QString,QString,QString,QString,int);
  void readSettings();
  void writeSettings();
  void writeCfg();
  void setSettings();
  void applyProjectSettings(QString projectName = "");
  void checkout( QString, QString, QString, QString,
		 QString, QString, QString, QString,
		 QString, int, int, int, bool);

  void import( QString, QString, QString, QString,
	       QString, QString, QString, QString,
	       QString, int, int, int,
	       QStringList, QStringList);

  void importVendor( QString, QString, QString, QString,
		     QString, QString, QString, QString,
		     QStringList, QStringList);

  void exportProject( QString, QString, QString, QString,
		      QString, QString, QString, QString,
		      QString, int, int, int, bool);

  void finishCheckOut(CvsBuffer*);
  void finishImport();
  void recValidateCvsFilesStatus(bool forceCacheReset = false, bool forceEntriesReset = false);
  void addSelectedFiles(bool bAsBinary);
  void updateDir(bool,bool);
  void replaceDir(bool);
  void updateFile(bool);
  void annotateDir();
  void annotateFile();
  void annotateGrepLineDir();
  void annotateGrepLinesDir();
  void annotateGrepLineFile();
  void annotateGrepLinesFile();
  void addCvsFiles(Directory *,const QStringList,bool);
  QString * getCurrentProfile() { return &m_coImportLastProfile;}
  QStringList getVendorTagList() { return m_coImportVendorTag;}
  QStringList getReleaseTagList() { return m_coImportReleaseTag;}
  QString getLastComment() { return m_coImportLastComment;}
  QStringList * getCurrentTagList() { return &m_currentTagList;}

  //file mapping
  struct FileAppItem {
    QString wildcard;
    QString app;
    QString params;
    bool isRegExp;
  };
  typedef QValueList<FileAppItem> FileAppList;
  FileAppList openFileAppList;
  FileAppList viewFileAppList;

  static const bool OVERRIDE;

  cvsToolbar *m_pTools;   //needed for whatsthis iconset

  //Flags for GUI blocking
  enum Block {
    BLOCKALL = 0,
    BLOCKNOCURSOR = 1,
    BLOCKNOCONTROLS = 2
  };

  /* -------------------------------- move these to gui later --------------------------------- */

  // Progress (image) timer related stuff
  CPixmapTimer *m_pPixmapTimer;
  
  CCvsOutput *m_pMessages;
  CvsDirListView *m_pWorkBenchTree;
  ColorTabWidget *m_pFileViews;
  CvsListView *m_pCvsFileList;
  NonCvsListView *m_pNonCvsFileList;
  CvsIgnoreListView *m_pCvsIgnoreFileList;
  
  CommitDialogImpl     *m_pCommitDlg;

  CSyntaxHighlighter* m_pSyntaxHighlighter;


  /* ---------------------------- these need to be checked after redesign -------------------------------- */

  //AutoUpdate
  Timer   m_updateTimer;
  
  //checkStatus
  Timer   m_timer;

  enum Timers {
    TALL = 0,
    TSTATUS = 1,
    TUPDATE = 2
  };

  void stopTimers(int = TALL);
  void startTimers(int = TALL);

  //dir of last(current) cvs call
  Directory       *m_pCurCvsDir;

  /* ----------------------------------------------------------------------------------- */

 protected slots:

  /** Help menu slots */
  void slot_debug();
  void slot_onlineHelp();

  void removeDir();
  void removeDirIfNoCvsRegisteredFiles();
  void rereadProject();
  void stopCurAction();
  void killInteractiveCmdThread();
  void statusDir();
  void updateAny();
  void mergeAny();
  void editFile( QString);
  void viewFileWithPath( QString);
  void openFile();
  void viewFile();
  void updateDir();
  void queryUpdateDir();
  void updateAllDir();
  void queryUpdateAllDir();
  void updateRevDir(QString);
  void revertToRevDir(QString param=QString::null);
  void updateToDirBranch(bool=false,bool=false);
  void commitAny();
  void commitDir();
  void mergeDir();
  void mergeFile();
  void annotateAny();
  void annotateGrepLine();
  void annotateGrepLines();
  void logDir();
  void historyDir();
  void loginDir();
  void logoutDir();
  void browseDir();
  void openShellDir();
  void removeLocalOptionsDir();
  void addSelectedFiles();
  void addSelectedBinFiles();
  void createNewFile();
  void createNewDir();
  void resurrectSelectedFiles();
  void statusFile();
  void diffFile();
  void diffAdvancedFile();
  void diffDir();
  void diffAdvancedDir();
  void diffFileSideBySide();
  void renameFile();
  void renameCurrentDir(QString);
  void updateFile();
  void queryUpdateFile();
  void updateRevFile(QString);
  void revertToRevFile(QString param=QString::null);
  void updateFilesToDirBranch();
  void commitFile();
  void logFile();
  void historyFile();
  void removeFile();
  void removeFileFromRep();
  void removeFileFromDisk();
  void removeNonCvsFileFromDisk();
  void removeCvsIgnoreFileFromDisk(); 
  void initialDirScanning();
  void expandDir();
  void collapsDir();
  void removeLocalOptionsFile();
  void watchAdd();
  void watchRemove();
  void watchOn();
  void watchOff();
  void cvsEditFile();
  void cvsUneditFile();
  void cvsEditDir();
  void cvsUneditDir();
  void cvsLockFile();
  void cvsUnlockFile();
  void cvsLockDir();
  void cvsUnlockDir();
  void editorsFile();
  void editorsDir();
  void watchersFile();
  void watchersDir();
  void release();
  void release_and_remove();
  void disableProjectSlot();
  void enableProjectSlot();
  void exportFromModuleDir();
  void replaceFile();
  void replaceDir();
  void replaceAllDir();
  void updateVirtualDir();
  void addCvsFiles(const QStringList,bool);
  void moveCvsFiles(const QString dropDir = QString::null,const QStringList list = NULL);
  void createDirTreePatch(Directory *,const QString&);
  void updateProjectTagList();
  void readCurrentTagList();

 private:

  virtual void writeSetup() = 0;
  virtual void initDone() = 0;
  virtual void setStatusText( const QString&, int ms=0) = 0;
  virtual void blockGUI(bool,int=BLOCKALL) = 0;
  virtual bool isGuiBlocked() = 0;
  virtual QString getNamesOfSelectedFiles() = 0;
  virtual QString getNamesOfSelectedFilesWithoutSelCheck() = 0;
  virtual QString getNameOfFirstSelectedFile() = 0;
  virtual void getNameAndRevOfFirstSelectedFile(QString *name, QString *rev) = 0;
  virtual QString getRev(QString *fileToFind) = 0;
  virtual Directory* getSelectedDir() = 0;
  virtual QStringList getSelectedFilesList() = 0;
  virtual void showInfo(const QString&, const QString&) = 0;
  virtual void showWarning(const QString&, const QString&) = 0;
  virtual bool showYesNoQuestion(const QString&, const QString&) = 0;
  virtual bool showOkCancelQuestion(const QString&, const QString&) = 0;
  virtual void saveViewportPos(bool override=FALSE) = 0;
  virtual void recoverViewportPos() = 0;
  virtual void checkInProgress(bool) = 0;

  void cvsCallFailed(int,CommandInterface*);
  void finishInteractiveCmd();
  bool moveProject(const QString&, const QString&, const QString&);
  bool renameProject(const QString&, const QString&);
  void expurgateProjectSettings();
  void fillCmdDebugStream(QTextStream&);

  FileAppItem getMatchForWildcard(QStringList &, FileAppList &);

  // since this function removes the project tree, the
  // returned entry is the new allocated entry for the dir
  // with the same fullpath as the Dir argument
  Directory * rereadProjectOfDir( Directory * Dir ) ;
  void doRemoveFileFromRepOrDisk (int FromRem, int FromDisk);
  bool removeDirTreeFromDisk(QString,bool);
  bool removeFilesInTreeFromDisk(QString,bool);
  void performRereadProject( QString,QString);
  void doRelease( bool remove=false);
  Directory *  openTreeAt(const QString&,const QString&);
  Directory *  openTreeAndActivate(const QString&,QString);

  // InteractiveCmdThread-related stuff
  CvsBuffer*             m_pCvsBuffer;
  bool                   m_interactiveCmdThreadIsRunning;
  bool                   m_chainedCommand;
  InteractiveCmdThread  *m_pInteractiveCmdThread;
  Directory *            m_pLastCvsCallDir;

  QString          m_lastOpenedDir;
  
  bool autoUpdate(QString, Directory**, int&);

  //state of checkout-import-dlg
  int              m_coImportLastAccessMethod;
  QStringList      m_coImportVendorTag;
  QStringList      m_coImportReleaseTag;
  QString          m_coImportLastComment;
  QString          m_coImportLastProfile;
   
  bool             m_stopAction;
  bool             m_showWarning;
  
  bool             m_bExternalDiffIsRunning;  // is true if diff runs using external program for diff
  QString          m_curDiffFileName;      //used for external diff
  QString          m_curTmpDiffFileName;   //used for external diff
  QString          m_FirstPosAddedDir;     //used for adding Dirs
  QStringList      m_AddedFilesList;       //used for adding Files/Dirs
  QString          m_newFileName;          //used for renaming 1 file
  QStringList      m_newFileNameList;      //used for removing files

  QString          m_coImportLocalDirectory;   //for checkout
  QString          m_coModule;                 //name of module (real dirname and name in workbench)
  
  QStringList      m_currentTagList;
  QString          m_curCommentFileName;
  QString          m_searchLine;
  QStringList      m_searchLines;
  bool             m_caseSensitive;

  QString          m_tmpStartUpDir;

  QValueList<QString> m_DirsToKill;

  //DebugFile related stuff
  QString m_debugCvsCallString;
  
 private slots:
  void handleMessage(MESSAGE);
  void cvsCommandFinished();
  void startInSingleDir();
  void slot_requestDirectorySuicide(const QVariant&);
  void slot_execDirectorySuicide();

};

//----------------------------------------------------------------------------

#endif   //CVSCONTROL_H

