// $Header: /home/cvs/jakarta-jmeter/src/protocol/http/org/apache/jmeter/protocol/http/control/Header.java,v 1.6 2004/02/12 00:07:12 sebb Exp $
/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
*/

package org.apache.jmeter.protocol.http.control;

import java.io.Serializable;

import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.testelement.AbstractTestElement;

/**
 * This class is an HTTP Header encapsulator.
 *
 * @author  <a href="mailto:giacomo@apache.org">Giacomo Pati</a>
 * @version $Revision: 1.6 $ last updated $Date: 2004/02/12 00:07:12 $
 */
public class Header extends AbstractTestElement implements Serializable
{
    private static String VALUE = "Header.value";

    /**
     * Create the header.
     */
    public Header()
    {
        this.setName("");
        this.setValue("");
    }

    /**
     * Create the coookie.
     */
    public Header(String name, String value)
    {
        this.setName(name);
        this.setValue(value);
    }

    public void addConfigElement(ConfigElement config)
    {
    }

    public boolean expectsModification()
    {
        return false;
    }

    public String getClassLabel()
    {
        return "Header";
    }

    /**
     * Get the value for this object.
     */
    public String getValue()
    {
        return getPropertyAsString(VALUE);
    }

    /**
     * Set the value for this object.
     */
    public synchronized void setValue(String value)
    {
        this.setProperty(VALUE, value);
    }

    /**
     * Creates a string representation of this header.
     */
    public String toString()
    {
        return getName() + "\t" + getValue();
    }
}
