// $Header: /home/cvs/jakarta-jmeter/src/core/org/apache/jmeter/gui/OnErrorPanel.java,v 1.3 2004/03/30 18:08:09 sebb Exp $
/*
 * Copyright 2003-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
*/

package org.apache.jmeter.gui;
import java.awt.BorderLayout;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import org.apache.jmeter.testelement.OnErrorTestElement;
import org.apache.jmeter.util.JMeterUtils;

/**
 * 
 * @version $Revision: 1.3 $ $Date: 2004/03/30 18:08:09 $
 */
public class OnErrorPanel extends JPanel 
{
	// Sampler error action buttons
	private JRadioButton continueBox;
	private JRadioButton stopThrdBox;
	private JRadioButton stopTestBox;

	private JPanel createOnErrorPanel()
	{
		JPanel panel = new JPanel();
		panel.setBorder(
			BorderFactory.createTitledBorder(
				JMeterUtils.getResString("sampler_on_error_action")));

		ButtonGroup group = new ButtonGroup();

		continueBox =
			new JRadioButton(JMeterUtils.getResString("sampler_on_error_continue"));
		group.add(continueBox);
		continueBox.setSelected(true);
		panel.add(continueBox);

		stopThrdBox =
			new JRadioButton(JMeterUtils.getResString("sampler_on_error_stop_thread"));
		group.add(stopThrdBox);
		panel.add(stopThrdBox);

		stopTestBox =
			new JRadioButton(JMeterUtils.getResString("sampler_on_error_stop_test"));
		group.add(stopTestBox);
		panel.add(stopTestBox);

		return panel;
	}
    /**
     * Create a new NamePanel with the default name.
     */
    public OnErrorPanel()
    {
        init();
    }

    /**
     * Initialize the GUI components and layout.
     */
    private void init()
    {
        setLayout(new BorderLayout(5, 0));
        add(createOnErrorPanel());
    }
    public void configure(int errorAction)
    {
		stopTestBox.setSelected(errorAction == OnErrorTestElement.ON_ERROR_STOPTEST);
		stopThrdBox.setSelected(errorAction == OnErrorTestElement.ON_ERROR_STOPTHREAD);
		//continueBox.setSelected(etc);// no need to set the remaining Radio Button
    }
    
    public int getOnErrorSetting()
    {
		if (stopTestBox.isSelected()) return OnErrorTestElement.ON_ERROR_STOPTEST;
		if (stopThrdBox.isSelected()) return OnErrorTestElement.ON_ERROR_STOPTHREAD;

		// Defaults to continue
		return OnErrorTestElement.ON_ERROR_CONTINUE;
    }
}
