// $Header: /home/cvs/jakarta-jmeter/src/components/org/apache/jmeter/control/RandomController.java,v 1.10 2004/02/13 01:31:55 sebb Exp $
/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
*/

package org.apache.jmeter.control;

import java.io.Serializable;
import java.util.Random;

/**
 * @author Michael Stover
 * @version $Revision: 1.10 $
 */
public class RandomController extends InterleaveControl implements Serializable
{
    static Random rand = new Random();

    public RandomController()
    {
    }

    /**
     * @see org.apache.jmeter.control.GenericController#resetCurrent()
     */
    protected void resetCurrent()
    {
        if (getSubControllers().size() > 0)
        {
            current = rand.nextInt(this.getSubControllers().size());
        }
        else
        {
            current = 0;
        }
    }

    /**
     * @see org.apache.jmeter.control.GenericController#incrementCurrent()
     */
    protected void incrementCurrent()
    {
        super.incrementCurrent();
        current = rand.nextInt(this.getSubControllers().size());
    }

}
