/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.OverlayTextField;
import com.jidesoft.swing.Overlayable;
import com.jidesoft.swing.SelectAllUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LabeledTextField
extends JPanel {
    protected JTextField _textField;
    protected JLabel _label;
    protected AbstractButton _button;
    protected String _labelText;
    protected Icon _icon;
    protected String _hintText;
    protected boolean _showHintTextWhenFocused = false;
    protected JLabel _hintLabel;
    protected PopupMenuCustomizer _customizer;
    protected KeyStroke _contextMenuKeyStroke;
    private DefaultOverlayable _hintOverlayable;

    public LabeledTextField() {
        this(null, null);
    }

    public LabeledTextField(Icon icon) {
        this(icon, null);
    }

    public LabeledTextField(Icon icon, String labelText) {
        this._icon = icon;
        this._labelText = labelText;
        this.initComponent();
    }

    protected void initComponent() {
        this._label = this.createLabel();
        if (this._label != null) {
            this._label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    LabeledTextField.this.showContextMenu();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
        }
        this._button = this.createButton();
        this._textField = this.createTextField();
        this.initLayout(this._label, this._textField, this._button);
        this.setContextMenuKeyStroke(KeyStroke.getKeyStroke(40, 512));
        this.registerContextMenuKeyStroke(this.getContextMenuKeyStroke());
        this.updateUI();
    }

    private void registerContextMenuKeyStroke(KeyStroke keyStroke) {
        if (keyStroke != null) {
            this.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LabeledTextField.this.showContextMenu();
                }
            }, keyStroke, 1);
        }
    }

    private void unregisterContextMenuKeyStroke(KeyStroke keyStroke) {
        if (keyStroke != null) {
            this.unregisterKeyboardAction(keyStroke);
        }
    }

    protected void showContextMenu() {
        if (this.isEnabled()) {
            JidePopupMenu menu = this.createContextMenu();
            this.customizePopupMenu(menu);
            PopupMenuCustomizer customizer = this.getPopupMenuCustomizer();
            if (customizer != null && menu != null) {
                customizer.customize(this, menu);
            }
            if (menu != null && menu.getComponentCount() > 0) {
                Point location = this.calculateContextMenuLocation();
                JideSwingUtilities.showPopupMenu(menu, this, location.x, location.y);
            }
        }
    }

    protected Point calculateContextMenuLocation() {
        Point location = this._label.getLocation();
        return new Point(location.x + (this._label.getIcon() == null ? 1 : this._label.getIcon().getIconWidth() / 2), location.y + this._label.getHeight() + 1);
    }

    protected void customizePopupMenu(JPopupMenu menu) {
    }

    protected void initLayout(JLabel label, final JTextField field, AbstractButton button) {
        this.setLayout(new BorderLayout(3, 3));
        if (label != null) {
            this.add((Component)label, "Before");
        }
        this._hintLabel = new JLabel(this.getHintText());
        this._hintLabel.setOpaque(false);
        Color foreground = UIDefaultsLookup.getColor("Label.disabledForeground");
        if (foreground == null) {
            foreground = Color.GRAY;
        }
        this._hintLabel.setForeground(foreground);
        this._hintOverlayable = new DefaultOverlayable(field, this._hintLabel, 10);
        this._hintOverlayable.setOpaque(false);
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                LabeledTextField.this.adjustOverlay(field, LabeledTextField.this._hintOverlayable);
            }

            @Override
            public void focusGained(FocusEvent e) {
                LabeledTextField.this.adjustOverlay(field, LabeledTextField.this._hintOverlayable);
            }
        });
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LabeledTextField.this.adjustOverlay(field, LabeledTextField.this._hintOverlayable);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LabeledTextField.this.adjustOverlay(field, LabeledTextField.this._hintOverlayable);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LabeledTextField.this.adjustOverlay(field, LabeledTextField.this._hintOverlayable);
            }
        });
        this.add(this._hintOverlayable);
        if (button != null) {
            this.add((Component)button, "After");
        }
    }

    public boolean isShowHintTextWhenFocused() {
        return this._showHintTextWhenFocused;
    }

    public void setShowHintTextWhenFocused(boolean showHintTextWhenFocused) {
        this._showHintTextWhenFocused = showHintTextWhenFocused;
        if (this._textField != null && this._hintOverlayable != null) {
            this.adjustOverlay(this._textField, this._hintOverlayable);
        }
    }

    private void adjustOverlay(JTextField field, Overlayable overlayable) {
        if (field.hasFocus() && !this.isShowHintTextWhenFocused()) {
            overlayable.setOverlayVisible(false);
        } else {
            String text = field.getText();
            if (text != null && text.length() != 0) {
                overlayable.setOverlayVisible(false);
            } else {
                overlayable.setOverlayVisible(true);
            }
        }
    }

    protected JTextField createTextField() {
        OverlayTextField textField = new OverlayTextField();
        SelectAllUtils.install(textField);
        JideSwingUtilities.setComponentTransparent(textField);
        textField.setColumns(20);
        return textField;
    }

    protected JidePopupMenu createContextMenu() {
        return new JidePopupMenu();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Border textFieldBorder = UIDefaultsLookup.getBorder("TextField.border");
        if (textFieldBorder != null) {
            boolean big;
            boolean bl = big = textFieldBorder.getBorderInsets((Component)this).top >= 2;
            if (big) {
                this.setBorder(textFieldBorder);
            } else {
                this.setBorder(BorderFactory.createCompoundBorder(textFieldBorder, BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            }
        } else {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }
        if (this.isEnabled()) {
            LookAndFeel.installColors(this, "TextField.background", "TextField.foreground");
        } else {
            LookAndFeel.installColors(this, "TextField.disableBackground", "TextField.inactiveForeground");
        }
        if (textFieldBorder != null && this._textField != null) {
            this._textField.setBorder(BorderFactory.createEmptyBorder());
        }
        this.setEnabled(this.isEnabled());
    }

    protected AbstractButton createButton() {
        return null;
    }

    protected JLabel createLabel() {
        JLabel label = new JLabel(this._icon);
        label.setText(this._labelText);
        return label;
    }

    public void setLabelText(String text) {
        this._labelText = text;
        if (this._label != null) {
            this._label.setText(text);
        }
    }

    public String getLabelText() {
        if (this._label != null) {
            return this._label.getText();
        }
        return this._labelText;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
        if (this._label != null) {
            this._label.setIcon(icon);
        }
    }

    public Icon getIcon() {
        if (this._label != null) {
            return this._label.getIcon();
        }
        return this._icon;
    }

    public JLabel getLabel() {
        return this._label;
    }

    public AbstractButton getButton() {
        return this._button;
    }

    public void setColumns(int columns) {
        if (this.getTextField() != null) {
            this.getTextField().setColumns(columns);
        }
    }

    public void setText(String text) {
        if (this.getTextField() != null) {
            this.getTextField().setText(text);
        }
    }

    public String getText() {
        if (this.getTextField() != null) {
            return this.getTextField().getText();
        }
        return null;
    }

    public JTextField getTextField() {
        return this._textField;
    }

    @Override
    public void setEnabled(boolean enabled) {
        JTextField textField;
        super.setEnabled(enabled);
        if (enabled) {
            if (this.getTextField() != null) {
                this.getTextField().setEnabled(true);
            }
            if (this.getLabel() != null) {
                this.getLabel().setEnabled(true);
            }
            if (this.getButton() != null) {
                this.getButton().setEnabled(true);
            }
        } else {
            if (this.getTextField() != null) {
                this.getTextField().setEnabled(false);
            }
            if (this.getLabel() != null) {
                this.getLabel().setEnabled(false);
            }
            if (this.getButton() != null) {
                this.getButton().setEnabled(false);
            }
            this.setBackground(UIDefaultsLookup.getColor("control"));
        }
        if (this._hintLabel != null) {
            boolean textEmpty = true;
            if (this.getTextField() != null) {
                textEmpty = this.getTextField().getText() == null || this.getTextField().getText().length() == 0;
            }
            this._hintLabel.setVisible(this.isEnabled() && textEmpty);
        }
        if ((textField = this.getTextField()) != null) {
            this.setBackground(textField.getBackground());
            this.setForeground(textField.getForeground());
        } else if (enabled) {
            this.setBackground(UIDefaultsLookup.getColor("TextField.background"));
            this.setForeground(UIDefaultsLookup.getColor("TextField.foreground"));
        } else {
            Color background = UIDefaultsLookup.getColor("TextField.disabledBackground");
            if (background == null) {
                background = UIDefaultsLookup.getColor("TextField.inactiveBackground");
            }
            this.setBackground(background);
            this.setForeground(UIDefaultsLookup.getColor("TextField.inactiveForeground"));
        }
    }

    @Override
    public int getBaseline(int width, int height) {
        if (SystemInfo.isJdk6Above()) {
            try {
                Method method = Component.class.getMethod("getBaseline", Integer.TYPE, Integer.TYPE);
                Object value = method.invoke((Object)this._textField, width, height);
                if (value instanceof Integer) {
                    return (Integer)value;
                }
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return -1;
    }

    public String getHintText() {
        return this._hintText;
    }

    public void setHintText(String hintText) {
        this._hintText = hintText;
        if (this._hintLabel != null) {
            this._hintLabel.setText(this._hintText);
        }
    }

    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this._customizer;
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer customizer) {
        this._customizer = customizer;
    }

    public KeyStroke getContextMenuKeyStroke() {
        if (this._contextMenuKeyStroke == null) {
            this._contextMenuKeyStroke = !SystemInfo.isMacOSX() ? KeyStroke.getKeyStroke(121, 1) : null;
        }
        return this._contextMenuKeyStroke;
    }

    public void setContextMenuKeyStroke(KeyStroke contextMenuKeyStroke) {
        if (this._contextMenuKeyStroke != null) {
            this.unregisterContextMenuKeyStroke(this._contextMenuKeyStroke);
        }
        this._contextMenuKeyStroke = contextMenuKeyStroke;
        if (this._contextMenuKeyStroke != null) {
            this.registerContextMenuKeyStroke(this._contextMenuKeyStroke);
        }
    }

    public static interface PopupMenuCustomizer {
        public void customize(LabeledTextField var1, JPopupMenu var2);
    }
}

