/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.Indexer;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Path;

class StreamInflatingIndexingOutputStream
extends OutputStream {
    private final OutputStream s1;
    private final PipedOutputStream s2;
    private final Thread thread;

    public StreamInflatingIndexingOutputStream(OutputStream s1, File indexFile) {
        this(s1, indexFile.toPath());
    }

    public StreamInflatingIndexingOutputStream(OutputStream s1, Path indexPath) {
        try {
            this.s1 = s1;
            this.s2 = new PipedOutputStream();
            PipedInputStream pin = new PipedInputStream(this.s2, Defaults.NON_ZERO_BUFFER_SIZE);
            this.thread = new Thread((Runnable)new Indexer(indexPath, pin), "BamIndexingThread");
            this.thread.start();
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }

    @Override
    public final void write(int b) throws IOException {
        this.s1.write(b);
        this.s2.write(b);
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.s1.write(b);
        this.s2.write(b);
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        this.s1.write(b, off, len);
        this.s2.write(b, off, len);
    }

    @Override
    public final void flush() throws IOException {
        this.s1.flush();
        this.s2.flush();
    }

    @Override
    public final void close() throws IOException {
        this.s1.close();
        this.s2.close();
        try {
            this.thread.join();
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }
}

