/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble;

import htsjdk.tribble.util.ParsingUtils;
import java.io.File;

public class Tribble {
    public static final String STANDARD_INDEX_EXTENSION = ".idx";

    private Tribble() {
    }

    public static String indexFile(String filename) {
        return Tribble.indexFile(filename, STANDARD_INDEX_EXTENSION);
    }

    public static File indexFile(File file) {
        return Tribble.indexFile(file.getAbsoluteFile(), STANDARD_INDEX_EXTENSION);
    }

    public static String tabixIndexFile(String filename) {
        return Tribble.indexFile(filename, ".tbi");
    }

    public static File tabixIndexFile(File file) {
        return Tribble.indexFile(file.getAbsoluteFile(), ".tbi");
    }

    private static String indexFile(String filename, String extension) {
        return ParsingUtils.appendToPath(filename, extension);
    }

    private static File indexFile(File file, String extension) {
        return new File(file.getAbsoluteFile() + extension);
    }
}

