/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.BlockCompressionMethod;
import htsjdk.samtools.cram.structure.BlockContentType;
import htsjdk.samtools.cram.structure.Slice;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

public class SliceIO {
    public void readSliceHeadBlock(Slice s, InputStream is) throws IOException {
        s.headerBlock = new Block(is, true, true);
        this.parseSliceHeaderBlock(s);
    }

    public void parseSliceHeaderBlock(Slice s) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(s.headerBlock.getRawContent());
        s.sequenceId = ByteBufferUtils.readUnsignedITF8(is);
        s.alignmentStart = ByteBufferUtils.readUnsignedITF8(is);
        s.alignmentSpan = ByteBufferUtils.readUnsignedITF8(is);
        s.nofRecords = ByteBufferUtils.readUnsignedITF8(is);
        s.globalRecordCounter = ByteBufferUtils.readUnsignedLTF8(is);
        s.nofBlocks = ByteBufferUtils.readUnsignedITF8(is);
        s.contentIDs = ByteBufferUtils.array(is);
        s.embeddedRefBlockContentID = ByteBufferUtils.readUnsignedITF8(is);
        s.refMD5 = new byte[16];
        ByteBufferUtils.readFully(s.refMD5, is);
    }

    public byte[] createSliceHeaderBlockContent(Slice s) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteBufferUtils.writeUnsignedITF8(s.sequenceId, baos);
        ByteBufferUtils.writeUnsignedITF8(s.alignmentStart, baos);
        ByteBufferUtils.writeUnsignedITF8(s.alignmentSpan, baos);
        ByteBufferUtils.writeUnsignedITF8(s.nofRecords, baos);
        ByteBufferUtils.writeUnsignedLTF8(s.globalRecordCounter, baos);
        ByteBufferUtils.writeUnsignedITF8(s.nofBlocks, baos);
        s.contentIDs = new int[s.external.size()];
        int i = 0;
        for (int id : s.external.keySet()) {
            s.contentIDs[i++] = id;
        }
        ByteBufferUtils.write(s.contentIDs, baos);
        ByteBufferUtils.writeUnsignedITF8(s.embeddedRefBlockContentID, baos);
        baos.write(s.refMD5 == null ? new byte[16] : s.refMD5);
        ByteBufferUtils.writeUnsignedITF8(s.sequenceId, baos);
        ByteBufferUtils.writeUnsignedITF8(s.sequenceId, baos);
        ByteBufferUtils.writeUnsignedITF8(s.sequenceId, baos);
        return baos.toByteArray();
    }

    public void createSliceHeaderBlock(Slice s) throws IOException {
        byte[] rawContent = this.createSliceHeaderBlockContent(s);
        s.headerBlock = new Block(BlockCompressionMethod.RAW, BlockContentType.MAPPED_SLICE, 0, rawContent, null);
    }

    public void readSliceBlocks(Slice s, boolean uncompressBlocks, InputStream is) throws IOException {
        s.external = new HashMap<Integer, Block>();
        block4: for (int i = 0; i < s.nofBlocks; ++i) {
            Block b1 = new Block(is, true, uncompressBlocks);
            switch (b1.contentType) {
                case CORE: {
                    s.coreBlock = b1;
                    continue block4;
                }
                case EXTERNAL: {
                    if (s.embeddedRefBlockContentID == b1.contentId) {
                        s.embeddedRefBlock = b1;
                    }
                    s.external.put(b1.contentId, b1);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Not a slice block, content type id " + b1.contentType.name());
                }
            }
        }
    }

    public void write(Slice s, OutputStream os) throws IOException {
        s.nofBlocks = 1 + s.external.size() + (s.embeddedRefBlock == null ? 0 : 1);
        s.contentIDs = new int[s.external.size()];
        int i = 0;
        Iterator<Integer> i$ = s.external.keySet().iterator();
        while (i$.hasNext()) {
            int id;
            s.contentIDs[i] = id = i$.next().intValue();
        }
        this.createSliceHeaderBlock(s);
        s.headerBlock.write(os);
        s.coreBlock.write(os);
        for (Block e : s.external.values()) {
            e.write(os);
        }
    }

    public void read(Slice s, InputStream is) throws IOException {
        this.readSliceHeadBlock(s, is);
        this.readSliceBlocks(s, true, is);
    }
}

