/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.CanonicalHuffmanIntegerCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class HuffmanEncoding
implements Encoding<Integer> {
    public static final EncodingID ENCODING_ID = EncodingID.HUFFMAN;
    private int[] bitLengths;
    private int[] values;

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buf = ByteBuffer.allocate(1024);
        ByteBufferUtils.writeUnsignedITF8(this.values.length, buf);
        for (int value : this.values) {
            ByteBufferUtils.writeUnsignedITF8(value, buf);
        }
        ByteBufferUtils.writeUnsignedITF8(this.bitLengths.length, buf);
        for (int value : this.bitLengths) {
            ByteBufferUtils.writeUnsignedITF8(value, buf);
        }
        buf.flip();
        byte[] array = new byte[buf.limit()];
        buf.get(array);
        return array;
    }

    @Override
    public void fromByteArray(byte[] data) {
        int i;
        ByteBuffer buf = ByteBuffer.wrap(data);
        int size = ByteBufferUtils.readUnsignedITF8(buf);
        this.values = new int[size];
        for (i = 0; i < size; ++i) {
            this.values[i] = ByteBufferUtils.readUnsignedITF8(buf);
        }
        size = ByteBufferUtils.readUnsignedITF8(buf);
        this.bitLengths = new int[size];
        for (i = 0; i < size; ++i) {
            this.bitLengths[i] = ByteBufferUtils.readUnsignedITF8(buf);
        }
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        return new CanonicalHuffmanIntegerCodec(this.values, this.bitLengths);
    }

    public static EncodingParams toParam(int[] bfValues, int[] bfBitLens) {
        HuffmanEncoding e = new HuffmanEncoding();
        e.values = bfValues;
        e.bitLengths = bfBitLens;
        return new EncodingParams(ENCODING_ID, e.toByteArray());
    }
}

