/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

public class BetaIntegerCodec
extends AbstractBitCodec<Integer> {
    private int offset = 0;
    private int readNofBits;

    public BetaIntegerCodec(int offset, int readNofBits) {
        this.offset = offset;
        this.readNofBits = readNofBits;
    }

    @Override
    public final Integer read(BitInputStream bis) throws IOException {
        return bis.readBits(this.readNofBits) - this.offset;
    }

    @Override
    public final long write(BitOutputStream bos, Integer value) throws IOException {
        int nofBits = (int)this.numberOfBits(value);
        long newValue = value + this.offset;
        bos.write(newValue, nofBits);
        return nofBits;
    }

    @Override
    public final long numberOfBits(Integer value) {
        if ((long)value.intValue() > 1L << this.readNofBits) {
            throw new IllegalArgumentException("Value written is bigger then allowed: value=" + value + ", max nof bits=" + this.readNofBits);
        }
        return this.readNofBits;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getReadNofBits() {
        return this.readNofBits;
    }

    public void setReadNofBits(int readNofBits) {
        this.readNofBits = readNofBits;
    }

    @Override
    public Integer read(BitInputStream bis, int len) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

