/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.build.Utils;
import htsjdk.samtools.cram.encoding.read_features.BaseQualityScore;
import htsjdk.samtools.cram.encoding.read_features.Deletion;
import htsjdk.samtools.cram.encoding.read_features.InsertBase;
import htsjdk.samtools.cram.encoding.read_features.Insertion;
import htsjdk.samtools.cram.encoding.read_features.ReadBase;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.encoding.read_features.SoftClip;
import htsjdk.samtools.cram.encoding.read_features.Substitution;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CramNormalizer {
    private SAMFileHeader header;
    private int readCounter = 0;
    private String readNamePrefix = "";
    private byte defaultQualityScore = (byte)30;
    private static Log log = Log.getInstance(CramNormalizer.class);
    private ReferenceSource referenceSource;

    public CramNormalizer(SAMFileHeader header) {
        this.header = header;
    }

    public CramNormalizer(SAMFileHeader header, ReferenceSource referenceSource) {
        this.header = header;
        this.referenceSource = referenceSource;
    }

    public void normalize(ArrayList<CramCompressionRecord> records, boolean resetPairing, byte[] ref, int alignmentStart, SubstitutionMatrix substitutionMatrix, boolean AP_delta) {
        int startCounter = this.readCounter;
        for (CramCompressionRecord r : records) {
            r.index = ++this.readCounter;
            if (r.sequenceId == -1) {
                r.sequenceName = "*";
                r.alignmentStart = 0;
                continue;
            }
            r.sequenceName = this.header.getSequence(r.sequenceId).getSequenceName();
        }
        for (CramCompressionRecord r : records) {
            int tlen;
            CramCompressionRecord downMate;
            if (!r.isMultiFragment() || r.isDetached()) {
                r.recordsToNextFragment = -1;
                r.next = null;
                r.previous = null;
                continue;
            }
            if (!r.isHasMateDownStream()) continue;
            r.next = downMate = records.get(r.index + r.recordsToNextFragment - startCounter);
            downMate.previous = r;
            r.mateAlignmentStart = downMate.alignmentStart;
            r.setMateUmapped(downMate.isSegmentUnmapped());
            r.setMateNegativeStrand(downMate.isNegativeStrand());
            r.mateSequenceID = downMate.sequenceId;
            if (r.mateSequenceID == -1) {
                r.mateAlignmentStart = 0;
            }
            downMate.mateAlignmentStart = r.alignmentStart;
            downMate.setMateUmapped(r.isSegmentUnmapped());
            downMate.setMateNegativeStrand(r.isNegativeStrand());
            downMate.mateSequenceID = r.sequenceId;
            if (downMate.mateSequenceID == -1) {
                downMate.mateAlignmentStart = 0;
            }
            if (r.isFirstSegment()) {
                r.templateSize = tlen = CramNormalizer.computeInsertSize(r, downMate);
                downMate.templateSize = -tlen;
                continue;
            }
            downMate.templateSize = tlen = CramNormalizer.computeInsertSize(downMate, r);
            r.templateSize = -tlen;
        }
        for (CramCompressionRecord r : records) {
            String name;
            if (r.readName != null) continue;
            r.readName = name = this.readNamePrefix + r.index;
            if (r.next != null) {
                r.next.readName = name;
            }
            if (r.previous == null) continue;
            r.previous.readName = name;
        }
        for (CramCompressionRecord r : records) {
            if (r.isSegmentUnmapped()) continue;
            byte[] refBases = ref;
            if (this.referenceSource != null) {
                refBases = this.referenceSource.getReferenceBases(this.header.getSequence(r.sequenceId), true);
            }
            byte[] bases = CramNormalizer.restoreReadBases(r, refBases, substitutionMatrix);
            r.readBases = bases;
        }
        CramNormalizer.restoreQualityScores(this.defaultQualityScore, records);
    }

    public static void restoreQualityScores(byte defaultQualityScore, List<CramCompressionRecord> records) {
        for (CramCompressionRecord record : records) {
            CramNormalizer.restoreQualityScores(defaultQualityScore, record);
        }
    }

    public static byte[] restoreQualityScores(byte defaultQualityScore, CramCompressionRecord record) {
        if (!record.isForcePreserveQualityScores()) {
            byte[] scores = new byte[record.readLength];
            Arrays.fill(scores, defaultQualityScore);
            if (record.readFeatures != null) {
                for (ReadFeature f : record.readFeatures) {
                    switch (f.getOperator()) {
                        case 81: {
                            int pos = f.getPosition();
                            byte q = ((BaseQualityScore)f).getQualityScore();
                            try {
                                scores[pos - 1] = q;
                                break;
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                System.err.println("PROBLEM CAUSED BY:");
                                System.err.println(record.toString());
                                throw e;
                            }
                        }
                        case 66: {
                            int pos = f.getPosition();
                            byte q = ((ReadBase)f).getQualityScore();
                            try {
                                scores[pos - 1] = q;
                                break;
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                System.err.println("PROBLEM CAUSED BY:");
                                System.err.println(record.toString());
                                throw e;
                            }
                        }
                    }
                }
            }
            record.qualityScores = scores;
        } else {
            byte[] scores = record.qualityScores;
            for (int i = 0; i < scores.length; ++i) {
                if (scores[i] != -1) continue;
                scores[i] = defaultQualityScore;
            }
        }
        return record.qualityScores;
    }

    private static final long calcRefLength(CramCompressionRecord record) {
        if (record.readFeatures == null || record.readFeatures.isEmpty()) {
            return record.readLength;
        }
        long len = record.readLength;
        for (ReadFeature rf : record.readFeatures) {
            switch (rf.getOperator()) {
                case 68: {
                    len += (long)((Deletion)rf).getLength();
                    break;
                }
                case 73: {
                    len -= (long)((Insertion)rf).getSequence().length;
                    break;
                }
            }
        }
        return len;
    }

    private static final byte[] restoreReadBases(CramCompressionRecord record, byte[] ref, SubstitutionMatrix substitutionMatrix) {
        int readLength = record.readLength;
        byte[] bases = new byte[readLength];
        int posInRead = 1;
        int alignmentStart = record.alignmentStart - 1;
        int posInSeq = 0;
        if (record.readFeatures == null || record.readFeatures.isEmpty()) {
            if (ref.length < alignmentStart + bases.length) {
                Arrays.fill(bases, (byte)78);
                System.arraycopy(ref, alignmentStart, bases, 0, Math.min(bases.length, ref.length - alignmentStart));
            } else {
                System.arraycopy(ref, alignmentStart, bases, 0, bases.length);
            }
            return bases;
        }
        List<ReadFeature> variations = record.readFeatures;
        block10: for (ReadFeature v : variations) {
            while (posInRead < v.getPosition()) {
                bases[posInRead - 1] = ref[alignmentStart + posInSeq++];
                ++posInRead;
            }
            switch (v.getOperator()) {
                case 88: {
                    Substitution sv = (Substitution)v;
                    byte refBase = Utils.normalizeBase(ref[alignmentStart + posInSeq]);
                    byte base = substitutionMatrix.base(refBase, sv.getCode());
                    sv.setBase(base);
                    sv.setRefernceBase(refBase);
                    bases[posInRead++ - 1] = base;
                    ++posInSeq;
                    break;
                }
                case 73: {
                    Insertion iv = (Insertion)v;
                    for (int i = 0; i < iv.getSequence().length; ++i) {
                        bases[posInRead++ - 1] = iv.getSequence()[i];
                    }
                    continue block10;
                }
                case 83: {
                    SoftClip sc = (SoftClip)v;
                    for (int i = 0; i < sc.getSequence().length; ++i) {
                        bases[posInRead++ - 1] = sc.getSequence()[i];
                    }
                    continue block10;
                }
                case 68: {
                    Deletion dv = (Deletion)v;
                    posInSeq += dv.getLength();
                    break;
                }
                case 105: {
                    InsertBase ib = (InsertBase)v;
                    bases[posInRead++ - 1] = ib.getBase();
                }
            }
        }
        while (posInRead <= readLength) {
            bases[posInRead - 1] = ref[alignmentStart + posInSeq++];
            ++posInRead;
        }
        for (ReadFeature v : variations) {
            switch (v.getOperator()) {
                case 66: {
                    ReadBase rb = (ReadBase)v;
                    bases[v.getPosition() - 1] = rb.getBase();
                    break;
                }
            }
        }
        for (int i = 0; i < bases.length; ++i) {
            bases[i] = Utils.normalizeBase(bases[i]);
        }
        return bases;
    }

    private static int computeInsertSize(CramCompressionRecord firstEnd, CramCompressionRecord secondEnd) {
        if (firstEnd.isSegmentUnmapped() || secondEnd.isSegmentUnmapped()) {
            return 0;
        }
        if (firstEnd.sequenceId != secondEnd.sequenceId) {
            return 0;
        }
        int firstEnd5PrimePosition = firstEnd.isNegativeStrand() ? firstEnd.getAlignmentEnd() : firstEnd.alignmentStart;
        int secondEnd5PrimePosition = secondEnd.isNegativeStrand() ? secondEnd.getAlignmentEnd() : secondEnd.alignmentStart;
        int adjustment = secondEnd5PrimePosition >= firstEnd5PrimePosition ? 1 : -1;
        return secondEnd5PrimePosition - firstEnd5PrimePosition + adjustment;
    }
}

