/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMRecord;

public class SimplifyingSAMFileWriter
implements SAMFileWriter {
    final SAMFileWriter dest;

    public SimplifyingSAMFileWriter(SAMFileWriter finalDestination) {
        this.dest = finalDestination;
    }

    public void addAlignment(SAMRecord read) {
        if (SimplifyingSAMFileWriter.keepRead(read)) {
            this.dest.addAlignment(SimplifyingSAMFileWriter.simplifyRead(read));
        }
    }

    public SAMFileHeader getFileHeader() {
        return this.dest.getFileHeader();
    }

    public void close() {
        this.dest.close();
    }

    public static final boolean keepRead(SAMRecord read) {
        return !SimplifyingSAMFileWriter.excludeRead(read);
    }

    public static final boolean excludeRead(SAMRecord read) {
        return read.getReadUnmappedFlag() || read.getReadFailsVendorQualityCheckFlag() || read.getDuplicateReadFlag() || read.getNotPrimaryAlignmentFlag();
    }

    public static final SAMRecord simplifyRead(SAMRecord read) {
        Object rg = read.getAttribute("RG");
        read.clearAttributes();
        read.setAttribute("RG", rg);
        return read;
    }
}

