/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2004 
 *					All rights reserved
 *
 *  This file is part of GPAC / Scene Rendering sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifndef STACKS3D_H
#define STACKS3D_H

#include "grouping.h"

/*unregister bindable from all bindable stacks listed, and bind their top if needed*/
void PreDestroyBindable(SFNode *bindable, Chain *stack_list);
/*returns isBound*/
Bool Bindable_GetIsBound(SFNode *bindable);
/*sets isBound*/
void Bindable_SetIsBound(SFNode *bindable, Bool val);
/*generic on_set_bind for all bindables*/
void Bindable_OnSetBind(SFNode *bindable, Chain *stack_list);
/*remove all bindable references to this stack and destroy chain*/
void BindableStackDelete(Chain *stack);
/*returns sensor handler if node is sensor and enabled*/
SensorHandler *get_sensor_handler(SFNode *n, Bool skip_anchor);

/*Anchor*/
#ifdef M4_DEF_Anchor
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	GROUPINGNODESTACK
	Bool enabled, active;
	SensorHandler hdl;
} AnchorStack;
void R3D_InitAnchor(Render3D *sr, SFNode *node);
SensorHandler *r3d_anchor_get_handler(SFNode *n);
#endif

/*background2D*/
#ifdef M4_DEF_Background2D
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	/*for image background*/
	TextureHandler txh;
	Bool needs_texture;
	/*keep track of background stacks using us*/
	Chain *reg_stacks;
	M4Mesh *mesh;
	M4BBox prev_bounds;
} Background2DStack;
void R3D_InitBackground2D(Render3D *sr, SFNode *node);
void R3D_Background2DModified(SFNode *node);
#endif


/*stack used by CompositeTexture2D and CompositeTexture3D*/
typedef struct _composite_texture
{
	TextureHandler txh;
	/*the surface object handling the texture*/
	struct _visual_surface *surface;
	u32 last_draw_time;
} CompositeTextureStack;
TextureHandler *r3d_composite_get_texture(SFNode *node);

/*CompositeTexture2D*/
#ifdef M4_DEF_CompositeTexture2D
void R3D_InitCompositeTexture2D(Render3D *sr, SFNode *node);
#endif
/*CompositeTexture3D*/
#ifdef M4_DEF_CompositeTexture3D
void R3D_InitCompositeTexture3D(Render3D *sr, SFNode *node);
#endif

/*DiscSensor*/
#ifdef M4_DEF_DiscSensor
typedef struct 
{
	SensorHandler hdl;
	struct scene_renderer *compositor;
	Double start_angle;
	M4Matrix initial_matrix;
} DiscSensorStack;
void R3D_InitDiscSensor(Render3D *sr, SFNode *node);
SensorHandler *r3d_ds_get_handler(SFNode *n);
#endif

/*Form*/
#ifdef M4_DEF_Form
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	GROUPINGNODESTACK
	Chain *grouplist;
	M4Rect clip;
} FormStack;
void R3D_InitForm(Render3D *sr, SFNode *node);
#endif

/*layer2D*/
#ifdef M4_DEF_Layer2D
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	GROUPINGNODESTACK
	Chain *backs;
	Chain *views;
	Bool first;
	M4Rect clip;
} Layer2DStack;
void R3D_InitLayer2D(Render3D *sr, SFNode *node);
#endif

/*layout*/
#ifdef M4_DEF_Layout
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	GROUPINGNODESTACK
	
	Bool start_scroll, all_scroll_out, is_scrolling;
	Double start_time, pause_time;
	Chain *lines;
	M4Rect clip;
	Float scroll_offset, last_scroll, prev_rate;
	Float scroll_rate, scale_scroll;
} LayoutStack;
void R3D_InitLayout(Render3D *sr, SFNode *node);
void R3D_LayoutModified(SFNode *node);
#endif

/*matte texture*/
#ifdef M4_DEF_MatteTexture
typedef struct
{
	/*resulting texture*/
	TextureHandler txh;
	/*resulting texture*/
	TextureHandler *surf_a, *surf_b, *surf_alpha;
	/*current overwrite*/
	Bool overwrite;
} MatteTextureStack;
void R3D_InitMatteTexture(Render3D *sr, SFNode *node);
void R3D_MatteTextureModified(SFNode *node);
TextureHandler *r3d_matte_get_texture(SFNode *node);
#endif

/*orderedGroup*/
#ifdef M4_DEF_OrderedGroup
struct og_pos
{
	Float priority;
	u32 position;
};
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	GROUPINGNODESTACK

	struct og_pos *priorities;
	u32 count;
} OrderedGroupStack;
void R3D_InitOrderedGroup(Render3D *sr, SFNode *node);
#endif

/*planesensor2D*/
#ifdef M4_DEF_PlaneSensor2D

typedef struct 
{
	SFVec2f start_drag;
	M4Matrix initial_matrix;
	struct scene_renderer *compositor;
	SensorHandler hdl;
} PS2DStack;
void R3D_InitPlaneSensor2D(Render3D *sr, SFNode *node);
SensorHandler *r3d_ps2D_get_handler(SFNode *n);
#endif


/*proximitySensor2D*/
#ifdef M4_DEF_ProximitySensor2D

typedef struct 
{
	Double last_time;
	struct scene_renderer *compositor;
	SensorHandler hdl;
} Prox2DStack;
void R3D_InitProximitySensor2D(Render3D *sr, SFNode *node);
SensorHandler *r3d_prox2D_get_handler(SFNode *n);
#endif

#ifdef M4_DEF_Switch
typedef struct
{
	s32 last_switch;
} SwitchStack;
void R3D_InitSwitch(Render3D *sr, SFNode *node);
#endif

/*text*/
#ifdef M4_DEF_Text
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	M4Mesh *mesh;
	M4Path *path;
	Chain *strike_list;
	Float ascent, descent;
	Chain *text_lines;
	M4Rect bounds;
} TextStack;
void R3D_InitText(Render3D *sr, SFNode *node);
#endif

/*timesensor*/
#ifdef M4_DEF_TimeSensor
typedef struct
{
	TimeNode time_handle;
	Bool store_info;
	Double start_time, cycle_interval;
	u32 num_cycles;
	struct scene_renderer *compositor;
} TimeSensorStack;
void R3D_InitTimeSensor(Render3D *sr, SFNode *node);
void R3D_TimeSensorModified(SFNode *node);
#endif

/*touchsensor*/
#ifdef M4_DEF_TouchSensor
typedef struct 
{
	SensorHandler hdl;
	Bool mouse_down;
	struct scene_renderer *compositor;
} TouchSensorStack;
void R3D_InitTouchSensor(Render3D *sr, SFNode *node);
SensorHandler *r3d_touch_sensor_get_handler(SFNode *n);
#endif

typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	/*keep track of viewport stacks using us*/
	Chain *reg_stacks;
	/*world transform*/
	M4Matrix world_view_mx;
} ViewStack;
/*viewport*/
#ifdef M4_DEF_Viewport
void R3D_InitViewport(Render3D *sr, SFNode *node);
#endif
/*viewpoint*/
#ifdef M4_DEF_Viewpoint
void R3D_InitViewpoint(Render3D *sr, SFNode *node);
#endif

/*linear/radial gradient*/
#if defined(M4_DEF_LinearGradient) || defined(M4_DEF_RadialGradient)
typedef struct
{
	TextureHandler txh;
} GradientStack;
#endif


/*for any lineprops*/
typedef struct
{
	Render3D *sr;
	u32 last_mod_time;
} LinePropStack;
void R3D_InitLineProps(Render3D *sr, SFNode *node);
u32 R3D_LP_GetLastUpdateTime(SFNode *node);


#ifdef M4_DEF_LinearGradient
void R3D_InitLinearGradient(Render3D *sr, SFNode *node);
TextureHandler *r3d_lg_get_texture(SFNode *node);
#endif

#ifdef M4_DEF_RadialGradient
void R3D_InitRadialGradient(Render3D *sr, SFNode *node);
TextureHandler *r3d_rg_get_texture(SFNode *node);
#endif

#ifdef M4_DEF_Transform2D
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	GROUPINGNODESTACK
	M4Matrix mx;
} TransformStack;
#endif

#ifdef M4_DEF_ColorTransform
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	GROUPINGNODESTACK
	M4ColorMatrix cmat;
} ColorTransformStack;
void R3D_InitColorTransform(Render3D *sr, SFNode *node);
#endif

#ifdef M4_DEF_Bitmap
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	M4Mesh *mesh;
	SFVec2f size;
} BitmapStack;
void R3D_InitBitmap(Render3D *sr, SFNode *node);
#endif

/*simple nodes without specific stacks extensions*/
#ifdef M4_DEF_Circle
void R3D_InitCircle(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_Curve2D
void R3D_InitCurve2D(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_Ellipse
void R3D_InitEllipse(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_Group
void R3D_InitGroup(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_IndexedFaceSet2D
void R3D_InitIFS2D(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_IndexedLineSet2D
void R3D_InitILS2D(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_PointSet2D
void R3D_InitPointSet2D(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_Rectangle
void R3D_InitRectangle(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_Shape
void R3D_InitShape(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_Transform2D
void R3D_InitTransform2D(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_TransformMatrix2D
void R3D_InitTransformMatrix2D(Render3D *sr, SFNode *node);
void TM2D_GetMatrix(SFNode *n, M4Matrix *mx);
#endif
#ifdef M4_DEF_PathLayout
void R3D_InitPathLayout(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_Box
void R3D_InitBox(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_Cone
void R3D_InitCone(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_Cylinder
void R3D_InitCylinder(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_Sphere
void R3D_InitSphere(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_IndexedFaceSet
void R3D_InitIFS(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_IndexedLineSet
void R3D_InitILS(Render3D *sr, SFNode *node);
#endif
#ifdef M4_DEF_Transform
void R3D_InitTransform(Render3D *sr, SFNode *node);
#endif

#ifdef M4_DEF_NavigationInfo
void R3D_InitNavigationInfo(Render3D *sr, SFNode *node);
#endif

#endif


