/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003 
 *					All rights reserved
 *
 *  This file is part of GPAC / Scene Rendering sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */



#ifndef COMMON_STACKS_H
#define COMMON_STACKS_H

#include <gpac/intern/m4_render_dev.h>

/*audio node stacks*/


void InitSound2D(LPSCENERENDER sr, SFNode *node);

#ifdef M4_DEF_AudioSource
typedef struct
{
	AudioInput input;
	TimeNode time_handle;
	Bool is_active;
	Double start_time;
} AudioSourceStack;
void InitAudioSource(LPSCENERENDER sr, SFNode *node);
void AudioSourceModified(SFNode *node);
#endif

#ifdef M4_DEF_AudioClip
typedef struct
{
	AudioInput input;
	TimeNode time_handle;
	Double start_time;
	Bool set_duration;
} AudioClipStack;
void InitAudioClip(LPSCENERENDER sr, SFNode *node);
void AudioClipModified(SFNode *node);
#endif


#ifdef M4_DEF_AudioBuffer
typedef struct
{
	AUDIO_GROUP_NODE

	TimeNode time_handle;
	Double start_time;
	Bool set_duration;
	/*AudioBuffer mixes its children*/
	AudioMixer *am;
	Bool is_init;
	/*buffer audio data*/
	char *buffer;
	u32 buffer_size;

	Bool done;
	/*read/write position in buffer and associated read time (CTS)*/
	u32 read_pos, write_pos, cur_cts;
	/*list of audio children after a traverse*/
	Chain *new_inputs;
} AudioBufferStack;
void InitAudioBuffer(LPSCENERENDER sr, SFNode *node);
void AudioBufferModified(SFNode *node);
#endif


/*AnimationStream*/
#ifdef M4_DEF_AnimationStream
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	TimeNode time_handle;
	Double start_time;
	MediaObject *stream;
	MFURL current_url;
} AnimationStreamStack;
void InitAnimationStream(SceneRenderer *sr, SFNode *node);
void AnimationStreamModified(SFNode *node);
#endif

/*timesensor*/
#ifdef M4_DEF_TimeSensor
typedef struct
{
	TimeNode time_handle;
	Bool store_info;
	Double start_time, cycle_interval;
	u32 num_cycles;
	LPSCENERENDER compositor;
} TimeSensorStack;
void InitTimeSensor(SceneRenderer *sr, SFNode *node);
void TimeSensorModified(SFNode *node);
#endif


/*image texture*/
#ifdef M4_DEF_ImageTexture
typedef struct
{
	TextureHandler txh;
} ImageTextureStack;
void InitImageTexture(SceneRenderer *sr, SFNode *node);
TextureHandler *it_get_texture(SFNode *node);
void ImageTextureModified(SFNode *node);
#endif

/*movie texture*/
#ifdef M4_DEF_MovieTexture
typedef struct
{
	TextureHandler txh;

	TimeNode time_handle;
	Bool fetch_first_frame, first_frame_fetched;
	Double start_time;
} MovieTextureStack;
void InitMovieTexture(SceneRenderer *sr, SFNode *node);
TextureHandler *mt_get_texture(SFNode *node);
void MovieTextureModified(SFNode *node);
#endif

/*pixel texture*/
#ifdef M4_DEF_PixelTexture
typedef struct
{
	TextureHandler txh;
	char *pixels;
} PixelTextureStack;
void InitPixelTexture(SceneRenderer *sr, SFNode *node);
TextureHandler *pt_get_texture(SFNode *node);
#endif


#endif


