#ifndef _V4SCENEGRAPH_H
#define _V4SCENEGRAPH_H

#include "safe_include.h" 
#include <gpac/m4_author.h>
#include <gpac/m4_render.h>

#include <wx/gdicmn.h>


extern "C" {
SFNode *CloneNodeForEditing(LPSCENEGRAPH inScene, SFNode *orig);
int GetNextNodeID(LPSCENEGRAPH sg);
}

class V4SceneGraph {
public:
	V4SceneGraph();
	~V4SceneGraph();

	SFNode *NewNode(u32 tag);
	SFNode *CopyNode(SFNode *node, SFNode *parent, bool copy);

	SFNode *SetTopNode(u32 tag);
	void SetSceneSize(int w, int h);
	void GetSceneSize(wxSize &size);

	void SetRenderer(LPSCENERENDER sr) { m_pSr = sr; }
	LPSCENERENDER GetSceneRenderer() { return m_pSr; }

	LPSCENEGRAPH GetSceneGraph() { return m_pSg; }
	SFNode *GetRootNode() { return SG_GetRootNode(m_pSg); }

	void SaveFile(const char * path);
	void LoadNew(); 
	void LoadBTFile(const char *path); 
	void LoadMP4File(const char *path); 

	void LoadCommand(u32 commandNumber);
protected:
	LPSCENEGRAPH m_pSg;
	LPSCENERENDER m_pSr;
	M4SceneManager *m_pSm;
	char *m_pOriginal_mp4;
	Bool m_bEncodeNames;

};

#endif

