#! /bin/bash

# Zeitgeist FTS Extension Test Harness
#
# Copyright © 2010 Canonical Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author:
#         Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
#

# Exit the script on any error
set -e

# Test environment
export ZEITGEIST_FTS_TESTS=1
export ZEITGEIST_DATA_PATH="$(mktemp -d)";
export ZEITGEIST_DEFAULT_EXTENSIONS=fts.SearchEngineExtension
export ZEITGEIST_EXTRA_EXTENSIONS=""
export PYTHONPATH="$(dirname $0)"
export DISPLAY=":27";

# Run test helpers to set up fully offline test harness
Xvfb $DISPLAY -screen 0 1024x768x8 &
XVFB_PID=$!
sleep 1

dbus-launch > $ZEITGEIST_DATA_PATH/_sessionbus.sh
source $ZEITGEIST_DATA_PATH/_sessionbus.sh
sleep 1

zeitgeist-daemon --no-datahub &
sleep 1

python $(dirname $0)/_tests.py
sleep 1 && zeitgeist-daemon --quit
kill $DBUS_SESSION_BUS_PID
kill $XVFB_PID && wait $XVFB_PID
rm -rf $ZEITGEIST_DATA_PATH
echo "Done"
