function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._login = browser.getLogin();
        this._password = browser.getPassword();
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        if (!this._login) {
            this._browser.skipTest();
        }
        if (this._state === 0) {
            this._browser.injectScript(makeAuthorizer('signup_email', 'signup_password', this._login, this._password));
        } else if (this._state >= 1) {
            setTimeout(this._browser.finish.bind(this._browser), 10000);
        }
        this._state++;
    },

    validateCallLog: function (log) {
        var pass = false;
        assertEquals('Unity.init', log[0].func, 'Unity.init');
        assertEquals('Tumblr', log[0].args[0].name, 'Tumblr');

        var i, actionsCount = 0;
        for (i = 0; i < log.length; i++) {
            if (log[i].func === 'Unity.MessagingIndicator.showIndicator') {
                pass = true;
            }
            if (log[i].func === 'Unity.addAction') {
                actionsCount++;
            }
        }
        assertEquals('Unity.addAction', actionsCount, 7);
        assertEquals('has indicators', pass, true);
    },

    scriptName: 'Tumblr/Tumblr.user.js'
};