/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.FilterIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import virtuoso.jena.driver.VirtGraph;

public class VirtResSetIter
implements ExtendedIterator {
    protected ResultSet v_resultSet;
    protected Triple v_row;
    protected TripleMatch v_in;
    protected boolean v_finished = false;
    protected boolean v_prefetched = false;
    protected VirtGraph v_graph = null;

    public VirtResSetIter() {
        this.v_finished = true;
    }

    public VirtResSetIter(VirtGraph virtGraph, ResultSet resultSet, TripleMatch tripleMatch) {
        this.v_resultSet = resultSet;
        this.v_in = tripleMatch;
        this.v_graph = virtGraph;
    }

    public void reset(ResultSet resultSet, PreparedStatement preparedStatement) {
        this.v_resultSet = resultSet;
        this.v_finished = false;
        this.v_prefetched = false;
        this.v_row = null;
    }

    public boolean hasNext() {
        if (!this.v_finished && !this.v_prefetched) {
            this.moveForward();
        }
        return !this.v_finished;
    }

    public Object removeNext() {
        Object object = this.next();
        this.remove();
        return object;
    }

    public Object next() {
        if (!this.v_finished && !this.v_prefetched) {
            this.moveForward();
        }
        this.v_prefetched = false;
        if (this.v_finished) {
            throw new NoSuchElementException();
        }
        return this.getRow();
    }

    public void remove() {
        if (this.v_row != null && this.v_graph != null) {
            this.v_graph.delete(this.v_row);
            this.v_row = null;
        }
    }

    protected void moveForward() {
        try {
            if (!this.v_finished && this.v_resultSet.next()) {
                this.extractRow();
                this.v_prefetched = true;
            } else {
                this.close();
            }
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    protected void extractRow() throws Exception {
        Node node = this.v_in.getMatchSubject() != null ? this.v_in.getMatchSubject() : VirtGraph.Object2Node(this.v_resultSet.getObject("s"));
        Node node2 = this.v_in.getMatchPredicate() != null ? this.v_in.getMatchPredicate() : VirtGraph.Object2Node(this.v_resultSet.getObject("p"));
        Node node3 = this.v_in.getMatchObject() != null ? this.v_in.getMatchObject() : VirtGraph.Object2Node(this.v_resultSet.getObject("o"));
        this.v_row = new Triple(node, node2, node3);
    }

    protected Object getRow() {
        return this.v_row;
    }

    public void close() {
        if (!this.v_finished && this.v_resultSet != null) {
            try {
                this.v_resultSet.close();
                this.v_resultSet = null;
            }
            catch (SQLException sQLException) {
                throw new JenaException((Throwable)sQLException);
            }
        }
        this.v_finished = true;
    }

    public Object getSingleton() throws SQLException {
        List list = (List)this.next();
        this.close();
        return list.get(0);
    }

    protected void finalize() throws SQLException {
        if (!this.v_finished && this.v_resultSet != null) {
            this.close();
        }
    }

    public ExtendedIterator andThen(ClosableIterator closableIterator) {
        return NiceIterator.andThen((Iterator)((Object)this), (Iterator)closableIterator);
    }

    public Set toSet() {
        return NiceIterator.asSet((ExtendedIterator)this);
    }

    public List toList() {
        return NiceIterator.asList((ExtendedIterator)this);
    }

    public ExtendedIterator filterKeep(Filter filter) {
        return new FilterIterator(filter, (Iterator)((Object)this));
    }

    public ExtendedIterator filterDrop(Filter filter) {
        return new FilterIterator(null, (Iterator)((Object)this));
    }

    public ExtendedIterator mapWith(Map1 map1) {
        return new Map1Iterator(map1, (Iterator)((Object)this));
    }
}

