/* valagdbusmodule.c generated by valac, the Vala compiler
 * generated from valagdbusmodule.vala, do not modify */

/* valagdbusmodule.vala
 *
 * Copyright (C) 2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <valagee.h>
#include <valaccode.h>
#include <stdlib.h>
#include <string.h>


#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT (vala_ccode_base_module_emit_context_get_type ())
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContext))
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContextClass))
#define VALA_CCODE_BASE_MODULE_IS_EMIT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT))
#define VALA_CCODE_BASE_MODULE_IS_EMIT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT))
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContextClass))

typedef struct _ValaCCodeBaseModuleEmitContext ValaCCodeBaseModuleEmitContext;
typedef struct _ValaCCodeBaseModuleEmitContextClass ValaCCodeBaseModuleEmitContextClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;
typedef struct _ValaCCodeDelegateModulePrivate ValaCCodeDelegateModulePrivate;

#define VALA_TYPE_GERROR_MODULE (vala_gerror_module_get_type ())
#define VALA_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModule))
#define VALA_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))
#define VALA_IS_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GERROR_MODULE))
#define VALA_IS_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GERROR_MODULE))
#define VALA_GERROR_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))

typedef struct _ValaGErrorModule ValaGErrorModule;
typedef struct _ValaGErrorModuleClass ValaGErrorModuleClass;
typedef struct _ValaGErrorModulePrivate ValaGErrorModulePrivate;

#define VALA_TYPE_GTYPE_MODULE (vala_gtype_module_get_type ())
#define VALA_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModule))
#define VALA_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))
#define VALA_IS_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GTYPE_MODULE))
#define VALA_IS_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GTYPE_MODULE))
#define VALA_GTYPE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))

typedef struct _ValaGTypeModule ValaGTypeModule;
typedef struct _ValaGTypeModuleClass ValaGTypeModuleClass;
typedef struct _ValaGTypeModulePrivate ValaGTypeModulePrivate;

#define VALA_TYPE_TYPEREGISTER_FUNCTION (vala_typeregister_function_get_type ())
#define VALA_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunction))
#define VALA_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))
#define VALA_IS_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_IS_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_TYPEREGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))

typedef struct _ValaTypeRegisterFunction ValaTypeRegisterFunction;
typedef struct _ValaTypeRegisterFunctionClass ValaTypeRegisterFunctionClass;

#define VALA_TYPE_GOBJECT_MODULE (vala_gobject_module_get_type ())
#define VALA_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule))
#define VALA_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))
#define VALA_IS_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GOBJECT_MODULE))
#define VALA_IS_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GOBJECT_MODULE))
#define VALA_GOBJECT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))

typedef struct _ValaGObjectModule ValaGObjectModule;
typedef struct _ValaGObjectModuleClass ValaGObjectModuleClass;
typedef struct _ValaGObjectModulePrivate ValaGObjectModulePrivate;

#define VALA_TYPE_GSIGNAL_MODULE (vala_gsignal_module_get_type ())
#define VALA_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule))
#define VALA_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))
#define VALA_IS_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_IS_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_GSIGNAL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))

typedef struct _ValaGSignalModule ValaGSignalModule;
typedef struct _ValaGSignalModuleClass ValaGSignalModuleClass;
typedef struct _ValaGSignalModulePrivate ValaGSignalModulePrivate;

#define VALA_TYPE_GASYNC_MODULE (vala_gasync_module_get_type ())
#define VALA_GASYNC_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModule))
#define VALA_GASYNC_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModuleClass))
#define VALA_IS_GASYNC_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GASYNC_MODULE))
#define VALA_IS_GASYNC_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GASYNC_MODULE))
#define VALA_GASYNC_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModuleClass))

typedef struct _ValaGAsyncModule ValaGAsyncModule;
typedef struct _ValaGAsyncModuleClass ValaGAsyncModuleClass;
typedef struct _ValaGAsyncModulePrivate ValaGAsyncModulePrivate;

#define VALA_TYPE_GVARIANT_MODULE (vala_gvariant_module_get_type ())
#define VALA_GVARIANT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GVARIANT_MODULE, ValaGVariantModule))
#define VALA_GVARIANT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GVARIANT_MODULE, ValaGVariantModuleClass))
#define VALA_IS_GVARIANT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GVARIANT_MODULE))
#define VALA_IS_GVARIANT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GVARIANT_MODULE))
#define VALA_GVARIANT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GVARIANT_MODULE, ValaGVariantModuleClass))

typedef struct _ValaGVariantModule ValaGVariantModule;
typedef struct _ValaGVariantModuleClass ValaGVariantModuleClass;
typedef struct _ValaGVariantModulePrivate ValaGVariantModulePrivate;

#define VALA_TYPE_GD_BUS_MODULE (vala_gd_bus_module_get_type ())
#define VALA_GD_BUS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GD_BUS_MODULE, ValaGDBusModule))
#define VALA_GD_BUS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GD_BUS_MODULE, ValaGDBusModuleClass))
#define VALA_IS_GD_BUS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GD_BUS_MODULE))
#define VALA_IS_GD_BUS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GD_BUS_MODULE))
#define VALA_GD_BUS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GD_BUS_MODULE, ValaGDBusModuleClass))

typedef struct _ValaGDBusModule ValaGDBusModule;
typedef struct _ValaGDBusModuleClass ValaGDBusModuleClass;
typedef struct _ValaGDBusModulePrivate ValaGDBusModulePrivate;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))

struct _ValaCCodeBaseModule {
	ValaCodeGenerator parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaCCodeBaseModuleEmitContext* emit_context;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	ValaSet* user_marshal_set;
	ValaSet* predefined_marshal_set;
	gint next_regex_id;
	gboolean in_constructor;
	gboolean in_static_or_class_context;
	gint next_coroutine_state;
	ValaDataType* void_type;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* regex_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaClass* gnode_type;
	ValaClass* gvaluearray_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaTypeSymbol* gthreadpool_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaClass* gvariant_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_proxy_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	ValaSet* wrappers;
};

struct _ValaCCodeBaseModuleClass {
	ValaCodeGeneratorClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	gboolean (*generate_enum_declaration) (ValaCCodeBaseModule* self, ValaEnum* en, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, ValaMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
	char* (*append_struct_array_free) (ValaCCodeBaseModule* self, ValaStruct* st);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr, gboolean is_macro_definition);
	void (*append_local_free) (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr, ValaCCodeExpression** delegate_target_destroy_notify);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*deserialize_expression) (ValaCCodeBaseModule* self, ValaCCodeFragment* fragment, ValaDataType* type, ValaCCodeExpression* variant_expr, ValaCCodeExpression* expr);
	ValaCCodeExpression* (*serialize_expression) (ValaCCodeBaseModule* self, ValaCCodeFragment* fragment, ValaDataType* type, ValaCCodeExpression* expr);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
	gboolean (*is_gobject_property) (ValaCCodeBaseModule* self, ValaProperty* prop);
	char* (*get_custom_creturn_type) (ValaCCodeBaseModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeBaseModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeBaseModule* self, ValaMethod* method);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeBaseModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeBaseModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeBaseModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeBaseModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeBaseModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeBaseModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_after_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeBaseModule* self, ValaList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeBaseModule* self, ValaList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeBaseModule* self, const char* array_cname, gint dim);
	char* (*get_parameter_array_length_cname) (ValaCCodeBaseModule* self, ValaFormalParameter* param, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeBaseModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeBaseModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeBaseModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeBaseModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag, gboolean always_fails);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, ValaMap* cparam_map, ValaMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, ValaMap* cparam_map, ValaMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

struct _ValaCCodeDelegateModule {
	ValaCCodeArrayModule parent_instance;
	ValaCCodeDelegateModulePrivate * priv;
};

struct _ValaCCodeDelegateModuleClass {
	ValaCCodeArrayModuleClass parent_class;
};

struct _ValaGErrorModule {
	ValaCCodeDelegateModule parent_instance;
	ValaGErrorModulePrivate * priv;
};

struct _ValaGErrorModuleClass {
	ValaCCodeDelegateModuleClass parent_class;
	ValaCCodeStatement* (*return_with_exception) (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
};

struct _ValaGTypeModule {
	ValaGErrorModule parent_instance;
	ValaGTypeModulePrivate * priv;
};

struct _ValaGTypeModuleClass {
	ValaGErrorModuleClass parent_class;
	void (*generate_virtual_method_declaration) (ValaGTypeModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct);
	void (*generate_class_init) (ValaGTypeModule* self, ValaClass* cl, ValaCCodeBlock* init_block);
	ValaTypeRegisterFunction* (*create_interface_register_function) (ValaGTypeModule* self, ValaInterface* iface);
};

struct _ValaGObjectModule {
	ValaGTypeModule parent_instance;
	ValaGObjectModulePrivate * priv;
};

struct _ValaGObjectModuleClass {
	ValaGTypeModuleClass parent_class;
};

struct _ValaGSignalModule {
	ValaGObjectModule parent_instance;
	ValaGSignalModulePrivate * priv;
};

struct _ValaGSignalModuleClass {
	ValaGObjectModuleClass parent_class;
	ValaCCodeExpression* (*get_dbus_g_type) (ValaGSignalModule* self, ValaDataType* data_type);
};

struct _ValaGAsyncModule {
	ValaGSignalModule parent_instance;
	ValaGAsyncModulePrivate * priv;
};

struct _ValaGAsyncModuleClass {
	ValaGSignalModuleClass parent_class;
};

struct _ValaGVariantModule {
	ValaGAsyncModule parent_instance;
	ValaGVariantModulePrivate * priv;
};

struct _ValaGVariantModuleClass {
	ValaGAsyncModuleClass parent_class;
};

struct _ValaGDBusModule {
	ValaGVariantModule parent_instance;
	ValaGDBusModulePrivate * priv;
};

struct _ValaGDBusModuleClass {
	ValaGVariantModuleClass parent_class;
};


static gpointer vala_gd_bus_module_parent_class = NULL;

GType vala_ccode_base_module_get_type (void) G_GNUC_CONST;
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
void vala_value_take_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void) G_GNUC_CONST;
gpointer vala_ccode_base_module_emit_context_ref (gpointer instance);
void vala_ccode_base_module_emit_context_unref (gpointer instance);
GParamSpec* vala_ccode_base_module_param_spec_emit_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_ccode_base_module_value_set_emit_context (GValue* value, gpointer v_object);
void vala_ccode_base_module_value_take_emit_context (GValue* value, gpointer v_object);
gpointer vala_ccode_base_module_value_get_emit_context (const GValue* value);
GType vala_ccode_base_module_emit_context_get_type (void) G_GNUC_CONST;
GType vala_ccode_struct_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_method_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_control_flow_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_member_access_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_assignment_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_method_call_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_array_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_delegate_module_get_type (void) G_GNUC_CONST;
GType vala_gerror_module_get_type (void) G_GNUC_CONST;
GType vala_gtype_module_get_type (void) G_GNUC_CONST;
gpointer vala_typeregister_function_ref (gpointer instance);
void vala_typeregister_function_unref (gpointer instance);
GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_typeregister_function (GValue* value, gpointer v_object);
void vala_value_take_typeregister_function (GValue* value, gpointer v_object);
gpointer vala_value_get_typeregister_function (const GValue* value);
GType vala_typeregister_function_get_type (void) G_GNUC_CONST;
GType vala_gobject_module_get_type (void) G_GNUC_CONST;
GType vala_gsignal_module_get_type (void) G_GNUC_CONST;
GType vala_gasync_module_get_type (void) G_GNUC_CONST;
GType vala_gvariant_module_get_type (void) G_GNUC_CONST;
GType vala_gd_bus_module_get_type (void) G_GNUC_CONST;
enum  {
	VALA_GD_BUS_MODULE_DUMMY_PROPERTY
};
char* vala_gd_bus_module_get_dbus_name (ValaTypeSymbol* symbol);
char* vala_gd_bus_module_get_dbus_name_for_member (ValaSymbol* symbol);
static void vala_gd_bus_module_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain);
void vala_ccode_base_module_generate_error_domain_declaration (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_declaration_space_add_constant_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static ValaCCodeFragment* vala_gd_bus_module_real_register_dbus_info (ValaCCodeBaseModule* base, ValaObjectTypeSymbol* sym);
ValaGDBusModule* vala_gd_bus_module_new (void);
ValaGDBusModule* vala_gd_bus_module_construct (GType object_type);
ValaGVariantModule* vala_gvariant_module_new (void);
ValaGVariantModule* vala_gvariant_module_construct (GType object_type);



char* vala_gd_bus_module_get_dbus_name (ValaTypeSymbol* symbol) {
	char* result = NULL;
	ValaAttribute* dbus;
	g_return_val_if_fail (symbol != NULL, NULL);
	dbus = vala_code_node_get_attribute ((ValaCodeNode*) symbol, "DBus");
	if (dbus == NULL) {
		result = NULL;
		_vala_code_node_unref0 (dbus);
		return result;
	}
	result = vala_attribute_get_string (dbus, "name");
	_vala_code_node_unref0 (dbus);
	return result;
}


char* vala_gd_bus_module_get_dbus_name_for_member (ValaSymbol* symbol) {
	char* result = NULL;
	ValaAttribute* dbus;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (symbol != NULL, NULL);
	dbus = vala_code_node_get_attribute ((ValaCodeNode*) symbol, "DBus");
	if (dbus != NULL) {
		_tmp0_ = vala_attribute_has_argument (dbus, "name");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = vala_attribute_get_string (dbus, "name");
		_vala_code_node_unref0 (dbus);
		return result;
	}
	result = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name (symbol));
	_vala_code_node_unref0 (dbus);
	return result;
}


static void vala_gd_bus_module_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain) {
	ValaGDBusModule * self;
	char* edomain_dbus_name;
	ValaCCodeInitializerList* error_entries;
	ValaCCodeDeclaration* _cdecl_;
	char* _tmp8_;
	char* _tmp9_;
	ValaCCodeVariableDeclarator* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	char* quark_fun_name;
	char* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	ValaCCodeFunction* cquark_fun;
	ValaCCodeBlock* cquark_block;
	char* _tmp15_;
	char* _tmp16_;
	char* quark_name;
	ValaCCodeDeclaration* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeFunctionCall* _tmp21_;
	ValaCCodeFunctionCall* register_call;
	char* _tmp22_;
	char* _tmp23_;
	char* _tmp24_;
	ValaCCodeConstant* _tmp25_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeUnaryExpression* _tmp27_;
	char* _tmp28_;
	char* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeIdentifier* _tmp31_;
	ValaCCodeFunctionCall* _tmp32_;
	ValaCCodeFunctionCall* nentries;
	char* _tmp33_;
	char* _tmp34_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeExpressionStatement* _tmp36_;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeCastExpression* _tmp38_;
	ValaCCodeReturnStatement* _tmp39_;
	self = (ValaGDBusModule*) base;
	g_return_if_fail (edomain != NULL);
	edomain_dbus_name = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) edomain);
	if (edomain_dbus_name == NULL) {
		VALA_CODE_VISITOR_CLASS (vala_gd_bus_module_parent_class)->visit_error_domain ((ValaCodeVisitor*) VALA_GVARIANT_MODULE (self), edomain);
		_g_free0 (edomain_dbus_name);
		return;
	}
	vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, ((ValaCCodeBaseModule*) self)->source_declarations);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) edomain)) {
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, ((ValaCCodeBaseModule*) self)->header_declarations);
	}
	if (!vala_symbol_is_private_symbol ((ValaSymbol*) edomain)) {
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, ((ValaCCodeBaseModule*) self)->internal_header_declarations);
	}
	error_entries = vala_ccode_initializer_list_new ();
	{
		ValaList* _tmp0_;
		ValaIterator* _tmp1_;
		ValaIterator* _ecode_it;
		_ecode_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vala_error_domain_get_codes (edomain))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			ValaErrorCode* ecode;
			char* ecode_dbus_name;
			ValaCCodeInitializerList* error_entry;
			char* _tmp4_;
			ValaCCodeIdentifier* _tmp5_;
			char* _tmp6_;
			ValaCCodeConstant* _tmp7_;
			if (!vala_iterator_next (_ecode_it)) {
				break;
			}
			ecode = (ValaErrorCode*) vala_iterator_get (_ecode_it);
			ecode_dbus_name = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) ecode);
			if (ecode_dbus_name == NULL) {
				char* _tmp2_;
				char* _tmp3_;
				ecode_dbus_name = (_tmp3_ = vala_symbol_lower_case_to_camel_case (_tmp2_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) ecode), -1)), _g_free0 (ecode_dbus_name), _tmp3_);
				_g_free0 (_tmp2_);
			}
			error_entry = vala_ccode_initializer_list_new ();
			vala_ccode_initializer_list_append (error_entry, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new (_tmp4_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) ecode, FALSE))));
			_vala_ccode_node_unref0 (_tmp5_);
			_g_free0 (_tmp4_);
			vala_ccode_initializer_list_append (error_entry, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_constant_new (_tmp6_ = g_strdup_printf ("\"%s.%s\"", edomain_dbus_name, ecode_dbus_name))));
			_vala_ccode_node_unref0 (_tmp7_);
			_g_free0 (_tmp6_);
			vala_ccode_initializer_list_append (error_entries, (ValaCCodeExpression*) error_entry);
			_vala_ccode_node_unref0 (error_entry);
			_g_free0 (ecode_dbus_name);
			_vala_code_node_unref0 (ecode);
		}
		_vala_collection_object_unref0 (_ecode_it);
	}
	_cdecl_ = vala_ccode_declaration_new ("const GDBusErrorEntry");
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp10_ = vala_ccode_variable_declarator_new (_tmp9_ = g_strconcat (_tmp8_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) edomain, NULL), "_entries[]", NULL), (ValaCCodeExpression*) error_entries, NULL)));
	_vala_ccode_node_unref0 (_tmp10_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp8_);
	vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_declaration_space_add_constant_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) _cdecl_);
	quark_fun_name = (_tmp12_ = g_strconcat (_tmp11_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) edomain), "quark", NULL), _g_free0 (_tmp11_), _tmp12_);
	cquark_fun = (_tmp14_ = vala_ccode_function_new (quark_fun_name, _tmp13_ = vala_typesymbol_get_cname (vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->gquark_type), FALSE)), _g_free0 (_tmp13_), _tmp14_);
	cquark_block = vala_ccode_block_new ();
	quark_name = (_tmp16_ = g_strdup_printf ("%squark_volatile", _tmp15_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) edomain)), _g_free0 (_tmp15_), _tmp16_);
	_cdecl_ = (_tmp17_ = vala_ccode_declaration_new ("gsize"), _vala_ccode_node_unref0 (_cdecl_), _tmp17_);
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp19_ = vala_ccode_variable_declarator_new (quark_name, (ValaCCodeExpression*) (_tmp18_ = vala_ccode_constant_new ("0")), NULL)));
	_vala_ccode_node_unref0 (_tmp19_);
	_vala_ccode_node_unref0 (_tmp18_);
	vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_VOLATILE);
	vala_ccode_block_add_statement (cquark_block, (ValaCCodeNode*) _cdecl_);
	register_call = (_tmp21_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("g_dbus_error_register_error_domain"))), _vala_ccode_node_unref0 (_tmp20_), _tmp21_);
	vala_ccode_function_call_add_argument (register_call, (ValaCCodeExpression*) (_tmp25_ = vala_ccode_constant_new (_tmp24_ = g_strconcat (_tmp23_ = g_strconcat ("\"", _tmp22_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) edomain, NULL), NULL), "-quark\"", NULL))));
	_vala_ccode_node_unref0 (_tmp25_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp22_);
	vala_ccode_function_call_add_argument (register_call, (ValaCCodeExpression*) (_tmp27_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new (quark_name)))));
	_vala_ccode_node_unref0 (_tmp27_);
	_vala_ccode_node_unref0 (_tmp26_);
	vala_ccode_function_call_add_argument (register_call, (ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new (_tmp29_ = g_strconcat (_tmp28_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) edomain, NULL), "_entries", NULL))));
	_vala_ccode_node_unref0 (_tmp30_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp28_);
	nentries = (_tmp32_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_identifier_new ("G_N_ELEMENTS"))), _vala_ccode_node_unref0 (_tmp31_), _tmp32_);
	vala_ccode_function_call_add_argument (nentries, (ValaCCodeExpression*) (_tmp35_ = vala_ccode_identifier_new (_tmp34_ = g_strconcat (_tmp33_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) edomain, NULL), "_entries", NULL))));
	_vala_ccode_node_unref0 (_tmp35_);
	_g_free0 (_tmp34_);
	_g_free0 (_tmp33_);
	vala_ccode_function_call_add_argument (register_call, (ValaCCodeExpression*) nentries);
	vala_ccode_block_add_statement (cquark_block, (ValaCCodeNode*) (_tmp36_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) register_call)));
	_vala_ccode_node_unref0 (_tmp36_);
	vala_ccode_block_add_statement (cquark_block, (ValaCCodeNode*) (_tmp39_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp38_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp37_ = vala_ccode_identifier_new (quark_name)), "GQuark")))));
	_vala_ccode_node_unref0 (_tmp39_);
	_vala_ccode_node_unref0 (_tmp38_);
	_vala_ccode_node_unref0 (_tmp37_);
	vala_ccode_function_set_block (cquark_fun, cquark_block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) cquark_fun);
	_vala_ccode_node_unref0 (nentries);
	_vala_ccode_node_unref0 (register_call);
	_g_free0 (quark_name);
	_vala_ccode_node_unref0 (cquark_block);
	_vala_ccode_node_unref0 (cquark_fun);
	_g_free0 (quark_fun_name);
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (error_entries);
	_g_free0 (edomain_dbus_name);
}


static ValaCCodeFragment* vala_gd_bus_module_real_register_dbus_info (ValaCCodeBaseModule* base, ValaObjectTypeSymbol* sym) {
	ValaGDBusModule * self;
	ValaCCodeFragment* result = NULL;
	self = (ValaGDBusModule*) base;
	g_return_val_if_fail (sym != NULL, NULL);
	result = vala_ccode_fragment_new ();
	return result;
}


ValaGDBusModule* vala_gd_bus_module_construct (GType object_type) {
	ValaGDBusModule* self;
	self = (ValaGDBusModule*) vala_gvariant_module_construct (object_type);
	return self;
}


ValaGDBusModule* vala_gd_bus_module_new (void) {
	return vala_gd_bus_module_construct (VALA_TYPE_GD_BUS_MODULE);
}


static void vala_gd_bus_module_class_init (ValaGDBusModuleClass * klass) {
	vala_gd_bus_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_gd_bus_module_real_visit_error_domain;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->register_dbus_info = vala_gd_bus_module_real_register_dbus_info;
}


static void vala_gd_bus_module_instance_init (ValaGDBusModule * self) {
}


GType vala_gd_bus_module_get_type (void) {
	static volatile gsize vala_gd_bus_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gd_bus_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGDBusModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gd_bus_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGDBusModule), 0, (GInstanceInitFunc) vala_gd_bus_module_instance_init, NULL };
		GType vala_gd_bus_module_type_id;
		vala_gd_bus_module_type_id = g_type_register_static (VALA_TYPE_GVARIANT_MODULE, "ValaGDBusModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_gd_bus_module_type_id__volatile, vala_gd_bus_module_type_id);
	}
	return vala_gd_bus_module_type_id__volatile;
}




