/**
 * @file gtest_geis_fixture.cpp
 * @brief A GTest fixture for testing the full uTouch stack through GEIS.
 */
/*
 *  Copyright 2012 Canonical Ltd.
 *
 *  This program is free software: you can redistribute it and/or modify it 
 *  under the terms of the GNU General Public License version 3, as published 
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but 
 *  WITHOUT ANY WARRANTY; without even the implied warranties of 
 *  MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along 
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "gtest_geis_fixture.h"

#include <unistd.h>
#include <X11/extensions/XInput2.h>


void GTestGeisFixture::
SetUp()
{
  // wait for things to settle
  usleep(1000000);

  // Chain up the static class heirarchy, as if the test framework was
  // designed by a Java trainee with some exposure to glib but has never used
  // C++.
  ASSERT_NO_FATAL_FAILURE(xorg::testing::Test::SetUp());

  // Verify that whatever X server is in use supports the required XInput
  // version.
  int xi_major = 2;
  int xi_minor = 2;
  ASSERT_EQ(Success, XIQueryVersion(Display(), &xi_major, &xi_minor));
  ASSERT_GE(xi_major, 2);
  ASSERT_GE(xi_minor, 2);

  setup_geis();
  EXPECT_TRUE(NULL != geis_) << "could not create GEIS instance";
}

void GTestGeisFixture::
TearDown()
{
  geis_delete(geis_);
  xorg::testing::Test::TearDown(); // NVI ftw.
  usleep(1000000);
}

int GTestGeisFixture::
geis_fd()
{
  GeisInteger fd;
  geis_get_configuration(geis_, GEIS_CONFIGURATION_FD, &fd);
  return fd;
}


void GTestGeisFixture::
setup_geis()
{
  geis_ = geis_new(GEIS_INIT_SYNCHRONOUS_START,
                   GEIS_INIT_NO_ATOMIC_GESTURES,
                   NULL);
}
