/**
 * @file geis_backend.c
 * @brief internal GEIS back end base class implementation
 *
 * Copyright 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */
#include "geis_backend.h"
#include "geis_backend_protected.h"

#include "geis_logging.h"
#include <stdlib.h>
#include <string.h>


/*
 * Initializes the base portion of the back end.
 */
void
geis_backend_init_base(GeisBackend       be_base,
                       GeisBackendVtable be_vtbl,
                       GeisString        be_name)
{
  be_base->be_name = strdup(be_name);
  be_base->be_vtbl = be_vtbl;
}


/*
 * Destroys the back end.
 */
void
geis_backend_delete(GeisBackend be)
{
  if (be)
  {
    geis_debug("destroying back end %s", geis_backend_name(be));
    free((char *)be->be_name);
    be->be_vtbl->finalize(be);
  }
}


/*
 * Gets the name of the back end (RTTI).
 */
GeisString
geis_backend_name(GeisBackend be)
{
  return be->be_name;
}


/**
 * Forwarding function for subscription activation.
 */
GeisStatus
geis_backend_subscribe(GeisBackend be, GeisSubscription sub)
{
  return be->be_vtbl->subscribe(be, sub);
}


/**
 * Forwarding function for subscription deactivation.
 */
GeisStatus
geis_backend_unsubscribe(GeisBackend be, GeisSubscription sub)
{
  return be->be_vtbl->unsubscribe(be, sub);
}



