/* amd64-linux.elf-entry.h
   created from amd64-linux.elf-entry.bin, 10045 (0x273d) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2009 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2009 Laszlo Molnar
   Copyright (C) 2000-2009 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ml1050@users.sourceforge.net>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_AMD64_LINUX_ELF_ENTRY_SIZE    10045
#define STUB_AMD64_LINUX_ELF_ENTRY_ADLER32 0xd722fb55
#define STUB_AMD64_LINUX_ELF_ENTRY_CRC32   0xb3166990

unsigned char stub_amd64_linux_elf_entry[10045] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 62,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,112, 24,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 23,  0, 20,  0,
/* 0x0040 */ 232,  0,  0,  0,  0, 85, 83, 81, 82, 72,  1,254, 86, 72,137,254,
/* 0x0050 */  72,137,215, 49,219, 49,201, 72,131,205,255,232, 80,  0,  0,  0,
/* 0x0060 */   1,219,116,  2,243,195,139, 30, 72,131,238,252, 17,219,138, 22,
/* 0x0070 */ 243,195, 72,141,  4, 47,131,249,  5,138, 16,118, 33, 72,131,253,
/* 0x0080 */ 252,119, 27,131,233,  4,139, 16, 72,131,192,  4,131,233,  4,137,
/* 0x0090 */  23, 72,141,127,  4,115,239,131,193,  4,138, 16,116, 16, 72,255,
/* 0x00a0 */ 192,136, 23,131,233,  1,138, 16, 72,141,127,  1,117,240,243,195,
/* 0x00b0 */ 252, 65, 91, 65,128,248,  8,116, 13,233,172,  0,  0,  0, 72,255,
/* 0x00c0 */ 198,136, 23, 72,255,199,138, 22,  1,219,117, 10,139, 30, 72,131,
/* 0x00d0 */ 238,252, 17,219,138, 22,114,230,141, 65,  1,235,  7,255,200, 65,
/* 0x00e0 */ 255,211, 17,192, 65,255,211, 17,192,  1,219,117, 10,139, 30, 72,
/* 0x00f0 */ 131,238,252, 17,219,138, 22,115,228,131,232,  3,114, 29,193,224,
/* 0x0100 */   8, 15,182,210,  9,208, 72,255,198,131,240,255, 15,132,  0,  0,
/* 0x0110 */   0,  0,209,248, 72, 99,232,114, 56,235, 14,  1,219,117,  8,139,
/* 0x0120 */  30, 72,131,238,252, 17,219,114, 40,255,193,  1,219,117,  8,139,
/* 0x0130 */  30, 72,131,238,252, 17,219,114, 24, 65,255,211, 17,201,  1,219,
/* 0x0140 */ 117,  8,139, 30, 72,131,238,252, 17,219,115,237,131,193,  2,235,
/* 0x0150 */   5, 65,255,211, 17,201, 72,129,253,  0,251,255,255,131,209,  2,
/* 0x0160 */ 232,  0,  0,  0,  0,233, 92,255,255,255, 65,128,248,  5,116, 13,
/* 0x0170 */ 233,147,  0,  0,  0, 72,255,198,136, 23, 72,255,199,138, 22,  1,
/* 0x0180 */ 219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22,114,230,141,
/* 0x0190 */  65,  1,235,  7,255,200, 65,255,211, 17,192, 65,255,211, 17,192,
/* 0x01a0 */   1,219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22,115,228,
/* 0x01b0 */ 131,232,  3,114, 27,193,224,  8, 15,182,210,  9,208, 72,255,198,
/* 0x01c0 */ 131,240,255, 15,132,  0,  0,  0,  0,209,248, 72, 99,232,235,  3,
/* 0x01d0 */  65,255,211, 17,201, 65,255,211, 17,201,117, 24,255,193, 65,255,
/* 0x01e0 */ 211, 17,201,  1,219,117,  8,139, 30, 72,131,238,252, 17,219,115,
/* 0x01f0 */ 237,131,193,  2, 72,129,253,  0,251,255,255,131,209,  1,232,  0,
/* 0x0200 */   0,  0,  0,233,117,255,255,255, 65,128,248,  2,116, 13,233,133,
/* 0x0210 */   0,  0,  0, 72,255,198,136, 23, 72,255,199,138, 22,  1,219,117,
/* 0x0220 */  10,139, 30, 72,131,238,252, 17,219,138, 22,114,230,141, 65,  1,
/* 0x0230 */  65,255,211, 17,192,  1,219,117, 10,139, 30, 72,131,238,252, 17,
/* 0x0240 */ 219,138, 22,115,235,131,232,  3,114, 23,193,224,  8, 15,182,210,
/* 0x0250 */   9,208, 72,255,198,131,240,255, 15,132,  0,  0,  0,  0, 72, 99,
/* 0x0260 */ 232,141, 65,  1, 65,255,211, 17,201, 65,255,211, 17,201,117, 24,
/* 0x0270 */ 137,193,131,192,  2, 65,255,211, 17,201,  1,219,117,  8,139, 30,
/* 0x0280 */  72,131,238,252, 17,219,115,237, 72,129,253,  0,243,255,255, 17,
/* 0x0290 */ 193,232,  0,  0,  0,  0,235,131, 65,128,248, 14, 15,133,  0,  0,
/* 0x02a0 */   0,  0, 85, 72,137,229, 68,139,  9, 73,137,208, 72,137,242, 72,
/* 0x02b0 */ 141,119,  2, 86,138,  7,255,202,136,193, 36,  7,192,233,  3, 72,
/* 0x02c0 */ 199,195,  0,253,255,255, 72,211,227,136,193, 72,141,156, 92,136,
/* 0x02d0 */ 241,255,255, 72,131,227,192,106,  0, 72, 57,220,117,249, 83, 72,
/* 0x02e0 */ 141,123,  8,138, 78,255,255,202,136, 71,  2,136,200,192,233,  4,
/* 0x02f0 */ 136, 79,  1, 36, 15,136,  7, 72,141, 79,252, 80, 65, 87, 72,141,
/* 0x0300 */  71,  4, 69, 49,255, 65, 86, 65,190,  1,  0,  0,  0, 65, 85, 69,
/* 0x0310 */  49,237, 65, 84, 85, 83, 72,137, 76, 36,240, 72,137, 68, 36,216,
/* 0x0320 */ 184,  1,  0,  0,  0, 72,137,116, 36,248, 76,137, 68, 36,232,137,
/* 0x0330 */ 195, 68,137, 76, 36,228, 15,182, 79,  2,211,227,137,217, 72,139,
/* 0x0340 */  92, 36, 56,255,201,137, 76, 36,212, 15,182, 79,  1,211,224, 72,
/* 0x0350 */ 139, 76, 36,240,255,200,137, 68, 36,208, 15,182,  7,199,  1,  0,
/* 0x0360 */   0,  0,  0,199, 68, 36,200,  0,  0,  0,  0,199, 68, 36,196,  1,
/* 0x0370 */   0,  0,  0,199, 68, 36,192,  1,  0,  0,  0,199, 68, 36,188,  1,
/* 0x0380 */   0,  0,  0,199,  3,  0,  0,  0,  0,137, 68, 36,204, 15,182, 79,
/* 0x0390 */   1,  1,193,184,  0,  3,  0,  0,211,224, 49,201,141,184, 54,  7,
/* 0x03a0 */   0,  0, 65, 57,255,115, 19, 72,139, 92, 36,216,137,200,255,193,
/* 0x03b0 */  57,249,102,199,  4, 67,  0,  4,235,235, 72,139,124, 36,248,137,
/* 0x03c0 */ 208, 69, 49,210, 65,131,203,255, 49,210, 73,137,252, 73,  1,196,
/* 0x03d0 */  76, 57,231, 15,132,239,  8,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x03e0 */ 255,194, 72,255,199, 65,  9,194,131,250,  4,126,227, 68, 59,124,
/* 0x03f0 */  36,228, 15,131,218,  8,  0,  0,139, 68, 36,212, 72, 99, 92, 36,
/* 0x0400 */ 200, 72,139, 84, 36,216, 68, 33,248,137, 68, 36,184, 72, 99,108,
/* 0x0410 */  36,184, 72,137,216, 72,193,224,  4, 72,  1,232, 65,129,251,255,
/* 0x0420 */ 255,255,  0, 76,141, 12, 66,119, 26, 76, 57,231, 15,132,150,  8,
/* 0x0430 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x0440 */  65,  9,194, 65, 15,183, 17, 68,137,216,193,232, 11, 15,183,202,
/* 0x0450 */  15,175,193, 65, 57,194, 15,131,197,  1,  0,  0, 65,137,195,184,
/* 0x0460 */   0,  8,  0,  0, 72,139, 92, 36,216, 41,200, 15,182, 76, 36,204,
/* 0x0470 */ 190,  1,  0,  0,  0,193,248,  5,141,  4,  2, 65, 15,182,213,102,
/* 0x0480 */  65,137,  1,139, 68, 36,208, 68, 33,248,211,224,185,  8,  0,  0,
/* 0x0490 */   0, 43, 76, 36,204,211,250,  1,208,105,192,  0,  3,  0,  0,131,
/* 0x04a0 */ 124, 36,200,  6,137,192, 76,141,140, 67,108, 14,  0,  0, 15,142,
/* 0x04b0 */ 184,  0,  0,  0, 72,139, 84, 36,232, 68,137,248, 68, 41,240, 15,
/* 0x04c0 */ 182, 44,  2,  1,237, 72, 99,214,137,235,129,227,  0,  1,  0,  0,
/* 0x04d0 */  65,129,251,255,255,255,  0, 72, 99,195, 73,141,  4, 65, 76,141,
/* 0x04e0 */   4, 80,119, 26, 76, 57,231, 15,132,219,  7,  0,  0, 15,182,  7,
/* 0x04f0 */  65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,
/* 0x0500 */ 183,144,  0,  2,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x0510 */ 175,193, 65, 57,194,115, 32, 65,137,195,184,  0,  8,  0,  0,  1,
/* 0x0520 */ 246, 41,200,193,248,  5,133,219,141,  4,  2,102, 65,137,128,  0,
/* 0x0530 */   2,  0,  0,116, 33,235, 45, 65, 41,195, 65, 41,194,137,208,102,
/* 0x0540 */ 193,232,  5,141,116, 54,  1,102, 41,194,133,219,102, 65,137,144,
/* 0x0550 */   0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,142, 97,255,
/* 0x0560 */ 255,255,235,120,129,254,255,  0,  0,  0,127,112, 72, 99,198, 65,
/* 0x0570 */ 129,251,255,255,255,  0, 77,141,  4, 65,119, 26, 76, 57,231, 15,
/* 0x0580 */ 132, 67,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x0590 */  72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,216,193,232, 11,
/* 0x05a0 */  15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,184,  0,
/* 0x05b0 */   8,  0,  0,  1,246, 41,200,193,248,  5,141,  4,  2,102, 65,137,
/* 0x05c0 */   0,235,161, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,141,
/* 0x05d0 */ 116, 54,  1,102, 41,194,102, 65,137, 16,235,136, 72,139, 76, 36,
/* 0x05e0 */ 232, 68,137,248, 65,255,199, 65,137,245, 64,136, 52,  1,131,124,
/* 0x05f0 */  36,200,  3,127, 13,199, 68, 36,200,  0,  0,  0,  0,233,166,  6,
/* 0x0600 */   0,  0,139, 84, 36,200,139, 68, 36,200,131,234,  3,131,232,  6,
/* 0x0610 */ 131,124, 36,200,  9, 15, 79,208,137, 84, 36,200,233,135,  6,  0,
/* 0x0620 */   0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,
/* 0x0630 */  72,139, 68, 36,216, 65,129,251,255,255,255,  0,102, 65,137, 17,
/* 0x0640 */  72,141, 52, 88,119, 26, 76, 57,231, 15,132,121,  6,  0,  0, 15,
/* 0x0650 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x0660 */  15,183,150,128,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202,
/* 0x0670 */  15,175,193, 65, 57,194,115, 78, 65,137,195,184,  0,  8,  0,  0,
/* 0x0680 */  76,139, 76, 36,216, 41,200,139, 76, 36,196, 68,137,116, 36,196,
/* 0x0690 */ 193,248,  5,141,  4,  2,139, 84, 36,192,137, 76, 36,192,102,137,
/* 0x06a0 */ 134,128,  1,  0,  0, 49,192,131,124, 36,200,  6,137, 84, 36,188,
/* 0x06b0 */  15,159,192, 73,129,193,100,  6,  0,  0,141,  4, 64,137, 68, 36,
/* 0x06c0 */ 200,233, 84,  2,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,
/* 0x06d0 */ 232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,137,150,128,
/* 0x06e0 */   1,  0,  0,119, 26, 76, 57,231, 15,132,218,  5,  0,  0, 15,182,
/* 0x06f0 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,
/* 0x0700 */ 183,150,152,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x0710 */ 175,193, 65, 57,194, 15,131,208,  0,  0,  0, 65,184,  0,  8,  0,
/* 0x0720 */   0, 65,137,195, 72,193,227,  5, 68,137,192, 41,200,193,248,  5,
/* 0x0730 */ 141,  4,  2,102,137,134,152,  1,  0,  0, 72,139, 68, 36,216, 72,
/* 0x0740 */   1,216, 65,129,251,255,255,255,  0, 72,141, 52,104,119, 26, 76,
/* 0x0750 */  57,231, 15,132,112,  5,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x0760 */ 193,227,  8, 72,255,199, 65,  9,194, 15,183,150,224,  1,  0,  0,
/* 0x0770 */  68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115,
/* 0x0780 */  79, 65, 41,200, 65,137,195, 65,193,248,  5, 69,133,255, 66,141,
/* 0x0790 */   4,  2,102,137,134,224,  1,  0,  0, 15,132, 41,  5,  0,  0, 49,
/* 0x07a0 */ 192,131,124, 36,200,  6, 72,139, 92, 36,232, 15,159,192,141, 68,
/* 0x07b0 */   0,  9,137, 68, 36,200, 68,137,248, 68, 41,240, 68, 15,182, 44,
/* 0x07c0 */   3, 68,137,248, 65,255,199, 68,136, 44,  3,233,216,  4,  0,  0,
/* 0x07d0 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,102,
/* 0x07e0 */ 137,150,224,  1,  0,  0,233, 17,  1,  0,  0, 65, 41,195, 65, 41,
/* 0x07f0 */ 194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,
/* 0x0800 */   0,102,137,150,152,  1,  0,  0,119, 26, 76, 57,231, 15,132,181,
/* 0x0810 */   4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,
/* 0x0820 */ 199, 65,  9,194, 15,183,150,176,  1,  0,  0, 68,137,216,193,232,
/* 0x0830 */  11, 15,183,202, 15,175,193, 65, 57,194,115, 32, 65,137,195,184,
/* 0x0840 */   0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,134,176,
/* 0x0850 */   1,  0,  0,139, 68, 36,196,233,152,  0,  0,  0, 65, 41,195, 65,
/* 0x0860 */  41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,
/* 0x0870 */ 255,  0,102,137,150,176,  1,  0,  0,119, 26, 76, 57,231, 15,132,
/* 0x0880 */  68,  4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,
/* 0x0890 */ 255,199, 65,  9,194, 15,183,150,200,  1,  0,  0, 68,137,216,193,
/* 0x08a0 */ 232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 29, 65,137,195,
/* 0x08b0 */ 184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,134,
/* 0x08c0 */ 200,  1,  0,  0,139, 68, 36,192,235, 34, 65, 41,195, 65, 41,194,
/* 0x08d0 */ 137,208,102,193,232,  5,102, 41,194,139, 68, 36,188,102,137,150,
/* 0x08e0 */ 200,  1,  0,  0,139, 84, 36,192,137, 84, 36,188,139, 76, 36,196,
/* 0x08f0 */ 137, 76, 36,192, 68,137,116, 36,196, 65,137,198, 49,192,131,124,
/* 0x0900 */  36,200,  6, 76,139, 76, 36,216, 15,159,192, 73,129,193,104, 10,
/* 0x0910 */   0,  0,141, 68, 64,  8,137, 68, 36,200, 65,129,251,255,255,255,
/* 0x0920 */   0,119, 26, 76, 57,231, 15,132,156,  3,  0,  0, 15,182,  7, 65,
/* 0x0930 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183,
/* 0x0940 */  17, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,
/* 0x0950 */ 115, 39, 65,137,195,184,  0,  8,  0,  0, 69, 49,237, 41,200,193,
/* 0x0960 */ 248,  5,141,  4,  2,102, 65,137,  1, 72, 99, 68, 36,184, 72,193,
/* 0x0970 */ 224,  4, 77,141, 68,  1,  4,235,120, 65, 41,195, 65, 41,194,137,
/* 0x0980 */ 208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,
/* 0x0990 */  65,137, 17,119, 26, 76, 57,231, 15,132, 42,  3,  0,  0, 15,182,
/* 0x09a0 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65,
/* 0x09b0 */  15,183, 81,  2, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x09c0 */  65, 57,194,115, 52, 65,137,195,184,  0,  8,  0,  0, 65,189,  8,
/* 0x09d0 */   0,  0,  0, 41,200,193,248,  5,141,  4,  2,102, 65,137, 65,  2,
/* 0x09e0 */  72, 99, 68, 36,184, 72,193,224,  4, 77,141,132,  1,  4,  1,  0,
/* 0x09f0 */   0, 65,185,  3,  0,  0,  0,235, 39, 65, 41,195, 65, 41,194,137,
/* 0x0a00 */ 208,102,193,232,  5, 77,141,129,  4,  2,  0,  0, 65,189, 16,  0,
/* 0x0a10 */   0,  0,102, 41,194,102, 65,137, 81,  2, 65,185,  8,  0,  0,  0,
/* 0x0a20 */  68,137,203,189,  1,  0,  0,  0, 72, 99,197, 65,129,251,255,255,
/* 0x0a30 */ 255,  0, 73,141, 52, 64,119, 26, 76, 57,231, 15,132,135,  2,  0,
/* 0x0a40 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x0a50 */   9,194, 15,183, 14, 68,137,216,193,232, 11, 15,183,209, 15,175,
/* 0x0a60 */ 194, 65, 57,194,115, 23, 65,137,195,184,  0,  8,  0,  0,  1,237,
/* 0x0a70 */  41,208,193,248,  5,141,  4,  1,102,137,  6,235, 22, 65, 41,195,
/* 0x0a80 */  65, 41,194,137,200,102,193,232,  5,141,108, 45,  1,102, 41,193,
/* 0x0a90 */ 102,137, 14,255,203,117,145,184,  1,  0,  0,  0, 68,137,201,211,
/* 0x0aa0 */ 224, 41,197, 68,  1,237,131,124, 36,200,  3, 15,143,194,  1,  0,
/* 0x0ab0 */   0,131, 68, 36,200,  7,184,  3,  0,  0,  0,131,253,  4, 15, 76,
/* 0x0ac0 */ 197, 72,139, 92, 36,216, 65,184,  1,  0,  0,  0, 72,152, 72,193,
/* 0x0ad0 */ 224,  7, 76,141,140,  3, 96,  3,  0,  0,187,  6,  0,  0,  0, 73,
/* 0x0ae0 */  99,192, 65,129,251,255,255,255,  0, 73,141, 52, 65,119, 26, 76,
/* 0x0af0 */  57,231, 15,132,208,  1,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x0b00 */ 193,227,  8, 72,255,199, 65,  9,194, 15,183, 22, 68,137,216,193,
/* 0x0b10 */ 232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,
/* 0x0b20 */ 184,  0,  8,  0,  0, 69,  1,192, 41,200,193,248,  5,141,  4,  2,
/* 0x0b30 */ 102,137,  6,235, 23, 65, 41,195, 65, 41,194,137,208,102,193,232,
/* 0x0b40 */   5, 71,141, 68,  0,  1,102, 41,194,102,137, 22,255,203,117,143,
/* 0x0b50 */  65,131,232, 64, 65,131,248,  3, 69,137,198, 15,142, 13,  1,  0,
/* 0x0b60 */   0, 65,131,230,  1, 68,137,192,209,248, 65,131,206,  2, 65,131,
/* 0x0b70 */ 248, 13,141,112,255,127, 35,137,241, 72,139, 92, 36,216, 73, 99,
/* 0x0b80 */ 192, 65,211,230, 72,  1,192, 68,137,242, 72,141, 20, 83, 72, 41,
/* 0x0b90 */ 194, 76,141,138, 94,  5,  0,  0,235, 81,141,112,251, 65,129,251,
/* 0x0ba0 */ 255,255,255,  0,119, 26, 76, 57,231, 15,132, 25,  1,  0,  0, 15,
/* 0x0bb0 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x0bc0 */  65,209,235, 69,  1,246, 69, 57,218,114,  7, 69, 41,218, 65,131,
/* 0x0bd0 */ 206,  1,255,206,117,199, 76,139, 76, 36,216, 65,193,230,  4,190,
/* 0x0be0 */   4,  0,  0,  0, 73,129,193, 68,  6,  0,  0, 65,189,  1,  0,  0,
/* 0x0bf0 */   0,187,  1,  0,  0,  0, 72, 99,195, 65,129,251,255,255,255,  0,
/* 0x0c00 */  77,141,  4, 65,119, 26, 76, 57,231, 15,132,185,  0,  0,  0, 15,
/* 0x0c10 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x0c20 */  65, 15,183, 16, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x0c30 */  65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,  1,219, 41,
/* 0x0c40 */ 200,193,248,  5,141,  4,  2,102, 65,137,  0,235, 26, 65, 41,195,
/* 0x0c50 */  65, 41,194,137,208,102,193,232,  5,141, 92, 27,  1, 69,  9,238,
/* 0x0c60 */ 102, 41,194,102, 65,137, 16, 69,  1,237,255,206,117,136, 65,255,
/* 0x0c70 */ 198,116, 64,131,197,  2, 69, 57,254,119, 77, 72,139, 84, 36,232,
/* 0x0c80 */  68,137,248, 68, 41,240, 68, 15,182, 44,  2, 68,137,248, 65,255,
/* 0x0c90 */ 199,255,205, 68,136, 44,  2, 15,149,194, 49,192, 68, 59,124, 36,
/* 0x0ca0 */ 228, 15,146,192,133,194,117,211, 68, 59,124, 36,228, 15,130, 69,
/* 0x0cb0 */ 247,255,255, 65,129,251,255,255,255,  0,119, 22, 76, 57,231,184,
/* 0x0cc0 */   1,  0,  0,  0,116, 35,235,  7,184,  1,  0,  0,  0,235, 26, 72,
/* 0x0cd0 */ 255,199,137,248, 43, 68, 36,248, 72,139, 76, 36,240, 72,139, 92,
/* 0x0ce0 */  36, 56,137,  1, 68,137, 59, 49,192, 91, 93, 65, 92, 65, 93, 65,
/* 0x0cf0 */  94, 65, 95, 65, 87, 72,141, 71,  4, 69, 49,255, 65, 86, 65,190,
/* 0x0d00 */   1,  0,  0,  0, 65, 85, 69, 49,237, 65, 84, 85, 83, 72,137, 76,
/* 0x0d10 */  36,240, 72,137, 68, 36,216,184,  1,  0,  0,  0, 72,137,116, 36,
/* 0x0d20 */ 248, 76,137, 68, 36,232,137,195, 68,137, 76, 36,228, 15,182, 79,
/* 0x0d30 */   2,211,227,137,217, 72,139, 92, 36, 56,255,201,137, 76, 36,212,
/* 0x0d40 */  15,182, 79,  1,211,224, 72,139, 76, 36,240,255,200,137, 68, 36,
/* 0x0d50 */ 208, 15,182,  7,199,  1,  0,  0,  0,  0,199, 68, 36,200,  0,  0,
/* 0x0d60 */   0,  0,199, 68, 36,196,  1,  0,  0,  0,199, 68, 36,192,  1,  0,
/* 0x0d70 */   0,  0,199, 68, 36,188,  1,  0,  0,  0,199,  3,  0,  0,  0,  0,
/* 0x0d80 */ 137, 68, 36,204, 15,182, 79,  1,  1,193,184,  0,  3,  0,  0,211,
/* 0x0d90 */ 224, 49,201,141,184, 54,  7,  0,  0, 65, 57,255,115, 19, 72,139,
/* 0x0da0 */  92, 36,216,137,200,255,193, 57,249,102,199,  4, 67,  0,  4,235,
/* 0x0db0 */ 235, 72,139,124, 36,248,137,208, 69, 49,210, 65,131,203,255, 49,
/* 0x0dc0 */ 210, 73,137,252, 73,  1,196, 76, 57,231, 15,132,239,  8,  0,  0,
/* 0x0dd0 */  15,182,  7, 65,193,226,  8,255,194, 72,255,199, 65,  9,194,131,
/* 0x0de0 */ 250,  4,126,227, 68, 59,124, 36,228, 15,131,218,  8,  0,  0,139,
/* 0x0df0 */  68, 36,212, 72, 99, 92, 36,200, 72,139, 84, 36,216, 68, 33,248,
/* 0x0e00 */ 137, 68, 36,184, 72, 99,108, 36,184, 72,137,216, 72,193,224,  4,
/* 0x0e10 */  72,  1,232, 65,129,251,255,255,255,  0, 76,141, 12, 66,119, 26,
/* 0x0e20 */  76, 57,231, 15,132,150,  8,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x0e30 */  65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 17, 68,137,
/* 0x0e40 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194, 15,131,197,
/* 0x0e50 */   1,  0,  0, 65,137,195,184,  0,  8,  0,  0, 72,139, 92, 36,216,
/* 0x0e60 */  41,200, 15,182, 76, 36,204,190,  1,  0,  0,  0,193,248,  5,141,
/* 0x0e70 */   4,  2, 65, 15,182,213,102, 65,137,  1,139, 68, 36,208, 68, 33,
/* 0x0e80 */ 248,211,224,185,  8,  0,  0,  0, 43, 76, 36,204,211,250,  1,208,
/* 0x0e90 */ 105,192,  0,  3,  0,  0,131,124, 36,200,  6,137,192, 76,141,140,
/* 0x0ea0 */  67,108, 14,  0,  0, 15,142,184,  0,  0,  0, 72,139, 84, 36,232,
/* 0x0eb0 */  68,137,248, 68, 41,240, 15,182, 44,  2,  1,237, 72, 99,214,137,
/* 0x0ec0 */ 235,129,227,  0,  1,  0,  0, 65,129,251,255,255,255,  0, 72, 99,
/* 0x0ed0 */ 195, 73,141,  4, 65, 76,141,  4, 80,119, 26, 76, 57,231, 15,132,
/* 0x0ee0 */ 219,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,
/* 0x0ef0 */ 255,199, 65,  9,194, 65, 15,183,144,  0,  2,  0,  0, 68,137,216,
/* 0x0f00 */ 193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 32, 65,137,
/* 0x0f10 */ 195,184,  0,  8,  0,  0,  1,246, 41,200,193,248,  5,133,219,141,
/* 0x0f20 */   4,  2,102, 65,137,128,  0,  2,  0,  0,116, 33,235, 45, 65, 41,
/* 0x0f30 */ 195, 65, 41,194,137,208,102,193,232,  5,141,116, 54,  1,102, 41,
/* 0x0f40 */ 194,133,219,102, 65,137,144,  0,  2,  0,  0,116, 14,129,254,255,
/* 0x0f50 */   0,  0,  0, 15,142, 97,255,255,255,235,120,129,254,255,  0,  0,
/* 0x0f60 */   0,127,112, 72, 99,198, 65,129,251,255,255,255,  0, 77,141,  4,
/* 0x0f70 */  65,119, 26, 76, 57,231, 15,132, 67,  7,  0,  0, 15,182,  7, 65,
/* 0x0f80 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183,
/* 0x0f90 */  16, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,
/* 0x0fa0 */ 115, 24, 65,137,195,184,  0,  8,  0,  0,  1,246, 41,200,193,248,
/* 0x0fb0 */   5,141,  4,  2,102, 65,137,  0,235,161, 65, 41,195, 65, 41,194,
/* 0x0fc0 */ 137,208,102,193,232,  5,141,116, 54,  1,102, 41,194,102, 65,137,
/* 0x0fd0 */  16,235,136, 72,139, 76, 36,232, 68,137,248, 65,255,199, 65,137,
/* 0x0fe0 */ 245, 64,136, 52,  1,131,124, 36,200,  3,127, 13,199, 68, 36,200,
/* 0x0ff0 */   0,  0,  0,  0,233,166,  6,  0,  0,139, 84, 36,200,139, 68, 36,
/* 0x1000 */ 200,131,234,  3,131,232,  6,131,124, 36,200,  9, 15, 79,208,137,
/* 0x1010 */  84, 36,200,233,135,  6,  0,  0, 65, 41,195, 65, 41,194,137,208,
/* 0x1020 */ 102,193,232,  5,102, 41,194, 72,139, 68, 36,216, 65,129,251,255,
/* 0x1030 */ 255,255,  0,102, 65,137, 17, 72,141, 52, 88,119, 26, 76, 57,231,
/* 0x1040 */  15,132,121,  6,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x1050 */   8, 72,255,199, 65,  9,194, 15,183,150,128,  1,  0,  0, 68,137,
/* 0x1060 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 78, 65,
/* 0x1070 */ 137,195,184,  0,  8,  0,  0, 76,139, 76, 36,216, 41,200,139, 76,
/* 0x1080 */  36,196, 68,137,116, 36,196,193,248,  5,141,  4,  2,139, 84, 36,
/* 0x1090 */ 192,137, 76, 36,192,102,137,134,128,  1,  0,  0, 49,192,131,124,
/* 0x10a0 */  36,200,  6,137, 84, 36,188, 15,159,192, 73,129,193,100,  6,  0,
/* 0x10b0 */   0,141,  4, 64,137, 68, 36,200,233, 84,  2,  0,  0, 65, 41,195,
/* 0x10c0 */  65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,
/* 0x10d0 */ 255,255,  0,102,137,150,128,  1,  0,  0,119, 26, 76, 57,231, 15,
/* 0x10e0 */ 132,218,  5,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x10f0 */  72,255,199, 65,  9,194, 15,183,150,152,  1,  0,  0, 68,137,216,
/* 0x1100 */ 193,232, 11, 15,183,202, 15,175,193, 65, 57,194, 15,131,208,  0,
/* 0x1110 */   0,  0, 65,184,  0,  8,  0,  0, 65,137,195, 72,193,227,  5, 68,
/* 0x1120 */ 137,192, 41,200,193,248,  5,141,  4,  2,102,137,134,152,  1,  0,
/* 0x1130 */   0, 72,139, 68, 36,216, 72,  1,216, 65,129,251,255,255,255,  0,
/* 0x1140 */  72,141, 52,104,119, 26, 76, 57,231, 15,132,112,  5,  0,  0, 15,
/* 0x1150 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x1160 */  15,183,150,224,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202,
/* 0x1170 */  15,175,193, 65, 57,194,115, 79, 65, 41,200, 65,137,195, 65,193,
/* 0x1180 */ 248,  5, 69,133,255, 66,141,  4,  2,102,137,134,224,  1,  0,  0,
/* 0x1190 */  15,132, 41,  5,  0,  0, 49,192,131,124, 36,200,  6, 72,139, 92,
/* 0x11a0 */  36,232, 15,159,192,141, 68,  0,  9,137, 68, 36,200, 68,137,248,
/* 0x11b0 */  68, 41,240, 68, 15,182, 44,  3, 68,137,248, 65,255,199, 68,136,
/* 0x11c0 */  44,  3,233,216,  4,  0,  0, 65, 41,195, 65, 41,194,137,208,102,
/* 0x11d0 */ 193,232,  5,102, 41,194,102,137,150,224,  1,  0,  0,233, 17,  1,
/* 0x11e0 */   0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,
/* 0x11f0 */ 194, 65,129,251,255,255,255,  0,102,137,150,152,  1,  0,  0,119,
/* 0x1200 */  26, 76, 57,231, 15,132,181,  4,  0,  0, 15,182,  7, 65,193,226,
/* 0x1210 */   8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,176,  1,
/* 0x1220 */   0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,
/* 0x1230 */ 194,115, 32, 65,137,195,184,  0,  8,  0,  0, 41,200,193,248,  5,
/* 0x1240 */ 141,  4,  2,102,137,134,176,  1,  0,  0,139, 68, 36,196,233,152,
/* 0x1250 */   0,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102,
/* 0x1260 */  41,194, 65,129,251,255,255,255,  0,102,137,150,176,  1,  0,  0,
/* 0x1270 */ 119, 26, 76, 57,231, 15,132, 68,  4,  0,  0, 15,182,  7, 65,193,
/* 0x1280 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,200,
/* 0x1290 */   1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x12a0 */  57,194,115, 29, 65,137,195,184,  0,  8,  0,  0, 41,200,193,248,
/* 0x12b0 */   5,141,  4,  2,102,137,134,200,  1,  0,  0,139, 68, 36,192,235,
/* 0x12c0 */  34, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,
/* 0x12d0 */ 139, 68, 36,188,102,137,150,200,  1,  0,  0,139, 84, 36,192,137,
/* 0x12e0 */  84, 36,188,139, 76, 36,196,137, 76, 36,192, 68,137,116, 36,196,
/* 0x12f0 */  65,137,198, 49,192,131,124, 36,200,  6, 76,139, 76, 36,216, 15,
/* 0x1300 */ 159,192, 73,129,193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36,
/* 0x1310 */ 200, 65,129,251,255,255,255,  0,119, 26, 76, 57,231, 15,132,156,
/* 0x1320 */   3,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,
/* 0x1330 */ 199, 65,  9,194, 65, 15,183, 17, 68,137,216,193,232, 11, 15,183,
/* 0x1340 */ 202, 15,175,193, 65, 57,194,115, 39, 65,137,195,184,  0,  8,  0,
/* 0x1350 */   0, 69, 49,237, 41,200,193,248,  5,141,  4,  2,102, 65,137,  1,
/* 0x1360 */  72, 99, 68, 36,184, 72,193,224,  4, 77,141, 68,  1,  4,235,120,
/* 0x1370 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,
/* 0x1380 */ 129,251,255,255,255,  0,102, 65,137, 17,119, 26, 76, 57,231, 15,
/* 0x1390 */ 132, 42,  3,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x13a0 */  72,255,199, 65,  9,194, 65, 15,183, 81,  2, 68,137,216,193,232,
/* 0x13b0 */  11, 15,183,202, 15,175,193, 65, 57,194,115, 52, 65,137,195,184,
/* 0x13c0 */   0,  8,  0,  0, 65,189,  8,  0,  0,  0, 41,200,193,248,  5,141,
/* 0x13d0 */   4,  2,102, 65,137, 65,  2, 72, 99, 68, 36,184, 72,193,224,  4,
/* 0x13e0 */  77,141,132,  1,  4,  1,  0,  0, 65,185,  3,  0,  0,  0,235, 39,
/* 0x13f0 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5, 77,141,129,  4,
/* 0x1400 */   2,  0,  0, 65,189, 16,  0,  0,  0,102, 41,194,102, 65,137, 81,
/* 0x1410 */   2, 65,185,  8,  0,  0,  0, 68,137,203,189,  1,  0,  0,  0, 72,
/* 0x1420 */  99,197, 65,129,251,255,255,255,  0, 73,141, 52, 64,119, 26, 76,
/* 0x1430 */  57,231, 15,132,135,  2,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x1440 */ 193,227,  8, 72,255,199, 65,  9,194, 15,183, 14, 68,137,216,193,
/* 0x1450 */ 232, 11, 15,183,209, 15,175,194, 65, 57,194,115, 23, 65,137,195,
/* 0x1460 */ 184,  0,  8,  0,  0,  1,237, 41,208,193,248,  5,141,  4,  1,102,
/* 0x1470 */ 137,  6,235, 22, 65, 41,195, 65, 41,194,137,200,102,193,232,  5,
/* 0x1480 */ 141,108, 45,  1,102, 41,193,102,137, 14,255,203,117,145,184,  1,
/* 0x1490 */   0,  0,  0, 68,137,201,211,224, 41,197, 68,  1,237,131,124, 36,
/* 0x14a0 */ 200,  3, 15,143,194,  1,  0,  0,131, 68, 36,200,  7,184,  3,  0,
/* 0x14b0 */   0,  0,131,253,  4, 15, 76,197, 72,139, 92, 36,216, 65,184,  1,
/* 0x14c0 */   0,  0,  0, 72,152, 72,193,224,  7, 76,141,140,  3, 96,  3,  0,
/* 0x14d0 */   0,187,  6,  0,  0,  0, 73, 99,192, 65,129,251,255,255,255,  0,
/* 0x14e0 */  73,141, 52, 65,119, 26, 76, 57,231, 15,132,208,  1,  0,  0, 15,
/* 0x14f0 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x1500 */  15,183, 22, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x1510 */  57,194,115, 24, 65,137,195,184,  0,  8,  0,  0, 69,  1,192, 41,
/* 0x1520 */ 200,193,248,  5,141,  4,  2,102,137,  6,235, 23, 65, 41,195, 65,
/* 0x1530 */  41,194,137,208,102,193,232,  5, 71,141, 68,  0,  1,102, 41,194,
/* 0x1540 */ 102,137, 22,255,203,117,143, 65,131,232, 64, 65,131,248,  3, 69,
/* 0x1550 */ 137,198, 15,142, 13,  1,  0,  0, 65,131,230,  1, 68,137,192,209,
/* 0x1560 */ 248, 65,131,206,  2, 65,131,248, 13,141,112,255,127, 35,137,241,
/* 0x1570 */  72,139, 92, 36,216, 73, 99,192, 65,211,230, 72,  1,192, 68,137,
/* 0x1580 */ 242, 72,141, 20, 83, 72, 41,194, 76,141,138, 94,  5,  0,  0,235,
/* 0x1590 */  81,141,112,251, 65,129,251,255,255,255,  0,119, 26, 76, 57,231,
/* 0x15a0 */  15,132, 25,  1,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x15b0 */   8, 72,255,199, 65,  9,194, 65,209,235, 69,  1,246, 69, 57,218,
/* 0x15c0 */ 114,  7, 69, 41,218, 65,131,206,  1,255,206,117,199, 76,139, 76,
/* 0x15d0 */  36,216, 65,193,230,  4,190,  4,  0,  0,  0, 73,129,193, 68,  6,
/* 0x15e0 */   0,  0, 65,189,  1,  0,  0,  0,187,  1,  0,  0,  0, 72, 99,195,
/* 0x15f0 */  65,129,251,255,255,255,  0, 77,141,  4, 65,119, 26, 76, 57,231,
/* 0x1600 */  15,132,185,  0,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x1610 */   8, 72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,216,193,232,
/* 0x1620 */  11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,184,
/* 0x1630 */   0,  8,  0,  0,  1,219, 41,200,193,248,  5,141,  4,  2,102, 65,
/* 0x1640 */ 137,  0,235, 26, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,
/* 0x1650 */ 141, 92, 27,  1, 69,  9,238,102, 41,194,102, 65,137, 16, 69,  1,
/* 0x1660 */ 237,255,206,117,136, 65,255,198,116, 64,131,197,  2, 69, 57,254,
/* 0x1670 */ 119, 77, 72,139, 84, 36,232, 68,137,248, 68, 41,240, 68, 15,182,
/* 0x1680 */  44,  2, 68,137,248, 65,255,199,255,205, 68,136, 44,  2, 15,149,
/* 0x1690 */ 194, 49,192, 68, 59,124, 36,228, 15,146,192,133,194,117,211, 68,
/* 0x16a0 */  59,124, 36,228, 15,130, 69,247,255,255, 65,129,251,255,255,255,
/* 0x16b0 */   0,119, 22, 76, 57,231,184,  1,  0,  0,  0,116, 35,235,  7,184,
/* 0x16c0 */   1,  0,  0,  0,235, 26, 72,255,199,137,248, 43, 68, 36,248, 72,
/* 0x16d0 */ 139, 76, 36,240, 72,139, 92, 36, 56,137,  1, 68,137, 59, 49,192,
/* 0x16e0 */  91, 93, 65, 92, 65, 93, 65, 94, 65, 95, 72,139,117,248, 72,139,
/* 0x16f0 */ 125, 16,139, 75,  4, 72,  1,206,139, 19, 72,  1,215,201, 89, 72,
/* 0x1700 */ 137,240, 72, 41,200, 90, 72, 41,215, 89,137, 57, 91, 93,195,104,
/* 0x1710 */  30,  0,  0,  0, 90,232,  0,  0,  0,  0, 80, 82, 79, 84, 95, 69,
/* 0x1720 */  88, 69, 67,124, 80, 82, 79, 84, 95, 87, 82, 73, 84, 69, 32,102,
/* 0x1730 */  97,105,108,101,100, 46, 10,  0, 94,106,  2, 95,106,  1, 88, 15,
/* 0x1740 */   5,106,127, 95,106, 60, 88, 15,  5, 91,191,  0,  0,  0,  0,106,
/* 0x1750 */   7, 90,190,  0,  0,  0,  0,106, 50, 65, 90, 69, 41,192,106,  9,
/* 0x1760 */  88, 15,  5, 57,199, 15,133,  0,  0,  0,  0,104,  0,  0,  0,  0,
/* 0x1770 */ 104,  0,  0,  0,  0,190,  0,  0,  0,  0,104,  0,  0,  0,  0,104,
/* 0x1780 */   0,  0,  0,  0, 65, 87,137,250, 41,242,116, 13,  1,213,137,217,
/* 0x1790 */  41,241,193,233,  3,252,243, 72,165,151,137,222, 80,146,173, 80,
/* 0x17a0 */  72,137,225,173,151,173, 68, 15,182,192,135,254,255,213, 89,195,
/* 0x17b0 */  93, 68,139,125,247, 65,129,239,200,  0,  0,  0,232,136,255,255,
/* 0x17c0 */ 255,102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102,
/* 0x17d0 */  54, 52, 45,120, 56, 54, 45, 54, 52, 10, 10, 83,101, 99,116,105,
/* 0x17e0 */ 111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32,
/* 0x17f0 */  32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32,
/* 0x1800 */  32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1810 */  32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1820 */  32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,
/* 0x1830 */ 108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 69,
/* 0x1840 */  76, 70, 77, 65, 73, 78, 88, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x1850 */  48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1860 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1870 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1880 */  48, 52, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1890 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x18a0 */  79, 78, 76, 89, 10, 32, 32, 49, 32, 78, 82, 86, 95, 72, 69, 65,
/* 0x18b0 */  68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 54, 54, 32,
/* 0x18c0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x18d0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x18e0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52,100, 32, 32, 50,
/* 0x18f0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x1900 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 78, 82, 86, 50,
/* 0x1910 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1920 */  98, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1930 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1940 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 98, 51,
/* 0x1950 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1960 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x1970 */  89, 10, 32, 32, 51, 32, 78, 82, 86, 50, 68, 32, 32, 32, 32, 32,
/* 0x1980 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 57,101, 32, 32, 48, 48,
/* 0x1990 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x19a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x19b0 */  32, 32, 48, 48, 48, 48, 48, 49, 54, 97, 32, 32, 50, 42, 42, 48,
/* 0x19c0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x19d0 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32,
/* 0x19e0 */  78, 82, 86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x19f0 */  48, 48, 48, 48, 57, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a00 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1a10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1a20 */  48, 50, 48, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1a30 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x1a40 */  68, 79, 78, 76, 89, 10, 32, 32, 53, 32, 76, 90, 77, 65, 95, 69,
/* 0x1a50 */  76, 70, 48, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 54, 52,
/* 0x1a60 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a70 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a80 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 57, 56, 32, 32,
/* 0x1a90 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x1aa0 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1ab0 */  32, 32, 54, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32,
/* 0x1ac0 */  32, 32, 48, 48, 48, 48, 48, 57,102, 55, 32, 32, 48, 48, 48, 48,
/* 0x1ad0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1ae0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1af0 */  48, 48, 48, 48, 48, 50,102, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1b00 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1b10 */  76, 89, 10, 32, 32, 55, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x1b20 */  48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57,102, 55, 32, 32, 48,
/* 0x1b30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1b40 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b50 */  48, 32, 32, 48, 48, 48, 48, 48, 99,102, 51, 32, 32, 50, 42, 42,
/* 0x1b60 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x1b70 */  68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 76, 90, 77, 65, 95, 68,
/* 0x1b80 */  69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 52,
/* 0x1b90 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ba0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1bb0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 54,101, 97, 32, 32,
/* 0x1bc0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x1bd0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32, 78, 82, 86,
/* 0x1be0 */  95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1bf0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c00 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c10 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 54,102,
/* 0x1c20 */ 101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1c30 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 48, 32,
/* 0x1c40 */  69, 76, 70, 77, 65, 73, 78, 89, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x1c50 */  48, 48, 48, 48, 51, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c60 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1c70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1c80 */  49, 54,102,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1c90 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x1ca0 */  68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 69, 76, 70, 77, 65, 73,
/* 0x1cb0 */  78, 90, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 56, 57,
/* 0x1cc0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1cd0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ce0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 51, 56, 32, 32,
/* 0x1cf0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x1d00 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1d10 */  83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48,
/* 0x1d20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1d30 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68,  9,
/* 0x1d40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d50 */  32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x1d60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1d70 */ 100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,  9, 48, 48,
/* 0x1d80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x1d90 */  90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x1da0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1db0 */ 100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89,  9, 48, 48, 48, 48,
/* 0x1dc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76, 70,
/* 0x1dd0 */  77, 65, 73, 78, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1de0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69,
/* 0x1df0 */  76, 70, 77, 65, 73, 78, 90,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e00 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1e10 */  90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e20 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65,
/* 0x1e30 */  73, 78, 88,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e40 */  48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48,
/* 0x1e50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1e60 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69,  9, 48, 48, 48,
/* 0x1e70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82,
/* 0x1e80 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e90 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86,
/* 0x1ea0 */  50, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1eb0 */  48, 48, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x1ec0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1ed0 */ 100, 32, 32, 78, 82, 86, 50, 66,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ee0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 66, 10,
/* 0x1ef0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f00 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76,
/* 0x1f10 */  70, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f20 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10,
/* 0x1f30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f40 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x1f50 */  67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f60 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x1f70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f80 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x1f90 */  67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1fa0 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x1fb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1fc0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 84, 65, 73,
/* 0x1fd0 */  76,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1fe0 */  48, 48, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48,
/* 0x1ff0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32,
/* 0x2000 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,  9, 48, 48,
/* 0x2010 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 95,
/* 0x2020 */ 115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2030 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x2040 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2050 */  48, 48, 48, 48, 48, 32, 65, 68, 82, 77, 10, 48, 48, 48, 48, 48,
/* 0x2060 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x2070 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x2080 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 69, 78, 77, 10,
/* 0x2090 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x20a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48,
/* 0x20b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x20c0 */  74, 77, 80, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x20d0 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x20e0 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x20f0 */  48, 48, 48, 48, 32, 65, 68, 82, 85, 10, 48, 48, 48, 48, 48, 48,
/* 0x2100 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x2110 */  32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x2120 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 65, 68, 82, 67, 10, 48,
/* 0x2130 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2140 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x2150 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x2160 */  69, 78, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2170 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x2180 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2190 */  48, 48, 48, 32, 65, 68, 82, 88, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x21a0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x21b0 */  32, 91, 69, 76, 70, 77, 65, 73, 78, 88, 93, 58, 10, 79, 70, 70,
/* 0x21c0 */  83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89,
/* 0x21d0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x21e0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x21f0 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x2200 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x2210 */  90, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2220 */  48, 48, 55, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x2230 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82,
/* 0x2240 */  86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x2250 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x2260 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x2270 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97,101, 32,
/* 0x2280 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x2290 */  32, 32, 78, 82, 86, 95, 72, 69, 65, 68, 43, 48,120, 48, 48, 48,
/* 0x22a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 49, 10, 48, 48,
/* 0x22b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 98, 32, 82,
/* 0x22c0 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x22d0 */  32, 69, 76, 70, 77, 65, 73, 78, 89, 43, 48,120,102,102,102,102,
/* 0x22e0 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 10, 82, 69,
/* 0x22f0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x2300 */  32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93, 58, 10, 79, 70,
/* 0x2310 */  70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84,
/* 0x2320 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2330 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2340 */  48, 48, 48, 48, 48, 57, 53, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x2350 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 78, 82, 86, 95, 72, 69,
/* 0x2360 */  65, 68, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2370 */  48, 48, 48, 50, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2380 */  48, 48, 48, 48, 53, 98, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x2390 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x23a0 */  89, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x23b0 */ 102,102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x23c0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82,
/* 0x23d0 */  86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x23e0 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x23f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x2400 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56, 97, 32,
/* 0x2410 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x2420 */  32, 32, 78, 82, 86, 95, 72, 69, 65, 68, 43, 48,120, 48, 48, 48,
/* 0x2430 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 49, 10, 48, 48,
/* 0x2440 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 50, 32, 82,
/* 0x2450 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x2460 */  32, 69, 76, 70, 77, 65, 73, 78, 89, 43, 48,120,102,102,102,102,
/* 0x2470 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 10, 82, 69,
/* 0x2480 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x2490 */  32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,
/* 0x24a0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32,
/* 0x24b0 */  32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x24c0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x24d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 88,
/* 0x24e0 */  56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 76,
/* 0x24f0 */  90, 77, 65, 95, 68, 69, 67, 51, 48, 43, 48,120, 48, 48, 48, 48,
/* 0x2500 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 48, 10, 10, 82, 69,
/* 0x2510 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x2520 */  32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 89, 93, 58,
/* 0x2530 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2540 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2550 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x2560 */  48, 48, 48, 48, 48, 48, 48, 48, 49, 56, 32, 82, 95, 88, 56, 54,
/* 0x2570 */  95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x2580 */  77, 65, 73, 78, 90, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x2590 */ 102,102,102,102,102,102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x25a0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x25b0 */  32, 91, 69, 76, 70, 77, 65, 73, 78, 90, 93, 58, 10, 79, 70, 70,
/* 0x25c0 */  83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89,
/* 0x25d0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x25e0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x25f0 */  48, 48, 48, 48, 49, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x2600 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 65, 68, 82, 77, 10, 48, 48,
/* 0x2610 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 98, 32, 82,
/* 0x2620 */  95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x2630 */  32, 76, 69, 78, 77, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2640 */  48, 48, 48, 48, 51, 52, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x2650 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 74, 77, 80, 85, 10, 48, 48,
/* 0x2660 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 57, 32, 82,
/* 0x2670 */  95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x2680 */  32, 65, 68, 82, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2690 */  48, 48, 48, 48, 51,101, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x26a0 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 65, 68, 82, 67, 10, 48, 48,
/* 0x26b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 51, 32, 82,
/* 0x26c0 */  95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x26d0 */  32, 76, 69, 78, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x26e0 */  48, 48, 48, 48, 52, 56, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x26f0 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 65, 68, 82, 88, 10, 48, 48,
/* 0x2700 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50,102, 32, 82,
/* 0x2710 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x2720 */  32, 69, 76, 70, 77, 65, 73, 78, 89, 43, 48,120, 48, 48, 48, 48,
/* 0x2730 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,100, 10
};
