/* places-default-renderer.c generated by valac 0.10.0, the Vala compiler
 * generated from places-default-renderer.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <unity.h>
#include <clutk/clutk.h>
#include <dee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <clutter/clutter.h>
#include <gee.h>


#define UNITY_PLACES_TYPE_DEFAULT_RENDERER (unity_places_default_renderer_get_type ())
#define UNITY_PLACES_DEFAULT_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_DEFAULT_RENDERER, UnityPlacesDefaultRenderer))
#define UNITY_PLACES_DEFAULT_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_DEFAULT_RENDERER, UnityPlacesDefaultRendererClass))
#define UNITY_PLACES_IS_DEFAULT_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_DEFAULT_RENDERER))
#define UNITY_PLACES_IS_DEFAULT_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_DEFAULT_RENDERER))
#define UNITY_PLACES_DEFAULT_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_DEFAULT_RENDERER, UnityPlacesDefaultRendererClass))

typedef struct _UnityPlacesDefaultRenderer UnityPlacesDefaultRenderer;
typedef struct _UnityPlacesDefaultRendererClass UnityPlacesDefaultRendererClass;
typedef struct _UnityPlacesDefaultRendererPrivate UnityPlacesDefaultRendererPrivate;

#define UNITY_PLACES_TYPE_EMPTY_SEARCH_GROUP (unity_places_empty_search_group_get_type ())
#define UNITY_PLACES_EMPTY_SEARCH_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_EMPTY_SEARCH_GROUP, UnityPlacesEmptySearchGroup))
#define UNITY_PLACES_EMPTY_SEARCH_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_EMPTY_SEARCH_GROUP, UnityPlacesEmptySearchGroupClass))
#define UNITY_PLACES_IS_EMPTY_SEARCH_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_EMPTY_SEARCH_GROUP))
#define UNITY_PLACES_IS_EMPTY_SEARCH_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_EMPTY_SEARCH_GROUP))
#define UNITY_PLACES_EMPTY_SEARCH_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_EMPTY_SEARCH_GROUP, UnityPlacesEmptySearchGroupClass))

typedef struct _UnityPlacesEmptySearchGroup UnityPlacesEmptySearchGroup;
typedef struct _UnityPlacesEmptySearchGroupClass UnityPlacesEmptySearchGroupClass;

#define UNITY_PLACES_TYPE_EMPTY_SECTION_GROUP (unity_places_empty_section_group_get_type ())
#define UNITY_PLACES_EMPTY_SECTION_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_EMPTY_SECTION_GROUP, UnityPlacesEmptySectionGroup))
#define UNITY_PLACES_EMPTY_SECTION_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_EMPTY_SECTION_GROUP, UnityPlacesEmptySectionGroupClass))
#define UNITY_PLACES_IS_EMPTY_SECTION_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_EMPTY_SECTION_GROUP))
#define UNITY_PLACES_IS_EMPTY_SECTION_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_EMPTY_SECTION_GROUP))
#define UNITY_PLACES_EMPTY_SECTION_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_EMPTY_SECTION_GROUP, UnityPlacesEmptySectionGroupClass))

typedef struct _UnityPlacesEmptySectionGroup UnityPlacesEmptySectionGroup;
typedef struct _UnityPlacesEmptySectionGroupClass UnityPlacesEmptySectionGroupClass;

#define UNITY_PLACES_TYPE_VIEW (unity_places_view_get_type ())
#define UNITY_PLACES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_VIEW, UnityPlacesView))
#define UNITY_PLACES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_VIEW, UnityPlacesViewClass))
#define UNITY_PLACES_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_VIEW))
#define UNITY_PLACES_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_VIEW))
#define UNITY_PLACES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_VIEW, UnityPlacesViewClass))

typedef struct _UnityPlacesView UnityPlacesView;
typedef struct _UnityPlacesViewClass UnityPlacesViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _UnityPlacesViewPrivate UnityPlacesViewPrivate;

#define UNITY_PLACES_TYPE_PLACE_HOME_ENTRY (unity_places_place_home_entry_get_type ())
#define UNITY_PLACES_PLACE_HOME_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_HOME_ENTRY, UnityPlacesPlaceHomeEntry))
#define UNITY_PLACES_PLACE_HOME_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE_HOME_ENTRY, UnityPlacesPlaceHomeEntryClass))
#define UNITY_PLACES_IS_PLACE_HOME_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_HOME_ENTRY))
#define UNITY_PLACES_IS_PLACE_HOME_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE_HOME_ENTRY))
#define UNITY_PLACES_PLACE_HOME_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE_HOME_ENTRY, UnityPlacesPlaceHomeEntryClass))

typedef struct _UnityPlacesPlaceHomeEntry UnityPlacesPlaceHomeEntry;
typedef struct _UnityPlacesPlaceHomeEntryClass UnityPlacesPlaceHomeEntryClass;

#define UNITY_PLACES_TYPE_PLACE_SEARCH_BAR (unity_places_place_search_bar_get_type ())
#define UNITY_PLACES_PLACE_SEARCH_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR, UnityPlacesPlaceSearchBar))
#define UNITY_PLACES_PLACE_SEARCH_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR, UnityPlacesPlaceSearchBarClass))
#define UNITY_PLACES_IS_PLACE_SEARCH_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR))
#define UNITY_PLACES_IS_PLACE_SEARCH_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR))
#define UNITY_PLACES_PLACE_SEARCH_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR, UnityPlacesPlaceSearchBarClass))

typedef struct _UnityPlacesPlaceSearchBar UnityPlacesPlaceSearchBar;
typedef struct _UnityPlacesPlaceSearchBarClass UnityPlacesPlaceSearchBarClass;

#define UNITY_PLACES_TYPE_DEFAULT_RENDERER_GROUP (unity_places_default_renderer_group_get_type ())
#define UNITY_PLACES_DEFAULT_RENDERER_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_DEFAULT_RENDERER_GROUP, UnityPlacesDefaultRendererGroup))
#define UNITY_PLACES_DEFAULT_RENDERER_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_DEFAULT_RENDERER_GROUP, UnityPlacesDefaultRendererGroupClass))
#define UNITY_PLACES_IS_DEFAULT_RENDERER_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_DEFAULT_RENDERER_GROUP))
#define UNITY_PLACES_IS_DEFAULT_RENDERER_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_DEFAULT_RENDERER_GROUP))
#define UNITY_PLACES_DEFAULT_RENDERER_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_DEFAULT_RENDERER_GROUP, UnityPlacesDefaultRendererGroupClass))

typedef struct _UnityPlacesDefaultRendererGroup UnityPlacesDefaultRendererGroup;
typedef struct _UnityPlacesDefaultRendererGroupClass UnityPlacesDefaultRendererGroupClass;
typedef struct _UnityPlacesDefaultRendererGroupPrivate UnityPlacesDefaultRendererGroupPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))

#define UNITY_TESTING_TYPE_OBJECT_REGISTRY (unity_testing_object_registry_get_type ())
#define UNITY_TESTING_OBJECT_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TESTING_TYPE_OBJECT_REGISTRY, UnityTestingObjectRegistry))
#define UNITY_TESTING_OBJECT_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TESTING_TYPE_OBJECT_REGISTRY, UnityTestingObjectRegistryClass))
#define UNITY_TESTING_IS_OBJECT_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TESTING_TYPE_OBJECT_REGISTRY))
#define UNITY_TESTING_IS_OBJECT_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TESTING_TYPE_OBJECT_REGISTRY))
#define UNITY_TESTING_OBJECT_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TESTING_TYPE_OBJECT_REGISTRY, UnityTestingObjectRegistryClass))

typedef struct _UnityTestingObjectRegistry UnityTestingObjectRegistry;
typedef struct _UnityTestingObjectRegistryClass UnityTestingObjectRegistryClass;
#define _unity_testing_object_registry_unref0(var) ((var == NULL) ? NULL : (var = (unity_testing_object_registry_unref (var), NULL)))
typedef struct _UnityPlacesEmptySearchGroupPrivate UnityPlacesEmptySearchGroupPrivate;
typedef struct _Block2Data Block2Data;
typedef struct _UnityPlacesEmptySectionGroupPrivate UnityPlacesEmptySectionGroupPrivate;

struct _UnityPlacesDefaultRenderer {
	UnityLayeredBin parent_instance;
	UnityPlacesDefaultRendererPrivate * priv;
};

struct _UnityPlacesDefaultRendererClass {
	UnityLayeredBinClass parent_class;
};

struct _UnityPlacesDefaultRendererPrivate {
	UnityPlacesEmptySearchGroup* search_empty;
	UnityPlacesEmptySectionGroup* section_empty;
	CtkScrollView* scroll;
	UnityCairoCanvas* trough;
	UnityCairoCanvas* slider;
	gint slider_state;
	gboolean button_pressed;
	CtkEffectGlow* slider_glow;
	CtkVBox* box;
	DeeModel* groups_model;
	DeeModel* results_model;
	UnityPlacesView* place_view;
	char** expanded;
	gint expanded_length1;
	gint _expanded_size_;
};

struct _UnityPlacesView {
	CtkBox parent_instance;
	UnityPlacesViewPrivate * priv;
	UnityPlacesPlaceHomeEntry* home_entry;
	UnityPlacesPlaceSearchBar* search_bar;
};

struct _UnityPlacesViewClass {
	CtkBoxClass parent_class;
};

struct _UnityPlacesDefaultRendererGroup {
	UnityExpandingBin parent_instance;
	UnityPlacesDefaultRendererGroupPrivate * priv;
	guint n_results;
};

struct _UnityPlacesDefaultRendererGroupClass {
	UnityExpandingBinClass parent_class;
};

struct _UnityPlacesEmptySearchGroup {
	CtkBin parent_instance;
	UnityPlacesEmptySearchGroupPrivate * priv;
};

struct _UnityPlacesEmptySearchGroupClass {
	CtkBinClass parent_class;
};

struct _UnityPlacesEmptySearchGroupPrivate {
	guint _group_id;
	DeeModel* _results;
	gboolean _active;
	CtkVBox* box;
};

struct _Block2Data {
	int _ref_count_;
	UnityPlacesEmptySearchGroup * self;
	char* uri;
	char* mimetype;
};

struct _UnityPlacesEmptySectionGroup {
	CtkBin parent_instance;
	UnityPlacesEmptySectionGroupPrivate * priv;
};

struct _UnityPlacesEmptySectionGroupClass {
	CtkBinClass parent_class;
};

struct _UnityPlacesEmptySectionGroupPrivate {
	guint _group_id;
	CtkText* text;
	DeeModel* _results;
	gboolean _active;
	CtkEffectGlow* glow;
	UnityCairoCanvas* bg;
};


static gpointer unity_places_default_renderer_parent_class = NULL;
static UnityPlaceRendererIface* unity_places_default_renderer_unity_place_renderer_parent_iface = NULL;
static gpointer unity_places_empty_search_group_parent_class = NULL;
static gpointer unity_places_empty_section_group_parent_class = NULL;

GType unity_places_default_renderer_get_type (void) G_GNUC_CONST;
GType unity_places_empty_search_group_get_type (void) G_GNUC_CONST;
GType unity_places_empty_section_group_get_type (void) G_GNUC_CONST;
GType unity_places_view_get_type (void) G_GNUC_CONST;
#define UNITY_PLACES_DEFAULT_RENDERER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACES_TYPE_DEFAULT_RENDERER, UnityPlacesDefaultRendererPrivate))
enum  {
	UNITY_PLACES_DEFAULT_RENDERER_DUMMY_PROPERTY
};
#define UNITY_PLACES_DEFAULT_RENDERER_TOP_PADDING 22.0f
#define UNITY_PLACES_DEFAULT_RENDERER_PADDING 12.0f
#define UNITY_PLACES_DEFAULT_RENDERER_SPACING 0
#define UNITY_PLACES_DEFAULT_RENDERER_SLIDER_STATE_NORMAL 0
#define UNITY_PLACES_DEFAULT_RENDERER_SLIDER_STATE_PRELIGHT 1
#define UNITY_PLACES_DEFAULT_RENDERER_SLIDER_STATE_ACTIVE 2
UnityPlacesDefaultRenderer* unity_places_default_renderer_new (void);
UnityPlacesDefaultRenderer* unity_places_default_renderer_construct (GType object_type);
static double _unity_places_default_renderer_align (double val);
static void unity_places_default_renderer_trough_paint (UnityPlacesDefaultRenderer* self, cairo_t* cr, gint width, gint height);
static void unity_places_default_renderer_slider_paint (UnityPlacesDefaultRenderer* self, cairo_t* cr, gint width, gint height);
static gboolean unity_places_default_renderer_on_slider_enter (UnityPlacesDefaultRenderer* self, ClutterEvent* event);
static gboolean unity_places_default_renderer_on_slider_leave (UnityPlacesDefaultRenderer* self, ClutterEvent* event);
static gboolean unity_places_default_renderer_on_slider_button_press (UnityPlacesDefaultRenderer* self, ClutterEvent* event);
static gboolean unity_places_default_renderer_on_slider_button_release (UnityPlacesDefaultRenderer* self, ClutterEvent* event);
static void unity_places_default_renderer_real_set_models (UnityPlaceRenderer* base, DeeModel* groups, DeeModel* results, GeeHashMap* hints);
static void unity_places_default_renderer_on_group_added (UnityPlacesDefaultRenderer* self, DeeModel* model, DeeModelIter* iter);
static void _unity_places_default_renderer_on_group_added_dee_model_row_added (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void unity_places_default_renderer_on_group_removed (UnityPlacesDefaultRenderer* self, DeeModel* model, DeeModelIter* iter);
static void _unity_places_default_renderer_on_group_removed_dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void unity_places_default_renderer_update_views (UnityPlacesDefaultRenderer* self);
gboolean unity_places_empty_search_group_get_active (UnityPlacesEmptySearchGroup* self);
gboolean unity_places_empty_section_group_get_active (UnityPlacesEmptySectionGroup* self);
GType unity_places_place_home_entry_get_type (void) G_GNUC_CONST;
GType unity_places_place_search_bar_get_type (void) G_GNUC_CONST;
void unity_places_place_search_bar_set_search_fail (UnityPlacesPlaceSearchBar* self, gboolean value);
static void unity_places_default_renderer_real_activate_default (UnityPlaceRenderer* base);
GType unity_places_default_renderer_group_get_type (void) G_GNUC_CONST;
guint unity_places_default_renderer_group_get_group_id (UnityPlacesDefaultRendererGroup* self);
UnityPlacesEmptySearchGroup* unity_places_empty_search_group_new (guint group_id, DeeModel* results);
UnityPlacesEmptySearchGroup* unity_places_empty_search_group_construct (GType object_type, guint group_id, DeeModel* results);
static void _lambda69_ (const char* u, const char* m, UnityPlacesDefaultRenderer* self);
static void __lambda69__unity_places_empty_search_group_activated (UnityPlacesEmptySearchGroup* _sender, const char* uri, const char* mimetype, gpointer self);
static void _unity_places_default_renderer_update_views_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
UnityPlacesEmptySectionGroup* unity_places_empty_section_group_new (guint group_id, DeeModel* results);
UnityPlacesEmptySectionGroup* unity_places_empty_section_group_construct (GType object_type, guint group_id, DeeModel* results);
UnityPlacesDefaultRendererGroup* unity_places_default_renderer_group_new (guint group_id, const char* group_renderer, const char* display_name, const char* icon_hint, DeeModel* results);
UnityPlacesDefaultRendererGroup* unity_places_default_renderer_group_construct (GType object_type, guint group_id, const char* group_renderer, const char* display_name, const char* icon_hint, DeeModel* results);
static void _lambda70_ (const char* u, const char* m, UnityPlacesDefaultRenderer* self);
static void __lambda70__unity_places_default_renderer_group_activated (UnityPlacesDefaultRendererGroup* _sender, const char* uri, const char* mimetype, gpointer self);
void unity_places_default_renderer_group_set_always_expanded (UnityPlacesDefaultRendererGroup* self, gboolean value);
static void _g_list_free_g_object_unref (GList* self);
static void _unity_places_default_renderer_trough_paint_unity_cairo_canvas_cairo_canvas_paint (cairo_t* cr, gint width, gint height, gpointer self);
static void _unity_places_default_renderer_slider_paint_unity_cairo_canvas_cairo_canvas_paint (cairo_t* cr, gint width, gint height, gpointer self);
static gboolean _unity_places_default_renderer_on_slider_enter_clutter_actor_enter_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean _unity_places_default_renderer_on_slider_leave_clutter_actor_leave_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean _unity_places_default_renderer_on_slider_button_press_clutter_actor_button_press_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean _unity_places_default_renderer_on_slider_button_release_clutter_actor_button_release_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
gpointer unity_testing_object_registry_ref (gpointer instance);
void unity_testing_object_registry_unref (gpointer instance);
GParamSpec* unity_testing_param_spec_object_registry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_testing_value_set_object_registry (GValue* value, gpointer v_object);
void unity_testing_value_take_object_registry (GValue* value, gpointer v_object);
gpointer unity_testing_value_get_object_registry (const GValue* value);
GType unity_testing_object_registry_get_type (void) G_GNUC_CONST;
UnityTestingObjectRegistry* unity_testing_object_registry_get_default (void);
GeeArrayList* unity_testing_object_registry_lookup (UnityTestingObjectRegistry* self, const char* name);
static GObject * unity_places_default_renderer_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_places_default_renderer_finalize (GObject* obj);
#define UNITY_PLACES_EMPTY_SEARCH_GROUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACES_TYPE_EMPTY_SEARCH_GROUP, UnityPlacesEmptySearchGroupPrivate))
enum  {
	UNITY_PLACES_EMPTY_SEARCH_GROUP_DUMMY_PROPERTY,
	UNITY_PLACES_EMPTY_SEARCH_GROUP_GROUP_ID,
	UNITY_PLACES_EMPTY_SEARCH_GROUP_RESULTS,
	UNITY_PLACES_EMPTY_SEARCH_GROUP_ACTIVE
};
static void unity_places_empty_search_group_on_result_added (UnityPlacesEmptySearchGroup* self, DeeModelIter* iter);
static gboolean unity_places_empty_search_group_interesting (UnityPlacesEmptySearchGroup* self, DeeModelIter* iter);
DeeModel* unity_places_empty_search_group_get_results (UnityPlacesEmptySearchGroup* self);
static void _lambda68_ (Block2Data* _data2_);
static void __lambda68__ctk_button_clicked (CtkButton* _sender, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
void unity_places_empty_search_group_set_active (UnityPlacesEmptySearchGroup* self, gboolean value);
static void unity_places_empty_search_group_on_result_removed (UnityPlacesEmptySearchGroup* self, DeeModelIter* iter);
guint unity_places_empty_search_group_get_group_id (UnityPlacesEmptySearchGroup* self);
void unity_places_empty_search_group_set_group_id (UnityPlacesEmptySearchGroup* self, guint value);
void unity_places_empty_search_group_set_results (UnityPlacesEmptySearchGroup* self, DeeModel* value);
static void _unity_places_empty_search_group_on_result_added_dee_model_row_added (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void _unity_places_empty_search_group_on_result_removed_dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static GObject * unity_places_empty_search_group_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_places_empty_search_group_finalize (GObject* obj);
static void unity_places_empty_search_group_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_places_empty_search_group_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define UNITY_PLACES_EMPTY_SECTION_GROUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACES_TYPE_EMPTY_SECTION_GROUP, UnityPlacesEmptySectionGroupPrivate))
enum  {
	UNITY_PLACES_EMPTY_SECTION_GROUP_DUMMY_PROPERTY,
	UNITY_PLACES_EMPTY_SECTION_GROUP_GROUP_ID,
	UNITY_PLACES_EMPTY_SECTION_GROUP_RESULTS,
	UNITY_PLACES_EMPTY_SECTION_GROUP_ACTIVE
};
static void unity_places_empty_section_group_real_allocate (ClutterActor* base, const ClutterActorBox* box, ClutterAllocationFlags flags);
static void unity_places_empty_section_group_on_result_added (UnityPlacesEmptySectionGroup* self, DeeModelIter* iter);
static gboolean unity_places_empty_section_group_interesting (UnityPlacesEmptySectionGroup* self, DeeModelIter* iter);
DeeModel* unity_places_empty_section_group_get_results (UnityPlacesEmptySectionGroup* self);
void unity_places_empty_section_group_set_active (UnityPlacesEmptySectionGroup* self, gboolean value);
static void unity_places_empty_section_group_on_result_removed (UnityPlacesEmptySectionGroup* self, DeeModelIter* iter);
static void unity_places_empty_section_group_real_get_preferred_height (ClutterActor* base, float for_width, float* mheight, float* nheight);
guint unity_places_empty_section_group_get_group_id (UnityPlacesEmptySectionGroup* self);
static void unity_places_empty_section_group_paint_bg (UnityPlacesEmptySectionGroup* self, cairo_t* cr, gint width, gint height);
void unity_places_empty_section_group_set_group_id (UnityPlacesEmptySectionGroup* self, guint value);
void unity_places_empty_section_group_set_results (UnityPlacesEmptySectionGroup* self, DeeModel* value);
static void _unity_places_empty_section_group_on_result_added_dee_model_row_added (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void _unity_places_empty_section_group_on_result_removed_dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void _unity_places_empty_section_group_paint_bg_unity_cairo_canvas_cairo_canvas_paint (cairo_t* cr, gint width, gint height, gpointer self);
static GObject * unity_places_empty_section_group_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_places_empty_section_group_finalize (GObject* obj);
static void unity_places_empty_section_group_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_places_empty_section_group_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

UnityPlacesDefaultRenderer* unity_places_default_renderer_construct (GType object_type) {
	UnityPlacesDefaultRenderer * self;
	self = (UnityPlacesDefaultRenderer*) g_object_new (object_type, NULL);
	return self;
}


UnityPlacesDefaultRenderer* unity_places_default_renderer_new (void) {
	return unity_places_default_renderer_construct (UNITY_PLACES_TYPE_DEFAULT_RENDERER);
}


static double _unity_places_default_renderer_align (double val) {
	double result = 0.0;
	double fract;
	fract = val - ((gint) val);
	if (fract != 0.5f) {
		result = (double) (((gint) val) + 0.5f);
		return result;
	} else {
		result = val;
		return result;
	}
}


static void unity_places_default_renderer_trough_paint (UnityPlacesDefaultRenderer* self, cairo_t* cr, gint width, gint height) {
	cairo_surface_t* dots;
	cairo_t* cr_dots;
	cairo_pattern_t* dot_pattern;
	double radius;
	cairo_pattern_t* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	dots = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 4, 4);
	cr_dots = cairo_create (dots);
	dot_pattern = NULL;
	radius = ((double) width) / 2.0f;
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	cairo_paint (cr);
	cairo_set_line_width (cr, (double) 1.0f);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	cairo_set_source_rgba (cr, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.25f);
	cairo_move_to (cr, (double) 0.5f, radius - 0.5f);
	cairo_arc (cr, radius, radius, radius - 0.5f, (180.0f * G_PI) / 180.0f, (0.0f * G_PI) / 180.0f);
	cairo_line_to (cr, ((double) width) - 0.5f, (((double) height) - radius) - 0.5f);
	cairo_arc (cr, radius, (((double) height) - radius) - 0.5f, radius - 0.5f, (0.0f * G_PI) / 180.0f, (180.0f * G_PI) / 180.0f);
	cairo_close_path (cr);
	cairo_set_source_rgba (cr, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.1f);
	cairo_set_operator (cr_dots, CAIRO_OPERATOR_CLEAR);
	cairo_paint (cr_dots);
	cairo_scale (cr_dots, (double) 1.0f, (double) 1.0f);
	cairo_set_operator (cr_dots, CAIRO_OPERATOR_OVER);
	cairo_set_source_rgba (cr_dots, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.025f);
	cairo_rectangle (cr_dots, (double) 0.0f, (double) 0.0f, (double) 1.0f, (double) 1.0f);
	cairo_fill (cr_dots);
	cairo_rectangle (cr_dots, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 1.0f);
	cairo_fill (cr_dots);
	cairo_rectangle (cr_dots, (double) 2.0f, (double) 0.0f, (double) 1.0f, (double) 1.0f);
	cairo_fill (cr_dots);
	cairo_rectangle (cr_dots, (double) 0.0f, (double) 2.0f, (double) 1.0f, (double) 1.0f);
	cairo_fill (cr_dots);
	cairo_rectangle (cr_dots, (double) 2.0f, (double) 2.0f, (double) 1.0f, (double) 1.0f);
	cairo_fill (cr_dots);
	cairo_rectangle (cr_dots, (double) 3.0f, (double) 3.0f, (double) 1.0f, (double) 1.0f);
	cairo_fill (cr_dots);
	dot_pattern = (_tmp0_ = cairo_pattern_create_for_surface (dots), _cairo_pattern_destroy0 (dot_pattern), _tmp0_);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	cairo_set_source (cr, dot_pattern);
	cairo_pattern_set_extend (dot_pattern, CAIRO_EXTEND_REPEAT);
	cairo_fill_preserve (cr);
	cairo_set_source_rgba (cr, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.35f);
	cairo_stroke (cr);
	_cairo_pattern_destroy0 (dot_pattern);
	_cairo_destroy0 (cr_dots);
	_cairo_surface_destroy0 (dots);
}


static void unity_places_default_renderer_slider_paint (UnityPlacesDefaultRenderer* self, cairo_t* cr, gint width, gint height) {
	cairo_surface_t* stripes;
	cairo_t* cr_stripes;
	cairo_pattern_t* stripe_pattern;
	double radius;
	double half;
	double half_height;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	stripes = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 4, 4);
	cr_stripes = cairo_create (stripes);
	stripe_pattern = NULL;
	radius = ((double) width) / 2.0f;
	half = ((double) width) / 2.0f;
	half_height = ((double) height) / 2.0f;
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	cairo_paint (cr);
	cairo_set_line_width (cr, (double) 1.0f);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	cairo_set_source_rgba (cr, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.75f);
	cairo_move_to (cr, (double) 0.5f, radius - 0.5f);
	cairo_arc (cr, radius, radius, radius - 0.5f, (180.0f * G_PI) / 180.0f, (0.0f * G_PI) / 180.0f);
	cairo_line_to (cr, ((double) width) - 0.5f, (((double) height) - radius) - 0.5f);
	cairo_arc (cr, radius, (((double) height) - radius) - 0.5f, radius - 0.5f, (0.0f * G_PI) / 180.0f, (180.0f * G_PI) / 180.0f);
	cairo_close_path (cr);
	if (self->priv->slider_state == UNITY_PLACES_DEFAULT_RENDERER_SLIDER_STATE_NORMAL) {
		cairo_set_source_rgba (cr, (double) 0.0f, (double) 0.0f, (double) 0.0f, (double) 0.15f);
	} else {
		if (self->priv->slider_state == UNITY_PLACES_DEFAULT_RENDERER_SLIDER_STATE_PRELIGHT) {
			cairo_pattern_t* _tmp0_;
			cairo_set_source_rgba (cr, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.1f);
			cairo_fill_preserve (cr);
			cairo_set_operator (cr_stripes, CAIRO_OPERATOR_CLEAR);
			cairo_paint (cr_stripes);
			cairo_scale (cr_stripes, (double) 1.0f, (double) 1.0f);
			cairo_set_operator (cr_stripes, CAIRO_OPERATOR_OVER);
			cairo_set_source_rgba (cr_stripes, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.15f);
			cairo_rectangle (cr_stripes, (double) 0.0f, (double) 0.0f, (double) 1.0f, (double) 1.0f);
			cairo_fill (cr_stripes);
			cairo_rectangle (cr_stripes, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 1.0f);
			cairo_fill (cr_stripes);
			cairo_rectangle (cr_stripes, (double) 2.0f, (double) 2.0f, (double) 1.0f, (double) 1.0f);
			cairo_fill (cr_stripes);
			cairo_rectangle (cr_stripes, (double) 3.0f, (double) 3.0f, (double) 1.0f, (double) 1.0f);
			cairo_fill (cr_stripes);
			stripe_pattern = (_tmp0_ = cairo_pattern_create_for_surface (stripes), _cairo_pattern_destroy0 (stripe_pattern), _tmp0_);
			cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
			cairo_set_source (cr, stripe_pattern);
			cairo_pattern_set_extend (stripe_pattern, CAIRO_EXTEND_REPEAT);
		} else {
			if (self->priv->slider_state == UNITY_PLACES_DEFAULT_RENDERER_SLIDER_STATE_ACTIVE) {
				cairo_set_source_rgba (cr, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 1.0f);
			}
		}
	}
	cairo_fill_preserve (cr);
	cairo_set_source_rgba (cr, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.5f);
	cairo_stroke (cr);
	cairo_set_source_rgba (cr, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.75f);
	cairo_move_to (cr, _unity_places_default_renderer_align ((double) 1.0f), _unity_places_default_renderer_align (half_height - 2.0f));
	cairo_line_to (cr, _unity_places_default_renderer_align (((double) width) - 2.0f), _unity_places_default_renderer_align (half_height - 2.0f));
	cairo_move_to (cr, _unity_places_default_renderer_align ((double) 1.0f), _unity_places_default_renderer_align (half_height));
	cairo_line_to (cr, _unity_places_default_renderer_align (((double) width) - 2.0f), _unity_places_default_renderer_align (half_height));
	cairo_move_to (cr, _unity_places_default_renderer_align ((double) 1.0f), _unity_places_default_renderer_align (half_height + 2.0f));
	cairo_line_to (cr, _unity_places_default_renderer_align (((double) width) - 2.0f), _unity_places_default_renderer_align (half_height + 2.0f));
	if (self->priv->slider_state == UNITY_PLACES_DEFAULT_RENDERER_SLIDER_STATE_NORMAL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->slider_state == UNITY_PLACES_DEFAULT_RENDERER_SLIDER_STATE_PRELIGHT;
	}
	if (_tmp1_) {
		cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	} else {
		if (self->priv->slider_state == UNITY_PLACES_DEFAULT_RENDERER_SLIDER_STATE_ACTIVE) {
			cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
		}
	}
	cairo_stroke (cr);
	_cairo_pattern_destroy0 (stripe_pattern);
	_cairo_destroy0 (cr_stripes);
	_cairo_surface_destroy0 (stripes);
}


static gboolean unity_places_default_renderer_on_slider_enter (UnityPlacesDefaultRenderer* self, ClutterEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->slider_state = UNITY_PLACES_DEFAULT_RENDERER_SLIDER_STATE_PRELIGHT;
	unity_cairo_canvas_update (self->priv->slider);
	ctk_effect_set_invalidate_effect_cache ((CtkEffect*) self->priv->slider_glow, TRUE);
	result = FALSE;
	return result;
}


static gboolean unity_places_default_renderer_on_slider_leave (UnityPlacesDefaultRenderer* self, ClutterEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->button_pressed) {
		self->priv->slider_state = UNITY_PLACES_DEFAULT_RENDERER_SLIDER_STATE_NORMAL;
		unity_cairo_canvas_update (self->priv->slider);
		ctk_effect_set_invalidate_effect_cache ((CtkEffect*) self->priv->slider_glow, TRUE);
	}
	result = FALSE;
	return result;
}


static gboolean unity_places_default_renderer_on_slider_button_press (UnityPlacesDefaultRenderer* self, ClutterEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->button_pressed = TRUE;
	self->priv->slider_state = UNITY_PLACES_DEFAULT_RENDERER_SLIDER_STATE_ACTIVE;
	unity_cairo_canvas_update (self->priv->slider);
	ctk_effect_set_invalidate_effect_cache ((CtkEffect*) self->priv->slider_glow, TRUE);
	result = FALSE;
	return result;
}


static gboolean unity_places_default_renderer_on_slider_button_release (UnityPlacesDefaultRenderer* self, ClutterEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->button_pressed = FALSE;
	self->priv->slider_state = UNITY_PLACES_DEFAULT_RENDERER_SLIDER_STATE_PRELIGHT;
	unity_cairo_canvas_update (self->priv->slider);
	ctk_effect_set_invalidate_effect_cache ((CtkEffect*) self->priv->slider_glow, TRUE);
	result = FALSE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _unity_places_default_renderer_on_group_added_dee_model_row_added (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_places_default_renderer_on_group_added (self, _sender, iter);
}


static void _unity_places_default_renderer_on_group_removed_dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_places_default_renderer_on_group_removed (self, _sender, iter);
}


static void unity_places_default_renderer_real_set_models (UnityPlaceRenderer* base, DeeModel* groups, DeeModel* results, GeeHashMap* hints) {
	UnityPlacesDefaultRenderer * self;
	DeeModel* _tmp0_;
	DeeModel* _tmp1_;
	char* expandable;
	gboolean _tmp2_ = FALSE;
	DeeModelIter* iter;
	self = (UnityPlacesDefaultRenderer*) base;
	g_return_if_fail (groups != NULL);
	g_return_if_fail (results != NULL);
	g_return_if_fail (hints != NULL);
	self->priv->groups_model = (_tmp0_ = _g_object_ref0 (groups), _g_object_unref0 (self->priv->groups_model), _tmp0_);
	self->priv->results_model = (_tmp1_ = _g_object_ref0 (results), _g_object_unref0 (self->priv->results_model), _tmp1_);
	expandable = (char*) gee_abstract_map_get ((GeeAbstractMap*) hints, "ExpandedGroups");
	if (expandable != NULL) {
		_tmp2_ = _vala_strcmp0 (expandable, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		char** _tmp3_;
		char** _tmp4_;
		self->priv->expanded = (_tmp4_ = _tmp3_ = g_strsplit (expandable, " ", 0), self->priv->expanded = (_vala_array_free (self->priv->expanded, self->priv->expanded_length1, (GDestroyNotify) g_free), NULL), self->priv->expanded_length1 = _vala_array_length (_tmp3_), self->priv->_expanded_size_ = self->priv->expanded_length1, _tmp4_);
	}
	iter = dee_model_get_first_iter (groups);
	while (TRUE) {
		if (!(!dee_model_is_last (groups, iter))) {
			break;
		}
		unity_places_default_renderer_on_group_added (self, groups, iter);
		iter = dee_model_next (groups, iter);
	}
	g_signal_connect_object (self->priv->groups_model, "row-added", (GCallback) _unity_places_default_renderer_on_group_added_dee_model_row_added, self, 0);
	g_signal_connect_object (self->priv->groups_model, "row-removed", (GCallback) _unity_places_default_renderer_on_group_removed_dee_model_row_removed, self, 0);
	_g_free0 (expandable);
}


static void unity_places_default_renderer_update_views (UnityPlacesDefaultRenderer* self) {
	gint search_empty_opacity;
	gint section_empty_opacity;
	gint groups_box_opacity;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	search_empty_opacity = 0;
	section_empty_opacity = 0;
	groups_box_opacity = 255;
	if (unity_places_empty_search_group_get_active (self->priv->search_empty)) {
		search_empty_opacity = 255;
		section_empty_opacity = 0;
		groups_box_opacity = 0;
	} else {
		if (unity_places_empty_section_group_get_active (self->priv->section_empty)) {
			search_empty_opacity = 0;
			section_empty_opacity = 255;
			groups_box_opacity = 0;
		}
	}
	clutter_actor_animate ((ClutterActor*) self->priv->search_empty, (gulong) CLUTTER_EASE_IN_QUAD, (guint) 300, "opacity", search_empty_opacity, NULL);
	clutter_actor_animate ((ClutterActor*) self->priv->section_empty, (gulong) CLUTTER_EASE_IN_QUAD, (guint) 300, "opacity", section_empty_opacity, NULL);
	clutter_actor_animate ((ClutterActor*) self->priv->scroll, (gulong) CLUTTER_EASE_IN_QUAD, (guint) 300, "opacity", groups_box_opacity, NULL);
	if (unity_places_empty_section_group_get_active (self->priv->section_empty)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = unity_places_empty_search_group_get_active (self->priv->search_empty);
	}
	unity_places_place_search_bar_set_search_fail (self->priv->place_view->search_bar, _tmp0_);
}


static void unity_places_default_renderer_real_activate_default (UnityPlaceRenderer* base) {
	UnityPlacesDefaultRenderer * self;
	GList* children;
	self = (UnityPlacesDefaultRenderer*) base;
	children = clutter_container_get_children ((ClutterContainer*) self->priv->box);
	{
		GList* child_collection;
		GList* child_it;
		child_collection = children;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child;
			child = _g_object_ref0 ((ClutterActor*) child_it->data);
			{
				ClutterActor* _tmp0_;
				UnityPlacesDefaultRendererGroup* group;
				group = _g_object_ref0 ((_tmp0_ = child, UNITY_PLACES_IS_DEFAULT_RENDERER_GROUP (_tmp0_) ? ((UnityPlacesDefaultRendererGroup*) _tmp0_) : NULL));
				if (group->n_results > 0) {
					DeeModelIter* iter;
					iter = dee_model_get_first_iter (self->priv->results_model);
					while (TRUE) {
						if (!(!dee_model_is_last (self->priv->results_model, iter))) {
							break;
						}
						if (dee_model_get_uint (self->priv->results_model, iter, (guint) 2) == unity_places_default_renderer_group_get_group_id (group)) {
							g_signal_emit_by_name ((UnityPlaceRenderer*) self, "activated", dee_model_get_string (self->priv->results_model, iter, (guint) 0), dee_model_get_string (self->priv->results_model, iter, (guint) 3));
							break;
						}
						iter = dee_model_next (self->priv->results_model, iter);
					}
					_g_object_unref0 (group);
					_g_object_unref0 (child);
					break;
				}
				_g_object_unref0 (group);
				_g_object_unref0 (child);
			}
		}
	}
	_g_list_free0 (children);
}


static void _lambda69_ (const char* u, const char* m, UnityPlacesDefaultRenderer* self) {
	g_return_if_fail (u != NULL);
	g_return_if_fail (m != NULL);
	g_signal_emit_by_name ((UnityPlaceRenderer*) self, "activated", u, m);
}


static void __lambda69__unity_places_empty_search_group_activated (UnityPlacesEmptySearchGroup* _sender, const char* uri, const char* mimetype, gpointer self) {
	_lambda69_ (uri, mimetype, self);
}


static void _unity_places_default_renderer_update_views_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_places_default_renderer_update_views (self);
}


static void _lambda70_ (const char* u, const char* m, UnityPlacesDefaultRenderer* self) {
	g_return_if_fail (u != NULL);
	g_return_if_fail (m != NULL);
	g_signal_emit_by_name ((UnityPlaceRenderer*) self, "activated", u, m);
}


static void __lambda70__unity_places_default_renderer_group_activated (UnityPlacesDefaultRendererGroup* _sender, const char* uri, const char* mimetype, gpointer self) {
	_lambda70_ (uri, mimetype, self);
}


static void unity_places_default_renderer_on_group_added (UnityPlacesDefaultRenderer* self, DeeModel* model, DeeModelIter* iter) {
	char* renderer;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	renderer = g_strdup (dee_model_get_string (model, iter, (guint) 0));
	if (_vala_strcmp0 (renderer, "UnityEmptySearchRenderer") == 0) {
		UnityPlacesEmptySearchGroup* _tmp0_;
		self->priv->search_empty = (_tmp0_ = g_object_ref_sink (unity_places_empty_search_group_new ((guint) dee_model_get_position (model, iter), self->priv->results_model)), _g_object_unref0 (self->priv->search_empty), _tmp0_);
		clutter_actor_set_opacity ((ClutterActor*) self->priv->search_empty, (guint8) 0);
		clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->priv->search_empty);
		g_signal_connect_object (self->priv->search_empty, "activated", (GCallback) __lambda69__unity_places_empty_search_group_activated, self, 0);
		g_signal_connect_object ((GObject*) self->priv->search_empty, "notify::active", (GCallback) _unity_places_default_renderer_update_views_g_object_notify, self, 0);
	} else {
		if (_vala_strcmp0 (renderer, "UnityEmptySectionRenderer") == 0) {
			UnityPlacesEmptySectionGroup* _tmp1_;
			self->priv->section_empty = (_tmp1_ = g_object_ref_sink (unity_places_empty_section_group_new ((guint) dee_model_get_position (model, iter), self->priv->results_model)), _g_object_unref0 (self->priv->section_empty), _tmp1_);
			clutter_actor_set_opacity ((ClutterActor*) self->priv->section_empty, (guint8) 0);
			clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->priv->section_empty);
			g_signal_connect_object ((GObject*) self->priv->section_empty, "notify::active", (GCallback) _unity_places_default_renderer_update_views_g_object_notify, self, 0);
		} else {
			UnityPlacesDefaultRendererGroup* group;
			group = g_object_ref_sink (unity_places_default_renderer_group_new ((guint) dee_model_get_position (model, iter), dee_model_get_string (model, iter, (guint) 0), dee_model_get_string (model, iter, (guint) 1), dee_model_get_string (model, iter, (guint) 2), self->priv->results_model));
			g_signal_connect_object (group, "activated", (GCallback) __lambda70__unity_places_default_renderer_group_activated, self, 0);
			g_object_set_data_full ((GObject*) group, "model-iter", iter, NULL);
			ctk_box_pack ((CtkBox*) self->priv->box, (ClutterActor*) group, FALSE, TRUE);
			{
				char** id_collection;
				int id_collection_length1;
				int id_it;
				id_collection = self->priv->expanded;
				id_collection_length1 = self->priv->expanded_length1;
				for (id_it = 0; id_it < self->priv->expanded_length1; id_it = id_it + 1) {
					char* id;
					id = g_strdup (id_collection[id_it]);
					{
						if (dee_model_get_position (model, iter) == atoi (id)) {
							unity_places_default_renderer_group_set_always_expanded (group, TRUE);
						}
						_g_free0 (id);
					}
				}
			}
			_g_object_unref0 (group);
		}
	}
	_g_free0 (renderer);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static void unity_places_default_renderer_on_group_removed (UnityPlacesDefaultRenderer* self, DeeModel* model, DeeModelIter* iter) {
	GList* children;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	children = clutter_container_get_children ((ClutterContainer*) self->priv->box);
	{
		GList* actor_collection;
		GList* actor_it;
		actor_collection = children;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* actor;
			actor = _g_object_ref0 ((ClutterActor*) actor_it->data);
			{
				DeeModelIter* i;
				i = (DeeModelIter*) ((DeeModelIter*) g_object_get_data ((GObject*) actor, "model-iter"));
				if (i == iter) {
					clutter_actor_destroy (actor);
					_g_object_unref0 (actor);
					break;
				}
				_g_object_unref0 (actor);
			}
		}
	}
	__g_list_free_g_object_unref0 (children);
}


static void _unity_places_default_renderer_trough_paint_unity_cairo_canvas_cairo_canvas_paint (cairo_t* cr, gint width, gint height, gpointer self) {
	unity_places_default_renderer_trough_paint (self, cr, width, height);
}


static void _unity_places_default_renderer_slider_paint_unity_cairo_canvas_cairo_canvas_paint (cairo_t* cr, gint width, gint height, gpointer self) {
	unity_places_default_renderer_slider_paint (self, cr, width, height);
}


static gboolean _unity_places_default_renderer_on_slider_enter_clutter_actor_enter_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_places_default_renderer_on_slider_enter (self, event);
	return result;
}


static gboolean _unity_places_default_renderer_on_slider_leave_clutter_actor_leave_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_places_default_renderer_on_slider_leave (self, event);
	return result;
}


static gboolean _unity_places_default_renderer_on_slider_button_press_clutter_actor_button_press_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_places_default_renderer_on_slider_button_press (self, event);
	return result;
}


static gboolean _unity_places_default_renderer_on_slider_button_release_clutter_actor_button_release_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_places_default_renderer_on_slider_button_release (self, event);
	return result;
}


static GObject * unity_places_default_renderer_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlacesDefaultRenderer * self;
	parent_class = G_OBJECT_CLASS (unity_places_default_renderer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACES_DEFAULT_RENDERER (obj);
	{
		CtkPadding _tmp0_ = {0};
		CtkPadding _tmp1_;
		CtkEffectGlow* _tmp2_;
		ClutterColor _tmp3_ = {0};
		ClutterColor _tmp4_;
		UnityCairoCanvas* _tmp5_;
		UnityCairoCanvas* _tmp6_;
		CtkScrollView* _tmp7_;
		CtkVBox* _tmp8_;
		UnityTestingObjectRegistry* _tmp9_;
		GeeArrayList* _tmp10_;
		GObject* _tmp11_;
		UnityPlacesView* _tmp12_;
		ctk_actor_set_padding ((CtkActor*) self, (_tmp1_ = (_tmp0_.top = UNITY_PLACES_DEFAULT_RENDERER_PADDING, _tmp0_.right = 0.0f, _tmp0_.bottom = 0.0f, _tmp0_.left = 0.0f, _tmp0_), &_tmp1_));
		self->priv->slider_glow = (_tmp2_ = g_object_ref_sink ((CtkEffectGlow*) ctk_effect_glow_new ()), _g_object_unref0 (self->priv->slider_glow), _tmp2_);
		ctk_effect_glow_set_color (self->priv->slider_glow, (_tmp4_ = (_tmp3_.red = (guint8) 255, _tmp3_.green = (guint8) 255, _tmp3_.blue = (guint8) 255, _tmp3_.alpha = (guint8) 255, _tmp3_), &_tmp4_));
		ctk_effect_glow_set_factor (self->priv->slider_glow, 1.0f);
		ctk_effect_set_margin ((CtkEffect*) self->priv->slider_glow, 5);
		self->priv->trough = (_tmp5_ = g_object_ref_sink (unity_cairo_canvas_new (_unity_places_default_renderer_trough_paint_unity_cairo_canvas_cairo_canvas_paint, self)), _g_object_unref0 (self->priv->trough), _tmp5_);
		self->priv->slider = (_tmp6_ = g_object_ref_sink (unity_cairo_canvas_new (_unity_places_default_renderer_slider_paint_unity_cairo_canvas_cairo_canvas_paint, self)), _g_object_unref0 (self->priv->slider), _tmp6_);
		g_signal_connect_object ((ClutterActor*) self->priv->slider, "enter-event", (GCallback) _unity_places_default_renderer_on_slider_enter_clutter_actor_enter_event, self, 0);
		g_signal_connect_object ((ClutterActor*) self->priv->slider, "leave-event", (GCallback) _unity_places_default_renderer_on_slider_leave_clutter_actor_leave_event, self, 0);
		g_signal_connect_object ((ClutterActor*) self->priv->slider, "button-press-event", (GCallback) _unity_places_default_renderer_on_slider_button_press_clutter_actor_button_press_event, self, 0);
		g_signal_connect_object ((ClutterActor*) self->priv->slider, "button-release-event", (GCallback) _unity_places_default_renderer_on_slider_button_release_clutter_actor_button_release_event, self, 0);
		self->priv->slider_state = UNITY_PLACES_DEFAULT_RENDERER_SLIDER_STATE_NORMAL;
		self->priv->button_pressed = FALSE;
		ctk_actor_add_effect ((CtkActor*) self->priv->slider, (CtkEffect*) self->priv->slider_glow);
		self->priv->scroll = (_tmp7_ = g_object_ref_sink ((CtkScrollView*) ctk_scroll_view_new ()), _g_object_unref0 (self->priv->scroll), _tmp7_);
		ctk_scroll_view_set_scroll_bar (self->priv->scroll, (ClutterActor*) self->priv->trough, (ClutterActor*) self->priv->slider);
		clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->priv->scroll);
		clutter_actor_show ((ClutterActor*) self->priv->scroll);
		clutter_actor_show ((ClutterActor*) self->priv->trough);
		clutter_actor_show ((ClutterActor*) self->priv->slider);
		self->priv->box = (_tmp8_ = g_object_ref_sink ((CtkVBox*) ctk_vbox_new ((guint) UNITY_PLACES_DEFAULT_RENDERER_SPACING)), _g_object_unref0 (self->priv->box), _tmp8_);
		ctk_box_set_homogeneous ((CtkBox*) self->priv->box, FALSE);
		clutter_container_add_actor ((ClutterContainer*) self->priv->scroll, (ClutterActor*) self->priv->box);
		clutter_actor_show ((ClutterActor*) self->priv->box);
		self->priv->place_view = (_tmp12_ = (_tmp11_ = (GObject*) gee_abstract_list_get ((GeeAbstractList*) (_tmp10_ = unity_testing_object_registry_lookup (_tmp9_ = unity_testing_object_registry_get_default (), "UnityPlacesView")), 0), UNITY_PLACES_IS_VIEW (_tmp11_) ? ((UnityPlacesView*) _tmp11_) : NULL), _g_object_unref0 (self->priv->place_view), _tmp12_);
		_g_object_unref0 (_tmp10_);
		_unity_testing_object_registry_unref0 (_tmp9_);
	}
	return obj;
}


static void unity_places_default_renderer_class_init (UnityPlacesDefaultRendererClass * klass) {
	unity_places_default_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlacesDefaultRendererPrivate));
	G_OBJECT_CLASS (klass)->constructor = unity_places_default_renderer_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_places_default_renderer_finalize;
}


static void unity_places_default_renderer_unity_place_renderer_interface_init (UnityPlaceRendererIface * iface) {
	unity_places_default_renderer_unity_place_renderer_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_models = unity_places_default_renderer_real_set_models;
	iface->activate_default = unity_places_default_renderer_real_activate_default;
}


static void unity_places_default_renderer_instance_init (UnityPlacesDefaultRenderer * self) {
	self->priv = UNITY_PLACES_DEFAULT_RENDERER_GET_PRIVATE (self);
	self->priv->expanded = NULL;
}


static void unity_places_default_renderer_finalize (GObject* obj) {
	UnityPlacesDefaultRenderer * self;
	self = UNITY_PLACES_DEFAULT_RENDERER (obj);
	{
	}
	_g_object_unref0 (self->priv->search_empty);
	_g_object_unref0 (self->priv->section_empty);
	_g_object_unref0 (self->priv->scroll);
	_g_object_unref0 (self->priv->trough);
	_g_object_unref0 (self->priv->slider);
	_g_object_unref0 (self->priv->slider_glow);
	_g_object_unref0 (self->priv->box);
	_g_object_unref0 (self->priv->groups_model);
	_g_object_unref0 (self->priv->results_model);
	_g_object_unref0 (self->priv->place_view);
	self->priv->expanded = (_vala_array_free (self->priv->expanded, self->priv->expanded_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (unity_places_default_renderer_parent_class)->finalize (obj);
}


GType unity_places_default_renderer_get_type (void) {
	static volatile gsize unity_places_default_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&unity_places_default_renderer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlacesDefaultRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_places_default_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlacesDefaultRenderer), 0, (GInstanceInitFunc) unity_places_default_renderer_instance_init, NULL };
		static const GInterfaceInfo unity_place_renderer_info = { (GInterfaceInitFunc) unity_places_default_renderer_unity_place_renderer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_places_default_renderer_type_id;
		unity_places_default_renderer_type_id = g_type_register_static (UNITY_TYPE_LAYERED_BIN, "UnityPlacesDefaultRenderer", &g_define_type_info, 0);
		g_type_add_interface_static (unity_places_default_renderer_type_id, UNITY_PLACE_TYPE_RENDERER, &unity_place_renderer_info);
		g_once_init_leave (&unity_places_default_renderer_type_id__volatile, unity_places_default_renderer_type_id);
	}
	return unity_places_default_renderer_type_id__volatile;
}


UnityPlacesEmptySearchGroup* unity_places_empty_search_group_construct (GType object_type, guint group_id, DeeModel* results) {
	UnityPlacesEmptySearchGroup * self;
	g_return_val_if_fail (results != NULL, NULL);
	self = (UnityPlacesEmptySearchGroup*) g_object_new (object_type, "group-id", group_id, "results", results, "active", FALSE, NULL);
	return self;
}


UnityPlacesEmptySearchGroup* unity_places_empty_search_group_new (guint group_id, DeeModel* results) {
	return unity_places_empty_search_group_construct (UNITY_PLACES_TYPE_EMPTY_SEARCH_GROUP, group_id, results);
}


static void _lambda68_ (Block2Data* _data2_) {
	UnityPlacesEmptySearchGroup * self;
	self = _data2_->self;
	g_signal_emit_by_name (self, "activated", _data2_->uri, _data2_->mimetype);
}


static void __lambda68__ctk_button_clicked (CtkButton* _sender, gpointer self) {
	_lambda68_ (self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_free0 (_data2_->mimetype);
		_g_free0 (_data2_->uri);
		g_slice_free (Block2Data, _data2_);
	}
}


static void unity_places_empty_search_group_on_result_added (UnityPlacesEmptySearchGroup* self, DeeModelIter* iter) {
	char* mes;
	CtkButton* button;
	CtkPadding _tmp0_ = {0};
	CtkPadding _tmp1_;
	CtkText* text;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	GList* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	if (!unity_places_empty_search_group_interesting (self, iter)) {
		return;
	}
	mes = g_strdup (dee_model_get_string (self->priv->_results, iter, (guint) 4));
	button = g_object_ref_sink ((CtkButton*) ctk_button_new (CTK_ORIENTATION_HORIZONTAL));
	ctk_actor_set_padding ((CtkActor*) button, (_tmp1_ = (_tmp0_.top = 12.0f, _tmp0_.right = 12.0f, _tmp0_.bottom = 12.0f, _tmp0_.left = 12.0f, _tmp0_), &_tmp1_));
	text = g_object_ref_sink ((CtkText*) ctk_text_new (""));
	clutter_text_set_markup ((ClutterText*) text, _tmp4_ = g_strconcat (_tmp3_ = g_strconcat ("<big>", _tmp2_ = g_markup_escape_text (mes, -1), NULL), "</big>", NULL));
	_g_free0 (_tmp4_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp2_);
	clutter_container_add_actor ((ClutterContainer*) button, (ClutterActor*) text);
	ctk_box_pack ((CtkBox*) self->priv->box, (ClutterActor*) button, FALSE, FALSE);
	if ((_tmp6_ = g_list_length (_tmp5_ = clutter_container_get_children ((ClutterContainer*) self->priv->box)) >= 2, _g_list_free0 (_tmp5_), _tmp6_)) {
		Block2Data* _data2_;
		UnityStripeTexture* bg;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->self = g_object_ref (self);
		bg = g_object_ref_sink (unity_stripe_texture_new (NULL, NULL));
		ctk_actor_set_background ((CtkActor*) button, (ClutterActor*) bg);
		_data2_->uri = g_strdup (dee_model_get_string (self->priv->_results, iter, (guint) 0));
		_data2_->mimetype = g_strdup (dee_model_get_string (self->priv->_results, iter, (guint) 3));
		g_signal_connect_data (button, "clicked", (GCallback) __lambda68__ctk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_g_object_unref0 (bg);
		block2_data_unref (_data2_);
	}
	unity_places_empty_search_group_set_active (self, TRUE);
	_g_object_unref0 (text);
	_g_object_unref0 (button);
	_g_free0 (mes);
}


static void unity_places_empty_search_group_on_result_removed (UnityPlacesEmptySearchGroup* self, DeeModelIter* iter) {
	GList* children;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	if (!unity_places_empty_search_group_interesting (self, iter)) {
		return;
	}
	unity_places_empty_search_group_set_active (self, FALSE);
	children = clutter_container_get_children ((ClutterContainer*) self->priv->box);
	{
		GList* child_collection;
		GList* child_it;
		child_collection = children;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child;
			child = _g_object_ref0 ((ClutterActor*) child_it->data);
			{
				clutter_container_remove_actor ((ClutterContainer*) self->priv->box, child);
				_g_object_unref0 (child);
			}
		}
	}
	_g_list_free0 (children);
}


static gboolean unity_places_empty_search_group_interesting (UnityPlacesEmptySearchGroup* self, DeeModelIter* iter) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	result = dee_model_get_uint (self->priv->_results, iter, (guint) 2) == self->priv->_group_id;
	return result;
}


guint unity_places_empty_search_group_get_group_id (UnityPlacesEmptySearchGroup* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_group_id;
	return result;
}


void unity_places_empty_search_group_set_group_id (UnityPlacesEmptySearchGroup* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_group_id = value;
	g_object_notify ((GObject *) self, "group-id");
}


DeeModel* unity_places_empty_search_group_get_results (UnityPlacesEmptySearchGroup* self) {
	DeeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_results;
	return result;
}


void unity_places_empty_search_group_set_results (UnityPlacesEmptySearchGroup* self, DeeModel* value) {
	DeeModel* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_results = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_results), _tmp0_);
	g_object_notify ((GObject *) self, "results");
}


gboolean unity_places_empty_search_group_get_active (UnityPlacesEmptySearchGroup* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}


void unity_places_empty_search_group_set_active (UnityPlacesEmptySearchGroup* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	g_object_notify ((GObject *) self, "active");
}


static void _unity_places_empty_search_group_on_result_added_dee_model_row_added (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_places_empty_search_group_on_result_added (self, iter);
}


static void _unity_places_empty_search_group_on_result_removed_dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_places_empty_search_group_on_result_removed (self, iter);
}


static GObject * unity_places_empty_search_group_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlacesEmptySearchGroup * self;
	parent_class = G_OBJECT_CLASS (unity_places_empty_search_group_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACES_EMPTY_SEARCH_GROUP (obj);
	{
		CtkHBox* hbox;
		CtkVBox* _tmp0_;
		hbox = g_object_ref_sink ((CtkHBox*) ctk_hbox_new ((guint) 0));
		clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) hbox);
		clutter_actor_show ((ClutterActor*) hbox);
		self->priv->box = (_tmp0_ = g_object_ref_sink ((CtkVBox*) ctk_vbox_new ((guint) 12)), _g_object_unref0 (self->priv->box), _tmp0_);
		ctk_box_pack ((CtkBox*) hbox, (ClutterActor*) self->priv->box, FALSE, FALSE);
		clutter_actor_show ((ClutterActor*) self->priv->box);
		g_signal_connect_object (self->priv->_results, "row-added", (GCallback) _unity_places_empty_search_group_on_result_added_dee_model_row_added, self, 0);
		g_signal_connect_object (self->priv->_results, "row-removed", (GCallback) _unity_places_empty_search_group_on_result_removed_dee_model_row_removed, self, 0);
		clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
		_g_object_unref0 (hbox);
	}
	return obj;
}


static void unity_places_empty_search_group_class_init (UnityPlacesEmptySearchGroupClass * klass) {
	unity_places_empty_search_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlacesEmptySearchGroupPrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_places_empty_search_group_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_places_empty_search_group_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_places_empty_search_group_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_places_empty_search_group_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_EMPTY_SEARCH_GROUP_GROUP_ID, g_param_spec_uint ("group-id", "group-id", "group-id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_EMPTY_SEARCH_GROUP_RESULTS, g_param_spec_object ("results", "results", "results", DEE_TYPE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_EMPTY_SEARCH_GROUP_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_signal_new ("activated", UNITY_PLACES_TYPE_EMPTY_SEARCH_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
}


static void unity_places_empty_search_group_instance_init (UnityPlacesEmptySearchGroup * self) {
	self->priv = UNITY_PLACES_EMPTY_SEARCH_GROUP_GET_PRIVATE (self);
}


static void unity_places_empty_search_group_finalize (GObject* obj) {
	UnityPlacesEmptySearchGroup * self;
	self = UNITY_PLACES_EMPTY_SEARCH_GROUP (obj);
	_g_object_unref0 (self->priv->_results);
	_g_object_unref0 (self->priv->box);
	G_OBJECT_CLASS (unity_places_empty_search_group_parent_class)->finalize (obj);
}


GType unity_places_empty_search_group_get_type (void) {
	static volatile gsize unity_places_empty_search_group_type_id__volatile = 0;
	if (g_once_init_enter (&unity_places_empty_search_group_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlacesEmptySearchGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_places_empty_search_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlacesEmptySearchGroup), 0, (GInstanceInitFunc) unity_places_empty_search_group_instance_init, NULL };
		GType unity_places_empty_search_group_type_id;
		unity_places_empty_search_group_type_id = g_type_register_static (CTK_TYPE_BIN, "UnityPlacesEmptySearchGroup", &g_define_type_info, 0);
		g_once_init_leave (&unity_places_empty_search_group_type_id__volatile, unity_places_empty_search_group_type_id);
	}
	return unity_places_empty_search_group_type_id__volatile;
}


static void unity_places_empty_search_group_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlacesEmptySearchGroup * self;
	self = UNITY_PLACES_EMPTY_SEARCH_GROUP (object);
	switch (property_id) {
		case UNITY_PLACES_EMPTY_SEARCH_GROUP_GROUP_ID:
		g_value_set_uint (value, unity_places_empty_search_group_get_group_id (self));
		break;
		case UNITY_PLACES_EMPTY_SEARCH_GROUP_RESULTS:
		g_value_set_object (value, unity_places_empty_search_group_get_results (self));
		break;
		case UNITY_PLACES_EMPTY_SEARCH_GROUP_ACTIVE:
		g_value_set_boolean (value, unity_places_empty_search_group_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_places_empty_search_group_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlacesEmptySearchGroup * self;
	self = UNITY_PLACES_EMPTY_SEARCH_GROUP (object);
	switch (property_id) {
		case UNITY_PLACES_EMPTY_SEARCH_GROUP_GROUP_ID:
		unity_places_empty_search_group_set_group_id (self, g_value_get_uint (value));
		break;
		case UNITY_PLACES_EMPTY_SEARCH_GROUP_RESULTS:
		unity_places_empty_search_group_set_results (self, g_value_get_object (value));
		break;
		case UNITY_PLACES_EMPTY_SEARCH_GROUP_ACTIVE:
		unity_places_empty_search_group_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityPlacesEmptySectionGroup* unity_places_empty_section_group_construct (GType object_type, guint group_id, DeeModel* results) {
	UnityPlacesEmptySectionGroup * self;
	g_return_val_if_fail (results != NULL, NULL);
	self = (UnityPlacesEmptySectionGroup*) g_object_new (object_type, "group-id", group_id, "results", results, "active", FALSE, NULL);
	return self;
}


UnityPlacesEmptySectionGroup* unity_places_empty_section_group_new (guint group_id, DeeModel* results) {
	return unity_places_empty_section_group_construct (UNITY_PLACES_TYPE_EMPTY_SECTION_GROUP, group_id, results);
}


static void unity_places_empty_section_group_real_allocate (ClutterActor* base, const ClutterActorBox* box, ClutterAllocationFlags flags) {
	UnityPlacesEmptySectionGroup * self;
	ClutterActorBox child_box = {0};
	float twidth = 0.0F;
	float theight = 0.0F;
	self = (UnityPlacesEmptySectionGroup*) base;
	CLUTTER_ACTOR_CLASS (unity_places_empty_section_group_parent_class)->allocate ((ClutterActor*) CTK_BIN (self), box, flags);
	memset (&child_box, 0, sizeof (ClutterActorBox));
	clutter_actor_get_preferred_size ((ClutterActor*) self->priv->text, &twidth, &theight, NULL, NULL);
	child_box.x1 = (((*box).x2 - (*box).x1) / 2.0f) - (twidth / 2.0f);
	child_box.x2 = child_box.x1 + twidth;
	child_box.y1 = (((*box).y2 - (*box).y1) / 2.0f) - (theight / 2.0f);
	child_box.y2 = child_box.y1 + theight;
	clutter_actor_allocate ((ClutterActor*) self->priv->text, &child_box, flags);
}


static void unity_places_empty_section_group_on_result_added (UnityPlacesEmptySectionGroup* self, DeeModelIter* iter) {
	char* mes;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	if (!unity_places_empty_section_group_interesting (self, iter)) {
		return;
	}
	mes = g_strdup (dee_model_get_string (self->priv->_results, iter, (guint) 4));
	clutter_text_set_markup ((ClutterText*) self->priv->text, _tmp2_ = g_strconcat (_tmp1_ = g_strconcat ("<big>", _tmp0_ = g_markup_escape_text (mes, -1), NULL), "</big>", NULL));
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	unity_places_empty_section_group_set_active (self, TRUE);
	ctk_effect_set_invalidate_effect_cache ((CtkEffect*) self->priv->glow, TRUE);
	unity_cairo_canvas_update (self->priv->bg);
	_g_free0 (mes);
}


static void unity_places_empty_section_group_on_result_removed (UnityPlacesEmptySectionGroup* self, DeeModelIter* iter) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	if (!unity_places_empty_section_group_interesting (self, iter)) {
		return;
	}
	unity_places_empty_section_group_set_active (self, FALSE);
}


static void unity_places_empty_section_group_real_get_preferred_height (ClutterActor* base, float for_width, float* mheight, float* nheight) {
	UnityPlacesEmptySectionGroup * self;
	self = (UnityPlacesEmptySectionGroup*) base;
	*mheight = (float) 2000;
	*nheight = (float) 2000;
}


static gboolean unity_places_empty_section_group_interesting (UnityPlacesEmptySectionGroup* self, DeeModelIter* iter) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	result = dee_model_get_uint (self->priv->_results, iter, (guint) 2) == self->priv->_group_id;
	return result;
}


static void unity_places_empty_section_group_paint_bg (UnityPlacesEmptySectionGroup* self, cairo_t* cr, gint width, gint height) {
	gint radius;
	float twidth = 0.0F;
	float theight = 0.0F;
	gint padding;
	gint x;
	gint y;
	gint w;
	gint h;
	cairo_pattern_t* pat;
	gint factor;
	cairo_pattern_t* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	cairo_paint (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	cairo_set_line_width (cr, 1.0);
	radius = 7;
	clutter_actor_get_preferred_size ((ClutterActor*) self->priv->text, &twidth, &theight, NULL, NULL);
	padding = 35;
	x = ((width / 2) - (((gint) twidth) / 2)) - padding;
	y = ((height / 2) - (((gint) theight) / 2)) - padding;
	w = ((gint) twidth) + (padding * 2);
	h = ((gint) theight) + (padding * 2);
	cairo_move_to (cr, (double) x, (double) (y + radius));
	cairo_curve_to (cr, (double) x, (double) y, (double) x, (double) y, (double) (x + radius), (double) y);
	cairo_line_to (cr, (double) ((x + w) - radius), (double) y);
	cairo_curve_to (cr, (double) (x + w), (double) y, (double) (x + w), (double) y, (double) (x + w), (double) (y + radius));
	cairo_line_to (cr, (double) (x + w), (double) ((y + h) - radius));
	cairo_curve_to (cr, (double) (x + w), (double) (y + h), (double) (x + w), (double) (y + h), (double) ((x + w) - radius), (double) (y + h));
	cairo_line_to (cr, (double) (x + radius), (double) (y + h));
	cairo_curve_to (cr, (double) x, (double) (y + h), (double) x, (double) (y + h), (double) x, (double) ((y + h) - radius));
	cairo_close_path (cr);
	cairo_set_source_rgba (cr, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.1f);
	cairo_fill (cr);
	cairo_translate (cr, 0.5, 0.5);
	cairo_move_to (cr, (double) x, (double) (y + radius));
	cairo_curve_to (cr, (double) x, (double) y, (double) x, (double) y, (double) (x + radius), (double) y);
	cairo_line_to (cr, (double) ((x + w) - radius), (double) y);
	cairo_curve_to (cr, (double) (x + w), (double) y, (double) (x + w), (double) y, (double) (x + w), (double) (y + radius));
	cairo_line_to (cr, (double) (x + w), (double) ((y + h) - radius));
	cairo_curve_to (cr, (double) (x + w), (double) (y + h), (double) (x + w), (double) (y + h), (double) ((x + w) - radius), (double) (y + h));
	cairo_line_to (cr, (double) (x + radius), (double) (y + h));
	cairo_curve_to (cr, (double) x, (double) (y + h), (double) x, (double) (y + h), (double) x, (double) ((y + h) - radius));
	cairo_close_path (cr);
	cairo_set_source_rgba (cr, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.5f);
	cairo_stroke (cr);
	cairo_rectangle (cr, (double) x, (double) y, (double) (w / 4), (double) h);
	pat = cairo_pattern_create_radial ((double) x, (double) (y + h), (double) 0.0f, (double) x, (double) (y + h), (double) (w / 4.0f));
	cairo_pattern_add_color_stop_rgba (pat, (double) 0.0f, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.2f);
	cairo_pattern_add_color_stop_rgba (pat, (double) 0.8f, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.0f);
	cairo_set_source (cr, pat);
	cairo_fill_preserve (cr);
	factor = w / 4;
	cairo_rectangle (cr, (double) (x + (factor * 2)), (double) y, (double) (factor * 2), (double) h);
	pat = (_tmp0_ = cairo_pattern_create_radial ((double) ((x + w) - factor), (double) y, (double) 0.0f, (double) ((x + w) - factor), (double) y, (double) factor), _cairo_pattern_destroy0 (pat), _tmp0_);
	cairo_pattern_add_color_stop_rgba (pat, (double) 0.0f, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.2f);
	cairo_pattern_add_color_stop_rgba (pat, (double) 0.8f, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.0f);
	cairo_set_source (cr, pat);
	cairo_fill_preserve (cr);
	_cairo_pattern_destroy0 (pat);
}


guint unity_places_empty_section_group_get_group_id (UnityPlacesEmptySectionGroup* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_group_id;
	return result;
}


void unity_places_empty_section_group_set_group_id (UnityPlacesEmptySectionGroup* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_group_id = value;
	g_object_notify ((GObject *) self, "group-id");
}


DeeModel* unity_places_empty_section_group_get_results (UnityPlacesEmptySectionGroup* self) {
	DeeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_results;
	return result;
}


void unity_places_empty_section_group_set_results (UnityPlacesEmptySectionGroup* self, DeeModel* value) {
	DeeModel* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_results = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_results), _tmp0_);
	g_object_notify ((GObject *) self, "results");
}


gboolean unity_places_empty_section_group_get_active (UnityPlacesEmptySectionGroup* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}


void unity_places_empty_section_group_set_active (UnityPlacesEmptySectionGroup* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	g_object_notify ((GObject *) self, "active");
}


static void _unity_places_empty_section_group_on_result_added_dee_model_row_added (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_places_empty_section_group_on_result_added (self, iter);
}


static void _unity_places_empty_section_group_on_result_removed_dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_places_empty_section_group_on_result_removed (self, iter);
}


static void _unity_places_empty_section_group_paint_bg_unity_cairo_canvas_cairo_canvas_paint (cairo_t* cr, gint width, gint height, gpointer self) {
	unity_places_empty_section_group_paint_bg (self, cr, width, height);
}


static GObject * unity_places_empty_section_group_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlacesEmptySectionGroup * self;
	parent_class = G_OBJECT_CLASS (unity_places_empty_section_group_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACES_EMPTY_SECTION_GROUP (obj);
	{
		CtkText* _tmp0_;
		UnityCairoCanvas* bg;
		CtkEffectGlow* glow;
		self->priv->text = (_tmp0_ = g_object_ref_sink ((CtkText*) ctk_text_new ("")), _g_object_unref0 (self->priv->text), _tmp0_);
		clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->priv->text);
		clutter_actor_show ((ClutterActor*) self->priv->text);
		g_signal_connect_object (self->priv->_results, "row-added", (GCallback) _unity_places_empty_section_group_on_result_added_dee_model_row_added, self, 0);
		g_signal_connect_object (self->priv->_results, "row-removed", (GCallback) _unity_places_empty_section_group_on_result_removed_dee_model_row_removed, self, 0);
		clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
		bg = g_object_ref_sink (unity_cairo_canvas_new (_unity_places_empty_section_group_paint_bg_unity_cairo_canvas_cairo_canvas_paint, self));
		self->priv->bg = bg;
		ctk_actor_set_background ((CtkActor*) self, (ClutterActor*) bg);
		clutter_actor_show ((ClutterActor*) bg);
		glow = g_object_ref_sink ((CtkEffectGlow*) ctk_effect_glow_new ());
		self->priv->glow = glow;
		ctk_effect_glow_set_factor (glow, 1.0f);
		ctk_effect_set_margin ((CtkEffect*) glow, 0);
		ctk_actor_add_effect ((CtkActor*) self, (CtkEffect*) glow);
		_g_object_unref0 (glow);
		_g_object_unref0 (bg);
	}
	return obj;
}


static void unity_places_empty_section_group_class_init (UnityPlacesEmptySectionGroupClass * klass) {
	unity_places_empty_section_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlacesEmptySectionGroupPrivate));
	CLUTTER_ACTOR_CLASS (klass)->allocate = unity_places_empty_section_group_real_allocate;
	CLUTTER_ACTOR_CLASS (klass)->get_preferred_height = unity_places_empty_section_group_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->get_property = unity_places_empty_section_group_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_places_empty_section_group_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_places_empty_section_group_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_places_empty_section_group_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_EMPTY_SECTION_GROUP_GROUP_ID, g_param_spec_uint ("group-id", "group-id", "group-id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_EMPTY_SECTION_GROUP_RESULTS, g_param_spec_object ("results", "results", "results", DEE_TYPE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_EMPTY_SECTION_GROUP_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_signal_new ("activated", UNITY_PLACES_TYPE_EMPTY_SECTION_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
}


static void unity_places_empty_section_group_instance_init (UnityPlacesEmptySectionGroup * self) {
	self->priv = UNITY_PLACES_EMPTY_SECTION_GROUP_GET_PRIVATE (self);
}


static void unity_places_empty_section_group_finalize (GObject* obj) {
	UnityPlacesEmptySectionGroup * self;
	self = UNITY_PLACES_EMPTY_SECTION_GROUP (obj);
	_g_object_unref0 (self->priv->text);
	_g_object_unref0 (self->priv->_results);
	G_OBJECT_CLASS (unity_places_empty_section_group_parent_class)->finalize (obj);
}


GType unity_places_empty_section_group_get_type (void) {
	static volatile gsize unity_places_empty_section_group_type_id__volatile = 0;
	if (g_once_init_enter (&unity_places_empty_section_group_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlacesEmptySectionGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_places_empty_section_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlacesEmptySectionGroup), 0, (GInstanceInitFunc) unity_places_empty_section_group_instance_init, NULL };
		GType unity_places_empty_section_group_type_id;
		unity_places_empty_section_group_type_id = g_type_register_static (CTK_TYPE_BIN, "UnityPlacesEmptySectionGroup", &g_define_type_info, 0);
		g_once_init_leave (&unity_places_empty_section_group_type_id__volatile, unity_places_empty_section_group_type_id);
	}
	return unity_places_empty_section_group_type_id__volatile;
}


static void unity_places_empty_section_group_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlacesEmptySectionGroup * self;
	self = UNITY_PLACES_EMPTY_SECTION_GROUP (object);
	switch (property_id) {
		case UNITY_PLACES_EMPTY_SECTION_GROUP_GROUP_ID:
		g_value_set_uint (value, unity_places_empty_section_group_get_group_id (self));
		break;
		case UNITY_PLACES_EMPTY_SECTION_GROUP_RESULTS:
		g_value_set_object (value, unity_places_empty_section_group_get_results (self));
		break;
		case UNITY_PLACES_EMPTY_SECTION_GROUP_ACTIVE:
		g_value_set_boolean (value, unity_places_empty_section_group_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_places_empty_section_group_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlacesEmptySectionGroup * self;
	self = UNITY_PLACES_EMPTY_SECTION_GROUP (object);
	switch (property_id) {
		case UNITY_PLACES_EMPTY_SECTION_GROUP_GROUP_ID:
		unity_places_empty_section_group_set_group_id (self, g_value_get_uint (value));
		break;
		case UNITY_PLACES_EMPTY_SECTION_GROUP_RESULTS:
		unity_places_empty_section_group_set_results (self, g_value_get_object (value));
		break;
		case UNITY_PLACES_EMPTY_SECTION_GROUP_ACTIVE:
		unity_places_empty_section_group_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}



