/* banshee-collection.c generated by valac 0.16.1, the Vala compiler
 * generated from banshee-collection.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Alex Launi <alex.launi@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <unity.h>
#include <dee.h>
#include <gee.h>
#include <glib/gstdio.h>


#define UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION (unity_music_lens_banshee_collection_get_type ())
#define UNITY_MUSIC_LENS_BANSHEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION, UnityMusicLensBansheeCollection))
#define UNITY_MUSIC_LENS_BANSHEE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION, UnityMusicLensBansheeCollectionClass))
#define UNITY_MUSIC_LENS_IS_BANSHEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION))
#define UNITY_MUSIC_LENS_IS_BANSHEE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION))
#define UNITY_MUSIC_LENS_BANSHEE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION, UnityMusicLensBansheeCollectionClass))

typedef struct _UnityMusicLensBansheeCollection UnityMusicLensBansheeCollection;
typedef struct _UnityMusicLensBansheeCollectionClass UnityMusicLensBansheeCollectionClass;
typedef struct _UnityMusicLensBansheeCollectionPrivate UnityMusicLensBansheeCollectionPrivate;
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UNITY_MUSIC_LENS_TYPE_FILTER_PARSER (unity_music_lens_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER, UnityMusicLensFilterParser))
#define UNITY_MUSIC_LENS_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER, UnityMusicLensFilterParserClass))
#define UNITY_MUSIC_LENS_IS_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER, UnityMusicLensFilterParserClass))

typedef struct _UnityMusicLensFilterParser UnityMusicLensFilterParser;
typedef struct _UnityMusicLensFilterParserClass UnityMusicLensFilterParserClass;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))

#define UNITY_MUSIC_LENS_TYPE_TRACK (unity_music_lens_track_get_type ())
#define UNITY_MUSIC_LENS_TRACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_TRACK, UnityMusicLensTrack))
#define UNITY_MUSIC_LENS_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_TRACK, UnityMusicLensTrackClass))
#define UNITY_MUSIC_LENS_IS_TRACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_TRACK))
#define UNITY_MUSIC_LENS_IS_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_TRACK))
#define UNITY_MUSIC_LENS_TRACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_TRACK, UnityMusicLensTrackClass))

typedef struct _UnityMusicLensTrack UnityMusicLensTrack;
typedef struct _UnityMusicLensTrackClass UnityMusicLensTrackClass;

#define UNITY_MUSIC_LENS_TYPE_ALBUM (unity_music_lens_album_get_type ())
#define UNITY_MUSIC_LENS_ALBUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_ALBUM, UnityMusicLensAlbum))
#define UNITY_MUSIC_LENS_ALBUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_ALBUM, UnityMusicLensAlbumClass))
#define UNITY_MUSIC_LENS_IS_ALBUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_ALBUM))
#define UNITY_MUSIC_LENS_IS_ALBUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_ALBUM))
#define UNITY_MUSIC_LENS_ALBUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_ALBUM, UnityMusicLensAlbumClass))

typedef struct _UnityMusicLensAlbum UnityMusicLensAlbum;
typedef struct _UnityMusicLensAlbumClass UnityMusicLensAlbumClass;

#define UNITY_MUSIC_LENS_TYPE_CATEGORY (unity_music_lens_category_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))

#define UNITY_MUSIC_LENS_TYPE_BANSHEE_FILTER_PARSER (unity_music_lens_banshee_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_BANSHEE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_FILTER_PARSER, UnityMusicLensBansheeFilterParser))
#define UNITY_MUSIC_LENS_IS_BANSHEE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_BANSHEE_FILTER_PARSER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_FILTER_PARSER, UnityMusicLensBansheeFilterParserIface))

typedef struct _UnityMusicLensBansheeFilterParser UnityMusicLensBansheeFilterParser;
typedef struct _UnityMusicLensBansheeFilterParserIface UnityMusicLensBansheeFilterParserIface;

#define UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER (unity_music_lens_genre_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_GENRE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER, UnityMusicLensGenreFilterParser))
#define UNITY_MUSIC_LENS_GENRE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER, UnityMusicLensGenreFilterParserClass))
#define UNITY_MUSIC_LENS_IS_GENRE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_GENRE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_GENRE_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER, UnityMusicLensGenreFilterParserClass))

typedef struct _UnityMusicLensGenreFilterParser UnityMusicLensGenreFilterParser;
typedef struct _UnityMusicLensGenreFilterParserClass UnityMusicLensGenreFilterParserClass;

#define UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER (unity_music_lens_banshee_genre_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_BANSHEE_GENRE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER, UnityMusicLensBansheeGenreFilterParser))
#define UNITY_MUSIC_LENS_BANSHEE_GENRE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER, UnityMusicLensBansheeGenreFilterParserClass))
#define UNITY_MUSIC_LENS_IS_BANSHEE_GENRE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_BANSHEE_GENRE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_BANSHEE_GENRE_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER, UnityMusicLensBansheeGenreFilterParserClass))

typedef struct _UnityMusicLensBansheeGenreFilterParser UnityMusicLensBansheeGenreFilterParser;
typedef struct _UnityMusicLensBansheeGenreFilterParserClass UnityMusicLensBansheeGenreFilterParserClass;

#define UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER (unity_music_lens_decade_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_DECADE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER, UnityMusicLensDecadeFilterParser))
#define UNITY_MUSIC_LENS_DECADE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER, UnityMusicLensDecadeFilterParserClass))
#define UNITY_MUSIC_LENS_IS_DECADE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_DECADE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_DECADE_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER, UnityMusicLensDecadeFilterParserClass))

typedef struct _UnityMusicLensDecadeFilterParser UnityMusicLensDecadeFilterParser;
typedef struct _UnityMusicLensDecadeFilterParserClass UnityMusicLensDecadeFilterParserClass;

#define UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER (unity_music_lens_banshee_decade_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_BANSHEE_DECADE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER, UnityMusicLensBansheeDecadeFilterParser))
#define UNITY_MUSIC_LENS_BANSHEE_DECADE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER, UnityMusicLensBansheeDecadeFilterParserClass))
#define UNITY_MUSIC_LENS_IS_BANSHEE_DECADE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_BANSHEE_DECADE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_BANSHEE_DECADE_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER, UnityMusicLensBansheeDecadeFilterParserClass))

typedef struct _UnityMusicLensBansheeDecadeFilterParser UnityMusicLensBansheeDecadeFilterParser;
typedef struct _UnityMusicLensBansheeDecadeFilterParserClass UnityMusicLensBansheeDecadeFilterParserClass;

typedef enum  {
	UNITY_MUSIC_LENS_DATABASE_ERROR_FAILED_TO_OPEN
} UnityMusicLensDatabaseError;
#define UNITY_MUSIC_LENS_DATABASE_ERROR unity_music_lens_database_error_quark ()
struct _UnityMusicLensBansheeCollection {
	GObject parent_instance;
	UnityMusicLensBansheeCollectionPrivate * priv;
};

struct _UnityMusicLensBansheeCollectionClass {
	GObjectClass parent_class;
};

struct _UnityMusicLensBansheeCollectionPrivate {
	sqlite3* db;
};

typedef enum  {
	UNITY_MUSIC_LENS_CATEGORY_SONGS,
	UNITY_MUSIC_LENS_CATEGORY_ALBUMS,
	UNITY_MUSIC_LENS_CATEGORY_PURCHASE,
	UNITY_MUSIC_LENS_CATEGORY_MUSIC,
	UNITY_MUSIC_LENS_CATEGORY_RADIOS
} UnityMusicLensCategory;

struct _UnityMusicLensBansheeFilterParserIface {
	GTypeInterface parent_iface;
};


static gpointer unity_music_lens_banshee_collection_parent_class = NULL;

GQuark unity_music_lens_database_error_quark (void);
GType unity_music_lens_banshee_collection_get_type (void) G_GNUC_CONST;
#define UNITY_MUSIC_LENS_BANSHEE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION, UnityMusicLensBansheeCollectionPrivate))
enum  {
	UNITY_MUSIC_LENS_BANSHEE_COLLECTION_DUMMY_PROPERTY
};
#define UNITY_MUSIC_LENS_BANSHEE_COLLECTION_MAX_RESULTS 100
UnityMusicLensBansheeCollection* unity_music_lens_banshee_collection_new (GError** error);
UnityMusicLensBansheeCollection* unity_music_lens_banshee_collection_construct (GType object_type, GError** error);
GType unity_music_lens_filter_parser_get_type (void) G_GNUC_CONST;
void unity_music_lens_banshee_collection_search (UnityMusicLensBansheeCollection* self, UnityLensSearch* search, UnitySearchType search_type, GList* filters, gint max_results, gint category_override);
static gchar* unity_music_lens_banshee_collection_build_sql_from_filters (UnityMusicLensBansheeCollection* self, GList* filters);
static gint unity_music_lens_banshee_collection_execute_sql (UnityMusicLensBansheeCollection* self, const gchar* sql, sqlite3_stmt** stmt);
static gchar* unity_music_lens_banshee_collection_get_album_artwork_path (UnityMusicLensBansheeCollection* self, const gchar* artwork_id);
#define CONFIG_PKGDATADIR "/usr/local/share/unity"
#define UNITY_MUSIC_LENS_UNITY_ICON_PATH CONFIG_PKGDATADIR "/6"
#define UNITY_MUSIC_LENS_ALBUM_MISSING_ICON_PATH UNITY_MUSIC_LENS_UNITY_ICON_PATH "/album_missing.png"
UnityMusicLensTrack* unity_music_lens_track_new (void);
UnityMusicLensTrack* unity_music_lens_track_construct (GType object_type);
GType unity_music_lens_track_get_type (void) G_GNUC_CONST;
void unity_music_lens_track_set_title (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_artist (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_uri (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_mime_type (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_artwork_path (UnityMusicLensTrack* self, const gchar* value);
UnityMusicLensAlbum* unity_music_lens_album_new (void);
UnityMusicLensAlbum* unity_music_lens_album_construct (GType object_type);
GType unity_music_lens_album_get_type (void) G_GNUC_CONST;
void unity_music_lens_album_set_title (UnityMusicLensAlbum* self, const gchar* value);
void unity_music_lens_album_set_artist (UnityMusicLensAlbum* self, const gchar* value);
const gchar* unity_music_lens_album_get_artist (UnityMusicLensAlbum* self);
const gchar* unity_music_lens_album_get_title (UnityMusicLensAlbum* self);
void unity_music_lens_album_set_uri (UnityMusicLensAlbum* self, const gchar* value);
void unity_music_lens_album_set_artwork_path (UnityMusicLensAlbum* self, const gchar* value);
GType unity_music_lens_category_get_type (void) G_GNUC_CONST;
const gchar* unity_music_lens_track_get_uri (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_mime_type (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_title (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_artist (UnityMusicLensTrack* self);
gchar** unity_music_lens_banshee_collection_get_track_uris (UnityMusicLensBansheeCollection* self, UnityMusicLensAlbum* album, int* result_length1);
const gchar* unity_music_lens_album_get_uri (UnityMusicLensAlbum* self);
const gchar* unity_music_lens_album_get_artwork_path (UnityMusicLensAlbum* self);
static UnityMusicLensTrack* unity_music_lens_banshee_collection_get_track (UnityMusicLensBansheeCollection* self, sqlite3_stmt* stmt);
void unity_music_lens_track_set_album (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_genre (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_track_number (UnityMusicLensTrack* self, gint value);
void unity_music_lens_track_set_year (UnityMusicLensTrack* self, gint value);
void unity_music_lens_track_set_play_count (UnityMusicLensTrack* self, gint value);
void unity_music_lens_track_set_duration (UnityMusicLensTrack* self, gint value);
UnityMusicLensTrack* unity_music_lens_banshee_collection_get_album_track (UnityMusicLensBansheeCollection* self, const gchar* uri);
GSList* unity_music_lens_banshee_collection_get_album_tracks_detailed (UnityMusicLensBansheeCollection* self, const gchar* album_title, const gchar* album_artist);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
GType unity_music_lens_banshee_filter_parser_get_type (void) G_GNUC_CONST;
GType unity_music_lens_genre_filter_parser_get_type (void) G_GNUC_CONST;
UnityMusicLensBansheeGenreFilterParser* unity_music_lens_banshee_genre_filter_parser_new (UnityMusicLensGenreFilterParser* parser);
UnityMusicLensBansheeGenreFilterParser* unity_music_lens_banshee_genre_filter_parser_construct (GType object_type, UnityMusicLensGenreFilterParser* parser);
GType unity_music_lens_banshee_genre_filter_parser_get_type (void) G_GNUC_CONST;
GType unity_music_lens_decade_filter_parser_get_type (void) G_GNUC_CONST;
UnityMusicLensBansheeDecadeFilterParser* unity_music_lens_banshee_decade_filter_parser_new (UnityMusicLensDecadeFilterParser* parser);
UnityMusicLensBansheeDecadeFilterParser* unity_music_lens_banshee_decade_filter_parser_construct (GType object_type, UnityMusicLensDecadeFilterParser* parser);
GType unity_music_lens_banshee_decade_filter_parser_get_type (void) G_GNUC_CONST;
gchar* unity_music_lens_filter_parser_parse (UnityMusicLensFilterParser* self);
static void unity_music_lens_banshee_collection_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark unity_music_lens_database_error_quark (void) {
	return g_quark_from_static_string ("unity_music_lens_database_error-quark");
}


UnityMusicLensBansheeCollection* unity_music_lens_banshee_collection_construct (GType object_type, GError** error) {
	UnityMusicLensBansheeCollection * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	sqlite3* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_;
	gint rc;
	gint _tmp6_;
	GError * _inner_error_ = NULL;
	self = (UnityMusicLensBansheeCollection*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_strdup_printf ("%s/banshee-1/banshee.db", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = sqlite3_open (_tmp2_, &_tmp3_);
	_sqlite3_close0 (self->priv->db);
	self->priv->db = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	rc = _tmp5_;
	_tmp6_ = rc;
	if (_tmp6_ != SQLITE_OK) {
		gint _tmp7_;
		sqlite3* _tmp8_;
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_;
		_tmp7_ = rc;
		_tmp8_ = self->priv->db;
		_tmp9_ = sqlite3_errmsg (_tmp8_);
		g_printerr ("failed to open db, %d, %s\n", _tmp7_, _tmp9_);
		_tmp10_ = g_error_new_literal (UNITY_MUSIC_LENS_DATABASE_ERROR, UNITY_MUSIC_LENS_DATABASE_ERROR_FAILED_TO_OPEN, "Failed to open banshee database");
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == UNITY_MUSIC_LENS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


UnityMusicLensBansheeCollection* unity_music_lens_banshee_collection_new (GError** error) {
	return unity_music_lens_banshee_collection_construct (UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION, error);
}


/**
     * Performs a search on the banshee db
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void unity_music_lens_banshee_collection_search (UnityMusicLensBansheeCollection* self, UnityLensSearch* search, UnitySearchType search_type, GList* filters, gint max_results, gint category_override) {
	static const gint TRACK_TITLE = 0;
	static const gint TRACK_URI = 1;
	static const gint TRACK_MIMETYPE = 2;
	static const gint ALBUM_TITLE = 3;
	static const gint ALBUM_ARTWORKID = 4;
	static const gint ARTIST_NAME = 5;
	gint rc;
	sqlite3_stmt* stmt = NULL;
	UnityLensSearch* _tmp0_;
	DeeSerializableModel* _tmp1_;
	DeeSerializableModel* _tmp2_;
	DeeSerializableModel* _tmp3_;
	DeeSerializableModel* results_model;
	DeeSerializableModel* _tmp4_;
	DeeSerializableModel* _tmp5_;
	DeeSerializableModel* helper_model;
	gint _tmp6_;
	GeeTreeSet* _tmp12_;
	GeeTreeSet* albums;
	GList* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* filters_sql;
	gint _tmp15_ = 0;
	gint _tmp16_;
	UnityLensSearch* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	UnityLensSearch* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	UnityLensSearch* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gint _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* sql;
	const gchar* _tmp30_;
	sqlite3_stmt* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	sqlite3_stmt* _tmp33_;
	DeeSerializableModel* _tmp143_;
	DeeSerializableModel* _tmp144_;
	DeeSerializableModel* _tmp145_;
	DeeModelIter* _tmp146_ = NULL;
	DeeModelIter* iter;
	DeeSerializableModel* _tmp147_;
	DeeModelIter* _tmp148_ = NULL;
	DeeModelIter* last;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search != NULL);
	rc = 0;
	_tmp0_ = search;
	_tmp1_ = unity_lens_search_get_results_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	results_model = _tmp3_;
	_tmp4_ = results_model;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	helper_model = _tmp5_;
	_tmp6_ = category_override;
	if (_tmp6_ >= 0) {
		DeeSequenceModel* _tmp7_;
		DeeSerializableModel* _tmp8_;
		DeeSerializableModel* _tmp9_;
		guint _tmp10_;
		gchar** _tmp11_ = NULL;
		_tmp7_ = (DeeSequenceModel*) dee_sequence_model_new ();
		_g_object_unref0 (helper_model);
		helper_model = (DeeSerializableModel*) _tmp7_;
		_tmp8_ = helper_model;
		_tmp9_ = results_model;
		_tmp11_ = dee_model_get_schema ((DeeModel*) _tmp9_, &_tmp10_);
		dee_model_set_schema_full ((DeeModel*) _tmp8_, _tmp11_, (guint) _tmp10_);
	}
	_tmp12_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	albums = _tmp12_;
	_tmp13_ = filters;
	_tmp14_ = unity_music_lens_banshee_collection_build_sql_from_filters (self, _tmp13_);
	filters_sql = _tmp14_;
	_tmp16_ = max_results;
	if (_tmp16_ == (-1)) {
		_tmp15_ = UNITY_MUSIC_LENS_BANSHEE_COLLECTION_MAX_RESULTS;
	} else {
		gint _tmp17_;
		_tmp17_ = max_results;
		_tmp15_ = _tmp17_;
	}
	_tmp18_ = search;
	_tmp19_ = unity_lens_search_get_search_string (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = search;
	_tmp22_ = unity_lens_search_get_search_string (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = search;
	_tmp25_ = unity_lens_search_get_search_string (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = filters_sql;
	_tmp28_ = _tmp15_;
	_tmp29_ = g_strdup_printf ("SELECT CoreTracks.Title, CoreTracks.Uri, CoreTracks.MimeType, CoreAlbu" \
"ms.Title, CoreAlbums.ArtworkID, CoreArtists.Name                      " \
"FROM CoreTracks \n" \
"                      CROSS JOIN CoreArtists, CoreAlbums \n" \
"                      WHERE CoreArtists.ArtistID = CoreTracks.ArtistID" \
" \n" \
"                                                   AND CoreAlbums.Albu" \
"mID = CoreTracks.AlbumID \n" \
"                                                   AND CoreTracks.Prim" \
"arySourceID = 1 \n" \
"\t\t\t\t\t\t   AND ((CoreArtists.NameLowered LIKE '%%%s%%' ESCAPE '\\'" \
" \n" \
"\t\t\t\t\t\t  \t AND CoreArtists.NameLowered IS NOT NULL) \n" \
"\t\t\t\t\t\t        OR (CoreAlbums.TitleLowered LIKE '%%%s%%' ESCAPE '" \
"\\' \n" \
"\t\t\t\t\t\t  \t    AND CoreAlbums.TitleLowered IS NOT NULL) \n" \
"\t\t\t\t\t\t  \tOR (CoreTracks.TitleLowered LIKE '%%%s%%' ESCAPE '\\' " \
"\n" \
"\t\t\t\t\t\t  \t    AND CoreTracks.TitleLowered IS NOT NULL)\n" \
"                                                       )\n" \
"                                 %s\n" \
"                      ORDER BY CoreTracks.Score DESC\n" \
"                      LIMIT 0, %d;", _tmp20_, _tmp23_, _tmp26_, _tmp27_, _tmp28_);
	sql = _tmp29_;
	_tmp30_ = sql;
	_tmp32_ = unity_music_lens_banshee_collection_execute_sql (self, _tmp30_, &_tmp31_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp31_;
	rc = _tmp32_;
	_tmp33_ = stmt;
	if (_tmp33_ == NULL) {
		_g_free0 (sql);
		_g_free0 (filters_sql);
		_g_object_unref0 (albums);
		_g_object_unref0 (helper_model);
		_g_object_unref0 (results_model);
		_sqlite3_finalize0 (stmt);
		return;
	}
	{
		gboolean _tmp34_;
		_tmp34_ = TRUE;
		while (TRUE) {
			gboolean _tmp35_;
			sqlite3_stmt* _tmp37_;
			gint _tmp38_ = 0;
			gint _tmp39_;
			_tmp35_ = _tmp34_;
			if (!_tmp35_) {
				gint _tmp36_;
				_tmp36_ = rc;
				if (!(_tmp36_ == SQLITE_ROW)) {
					break;
				}
			}
			_tmp34_ = FALSE;
			_tmp37_ = stmt;
			_tmp38_ = sqlite3_step (_tmp37_);
			rc = _tmp38_;
			_tmp39_ = rc;
			switch (_tmp39_) {
				case SQLITE_DONE:
				{
					break;
				}
				case SQLITE_ROW:
				{
					sqlite3_stmt* _tmp40_;
					const gchar* _tmp41_ = NULL;
					gchar* _tmp42_ = NULL;
					gchar* artwork_path;
					gboolean _tmp43_ = FALSE;
					gboolean _tmp44_ = FALSE;
					const gchar* _tmp45_;
					gboolean _tmp47_;
					gboolean _tmp50_;
					UnityMusicLensTrack* _tmp52_;
					UnityMusicLensTrack* track;
					UnityMusicLensTrack* _tmp53_;
					sqlite3_stmt* _tmp54_;
					const gchar* _tmp55_ = NULL;
					UnityMusicLensTrack* _tmp56_;
					sqlite3_stmt* _tmp57_;
					const gchar* _tmp58_ = NULL;
					UnityMusicLensTrack* _tmp59_;
					sqlite3_stmt* _tmp60_;
					const gchar* _tmp61_ = NULL;
					UnityMusicLensTrack* _tmp62_;
					sqlite3_stmt* _tmp63_;
					const gchar* _tmp64_ = NULL;
					UnityMusicLensTrack* _tmp65_;
					const gchar* _tmp66_;
					UnityMusicLensAlbum* _tmp67_;
					UnityMusicLensAlbum* album;
					UnityMusicLensAlbum* _tmp68_;
					sqlite3_stmt* _tmp69_;
					const gchar* _tmp70_ = NULL;
					UnityMusicLensAlbum* _tmp71_;
					sqlite3_stmt* _tmp72_;
					const gchar* _tmp73_ = NULL;
					UnityMusicLensAlbum* _tmp74_;
					UnityMusicLensAlbum* _tmp75_;
					const gchar* _tmp76_;
					const gchar* _tmp77_;
					UnityMusicLensAlbum* _tmp78_;
					const gchar* _tmp79_;
					const gchar* _tmp80_;
					gchar* _tmp81_ = NULL;
					gchar* _tmp82_;
					UnityMusicLensAlbum* _tmp83_;
					const gchar* _tmp84_;
					guint category_id;
					gint _tmp85_;
					DeeSerializableModel* _tmp87_;
					UnityMusicLensTrack* _tmp88_;
					const gchar* _tmp89_;
					const gchar* _tmp90_;
					const gchar* _tmp91_;
					guint _tmp92_;
					UnityMusicLensTrack* _tmp93_;
					const gchar* _tmp94_;
					const gchar* _tmp95_;
					UnityMusicLensTrack* _tmp96_;
					const gchar* _tmp97_;
					const gchar* _tmp98_;
					UnityMusicLensTrack* _tmp99_;
					const gchar* _tmp100_;
					const gchar* _tmp101_;
					UnityMusicLensTrack* _tmp102_;
					const gchar* _tmp103_;
					const gchar* _tmp104_;
					GeeTreeSet* _tmp105_;
					UnityMusicLensAlbum* _tmp106_;
					const gchar* _tmp107_;
					const gchar* _tmp108_;
					UnityMusicLensAlbum* _tmp109_;
					const gchar* _tmp110_;
					const gchar* _tmp111_;
					gchar* _tmp112_;
					gchar* _tmp113_;
					gboolean _tmp114_ = FALSE;
					gboolean _tmp115_;
					_tmp40_ = stmt;
					_tmp41_ = sqlite3_column_text (_tmp40_, ALBUM_ARTWORKID);
					_tmp42_ = unity_music_lens_banshee_collection_get_album_artwork_path (self, _tmp41_);
					artwork_path = _tmp42_;
					_tmp45_ = artwork_path;
					if (_tmp45_ == NULL) {
						_tmp44_ = TRUE;
					} else {
						const gchar* _tmp46_;
						_tmp46_ = artwork_path;
						_tmp44_ = g_strcmp0 (_tmp46_, "") == 0;
					}
					_tmp47_ = _tmp44_;
					if (_tmp47_) {
						_tmp43_ = TRUE;
					} else {
						const gchar* _tmp48_;
						gboolean _tmp49_ = FALSE;
						_tmp48_ = artwork_path;
						_tmp49_ = g_file_test (_tmp48_, G_FILE_TEST_EXISTS);
						_tmp43_ = !_tmp49_;
					}
					_tmp50_ = _tmp43_;
					if (_tmp50_) {
						gchar* _tmp51_;
						_tmp51_ = g_strdup (UNITY_MUSIC_LENS_ALBUM_MISSING_ICON_PATH);
						_g_free0 (artwork_path);
						artwork_path = _tmp51_;
					}
					_tmp52_ = unity_music_lens_track_new ();
					track = _tmp52_;
					_tmp53_ = track;
					_tmp54_ = stmt;
					_tmp55_ = sqlite3_column_text (_tmp54_, TRACK_TITLE);
					unity_music_lens_track_set_title (_tmp53_, _tmp55_);
					_tmp56_ = track;
					_tmp57_ = stmt;
					_tmp58_ = sqlite3_column_text (_tmp57_, ARTIST_NAME);
					unity_music_lens_track_set_artist (_tmp56_, _tmp58_);
					_tmp59_ = track;
					_tmp60_ = stmt;
					_tmp61_ = sqlite3_column_text (_tmp60_, TRACK_URI);
					unity_music_lens_track_set_uri (_tmp59_, _tmp61_);
					_tmp62_ = track;
					_tmp63_ = stmt;
					_tmp64_ = sqlite3_column_text (_tmp63_, TRACK_MIMETYPE);
					unity_music_lens_track_set_mime_type (_tmp62_, _tmp64_);
					_tmp65_ = track;
					_tmp66_ = artwork_path;
					unity_music_lens_track_set_artwork_path (_tmp65_, _tmp66_);
					_tmp67_ = unity_music_lens_album_new ();
					album = _tmp67_;
					_tmp68_ = album;
					_tmp69_ = stmt;
					_tmp70_ = sqlite3_column_text (_tmp69_, ALBUM_TITLE);
					unity_music_lens_album_set_title (_tmp68_, _tmp70_);
					_tmp71_ = album;
					_tmp72_ = stmt;
					_tmp73_ = sqlite3_column_text (_tmp72_, ARTIST_NAME);
					unity_music_lens_album_set_artist (_tmp71_, _tmp73_);
					_tmp74_ = album;
					_tmp75_ = album;
					_tmp76_ = unity_music_lens_album_get_artist (_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp78_ = album;
					_tmp79_ = unity_music_lens_album_get_title (_tmp78_);
					_tmp80_ = _tmp79_;
					_tmp81_ = g_strdup_printf ("album://%s/%s", _tmp77_, _tmp80_);
					_tmp82_ = _tmp81_;
					unity_music_lens_album_set_uri (_tmp74_, _tmp82_);
					_g_free0 (_tmp82_);
					_tmp83_ = album;
					_tmp84_ = artwork_path;
					unity_music_lens_album_set_artwork_path (_tmp83_, _tmp84_);
					category_id = (guint) UNITY_MUSIC_LENS_CATEGORY_SONGS;
					_tmp85_ = category_override;
					if (_tmp85_ >= 0) {
						gint _tmp86_;
						_tmp86_ = category_override;
						category_id = (guint) _tmp86_;
					}
					_tmp87_ = helper_model;
					_tmp88_ = track;
					_tmp89_ = unity_music_lens_track_get_uri (_tmp88_);
					_tmp90_ = _tmp89_;
					_tmp91_ = artwork_path;
					_tmp92_ = category_id;
					_tmp93_ = track;
					_tmp94_ = unity_music_lens_track_get_mime_type (_tmp93_);
					_tmp95_ = _tmp94_;
					_tmp96_ = track;
					_tmp97_ = unity_music_lens_track_get_title (_tmp96_);
					_tmp98_ = _tmp97_;
					_tmp99_ = track;
					_tmp100_ = unity_music_lens_track_get_artist (_tmp99_);
					_tmp101_ = _tmp100_;
					_tmp102_ = track;
					_tmp103_ = unity_music_lens_track_get_uri (_tmp102_);
					_tmp104_ = _tmp103_;
					dee_model_append ((DeeModel*) _tmp87_, _tmp90_, _tmp91_, _tmp92_, _tmp95_, _tmp98_, _tmp101_, _tmp104_, NULL);
					_tmp105_ = albums;
					_tmp106_ = album;
					_tmp107_ = unity_music_lens_album_get_artist (_tmp106_);
					_tmp108_ = _tmp107_;
					_tmp109_ = album;
					_tmp110_ = unity_music_lens_album_get_title (_tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = g_strconcat (_tmp108_, _tmp111_, NULL);
					_tmp113_ = _tmp112_;
					_tmp114_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp105_, _tmp113_);
					_tmp115_ = _tmp114_;
					_g_free0 (_tmp113_);
					if (_tmp115_) {
						GString* _tmp116_;
						GString* uri_list_builder;
						UnityMusicLensAlbum* _tmp117_;
						gint _tmp118_ = 0;
						gchar** _tmp119_ = NULL;
						gint _tmp125_;
						DeeSerializableModel* _tmp127_;
						UnityMusicLensAlbum* _tmp128_;
						const gchar* _tmp129_;
						const gchar* _tmp130_;
						UnityMusicLensAlbum* _tmp131_;
						const gchar* _tmp132_;
						const gchar* _tmp133_;
						guint _tmp134_;
						UnityMusicLensAlbum* _tmp135_;
						const gchar* _tmp136_;
						const gchar* _tmp137_;
						UnityMusicLensAlbum* _tmp138_;
						const gchar* _tmp139_;
						const gchar* _tmp140_;
						GString* _tmp141_;
						const gchar* _tmp142_;
						_tmp116_ = g_string_new ("");
						uri_list_builder = _tmp116_;
						_tmp117_ = album;
						_tmp119_ = unity_music_lens_banshee_collection_get_track_uris (self, _tmp117_, &_tmp118_);
						{
							gchar** uri_collection = NULL;
							gint uri_collection_length1 = 0;
							gint _uri_collection_size_ = 0;
							gint uri_it = 0;
							uri_collection = _tmp119_;
							uri_collection_length1 = _tmp118_;
							for (uri_it = 0; uri_it < _tmp118_; uri_it = uri_it + 1) {
								gchar* _tmp120_;
								gchar* uri = NULL;
								_tmp120_ = g_strdup (uri_collection[uri_it]);
								uri = _tmp120_;
								{
									GString* _tmp121_;
									GString* _tmp122_;
									const gchar* _tmp123_;
									GString* _tmp124_;
									_tmp121_ = uri_list_builder;
									g_string_append (_tmp121_, "'");
									_tmp122_ = uri_list_builder;
									_tmp123_ = uri;
									g_string_append (_tmp122_, _tmp123_);
									_tmp124_ = uri_list_builder;
									g_string_append (_tmp124_, "' ");
									_g_free0 (uri);
								}
							}
							uri_collection = (_vala_array_free (uri_collection, uri_collection_length1, (GDestroyNotify) g_free), NULL);
						}
						category_id = (guint) UNITY_MUSIC_LENS_CATEGORY_ALBUMS;
						_tmp125_ = category_override;
						if (_tmp125_ >= 0) {
							gint _tmp126_;
							_tmp126_ = category_override;
							category_id = (guint) _tmp126_;
						}
						_tmp127_ = results_model;
						_tmp128_ = album;
						_tmp129_ = unity_music_lens_album_get_uri (_tmp128_);
						_tmp130_ = _tmp129_;
						_tmp131_ = album;
						_tmp132_ = unity_music_lens_album_get_artwork_path (_tmp131_);
						_tmp133_ = _tmp132_;
						_tmp134_ = category_id;
						_tmp135_ = album;
						_tmp136_ = unity_music_lens_album_get_title (_tmp135_);
						_tmp137_ = _tmp136_;
						_tmp138_ = album;
						_tmp139_ = unity_music_lens_album_get_artist (_tmp138_);
						_tmp140_ = _tmp139_;
						_tmp141_ = uri_list_builder;
						_tmp142_ = _tmp141_->str;
						dee_model_append ((DeeModel*) _tmp127_, _tmp130_, _tmp133_, _tmp134_, "audio/mp3", _tmp137_, _tmp140_, _tmp142_, NULL);
						_g_string_free0 (uri_list_builder);
					}
					_g_object_unref0 (album);
					_g_object_unref0 (track);
					_g_free0 (artwork_path);
					break;
				}
				default:
				{
					break;
				}
			}
		}
	}
	_tmp143_ = helper_model;
	_tmp144_ = results_model;
	if (_tmp143_ == _tmp144_) {
		_g_free0 (sql);
		_g_free0 (filters_sql);
		_g_object_unref0 (albums);
		_g_object_unref0 (helper_model);
		_g_object_unref0 (results_model);
		_sqlite3_finalize0 (stmt);
		return;
	}
	_tmp145_ = helper_model;
	_tmp146_ = dee_model_get_first_iter ((DeeModel*) _tmp145_);
	iter = _tmp146_;
	_tmp147_ = helper_model;
	_tmp148_ = dee_model_get_last_iter ((DeeModel*) _tmp147_);
	last = _tmp148_;
	while (TRUE) {
		DeeModelIter* _tmp149_;
		DeeModelIter* _tmp150_;
		DeeSerializableModel* _tmp151_;
		DeeModelIter* _tmp152_;
		GVariant** _tmp153_;
		GVariant** _tmp154_ = NULL;
		GVariant** row;
		gint row_length1;
		gint _row_size_;
		DeeSerializableModel* _tmp155_;
		GVariant** _tmp156_;
		gint _tmp156__length1;
		DeeSerializableModel* _tmp157_;
		DeeModelIter* _tmp158_;
		DeeModelIter* _tmp159_ = NULL;
		_tmp149_ = iter;
		_tmp150_ = last;
		if (!(_tmp149_ != _tmp150_)) {
			break;
		}
		_tmp151_ = helper_model;
		_tmp152_ = iter;
		_tmp154_ = _tmp153_ = dee_model_get_row ((DeeModel*) _tmp151_, _tmp152_, NULL);
		row = _tmp154_;
		row_length1 = _vala_array_length (_tmp153_);
		_row_size_ = row_length1;
		_tmp155_ = results_model;
		_tmp156_ = row;
		_tmp156__length1 = row_length1;
		dee_model_append_row ((DeeModel*) _tmp155_, _tmp156_);
		_tmp157_ = helper_model;
		_tmp158_ = iter;
		_tmp159_ = dee_model_next ((DeeModel*) _tmp157_, _tmp158_);
		iter = _tmp159_;
		row = (_vala_array_free (row, row_length1, (GDestroyNotify) g_variant_unref), NULL);
	}
	_g_free0 (sql);
	_g_free0 (filters_sql);
	_g_object_unref0 (albums);
	_g_object_unref0 (helper_model);
	_g_object_unref0 (results_model);
	_sqlite3_finalize0 (stmt);
}


/**
     * Computes path for album artwork.
     */
static gchar* unity_music_lens_banshee_collection_get_album_artwork_path (UnityMusicLensBansheeCollection* self, const gchar* artwork_id) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* album_art_dir;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* artwork_path;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (artwork_id != NULL, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_strdup_printf ("%s/media-art/", _tmp0_);
	album_art_dir = _tmp1_;
	_tmp2_ = artwork_id;
	_tmp3_ = g_strdup_printf ("%s/%s.jpg", album_art_dir, _tmp2_);
	artwork_path = _tmp3_;
	result = artwork_path;
	_g_free0 (album_art_dir);
	return result;
}


/**
     * Creates Track object out of single row of Statement result data.
     */
static UnityMusicLensTrack* unity_music_lens_banshee_collection_get_track (UnityMusicLensBansheeCollection* self, sqlite3_stmt* stmt) {
	UnityMusicLensTrack* result = NULL;
	static const gint TRACK_URI = 0;
	static const gint TRACK_TITLE = 1;
	static const gint ARTIST_NAME = 2;
	static const gint ALBUM_TITLE = 3;
	static const gint ALBUM_ARTWORKID = 4;
	static const gint TRACK_MIMETYPE = 5;
	static const gint TRACK_GENRE = 6;
	static const gint TRACK_NUMBER = 7;
	static const gint TRACK_YEAR = 8;
	static const gint TRACK_PLAYCOUNT = 9;
	static const gint TRACK_DURATION = 10;
	UnityMusicLensTrack* _tmp0_;
	UnityMusicLensTrack* track;
	sqlite3_stmt* _tmp1_;
	const gchar* _tmp2_ = NULL;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_ = NULL;
	sqlite3_stmt* _tmp5_;
	const gchar* _tmp6_ = NULL;
	sqlite3_stmt* _tmp7_;
	const gchar* _tmp8_ = NULL;
	sqlite3_stmt* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	sqlite3_stmt* _tmp13_;
	const gchar* _tmp14_ = NULL;
	sqlite3_stmt* _tmp15_;
	const gchar* _tmp16_ = NULL;
	sqlite3_stmt* _tmp17_;
	gint _tmp18_ = 0;
	sqlite3_stmt* _tmp19_;
	gint _tmp20_ = 0;
	sqlite3_stmt* _tmp21_;
	gint _tmp22_ = 0;
	sqlite3_stmt* _tmp23_;
	gint _tmp24_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stmt != NULL, NULL);
	_tmp0_ = unity_music_lens_track_new ();
	track = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = sqlite3_column_text (_tmp1_, TRACK_URI);
	unity_music_lens_track_set_uri (track, _tmp2_);
	_tmp3_ = stmt;
	_tmp4_ = sqlite3_column_text (_tmp3_, TRACK_TITLE);
	unity_music_lens_track_set_title (track, _tmp4_);
	_tmp5_ = stmt;
	_tmp6_ = sqlite3_column_text (_tmp5_, ARTIST_NAME);
	unity_music_lens_track_set_artist (track, _tmp6_);
	_tmp7_ = stmt;
	_tmp8_ = sqlite3_column_text (_tmp7_, ALBUM_TITLE);
	unity_music_lens_track_set_album (track, _tmp8_);
	_tmp9_ = stmt;
	_tmp10_ = sqlite3_column_text (_tmp9_, ALBUM_ARTWORKID);
	_tmp11_ = unity_music_lens_banshee_collection_get_album_artwork_path (self, _tmp10_);
	_tmp12_ = _tmp11_;
	unity_music_lens_track_set_artwork_path (track, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = stmt;
	_tmp14_ = sqlite3_column_text (_tmp13_, TRACK_MIMETYPE);
	unity_music_lens_track_set_mime_type (track, _tmp14_);
	_tmp15_ = stmt;
	_tmp16_ = sqlite3_column_text (_tmp15_, TRACK_GENRE);
	unity_music_lens_track_set_genre (track, _tmp16_);
	_tmp17_ = stmt;
	_tmp18_ = sqlite3_column_int (_tmp17_, TRACK_NUMBER);
	unity_music_lens_track_set_track_number (track, _tmp18_);
	_tmp19_ = stmt;
	_tmp20_ = sqlite3_column_int (_tmp19_, TRACK_YEAR);
	unity_music_lens_track_set_year (track, _tmp20_);
	_tmp21_ = stmt;
	_tmp22_ = sqlite3_column_int (_tmp21_, TRACK_PLAYCOUNT);
	unity_music_lens_track_set_play_count (track, _tmp22_);
	_tmp23_ = stmt;
	_tmp24_ = sqlite3_column_int (_tmp23_, TRACK_DURATION);
	unity_music_lens_track_set_duration (track, _tmp24_);
	result = track;
	return result;
}


/**
     * Returns single track.
     */
UnityMusicLensTrack* unity_music_lens_banshee_collection_get_album_track (UnityMusicLensBansheeCollection* self, const gchar* uri) {
	UnityMusicLensTrack* result = NULL;
	gchar* _tmp0_;
	gchar* sql;
	sqlite3_stmt* stmt = NULL;
	const gchar* _tmp1_;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint rc;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GDestroyNotify _tmp7_;
	sqlite3_stmt* _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_strdup ("SELECT \n" \
"                         CoreTracks.Uri,\n" \
"                         CoreTracks.Title,\n" \
"                         CoreArtists.Name,\n" \
"                         CoreAlbums.Title,\n" \
"                         CoreAlbums.ArtworkID,\n" \
"                         CoreTracks.MimeType,\n" \
"                         CoreTracks.Genre,\n" \
"                         CoreTracks.TrackNumber,\n" \
"                         CoreTracks.Year,\n" \
"                         CoreTracks.PlayCount,\n" \
"                         CoreTracks.Duration\n" \
"                    FROM CoreTracks \n" \
"                    CROSS JOIN CoreAlbums, CoreArtists \n" \
"                    WHERE CoreTracks.URI IS ?\n" \
"                          AND CoreArtists.ArtistID = CoreTracks.Artist" \
"ID \n" \
"                          AND CoreAlbums.AlbumID = CoreTracks.AlbumID");
	sql = _tmp0_;
	_tmp1_ = sql;
	_tmp3_ = unity_music_lens_banshee_collection_execute_sql (self, _tmp1_, &_tmp2_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp2_;
	rc = _tmp3_;
	_tmp4_ = stmt;
	_tmp5_ = uri;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = g_free;
	sqlite3_bind_text (_tmp4_, 1, _tmp6_, -1, _tmp7_);
	_tmp8_ = stmt;
	_tmp9_ = sqlite3_step (_tmp8_);
	rc = _tmp9_;
	_tmp10_ = rc;
	if (_tmp10_ == SQLITE_ROW) {
		sqlite3_stmt* _tmp11_;
		UnityMusicLensTrack* _tmp12_ = NULL;
		_tmp11_ = stmt;
		_tmp12_ = unity_music_lens_banshee_collection_get_track (self, _tmp11_);
		result = _tmp12_;
		_sqlite3_finalize0 (stmt);
		_g_free0 (sql);
		return result;
	}
	result = NULL;
	_sqlite3_finalize0 (stmt);
	_g_free0 (sql);
	return result;
}


/**
     * Returns all tracks of an album.
     */
static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


GSList* unity_music_lens_banshee_collection_get_album_tracks_detailed (UnityMusicLensBansheeCollection* self, const gchar* album_title, const gchar* album_artist) {
	GSList* result = NULL;
	gchar* _tmp0_;
	gchar* sql;
	sqlite3_stmt* stmt = NULL;
	const gchar* _tmp1_;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint rc;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GDestroyNotify _tmp7_;
	sqlite3_stmt* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GDestroyNotify _tmp11_;
	GSList* tracks;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (album_title != NULL, NULL);
	g_return_val_if_fail (album_artist != NULL, NULL);
	_tmp0_ = g_strdup ("SELECT \n" \
"                         CoreTracks.Uri,\n" \
"                         CoreTracks.Title,\n" \
"                         CoreArtists.Name,\n" \
"                         CoreAlbums.Title,\n" \
"                         CoreAlbums.ArtworkID,\n" \
"                         CoreTracks.MimeType,\n" \
"                         CoreTracks.Genre,\n" \
"                         CoreTracks.TrackNumber,\n" \
"                         CoreTracks.Year,\n" \
"                         CoreTracks.PlayCount,\n" \
"                         CoreTracks.Duration\n" \
"                    FROM CoreTracks \n" \
"                    CROSS JOIN CoreAlbums, CoreArtists \n" \
"                    WHERE CoreArtists.ArtistID = CoreTracks.ArtistID \n" \
"                          AND CoreAlbums.AlbumID = CoreTracks.AlbumID " \
"\n" \
"                          AND CoreAlbums.Title IS ?\n" \
"                          AND CoreArtists.Name IS ?\n" \
"                          AND CoreTracks.URI IS NOT NULL\n" \
"                    ORDER BY CoreTracks.TrackNumber ASC");
	sql = _tmp0_;
	_tmp1_ = sql;
	_tmp3_ = unity_music_lens_banshee_collection_execute_sql (self, _tmp1_, &_tmp2_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp2_;
	rc = _tmp3_;
	_tmp4_ = stmt;
	_tmp5_ = album_title;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = g_free;
	sqlite3_bind_text (_tmp4_, 1, _tmp6_, -1, _tmp7_);
	_tmp8_ = stmt;
	_tmp9_ = album_artist;
	_tmp10_ = g_strdup (_tmp9_);
	_tmp11_ = g_free;
	sqlite3_bind_text (_tmp8_, 2, _tmp10_, -1, _tmp11_);
	tracks = NULL;
	{
		gboolean _tmp12_;
		_tmp12_ = TRUE;
		while (TRUE) {
			gboolean _tmp13_;
			sqlite3_stmt* _tmp15_;
			gint _tmp16_ = 0;
			gint _tmp17_;
			_tmp13_ = _tmp12_;
			if (!_tmp13_) {
				gint _tmp14_;
				_tmp14_ = rc;
				if (!(_tmp14_ == SQLITE_ROW)) {
					break;
				}
			}
			_tmp12_ = FALSE;
			_tmp15_ = stmt;
			_tmp16_ = sqlite3_step (_tmp15_);
			rc = _tmp16_;
			_tmp17_ = rc;
			switch (_tmp17_) {
				case SQLITE_DONE:
				{
					break;
				}
				case SQLITE_ROW:
				{
					sqlite3_stmt* _tmp18_;
					UnityMusicLensTrack* _tmp19_ = NULL;
					_tmp18_ = stmt;
					_tmp19_ = unity_music_lens_banshee_collection_get_track (self, _tmp18_);
					tracks = g_slist_append (tracks, _tmp19_);
					break;
				}
				default:
				{
					break;
				}
			}
		}
	}
	result = tracks;
	_sqlite3_finalize0 (stmt);
	_g_free0 (sql);
	return result;
}


/**
     * returns an array like {uri://, uri://, ...}
     */
gchar** unity_music_lens_banshee_collection_get_track_uris (UnityMusicLensBansheeCollection* self, UnityMusicLensAlbum* album, int* result_length1) {
	gchar** result = NULL;
	static const gint URI_COLUMN = 0;
	gint rc = 0;
	sqlite3_stmt* stmt = NULL;
	UnityMusicLensAlbum* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	UnityMusicLensAlbum* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* sql;
	const gchar* _tmp7_;
	sqlite3_stmt* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GeeArrayList* _tmp10_;
	GeeArrayList* uris;
	GeeArrayList* _tmp20_;
	gint _tmp21_ = 0;
	gpointer* _tmp22_ = NULL;
	gchar** _tmp23_;
	gint _tmp23__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (album != NULL, NULL);
	_tmp0_ = album;
	_tmp1_ = unity_music_lens_album_get_title (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = album;
	_tmp4_ = unity_music_lens_album_get_artist (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("SELECT CoreTracks.Uri \n" \
"                    FROM CoreTracks \n" \
"                    CROSS JOIN CoreAlbums, CoreArtists \n" \
"                    WHERE CoreArtists.ArtistID = CoreTracks.ArtistID \n" \
"                          AND CoreAlbums.AlbumID = CoreTracks.AlbumID " \
"\n" \
"                          AND CoreAlbums.Title IS '%s'\n" \
"                          AND CoreArtists.Name IS '%s'\n" \
"                          AND CoreTracks.URI IS NOT NULL\n" \
"                    ORDER BY CoreTracks.TrackNumber ASC", _tmp2_, _tmp5_);
	sql = _tmp6_;
	_tmp7_ = sql;
	_tmp9_ = unity_music_lens_banshee_collection_execute_sql (self, _tmp7_, &_tmp8_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp8_;
	rc = _tmp9_;
	_tmp10_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	uris = _tmp10_;
	{
		gboolean _tmp11_;
		_tmp11_ = TRUE;
		while (TRUE) {
			gboolean _tmp12_;
			sqlite3_stmt* _tmp14_;
			gint _tmp15_ = 0;
			gint _tmp16_;
			_tmp12_ = _tmp11_;
			if (!_tmp12_) {
				gint _tmp13_;
				_tmp13_ = rc;
				if (!(_tmp13_ == SQLITE_ROW)) {
					break;
				}
			}
			_tmp11_ = FALSE;
			_tmp14_ = stmt;
			_tmp15_ = sqlite3_step (_tmp14_);
			rc = _tmp15_;
			_tmp16_ = rc;
			switch (_tmp16_) {
				case SQLITE_DONE:
				{
					break;
				}
				case SQLITE_ROW:
				{
					GeeArrayList* _tmp17_;
					sqlite3_stmt* _tmp18_;
					const gchar* _tmp19_ = NULL;
					_tmp17_ = uris;
					_tmp18_ = stmt;
					_tmp19_ = sqlite3_column_text (_tmp18_, URI_COLUMN);
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp19_);
					break;
				}
				default:
				{
					break;
				}
			}
		}
	}
	_tmp20_ = uris;
	_tmp22_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp20_, &_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp23__length1 = _tmp21_;
	if (result_length1) {
		*result_length1 = _tmp23__length1;
	}
	result = _tmp23_;
	_g_object_unref0 (uris);
	_g_free0 (sql);
	_sqlite3_finalize0 (stmt);
	return result;
}


/**
     * returns a string like "AND (Table.Column IS filter OR Table.OtherCol IS filter2) 
     * AND (Table.OtherColAgain IS AnotherFilter)" 
     */
static gchar* unity_music_lens_banshee_collection_build_sql_from_filters (UnityMusicLensBansheeCollection* self, GList* filters) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_;
	gboolean _tmp4_;
	GString* _tmp6_;
	GString* builder;
	GList* _tmp7_;
	GString* _tmp24_;
	GString* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = filters;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GList* _tmp2_;
		guint _tmp3_ = 0U;
		_tmp2_ = filters;
		_tmp3_ = g_list_length (_tmp2_);
		_tmp0_ = _tmp3_ == ((guint) 0);
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		result = _tmp5_;
		return result;
	}
	_tmp6_ = g_string_new ("");
	builder = _tmp6_;
	_tmp7_ = filters;
	{
		GList* parser_collection = NULL;
		GList* parser_it = NULL;
		parser_collection = _tmp7_;
		for (parser_it = parser_collection; parser_it != NULL; parser_it = parser_it->next) {
			UnityMusicLensFilterParser* _tmp8_;
			UnityMusicLensFilterParser* parser = NULL;
			_tmp8_ = _g_object_ref0 ((UnityMusicLensFilterParser*) parser_it->data);
			parser = _tmp8_;
			{
				UnityMusicLensBansheeFilterParser* bparser = NULL;
				UnityMusicLensFilterParser* _tmp9_;
				UnityMusicLensBansheeFilterParser* _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* parsed;
				gboolean _tmp17_ = FALSE;
				const gchar* _tmp18_;
				gboolean _tmp20_;
				GString* _tmp21_;
				GString* _tmp22_;
				const gchar* _tmp23_;
				_tmp9_ = parser;
				if (UNITY_MUSIC_LENS_IS_GENRE_FILTER_PARSER (_tmp9_)) {
					UnityMusicLensFilterParser* _tmp10_;
					UnityMusicLensBansheeGenreFilterParser* _tmp11_;
					_tmp10_ = parser;
					_tmp11_ = unity_music_lens_banshee_genre_filter_parser_new (UNITY_MUSIC_LENS_IS_GENRE_FILTER_PARSER (_tmp10_) ? ((UnityMusicLensGenreFilterParser*) _tmp10_) : NULL);
					_g_object_unref0 (bparser);
					bparser = (UnityMusicLensBansheeFilterParser*) _tmp11_;
				} else {
					UnityMusicLensFilterParser* _tmp12_;
					_tmp12_ = parser;
					if (UNITY_MUSIC_LENS_IS_DECADE_FILTER_PARSER (_tmp12_)) {
						UnityMusicLensFilterParser* _tmp13_;
						UnityMusicLensBansheeDecadeFilterParser* _tmp14_;
						_tmp13_ = parser;
						_tmp14_ = unity_music_lens_banshee_decade_filter_parser_new (UNITY_MUSIC_LENS_IS_DECADE_FILTER_PARSER (_tmp13_) ? ((UnityMusicLensDecadeFilterParser*) _tmp13_) : NULL);
						_g_object_unref0 (bparser);
						bparser = (UnityMusicLensBansheeFilterParser*) _tmp14_;
					} else {
						g_warning ("banshee-collection.vala:360: Recieved an unimplemented filter type");
						_g_object_unref0 (bparser);
						_g_object_unref0 (parser);
						continue;
					}
				}
				_tmp15_ = bparser;
				_tmp16_ = unity_music_lens_filter_parser_parse ((UnityMusicLensFilterParser*) _tmp15_);
				parsed = _tmp16_;
				_tmp18_ = parsed;
				if (_tmp18_ == NULL) {
					_tmp17_ = TRUE;
				} else {
					const gchar* _tmp19_;
					_tmp19_ = parsed;
					_tmp17_ = g_strcmp0 (_tmp19_, "") == 0;
				}
				_tmp20_ = _tmp17_;
				if (_tmp20_) {
					_g_free0 (parsed);
					_g_object_unref0 (bparser);
					_g_object_unref0 (parser);
					continue;
				}
				_tmp21_ = builder;
				g_string_append (_tmp21_, " AND ");
				_tmp22_ = builder;
				_tmp23_ = parsed;
				g_string_append (_tmp22_, _tmp23_);
				_g_free0 (parsed);
				_g_object_unref0 (bparser);
				_g_object_unref0 (parser);
			}
		}
	}
	_tmp24_ = builder;
	g_string_append (_tmp24_, " ");
	_tmp25_ = builder;
	_tmp26_ = _tmp25_->str;
	_tmp27_ = g_strdup (_tmp26_);
	result = _tmp27_;
	_g_string_free0 (builder);
	return result;
}


static gint unity_music_lens_banshee_collection_execute_sql (UnityMusicLensBansheeCollection* self, const gchar* sql, sqlite3_stmt** stmt) {
	sqlite3_stmt* _vala_stmt = NULL;
	gint result = 0;
	gint rc = 0;
	const gchar* _tmp0_;
	sqlite3* _tmp1_;
	const gchar* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	g_debug ("banshee-collection.vala:380: preparing to execute sql %s\n", _tmp0_);
	_tmp1_ = self->priv->db;
	_tmp2_ = sql;
	_tmp4_ = sqlite3_prepare_v2 (_tmp1_, _tmp2_, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (_vala_stmt);
	_vala_stmt = _tmp3_;
	rc = _tmp4_;
	_tmp5_ = rc;
	if (_tmp5_ == 1) {
		gint _tmp6_;
		sqlite3* _tmp7_;
		const gchar* _tmp8_ = NULL;
		_tmp6_ = rc;
		_tmp7_ = self->priv->db;
		_tmp8_ = sqlite3_errmsg (_tmp7_);
		g_warning ("banshee-collection.vala:384: SQL Error: %d, %s\n", _tmp6_, _tmp8_);
	}
	result = rc;
	if (stmt) {
		*stmt = _vala_stmt;
	} else {
		_sqlite3_finalize0 (_vala_stmt);
	}
	return result;
}


static void unity_music_lens_banshee_collection_class_init (UnityMusicLensBansheeCollectionClass * klass) {
	unity_music_lens_banshee_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityMusicLensBansheeCollectionPrivate));
	G_OBJECT_CLASS (klass)->finalize = unity_music_lens_banshee_collection_finalize;
}


static void unity_music_lens_banshee_collection_instance_init (UnityMusicLensBansheeCollection * self) {
	self->priv = UNITY_MUSIC_LENS_BANSHEE_COLLECTION_GET_PRIVATE (self);
}


static void unity_music_lens_banshee_collection_finalize (GObject* obj) {
	UnityMusicLensBansheeCollection * self;
	self = UNITY_MUSIC_LENS_BANSHEE_COLLECTION (obj);
	_sqlite3_close0 (self->priv->db);
	G_OBJECT_CLASS (unity_music_lens_banshee_collection_parent_class)->finalize (obj);
}


/**
   * Abstracts talking to the banshee collection database
   */
GType unity_music_lens_banshee_collection_get_type (void) {
	static volatile gsize unity_music_lens_banshee_collection_type_id__volatile = 0;
	if (g_once_init_enter (&unity_music_lens_banshee_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityMusicLensBansheeCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_music_lens_banshee_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityMusicLensBansheeCollection), 0, (GInstanceInitFunc) unity_music_lens_banshee_collection_instance_init, NULL };
		GType unity_music_lens_banshee_collection_type_id;
		unity_music_lens_banshee_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityMusicLensBansheeCollection", &g_define_type_info, 0);
		g_once_init_leave (&unity_music_lens_banshee_collection_type_id__volatile, unity_music_lens_banshee_collection_type_id);
	}
	return unity_music_lens_banshee_collection_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



