/* unity-greeter.c generated by valac 0.16.1, the Vala compiler
 * generated from unity-greeter.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Robert Ancell <robert.ancell@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <lightdm.h>
#include <canberra.h>
#include <cairo-xlib.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <gdk/gdkx.h>
#include <stdio.h>
#include <locale.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <gobject/gvaluecollector.h>


#define TYPE_UNITY_GREETER (unity_greeter_get_type ())
#define UNITY_GREETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNITY_GREETER, UnityGreeter))
#define UNITY_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNITY_GREETER, UnityGreeterClass))
#define IS_UNITY_GREETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNITY_GREETER))
#define IS_UNITY_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNITY_GREETER))
#define UNITY_GREETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNITY_GREETER, UnityGreeterClass))

typedef struct _UnityGreeter UnityGreeter;
typedef struct _UnityGreeterClass UnityGreeterClass;
typedef struct _UnityGreeterPrivate UnityGreeterPrivate;

#define TYPE_USER_LIST (user_list_get_type ())
#define USER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST, UserList))
#define USER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST, UserListClass))
#define IS_USER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST))
#define IS_USER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST))
#define USER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST, UserListClass))

typedef struct _UserList UserList;
typedef struct _UserListClass UserListClass;

#define TYPE_SETTINGS_DAEMON (settings_daemon_get_type ())
#define SETTINGS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_DAEMON, SettingsDaemon))
#define SETTINGS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_DAEMON, SettingsDaemonClass))
#define IS_SETTINGS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_DAEMON))
#define IS_SETTINGS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_DAEMON))
#define SETTINGS_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_DAEMON, SettingsDaemonClass))

typedef struct _SettingsDaemon SettingsDaemon;
typedef struct _SettingsDaemonClass SettingsDaemonClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_PROMPT (prompt_get_type ())
#define PROMPT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROMPT, Prompt))
#define PROMPT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROMPT, PromptClass))
#define IS_PROMPT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROMPT))
#define IS_PROMPT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROMPT))
#define PROMPT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROMPT, PromptClass))

typedef struct _Prompt Prompt;
typedef struct _PromptClass PromptClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__prompt_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__prompt_unref0_ (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _ca_context_destroy0(var) ((var == NULL) ? NULL : (var = (ca_context_destroy (var), NULL)))

#define TYPE_TEST_ENTRY (test_entry_get_type ())
typedef struct _TestEntry TestEntry;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MENU_BAR (menu_bar_get_type ())
#define MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENU_BAR, MenuBar))
#define MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENU_BAR, MenuBarClass))
#define IS_MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENU_BAR))
#define IS_MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENU_BAR))
#define MENU_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENU_BAR, MenuBarClass))

typedef struct _MenuBar MenuBar;
typedef struct _MenuBarClass MenuBarClass;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _UserListPrivate UserListPrivate;

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;

#define BACKGROUND_TYPE_DRAW_FLAGS (background_draw_flags_get_type ())
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _prompt_unref0(var) ((var == NULL) ? NULL : (var = (prompt_unref (var), NULL)))
typedef struct _PromptPrivate PromptPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _unity_greeter_unref0(var) ((var == NULL) ? NULL : (var = (unity_greeter_unref (var), NULL)))
typedef struct _ParamSpecUnityGreeter ParamSpecUnityGreeter;
typedef struct _ParamSpecPrompt ParamSpecPrompt;

struct _UnityGreeter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityGreeterPrivate * priv;
	UserList* user_list;
};

struct _UnityGreeterClass {
	GTypeClass parent_class;
	void (*finalize) (UnityGreeter *self);
};

struct _UnityGreeterPrivate {
	gchar* state_file;
	GKeyFile* state;
	SettingsDaemon* settings_daemon;
	MainWindow* main_window;
	LightDMGreeter* greeter;
	gboolean prompted;
	gboolean clear_messages;
	GList* active_prompts;
	gchar* authenticate_user;
	GList* test_backgrounds;
	gint n_test_entries;
	gchar* test_username;
	gboolean test_prompted_sso;
	gchar* test_two_prompts_first;
	gboolean test_request_new_password;
	gchar* test_new_password;
	gboolean test_is_authenticated;
	ca_context* canberra_context;
};

struct _TestEntry {
	gchar* username;
	gchar* real_name;
	gchar* background;
	gchar* layouts;
	gboolean is_active;
	gboolean has_messages;
	gchar* session;
};

struct _MainWindow {
	GtkWindow parent_instance;
	MainWindowPrivate * priv;
	UserList* user_list;
	MenuBar* menubar;
};

struct _MainWindowClass {
	GtkWindowClass parent_class;
};

struct _UserList {
	GtkEventBox parent_instance;
	UserListPrivate * priv;
	Background* background;
	MenuBar* menubar;
};

struct _UserListClass {
	GtkEventBoxClass parent_class;
};

typedef enum  {
	BACKGROUND_DRAW_FLAGS_NONE,
	BACKGROUND_DRAW_FLAGS_GRID
} BackgroundDrawFlags;

struct _Prompt {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PromptPrivate * priv;
	gchar* text;
	LightDMPromptType type;
};

struct _PromptClass {
	GTypeClass parent_class;
	void (*finalize) (Prompt *self);
};

struct _ParamSpecUnityGreeter {
	GParamSpec parent_instance;
};

struct _ParamSpecPrompt {
	GParamSpec parent_instance;
};


static gpointer unity_greeter_parent_class = NULL;
static gboolean unity_greeter_show_version;
static gboolean unity_greeter_show_version = FALSE;
extern gboolean unity_greeter_test_mode;
gboolean unity_greeter_test_mode = FALSE;
static GTimer* unity_greeter_log_timer;
static GTimer* unity_greeter_log_timer = NULL;
static cairo_surface_t* unity_greeter_background_surface;
static cairo_surface_t* unity_greeter_background_surface = NULL;
static gpointer prompt_parent_class = NULL;

#define grid_size 40
gpointer unity_greeter_ref (gpointer instance);
void unity_greeter_unref (gpointer instance);
GParamSpec* param_spec_unity_greeter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_unity_greeter (GValue* value, gpointer v_object);
void value_take_unity_greeter (GValue* value, gpointer v_object);
gpointer value_get_unity_greeter (const GValue* value);
GType unity_greeter_get_type (void) G_GNUC_CONST;
GType user_list_get_type (void) G_GNUC_CONST;
GType settings_daemon_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
gpointer prompt_ref (gpointer instance);
void prompt_unref (gpointer instance);
GParamSpec* param_spec_prompt (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_prompt (GValue* value, gpointer v_object);
void value_take_prompt (GValue* value, gpointer v_object);
gpointer value_get_prompt (const GValue* value);
GType prompt_get_type (void) G_GNUC_CONST;
#define UNITY_GREETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_UNITY_GREETER, UnityGreeterPrivate))
enum  {
	UNITY_GREETER_DUMMY_PROPERTY
};
static void _prompt_unref0_ (gpointer var);
static void _g_list_free__prompt_unref0_ (GList* self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
GType test_entry_get_type (void) G_GNUC_CONST;
TestEntry* test_entry_dup (const TestEntry* self);
void test_entry_free (TestEntry* self);
void test_entry_copy (const TestEntry* self, TestEntry* dest);
void test_entry_destroy (TestEntry* self);
UnityGreeter* unity_greeter_new (void);
UnityGreeter* unity_greeter_construct (GType object_type);
static void unity_greeter_show_message_cb (UnityGreeter* self, const gchar* text, LightDMMessageType type);
static void _unity_greeter_show_message_cb_lightdm_greeter_show_message (LightDMGreeter* _sender, const gchar* text, LightDMMessageType type, gpointer self);
static void unity_greeter_show_prompt_cb (UnityGreeter* self, const gchar* text, LightDMPromptType type);
static void _unity_greeter_show_prompt_cb_lightdm_greeter_show_prompt (LightDMGreeter* _sender, const gchar* text, LightDMPromptType type, gpointer self);
static void __lambda7_ (UnityGreeter* self);
static void ___lambda7__lightdm_greeter_autologin_timer_expired (LightDMGreeter* _sender, gpointer self);
static void unity_greeter_authentication_complete_cb (UnityGreeter* self);
static void _unity_greeter_authentication_complete_cb_lightdm_greeter_authentication_complete (LightDMGreeter* _sender, gpointer self);
SettingsDaemon* settings_daemon_new (void);
SettingsDaemon* settings_daemon_construct (GType object_type);
void settings_daemon_start (SettingsDaemon* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void settings_daemon_start_finish (SettingsDaemon* self, GAsyncResult* _res_);
MainWindow* main_window_new (void);
MainWindow* main_window_construct (GType object_type);
GType menu_bar_get_type (void) G_GNUC_CONST;
static gboolean unity_greeter_add_test_entry (UnityGreeter* self);
void user_list_set_offer_guest (UserList* self, gboolean value);
static gboolean unity_greeter_key_press_cb (UnityGreeter* self, GdkEventKey* event);
static gboolean _unity_greeter_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
void user_list_set_active_entry (UserList* self, const gchar* name);
void user_list_set_default_session (UserList* self, const gchar* value);
void user_list_set_always_show_manual (UserList* self, gboolean value);
static void unity_greeter_user_added_cb (UnityGreeter* self, LightDMUser* user);
static void _unity_greeter_user_added_cb_lightdm_user_list_user_added (LightDMUserList* _sender, LightDMUser* user, gpointer self);
static void _unity_greeter_user_added_cb_lightdm_user_list_user_changed (LightDMUserList* _sender, LightDMUser* user, gpointer self);
static void unity_greeter_user_removed_cb (UnityGreeter* self, LightDMUser* user);
static void _unity_greeter_user_removed_cb_lightdm_user_list_user_removed (LightDMUserList* _sender, LightDMUser* user, gpointer self);
static void unity_greeter_user_selected_cb (UnityGreeter* self, const gchar* username);
static void _unity_greeter_user_selected_cb_user_list_user_selected (UserList* _sender, const gchar* username, gpointer self);
static void unity_greeter_respond_to_prompt_cb (UnityGreeter* self, const gchar* text);
static void _unity_greeter_respond_to_prompt_cb_user_list_respond_to_prompt (UserList* _sender, const gchar* text, gpointer self);
static void unity_greeter_start_session_cb (UnityGreeter* self);
static void _unity_greeter_start_session_cb_user_list_start_session (UserList* _sender, gpointer self);
const gchar* user_list_get_selected (UserList* self);
static void unity_greeter_start_fake_wm (UnityGreeter* self);
static gboolean unity_greeter_ready_cb (UnityGreeter* self);
static gboolean _unity_greeter_ready_cb_gsource_func (gpointer self);
static gboolean unity_greeter_remove_test_entry (UnityGreeter* self);
void user_list_add_entry (UserList* self, const gchar* name, const gchar* label, const gchar* background, GList* keyboard_layouts, gboolean is_active, gboolean has_messages, const gchar* session);
static GList* unity_greeter_make_layout_list (UnityGreeter* self, const gchar* names);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void user_list_remove_entry (UserList* self, const gchar* name);
void unity_greeter_add_style_class (GtkWidget* widget);
LightDMLayout* unity_greeter_get_layout_by_name (const gchar* name);
gboolean ug_settings_get_boolean (const gchar* key);
#define UG_SETTINGS_KEY_PLAY_READY_SOUND "play-ready-sound"
void unity_greeter_show (UnityGreeter* self);
void user_list_clear_messages (UserList* self);
void user_list_show_message (UserList* self, const gchar* text, gboolean is_error);
Prompt* prompt_new (const gchar* text, LightDMPromptType type);
Prompt* prompt_construct (GType object_type, const gchar* text, LightDMPromptType type);
static void unity_greeter_set_prompt (UnityGreeter* self, const gchar* text, LightDMPromptType type);
const gchar* user_list_get_manual_username (UserList* self);
void user_list_set_manual_username (UserList* self, const gchar* value);
void user_list_show_prompt (UserList* self, const gchar* text, gboolean secret);
static void unity_greeter_background_loaded_cb (UnityGreeter* self, GParamSpec* pspec);
GType background_get_type (void) G_GNUC_CONST;
gdouble background_get_alpha (Background* self);
static void _unity_greeter_background_loaded_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_greeter_start_session (UnityGreeter* self);
GType background_draw_flags_get_type (void) G_GNUC_CONST;
void background_draw_full (Background* self, cairo_t* c, BackgroundDrawFlags flags);
static void unity_greeter_refresh_background (UnityGreeter* self, GdkScreen* screen, cairo_surface_t* surface);
const gchar* user_list_get_session (UserList* self);
void user_list_login_complete (UserList* self);
void user_list_show_authenticated (UserList* self, gboolean successful);
gboolean user_list_have_messages (UserList* self);
static void unity_greeter_start_authentication (UnityGreeter* self);
static GdkFilterReturn unity_greeter_focus_upon_map (UnityGreeter* self, GdkXEvent* gxevent, GdkEvent* event);
GtkWindow* menu_bar_get_keyboard_window (MenuBar* self);
static GdkFilterReturn _unity_greeter_focus_upon_map_gdk_filter_func (GdkXEvent* xevent, GdkEvent* event, gpointer self);
static cairo_surface_t* unity_greeter_create_root_surface (GdkScreen* screen);
static void unity_greeter_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message);
gint unity_greeter_main (gchar** args, int args_length1);
static void _unity_greeter_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
gchar* ug_settings_get_string (const gchar* key);
#define UG_SETTINGS_KEY_THEME_NAME "theme-name"
#define UG_SETTINGS_KEY_ICON_THEME_NAME "icon-theme-name"
#define UG_SETTINGS_KEY_FONT_NAME "font-name"
gdouble ug_settings_get_double (const gchar* key);
#define UG_SETTINGS_KEY_XFT_DPI "xft-dpi"
#define UG_SETTINGS_KEY_XFT_ANTIALIAS "xft-antialias"
#define UG_SETTINGS_KEY_XFT_HINTSTYLE "xft-hintstyle"
#define UG_SETTINGS_KEY_XFT_RGBA "xft-rgba"
static void unity_greeter_finalize (UnityGreeter* obj);
enum  {
	PROMPT_DUMMY_PROPERTY
};
static void prompt_finalize (Prompt* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry UNITY_GREETER_options[3] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &unity_greeter_show_version, "Show release version", NULL}, {"test-mode", (gchar) 0, 0, G_OPTION_ARG_NONE, &unity_greeter_test_mode, "Run in test mode", NULL}, {NULL}};
static const TestEntry UNITY_GREETER_test_entries[27] = {{"has-password", "Has Password", "*", "uk;us", FALSE, FALSE, NULL}, {"different-prompt", "Different Prompt", "*", "uk;us", FALSE, FALSE, NULL}, {"no-password", "No Password", "*", "uk;us", FALSE, FALSE, NULL}, {"change-password", "Change Password", "*", "uk;us", FALSE, FALSE, NULL}, {"auth-error", "Auth Error", "*", "uk;us", FALSE, FALSE, NULL}, {"two-factor", "Two Factor", "*", "uk;us", FALSE, FALSE, NULL}, {"two-prompts", "Two Prompts", "*", "uk;us", FALSE, FALSE, NULL}, {"info-prompt", "Info Prompt", "*", "uk;us", FALSE, FALSE, NULL}, {"long-info-prompt", "Long Info Prompt", "*", "uk;us", FALSE, FALSE, NULL}, {"wide-info-prompt", "Wide Info Prompt", "*", "uk;us", FALSE, FALSE, NULL}, {"multi-info-prompt", "Multi Info Prompt", "*", "uk;us", FALSE, FALSE, NULL}, {"very-very-long-name", "Long name (far too long to fit)", "*", "uk;us", FALSE, FALSE, NULL}, {"long-name-and-messages", "Long name and messages", "*", "uk;us", FALSE, TRUE, NULL}, {"active", "Active Account", "*", "uk;us", TRUE, FALSE, NULL}, {"has-messages", "Has Messages", "*", "uk;us", FALSE, TRUE, NULL}, {"gnome", "GNOME", "*", "uk;us", FALSE, FALSE, "gnome-shell"}, {"locked", "Locked Account", "*", "uk;us", FALSE, FALSE, NULL}, {"color-background", "Color Background", "#dd4814", "uk;us", FALSE, FALSE, NULL}, {"white-background", "White Background", "#ffffff", "uk;us", FALSE, FALSE, NULL}, {"black-background", "Black Background", "#000000", "uk;us", FALSE, FALSE, NULL}, {"no-background", "No Background", NULL, "uk;us", FALSE, FALSE, NULL}, {"unicode", "가나다라마", "*", "uk;us", FALSE, FALSE, NULL}, {"system-layout", "System Layout", "*", NULL, FALSE, FALSE, NULL}, {"four-layouts", "Four Layouts", "*", "de\tdvorak;ca;gb;fr\toss", FALSE, FALSE, NULL}, {"hy-layout", "Layout Is 'hy'", "*", "am\teastern-alt", FALSE, FALSE, NULL}, {"no-response", "No Response", "*", NULL, FALSE, FALSE, NULL}, {"", "", NULL, NULL, FALSE, FALSE, NULL}};

static void _prompt_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (prompt_unref (var), NULL));
}


static void _g_list_free__prompt_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _prompt_unref0_, NULL);
	g_list_free (self);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void _unity_greeter_show_message_cb_lightdm_greeter_show_message (LightDMGreeter* _sender, const gchar* text, LightDMMessageType type, gpointer self) {
	unity_greeter_show_message_cb (self, text, type);
}


static void _unity_greeter_show_prompt_cb_lightdm_greeter_show_prompt (LightDMGreeter* _sender, const gchar* text, LightDMPromptType type, gpointer self) {
	unity_greeter_show_prompt_cb (self, text, type);
}


static void __lambda7_ (UnityGreeter* self) {
	LightDMGreeter* _tmp0_;
	_tmp0_ = self->priv->greeter;
	lightdm_greeter_authenticate_autologin (_tmp0_);
}


static void ___lambda7__lightdm_greeter_autologin_timer_expired (LightDMGreeter* _sender, gpointer self) {
	__lambda7_ (self);
}


static void _unity_greeter_authentication_complete_cb_lightdm_greeter_authentication_complete (LightDMGreeter* _sender, gpointer self) {
	unity_greeter_authentication_complete_cb (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _unity_greeter_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = unity_greeter_key_press_cb (self, event);
	return result;
}


static void _unity_greeter_user_added_cb_lightdm_user_list_user_added (LightDMUserList* _sender, LightDMUser* user, gpointer self) {
	unity_greeter_user_added_cb (self, user);
}


static void _unity_greeter_user_added_cb_lightdm_user_list_user_changed (LightDMUserList* _sender, LightDMUser* user, gpointer self) {
	unity_greeter_user_added_cb (self, user);
}


static void _unity_greeter_user_removed_cb_lightdm_user_list_user_removed (LightDMUserList* _sender, LightDMUser* user, gpointer self) {
	unity_greeter_user_removed_cb (self, user);
}


static void _unity_greeter_user_selected_cb_user_list_user_selected (UserList* _sender, const gchar* username, gpointer self) {
	unity_greeter_user_selected_cb (self, username);
}


static void _unity_greeter_respond_to_prompt_cb_user_list_respond_to_prompt (UserList* _sender, const gchar* text, gpointer self) {
	unity_greeter_respond_to_prompt_cb (self, text);
}


static void _unity_greeter_start_session_cb_user_list_start_session (UserList* _sender, gpointer self) {
	unity_greeter_start_session_cb (self);
}


static gboolean _unity_greeter_ready_cb_gsource_func (gpointer self) {
	gboolean result;
	result = unity_greeter_ready_cb (self);
	return result;
}


UnityGreeter* unity_greeter_construct (GType object_type) {
	UnityGreeter* self = NULL;
	LightDMGreeter* _tmp0_;
	LightDMGreeter* _tmp1_;
	LightDMGreeter* _tmp2_;
	LightDMGreeter* _tmp3_;
	LightDMGreeter* _tmp4_;
	gboolean connected;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* state_dir;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	GKeyFile* _tmp20_;
	gchar* _tmp27_;
	gchar* last_user;
	MainWindow* _tmp31_;
	MainWindow* _tmp32_;
	MainWindow* _tmp33_;
	UserList* _tmp34_;
	UserList* _tmp35_;
	gboolean _tmp36_;
	UserList* _tmp84_;
	UserList* _tmp85_;
	UserList* _tmp86_;
	UserList* _tmp87_;
	const gchar* _tmp88_;
	const gchar* _tmp89_;
	GError * _inner_error_ = NULL;
	self = (UnityGreeter*) g_type_create_instance (object_type);
	_tmp0_ = lightdm_greeter_new ();
	_g_object_unref0 (self->priv->greeter);
	self->priv->greeter = _tmp0_;
	_tmp1_ = self->priv->greeter;
	g_signal_connect (_tmp1_, "show-message", (GCallback) _unity_greeter_show_message_cb_lightdm_greeter_show_message, self);
	_tmp2_ = self->priv->greeter;
	g_signal_connect (_tmp2_, "show-prompt", (GCallback) _unity_greeter_show_prompt_cb_lightdm_greeter_show_prompt, self);
	_tmp3_ = self->priv->greeter;
	g_signal_connect (_tmp3_, "autologin-timer-expired", (GCallback) ___lambda7__lightdm_greeter_autologin_timer_expired, self);
	_tmp4_ = self->priv->greeter;
	g_signal_connect (_tmp4_, "authentication-complete", (GCallback) _unity_greeter_authentication_complete_cb_lightdm_greeter_authentication_complete, self);
	connected = FALSE;
	{
		LightDMGreeter* _tmp5_;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		_tmp5_ = self->priv->greeter;
		_tmp6_ = lightdm_greeter_connect_sync (_tmp5_, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
		connected = _tmp7_;
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("unity-greeter.vala:112: Failed to connect to LightDM daemon");
		_g_error_free0 (e);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp9_ = connected;
	if (!_tmp9_) {
		gboolean _tmp10_;
		_tmp10_ = unity_greeter_test_mode;
		_tmp8_ = !_tmp10_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp11_ = _tmp8_;
	if (_tmp11_) {
		exit (EXIT_FAILURE);
	}
	_tmp12_ = unity_greeter_test_mode;
	if (!_tmp12_) {
		SettingsDaemon* _tmp13_;
		SettingsDaemon* _tmp14_;
		_tmp13_ = settings_daemon_new ();
		_g_object_unref0 (self->priv->settings_daemon);
		self->priv->settings_daemon = _tmp13_;
		_tmp14_ = self->priv->settings_daemon;
		settings_daemon_start (_tmp14_, NULL, NULL);
	}
	_tmp15_ = g_get_user_cache_dir ();
	_tmp16_ = g_build_filename (_tmp15_, "unity-greeter", NULL);
	state_dir = _tmp16_;
	_tmp17_ = state_dir;
	g_mkdir_with_parents (_tmp17_, 0775);
	_tmp18_ = state_dir;
	_tmp19_ = g_build_filename (_tmp18_, "state", NULL);
	_g_free0 (self->priv->state_file);
	self->priv->state_file = _tmp19_;
	_tmp20_ = g_key_file_new ();
	_g_key_file_free0 (self->priv->state);
	self->priv->state = _tmp20_;
	{
		GKeyFile* _tmp21_;
		const gchar* _tmp22_;
		_tmp21_ = self->priv->state;
		_tmp22_ = self->priv->state_file;
		g_key_file_load_from_file (_tmp21_, _tmp22_, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = e;
		if (!g_error_matches (_tmp23_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			const gchar* _tmp24_;
			GError* _tmp25_;
			const gchar* _tmp26_;
			_tmp24_ = self->priv->state_file;
			_tmp25_ = e;
			_tmp26_ = _tmp25_->message;
			g_warning ("unity-greeter.vala:135: Failed to load state from %s: %s\n", _tmp24_, _tmp26_);
		}
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_free0 (state_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp27_ = g_strdup ("");
	last_user = _tmp27_;
	{
		GKeyFile* _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		_tmp28_ = self->priv->state;
		_tmp29_ = g_key_file_get_value (_tmp28_, "greeter", "last-user", &_inner_error_);
		_tmp30_ = _tmp29_;
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
		_g_free0 (last_user);
		last_user = _tmp30_;
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		_g_free0 (last_user);
		_g_free0 (state_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp31_ = main_window_new ();
	_tmp32_ = g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->main_window);
	self->priv->main_window = _tmp32_;
	_tmp33_ = self->priv->main_window;
	_tmp34_ = _tmp33_->user_list;
	_tmp35_ = _g_object_ref0 (_tmp34_);
	_g_object_unref0 (self->user_list);
	self->user_list = _tmp35_;
	_tmp36_ = unity_greeter_test_mode;
	if (_tmp36_) {
		UserList* _tmp45_;
		MainWindow* _tmp46_;
		const gchar* _tmp47_;
		__g_list_free__g_free0_0 (self->priv->test_backgrounds);
		self->priv->test_backgrounds = NULL;
		{
			GDir* _tmp37_ = NULL;
			GDir* dir;
			_tmp37_ = g_dir_open ("/usr/share/backgrounds/", (guint) 0, &_inner_error_);
			dir = _tmp37_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch15_g_file_error;
				}
				_g_free0 (last_user);
				_g_free0 (state_dir);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			while (TRUE) {
				GDir* _tmp38_;
				const gchar* _tmp39_ = NULL;
				gchar* _tmp40_;
				gchar* bg;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				gchar* _tmp43_;
				_tmp38_ = dir;
				_tmp39_ = g_dir_read_name (_tmp38_);
				_tmp40_ = g_strdup (_tmp39_);
				bg = _tmp40_;
				_tmp41_ = bg;
				if (_tmp41_ == NULL) {
					_g_free0 (bg);
					break;
				}
				_tmp42_ = bg;
				_tmp43_ = g_strconcat ("/usr/share/backgrounds/", _tmp42_, NULL);
				self->priv->test_backgrounds = g_list_append (self->priv->test_backgrounds, _tmp43_);
				_g_free0 (bg);
			}
			_g_dir_close0 (dir);
		}
		goto __finally15;
		__catch15_g_file_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally15:
		if (_inner_error_ != NULL) {
			_g_free0 (last_user);
			_g_free0 (state_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		while (TRUE) {
			gboolean _tmp44_ = FALSE;
			_tmp44_ = unity_greeter_add_test_entry (self);
			if (!_tmp44_) {
				break;
			}
		}
		_tmp45_ = self->user_list;
		user_list_set_offer_guest (_tmp45_, TRUE);
		_tmp46_ = self->priv->main_window;
		g_signal_connect ((GtkWidget*) _tmp46_, "key-press-event", (GCallback) _unity_greeter_key_press_cb_gtk_widget_key_press_event, self);
		_tmp47_ = last_user;
		if (_tmp47_ != NULL) {
			UserList* _tmp48_;
			const gchar* _tmp49_;
			_tmp48_ = self->user_list;
			_tmp49_ = last_user;
			user_list_set_active_entry (_tmp48_, _tmp49_);
		}
	} else {
		UserList* _tmp50_;
		LightDMGreeter* _tmp51_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		UserList* _tmp54_;
		LightDMGreeter* _tmp55_;
		gboolean _tmp56_;
		gboolean _tmp57_;
		LightDMGreeter* _tmp58_;
		gboolean _tmp59_;
		gboolean _tmp60_;
		LightDMGreeter* _tmp70_;
		gboolean _tmp71_;
		gboolean _tmp72_;
		LightDMGreeter* _tmp74_;
		const gchar* _tmp75_;
		const gchar* _tmp76_;
		_tmp50_ = self->user_list;
		_tmp51_ = self->priv->greeter;
		_tmp52_ = lightdm_greeter_get_default_session_hint (_tmp51_);
		_tmp53_ = _tmp52_;
		user_list_set_default_session (_tmp50_, _tmp53_);
		_tmp54_ = self->user_list;
		_tmp55_ = self->priv->greeter;
		_tmp56_ = lightdm_greeter_get_show_manual_login_hint (_tmp55_);
		_tmp57_ = _tmp56_;
		user_list_set_always_show_manual (_tmp54_, _tmp57_);
		_tmp58_ = self->priv->greeter;
		_tmp59_ = lightdm_greeter_get_hide_users_hint (_tmp58_);
		_tmp60_ = _tmp59_;
		if (!_tmp60_) {
			LightDMUserList* _tmp61_ = NULL;
			LightDMUserList* _tmp62_;
			LightDMUserList* users;
			LightDMUserList* _tmp63_;
			LightDMUserList* _tmp64_;
			LightDMUserList* _tmp65_;
			LightDMUserList* _tmp66_;
			GList* _tmp67_;
			GList* _tmp68_;
			_tmp61_ = lightdm_user_list_get_instance ();
			_tmp62_ = _g_object_ref0 (_tmp61_);
			users = _tmp62_;
			_tmp63_ = users;
			g_signal_connect (_tmp63_, "user-added", (GCallback) _unity_greeter_user_added_cb_lightdm_user_list_user_added, self);
			_tmp64_ = users;
			g_signal_connect (_tmp64_, "user-changed", (GCallback) _unity_greeter_user_added_cb_lightdm_user_list_user_changed, self);
			_tmp65_ = users;
			g_signal_connect (_tmp65_, "user-removed", (GCallback) _unity_greeter_user_removed_cb_lightdm_user_list_user_removed, self);
			_tmp66_ = users;
			_tmp67_ = lightdm_user_list_get_users (_tmp66_);
			_tmp68_ = _tmp67_;
			{
				GList* user_collection = NULL;
				GList* user_it = NULL;
				user_collection = _tmp68_;
				for (user_it = user_collection; user_it != NULL; user_it = user_it->next) {
					LightDMUser* user = NULL;
					user = (LightDMUser*) user_it->data;
					{
						LightDMUser* _tmp69_;
						_tmp69_ = user;
						unity_greeter_user_added_cb (self, _tmp69_);
					}
				}
			}
			_g_object_unref0 (users);
		}
		_tmp70_ = self->priv->greeter;
		_tmp71_ = lightdm_greeter_get_has_guest_account_hint (_tmp70_);
		_tmp72_ = _tmp71_;
		if (_tmp72_) {
			UserList* _tmp73_;
			g_debug ("unity-greeter.vala:189: Adding guest account entry");
			_tmp73_ = self->user_list;
			user_list_set_offer_guest (_tmp73_, TRUE);
		}
		_tmp74_ = self->priv->greeter;
		_tmp75_ = lightdm_greeter_get_select_user_hint (_tmp74_);
		_tmp76_ = _tmp75_;
		if (_tmp76_ != NULL) {
			UserList* _tmp77_;
			LightDMGreeter* _tmp78_;
			const gchar* _tmp79_;
			const gchar* _tmp80_;
			_tmp77_ = self->user_list;
			_tmp78_ = self->priv->greeter;
			_tmp79_ = lightdm_greeter_get_select_user_hint (_tmp78_);
			_tmp80_ = _tmp79_;
			user_list_set_active_entry (_tmp77_, _tmp80_);
		} else {
			const gchar* _tmp81_;
			_tmp81_ = last_user;
			if (_tmp81_ != NULL) {
				UserList* _tmp82_;
				const gchar* _tmp83_;
				_tmp82_ = self->user_list;
				_tmp83_ = last_user;
				user_list_set_active_entry (_tmp82_, _tmp83_);
			}
		}
	}
	_tmp84_ = self->user_list;
	g_signal_connect (_tmp84_, "user-selected", (GCallback) _unity_greeter_user_selected_cb_user_list_user_selected, self);
	_tmp85_ = self->user_list;
	g_signal_connect (_tmp85_, "respond-to-prompt", (GCallback) _unity_greeter_respond_to_prompt_cb_user_list_respond_to_prompt, self);
	_tmp86_ = self->user_list;
	g_signal_connect (_tmp86_, "start-session", (GCallback) _unity_greeter_start_session_cb_user_list_start_session, self);
	_tmp87_ = self->user_list;
	_tmp88_ = user_list_get_selected (_tmp87_);
	_tmp89_ = _tmp88_;
	unity_greeter_user_selected_cb (self, _tmp89_);
	unity_greeter_start_fake_wm (self);
	gdk_threads_add_idle (_unity_greeter_ready_cb_gsource_func, self);
	_g_free0 (last_user);
	_g_free0 (state_dir);
	return self;
}


UnityGreeter* unity_greeter_new (void) {
	return unity_greeter_construct (TYPE_UNITY_GREETER);
}


static gboolean unity_greeter_key_press_cb (UnityGreeter* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey _tmp0_;
	GdkModifierType _tmp1_;
	GdkEventKey _tmp2_;
	guint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.state;
	if ((_tmp1_ & GDK_CONTROL_MASK) == 0) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.keyval;
	switch (_tmp3_) {
		case GDK_KEY_plus:
		{
			unity_greeter_add_test_entry (self);
			break;
		}
		case GDK_KEY_minus:
		{
			unity_greeter_remove_test_entry (self);
			break;
		}
		case GDK_KEY_0:
		{
			UserList* _tmp5_;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				_tmp4_ = unity_greeter_remove_test_entry (self);
				if (!_tmp4_) {
					break;
				}
			}
			_tmp5_ = self->user_list;
			user_list_set_offer_guest (_tmp5_, FALSE);
			break;
		}
		case GDK_KEY_equal:
		{
			UserList* _tmp7_;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				_tmp6_ = unity_greeter_add_test_entry (self);
				if (!_tmp6_) {
					break;
				}
			}
			_tmp7_ = self->user_list;
			user_list_set_offer_guest (_tmp7_, TRUE);
			break;
		}
		case GDK_KEY_g:
		{
			UserList* _tmp8_;
			_tmp8_ = self->user_list;
			user_list_set_offer_guest (_tmp8_, FALSE);
			break;
		}
		case GDK_KEY_G:
		{
			UserList* _tmp9_;
			_tmp9_ = self->user_list;
			user_list_set_offer_guest (_tmp9_, TRUE);
			break;
		}
		case GDK_KEY_m:
		{
			UserList* _tmp10_;
			_tmp10_ = self->user_list;
			user_list_set_always_show_manual (_tmp10_, FALSE);
			break;
		}
		case GDK_KEY_M:
		{
			UserList* _tmp11_;
			_tmp11_ = self->user_list;
			user_list_set_always_show_manual (_tmp11_, TRUE);
			break;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean unity_greeter_add_test_entry (UnityGreeter* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	TestEntry _tmp1_;
	TestEntry _tmp2_ = {0};
	TestEntry e;
	TestEntry _tmp3_;
	const gchar* _tmp4_;
	TestEntry _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* background;
	const gchar* _tmp8_;
	UserList* _tmp26_;
	TestEntry _tmp27_;
	const gchar* _tmp28_;
	TestEntry _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	TestEntry _tmp32_;
	const gchar* _tmp33_;
	GList* _tmp34_ = NULL;
	GList* _tmp35_;
	TestEntry _tmp36_;
	gboolean _tmp37_;
	TestEntry _tmp38_;
	gboolean _tmp39_;
	TestEntry _tmp40_;
	const gchar* _tmp41_;
	gint _tmp42_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->n_test_entries;
	_tmp1_ = UNITY_GREETER_test_entries[_tmp0_];
	test_entry_copy (&_tmp1_, &_tmp2_);
	e = _tmp2_;
	_tmp3_ = e;
	_tmp4_ = _tmp3_.username;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		result = FALSE;
		test_entry_destroy (&e);
		return result;
	}
	_tmp5_ = e;
	_tmp6_ = _tmp5_.background;
	_tmp7_ = g_strdup (_tmp6_);
	background = _tmp7_;
	_tmp8_ = background;
	if (g_strcmp0 (_tmp8_, "*") == 0) {
		gint background_index;
		GList* _tmp18_;
		guint _tmp19_ = 0U;
		background_index = 0;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp9_;
				_tmp9_ = TRUE;
				while (TRUE) {
					gboolean _tmp10_;
					gint _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					TestEntry _tmp15_;
					const gchar* _tmp16_;
					_tmp10_ = _tmp9_;
					if (!_tmp10_) {
						gint _tmp11_;
						_tmp11_ = i;
						i = _tmp11_ + 1;
					}
					_tmp9_ = FALSE;
					_tmp12_ = i;
					_tmp13_ = self->priv->n_test_entries;
					if (!(_tmp12_ < _tmp13_)) {
						break;
					}
					_tmp14_ = i;
					_tmp15_ = UNITY_GREETER_test_entries[_tmp14_];
					_tmp16_ = _tmp15_.background;
					if (g_strcmp0 (_tmp16_, "*") == 0) {
						gint _tmp17_;
						_tmp17_ = background_index;
						background_index = _tmp17_ + 1;
					}
				}
			}
		}
		_tmp18_ = self->priv->test_backgrounds;
		_tmp19_ = g_list_length (_tmp18_);
		if (_tmp19_ > ((guint) 0)) {
			GList* _tmp20_;
			gint _tmp21_;
			GList* _tmp22_;
			guint _tmp23_ = 0U;
			gconstpointer _tmp24_ = NULL;
			gchar* _tmp25_;
			_tmp20_ = self->priv->test_backgrounds;
			_tmp21_ = background_index;
			_tmp22_ = self->priv->test_backgrounds;
			_tmp23_ = g_list_length (_tmp22_);
			_tmp24_ = g_list_nth_data (_tmp20_, _tmp21_ % _tmp23_);
			_tmp25_ = g_strdup ((const gchar*) _tmp24_);
			_g_free0 (background);
			background = _tmp25_;
		}
	}
	_tmp26_ = self->user_list;
	_tmp27_ = e;
	_tmp28_ = _tmp27_.username;
	_tmp29_ = e;
	_tmp30_ = _tmp29_.real_name;
	_tmp31_ = background;
	_tmp32_ = e;
	_tmp33_ = _tmp32_.layouts;
	_tmp34_ = unity_greeter_make_layout_list (self, _tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = e;
	_tmp37_ = _tmp36_.is_active;
	_tmp38_ = e;
	_tmp39_ = _tmp38_.has_messages;
	_tmp40_ = e;
	_tmp41_ = _tmp40_.session;
	user_list_add_entry (_tmp26_, _tmp28_, _tmp30_, _tmp31_, _tmp35_, _tmp37_, _tmp39_, _tmp41_);
	__g_list_free__g_object_unref0_0 (_tmp35_);
	_tmp42_ = self->priv->n_test_entries;
	self->priv->n_test_entries = _tmp42_ + 1;
	result = TRUE;
	_g_free0 (background);
	test_entry_destroy (&e);
	return result;
}


static gboolean unity_greeter_remove_test_entry (UnityGreeter* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	UserList* _tmp1_;
	gint _tmp2_;
	TestEntry _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->n_test_entries;
	if (_tmp0_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->user_list;
	_tmp2_ = self->priv->n_test_entries;
	_tmp3_ = UNITY_GREETER_test_entries[_tmp2_ - 1];
	_tmp4_ = _tmp3_.username;
	user_list_remove_entry (_tmp1_, _tmp4_);
	_tmp5_ = self->priv->n_test_entries;
	self->priv->n_test_entries = _tmp5_ - 1;
	result = TRUE;
	return result;
}


void unity_greeter_add_style_class (GtkWidget* widget) {
	GtkWidget* _tmp0_;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* ctx;
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_widget_get_style_context (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	ctx = _tmp2_;
	gtk_style_context_add_class (ctx, "lightdm");
	_g_object_unref0 (ctx);
}


static GList* unity_greeter_make_layout_list (UnityGreeter* self, const gchar* names) {
	GList* result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** names_split;
	gint names_split_length1;
	gint _names_split_size_;
	GList* layouts;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (names != NULL, NULL);
	_tmp0_ = names;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ";", 0);
	names_split = _tmp2_;
	names_split_length1 = _vala_array_length (_tmp1_);
	_names_split_size_ = names_split_length1;
	layouts = NULL;
	_tmp3_ = names_split;
	_tmp3__length1 = names_split_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp3_;
		name_collection_length1 = _tmp3__length1;
		for (name_it = 0; name_it < _tmp3__length1; name_it = name_it + 1) {
			gchar* _tmp4_;
			gchar* name = NULL;
			_tmp4_ = g_strdup (name_collection[name_it]);
			name = _tmp4_;
			{
				const gchar* _tmp5_;
				LightDMLayout* _tmp6_ = NULL;
				LightDMLayout* layout;
				LightDMLayout* _tmp7_;
				_tmp5_ = name;
				_tmp6_ = unity_greeter_get_layout_by_name (_tmp5_);
				layout = _tmp6_;
				_tmp7_ = layout;
				if (_tmp7_ != NULL) {
					LightDMLayout* _tmp8_;
					LightDMLayout* _tmp9_;
					_tmp8_ = layout;
					_tmp9_ = _g_object_ref0 (_tmp8_);
					layouts = g_list_append (layouts, _tmp9_);
				}
				_g_object_unref0 (layout);
				_g_free0 (name);
			}
		}
	}
	result = layouts;
	names_split = (_vala_array_free (names_split, names_split_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


LightDMLayout* unity_greeter_get_layout_by_name (const gchar* name) {
	LightDMLayout* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = lightdm_get_layouts ();
	{
		GList* layout_collection = NULL;
		GList* layout_it = NULL;
		layout_collection = _tmp0_;
		for (layout_it = layout_collection; layout_it != NULL; layout_it = layout_it->next) {
			LightDMLayout* layout = NULL;
			layout = (LightDMLayout*) layout_it->data;
			{
				LightDMLayout* _tmp1_;
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp1_ = layout;
				_tmp2_ = lightdm_layout_get_name (_tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = name;
				if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
					LightDMLayout* _tmp5_;
					LightDMLayout* _tmp6_;
					_tmp5_ = layout;
					_tmp6_ = _g_object_ref0 (_tmp5_);
					result = _tmp6_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gboolean unity_greeter_ready_cb (UnityGreeter* self) {
	gboolean result = FALSE;
	ca_context* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_debug ("unity-greeter.vala:315: starting system-ready sound");
	ca_context_create (&_tmp0_);
	_ca_context_destroy0 (self->priv->canberra_context);
	self->priv->canberra_context = _tmp0_;
	_tmp1_ = ug_settings_get_boolean (UG_SETTINGS_KEY_PLAY_READY_SOUND);
	if (_tmp1_) {
		ca_context* _tmp2_;
		_tmp2_ = self->priv->canberra_context;
		ca_context_play (_tmp2_, (guint32) 0, CA_PROP_CANBERRA_XDG_THEME_NAME, "ubuntu", CA_PROP_EVENT_ID, "system-ready", NULL);
	}
	result = FALSE;
	return result;
}


static void unity_greeter_user_added_cb (UnityGreeter* self, LightDMUser* user) {
	LightDMUser* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	LightDMUser* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	LightDMUser* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* label;
	LightDMUser* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GList* layouts;
	LightDMUser* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_ = NULL;
	UserList* _tmp26_;
	LightDMUser* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	LightDMUser* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	GList* _tmp34_;
	LightDMUser* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	LightDMUser* _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	LightDMUser* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (user != NULL);
	_tmp0_ = user;
	_tmp1_ = lightdm_user_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = user;
	_tmp4_ = lightdm_user_get_real_name (_tmp3_);
	_tmp5_ = _tmp4_;
	g_debug ("unity-greeter.vala:332: Adding/updating user %s (%s)", _tmp2_, _tmp5_);
	_tmp6_ = user;
	_tmp7_ = lightdm_user_get_real_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup (_tmp8_);
	label = _tmp9_;
	_tmp10_ = user;
	_tmp11_ = lightdm_user_get_real_name (_tmp10_);
	_tmp12_ = _tmp11_;
	if (g_strcmp0 (_tmp12_, "") == 0) {
		LightDMUser* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp13_ = user;
		_tmp14_ = lightdm_user_get_name (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (label);
		label = _tmp16_;
	}
	layouts = NULL;
	_tmp17_ = user;
	_tmp19_ = _tmp18_ = lightdm_user_get_layouts (_tmp17_);
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp19_;
		name_collection_length1 = _vala_array_length (_tmp18_);
		for (name_it = 0; name_it < _vala_array_length (_tmp18_); name_it = name_it + 1) {
			gchar* _tmp20_;
			gchar* name = NULL;
			_tmp20_ = g_strdup (name_collection[name_it]);
			name = _tmp20_;
			{
				const gchar* _tmp21_;
				LightDMLayout* _tmp22_ = NULL;
				LightDMLayout* layout;
				LightDMLayout* _tmp23_;
				_tmp21_ = name;
				_tmp22_ = unity_greeter_get_layout_by_name (_tmp21_);
				layout = _tmp22_;
				_tmp23_ = layout;
				if (_tmp23_ != NULL) {
					LightDMLayout* _tmp24_;
					LightDMLayout* _tmp25_;
					_tmp24_ = layout;
					_tmp25_ = _g_object_ref0 (_tmp24_);
					layouts = g_list_append (layouts, _tmp25_);
				}
				_g_object_unref0 (layout);
				_g_free0 (name);
			}
		}
	}
	_tmp26_ = self->user_list;
	_tmp27_ = user;
	_tmp28_ = lightdm_user_get_name (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = label;
	_tmp31_ = user;
	_tmp32_ = lightdm_user_get_background (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = layouts;
	_tmp35_ = user;
	_tmp36_ = lightdm_user_get_logged_in (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = user;
	_tmp39_ = lightdm_user_get_has_messages (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = user;
	_tmp42_ = lightdm_user_get_session (_tmp41_);
	_tmp43_ = _tmp42_;
	user_list_add_entry (_tmp26_, _tmp29_, _tmp30_, _tmp33_, _tmp34_, _tmp37_, _tmp40_, _tmp43_);
	__g_list_free__g_object_unref0_0 (layouts);
	_g_free0 (label);
}


static void unity_greeter_user_removed_cb (UnityGreeter* self, LightDMUser* user) {
	LightDMUser* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	UserList* _tmp3_;
	LightDMUser* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (user != NULL);
	_tmp0_ = user;
	_tmp1_ = lightdm_user_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("unity-greeter.vala:351: Removing user %s", _tmp2_);
	_tmp3_ = self->user_list;
	_tmp4_ = user;
	_tmp5_ = lightdm_user_get_name (_tmp4_);
	_tmp6_ = _tmp5_;
	user_list_remove_entry (_tmp3_, _tmp6_);
}


void unity_greeter_show (UnityGreeter* self) {
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	GdkWindow* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("unity-greeter.vala:357: Showing main window");
	_tmp0_ = self->priv->main_window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->main_window;
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) _tmp1_);
	gdk_window_focus (_tmp2_, (guint32) GDK_CURRENT_TIME);
}


static void unity_greeter_show_message_cb (UnityGreeter* self, const gchar* text, LightDMMessageType type) {
	gboolean _tmp0_;
	UserList* _tmp2_;
	const gchar* _tmp3_;
	LightDMMessageType _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->clear_messages;
	if (_tmp0_) {
		UserList* _tmp1_;
		_tmp1_ = self->user_list;
		user_list_clear_messages (_tmp1_);
		self->priv->clear_messages = FALSE;
	}
	_tmp2_ = self->user_list;
	_tmp3_ = text;
	_tmp4_ = type;
	user_list_show_message (_tmp2_, _tmp3_, _tmp4_ == LIGHTDM_MESSAGE_TYPE_ERROR);
}


static void unity_greeter_show_prompt_cb (UnityGreeter* self, const gchar* text, LightDMPromptType type) {
	const gchar* _tmp0_;
	LightDMPromptType _tmp1_;
	Prompt* _tmp2_;
	GList* _tmp3_;
	guint _tmp4_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	_tmp1_ = type;
	_tmp2_ = prompt_new (_tmp0_, _tmp1_);
	self->priv->active_prompts = g_list_append (self->priv->active_prompts, _tmp2_);
	_tmp3_ = self->priv->active_prompts;
	_tmp4_ = g_list_length (_tmp3_);
	if (_tmp4_ == ((guint) 1)) {
		const gchar* _tmp5_;
		LightDMPromptType _tmp6_;
		_tmp5_ = text;
		_tmp6_ = type;
		unity_greeter_set_prompt (self, _tmp5_, _tmp6_);
	}
}


static void unity_greeter_set_prompt (UnityGreeter* self, const gchar* text, LightDMPromptType type) {
	gboolean _tmp0_;
	gboolean _tmp2_ = FALSE;
	UserList* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp9_;
	const gchar* _tmp17_;
	const gchar* _tmp19_;
	UserList* _tmp21_;
	const gchar* _tmp22_;
	LightDMPromptType _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->clear_messages;
	if (_tmp0_) {
		UserList* _tmp1_;
		_tmp1_ = self->user_list;
		user_list_clear_messages (_tmp1_);
		self->priv->clear_messages = FALSE;
	}
	_tmp3_ = self->user_list;
	_tmp4_ = user_list_get_selected (_tmp3_);
	_tmp5_ = _tmp4_;
	if (g_strcmp0 (_tmp5_, "*other") == 0) {
		UserList* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = self->user_list;
		_tmp7_ = user_list_get_manual_username (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp9_ = _tmp2_;
	if (_tmp9_) {
		gboolean _tmp10_;
		_tmp10_ = unity_greeter_test_mode;
		if (_tmp10_) {
			UserList* _tmp11_;
			const gchar* _tmp12_;
			_tmp11_ = self->user_list;
			_tmp12_ = self->priv->test_username;
			user_list_set_manual_username (_tmp11_, _tmp12_);
		} else {
			UserList* _tmp13_;
			LightDMGreeter* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp13_ = self->user_list;
			_tmp14_ = self->priv->greeter;
			_tmp15_ = lightdm_greeter_get_authentication_user (_tmp14_);
			_tmp16_ = _tmp15_;
			user_list_set_manual_username (_tmp13_, _tmp16_);
		}
	}
	self->priv->prompted = TRUE;
	_tmp17_ = text;
	if (g_strcmp0 (_tmp17_, "Password: ") == 0) {
		const gchar* _tmp18_ = NULL;
		_tmp18_ = _ ("Password:");
		text = _tmp18_;
	}
	_tmp19_ = text;
	if (g_strcmp0 (_tmp19_, "login:") == 0) {
		const gchar* _tmp20_ = NULL;
		_tmp20_ = _ ("Username:");
		text = _tmp20_;
	}
	_tmp21_ = self->user_list;
	_tmp22_ = text;
	_tmp23_ = type;
	user_list_show_prompt (_tmp21_, _tmp22_, _tmp23_ == LIGHTDM_PROMPT_TYPE_SECRET);
	self->priv->clear_messages = TRUE;
}


static void _unity_greeter_background_loaded_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_greeter_background_loaded_cb (self, pspec);
}


static void unity_greeter_background_loaded_cb (UnityGreeter* self, GParamSpec* pspec) {
	UserList* _tmp0_;
	Background* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->user_list;
	_tmp1_ = _tmp0_->background;
	_tmp2_ = background_get_alpha (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 1.0) {
		UserList* _tmp4_;
		Background* _tmp5_;
		guint _tmp6_ = 0U;
		GQuark _tmp7_ = 0U;
		_tmp4_ = self->user_list;
		_tmp5_ = _tmp4_->background;
		g_signal_parse_name ("notify::alpha", G_TYPE_OBJECT, &_tmp6_, &_tmp7_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, _tmp7_, NULL, (GCallback) _unity_greeter_background_loaded_cb_g_object_notify, self);
		unity_greeter_start_session (self);
	}
}


static void unity_greeter_start_session (UnityGreeter* self) {
	cairo_surface_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* c;
	UserList* _tmp2_;
	Background* _tmp3_;
	cairo_t* _tmp4_;
	GdkScreen* _tmp5_ = NULL;
	cairo_surface_t* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = unity_greeter_background_surface;
	_tmp1_ = cairo_create (_tmp0_);
	c = _tmp1_;
	_tmp2_ = self->user_list;
	_tmp3_ = _tmp2_->background;
	_tmp4_ = c;
	background_draw_full (_tmp3_, _tmp4_, BACKGROUND_DRAW_FLAGS_NONE);
	_cairo_destroy0 (c);
	c = NULL;
	_tmp5_ = gdk_screen_get_default ();
	_tmp6_ = unity_greeter_background_surface;
	unity_greeter_refresh_background (self, _tmp5_, _tmp6_);
	{
		LightDMGreeter* _tmp7_;
		UserList* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp7_ = self->priv->greeter;
		_tmp8_ = self->user_list;
		_tmp9_ = user_list_get_session (_tmp8_);
		_tmp10_ = _tmp9_;
		lightdm_greeter_start_session_sync (_tmp7_, _tmp10_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("unity-greeter.vala:430: Failed to start session: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally16:
	if (_inner_error_ != NULL) {
		_cairo_destroy0 (c);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_cairo_destroy0 (c);
}


static void unity_greeter_authentication_complete_cb (UnityGreeter* self) {
	gboolean is_authenticated = FALSE;
	gboolean _tmp0_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	__g_list_free__prompt_unref0_0 (self->priv->active_prompts);
	self->priv->active_prompts = NULL;
	_tmp0_ = unity_greeter_test_mode;
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->test_is_authenticated;
		is_authenticated = _tmp1_;
	} else {
		LightDMGreeter* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->greeter;
		_tmp3_ = lightdm_greeter_get_is_authenticated (_tmp2_);
		_tmp4_ = _tmp3_;
		is_authenticated = _tmp4_;
	}
	_tmp5_ = is_authenticated;
	if (_tmp5_) {
		gboolean _tmp6_;
		_tmp6_ = self->priv->prompted;
		if (_tmp6_) {
			UserList* _tmp7_;
			gboolean _tmp8_;
			_tmp7_ = self->user_list;
			user_list_login_complete (_tmp7_);
			_tmp8_ = unity_greeter_test_mode;
			if (!_tmp8_) {
				UserList* _tmp9_;
				Background* _tmp10_;
				gdouble _tmp11_;
				gdouble _tmp12_;
				_tmp9_ = self->user_list;
				_tmp10_ = _tmp9_->background;
				_tmp11_ = background_get_alpha (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_ == 1.0) {
					unity_greeter_start_session (self);
				} else {
					UserList* _tmp13_;
					Background* _tmp14_;
					_tmp13_ = self->user_list;
					_tmp14_ = _tmp13_->background;
					g_signal_connect ((GObject*) _tmp14_, "notify::alpha", (GCallback) _unity_greeter_background_loaded_cb_g_object_notify, self);
				}
			} else {
				cairo_surface_t* _tmp15_;
				cairo_t* _tmp16_;
				cairo_t* c;
				UserList* _tmp17_;
				Background* _tmp18_;
				cairo_t* _tmp19_;
				GdkScreen* _tmp20_ = NULL;
				cairo_surface_t* _tmp21_;
				_tmp15_ = unity_greeter_background_surface;
				_tmp16_ = cairo_create (_tmp15_);
				c = _tmp16_;
				_tmp17_ = self->user_list;
				_tmp18_ = _tmp17_->background;
				_tmp19_ = c;
				background_draw_full (_tmp18_, _tmp19_, BACKGROUND_DRAW_FLAGS_NONE);
				_cairo_destroy0 (c);
				c = NULL;
				_tmp20_ = gdk_screen_get_default ();
				_tmp21_ = unity_greeter_background_surface;
				unity_greeter_refresh_background (self, _tmp20_, _tmp21_);
				g_debug ("unity-greeter.vala:465: Successfully logged in!  Quitting...");
				gtk_main_quit ();
				_cairo_destroy0 (c);
			}
		} else {
			UserList* _tmp22_;
			self->priv->prompted = TRUE;
			_tmp22_ = self->user_list;
			user_list_show_authenticated (_tmp22_, TRUE);
		}
	} else {
		gboolean _tmp23_;
		_tmp23_ = self->priv->prompted;
		if (_tmp23_) {
			gboolean _tmp24_;
			UserList* _tmp26_;
			gboolean _tmp27_ = FALSE;
			_tmp24_ = self->priv->clear_messages;
			if (_tmp24_) {
				UserList* _tmp25_;
				_tmp25_ = self->user_list;
				user_list_clear_messages (_tmp25_);
			}
			_tmp26_ = self->user_list;
			_tmp27_ = user_list_have_messages (_tmp26_);
			if (!_tmp27_) {
				UserList* _tmp28_;
				const gchar* _tmp29_ = NULL;
				_tmp28_ = self->user_list;
				_tmp29_ = _ ("Invalid password, please try again");
				user_list_show_message (_tmp28_, _tmp29_, TRUE);
			}
			unity_greeter_start_authentication (self);
		} else {
			UserList* _tmp30_;
			gboolean _tmp31_ = FALSE;
			UserList* _tmp34_;
			_tmp30_ = self->user_list;
			_tmp31_ = user_list_have_messages (_tmp30_);
			if (!_tmp31_) {
				UserList* _tmp32_;
				const gchar* _tmp33_ = NULL;
				_tmp32_ = self->user_list;
				_tmp33_ = _ ("Failed to authenticate");
				user_list_show_message (_tmp32_, _tmp33_, TRUE);
			}
			_tmp34_ = self->user_list;
			user_list_show_authenticated (_tmp34_, FALSE);
		}
	}
}


static void unity_greeter_user_selected_cb (UnityGreeter* self, const gchar* username) {
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	GKeyFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* data;
	UserList* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = username;
	g_key_file_set_value (_tmp0_, "greeter", "last-user", _tmp1_);
	_tmp2_ = self->priv->state;
	_tmp3_ = g_key_file_to_data (_tmp2_, NULL, NULL);
	data = _tmp3_;
	{
		const gchar* _tmp4_;
		_tmp4_ = self->priv->state_file;
		g_file_set_contents (_tmp4_, data, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch17_g_error;
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_debug ("unity-greeter.vala:510: Failed to write state: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally17:
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = self->user_list;
	user_list_clear_messages (_tmp7_);
	unity_greeter_start_authentication (self);
	_g_free0 (data);
}


static void unity_greeter_start_authentication (UnityGreeter* self) {
	UserList* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->prompted = FALSE;
	__g_list_free__prompt_unref0_0 (self->priv->active_prompts);
	self->priv->active_prompts = NULL;
	_tmp0_ = self->user_list;
	user_list_set_manual_username (_tmp0_, NULL);
	self->priv->clear_messages = FALSE;
	_tmp1_ = unity_greeter_test_mode;
	if (_tmp1_) {
		UserList* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GQuark _tmp7_ = 0U;
		static GQuark _tmp6_label0 = 0;
		static GQuark _tmp6_label1 = 0;
		static GQuark _tmp6_label2 = 0;
		static GQuark _tmp6_label3 = 0;
		static GQuark _tmp6_label4 = 0;
		static GQuark _tmp6_label5 = 0;
		static GQuark _tmp6_label6 = 0;
		static GQuark _tmp6_label7 = 0;
		static GQuark _tmp6_label8 = 0;
		static GQuark _tmp6_label9 = 0;
		_g_free0 (self->priv->test_username);
		self->priv->test_username = NULL;
		self->priv->test_is_authenticated = FALSE;
		self->priv->test_prompted_sso = FALSE;
		_g_free0 (self->priv->test_two_prompts_first);
		self->priv->test_two_prompts_first = NULL;
		self->priv->test_request_new_password = FALSE;
		_g_free0 (self->priv->test_new_password);
		self->priv->test_new_password = NULL;
		_tmp2_ = self->user_list;
		_tmp3_ = user_list_get_selected (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
		if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("*other")))) {
			switch (0) {
				default:
				{
					const gchar* _tmp8_;
					_tmp8_ = self->priv->authenticate_user;
					if (_tmp8_ != NULL) {
						const gchar* _tmp9_;
						gchar* _tmp10_;
						const gchar* _tmp11_ = NULL;
						_tmp9_ = self->priv->authenticate_user;
						_tmp10_ = g_strdup (_tmp9_);
						_g_free0 (self->priv->test_username);
						self->priv->test_username = _tmp10_;
						_g_free0 (self->priv->authenticate_user);
						self->priv->authenticate_user = NULL;
						_tmp11_ = _ ("Password:");
						unity_greeter_show_prompt_cb (self, _tmp11_, LIGHTDM_PROMPT_TYPE_SECRET);
					} else {
						const gchar* _tmp12_ = NULL;
						_tmp12_ = _ ("Username:");
						unity_greeter_show_prompt_cb (self, _tmp12_, LIGHTDM_PROMPT_TYPE_QUESTION);
					}
					break;
				}
			}
		} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("*guest")))) {
			switch (0) {
				default:
				{
					self->priv->test_is_authenticated = TRUE;
					unity_greeter_authentication_complete_cb (self);
					break;
				}
			}
		} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("different-prompt")))) {
			switch (0) {
				default:
				{
					unity_greeter_show_prompt_cb (self, "Secret word", LIGHTDM_PROMPT_TYPE_SECRET);
					break;
				}
			}
		} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("no-password")))) {
			switch (0) {
				default:
				{
					self->priv->test_is_authenticated = TRUE;
					unity_greeter_authentication_complete_cb (self);
					break;
				}
			}
		} else if (_tmp7_ == ((0 != _tmp6_label4) ? _tmp6_label4 : (_tmp6_label4 = g_quark_from_static_string ("auth-error")))) {
			switch (0) {
				default:
				{
					unity_greeter_show_message_cb (self, "Authentication Error", LIGHTDM_MESSAGE_TYPE_ERROR);
					self->priv->test_is_authenticated = FALSE;
					unity_greeter_authentication_complete_cb (self);
					break;
				}
			}
		} else if (_tmp7_ == ((0 != _tmp6_label5) ? _tmp6_label5 : (_tmp6_label5 = g_quark_from_static_string ("info-prompt")))) {
			switch (0) {
				default:
				{
					const gchar* _tmp13_ = NULL;
					unity_greeter_show_message_cb (self, "Welcome to Unity Greeter", LIGHTDM_MESSAGE_TYPE_INFO);
					_tmp13_ = _ ("Password:");
					unity_greeter_show_prompt_cb (self, _tmp13_, LIGHTDM_PROMPT_TYPE_SECRET);
					break;
				}
			}
		} else if (_tmp7_ == ((0 != _tmp6_label6) ? _tmp6_label6 : (_tmp6_label6 = g_quark_from_static_string ("long-info-prompt")))) {
			switch (0) {
				default:
				{
					const gchar* _tmp14_ = NULL;
					unity_greeter_show_message_cb (self, "Welcome to Unity Greeter\n" \
"\n" \
"We like to annoy you with long messages.\n" \
"Like this one\n" \
"\n" \
"This is the last line of a multiple line message.", LIGHTDM_MESSAGE_TYPE_INFO);
					_tmp14_ = _ ("Password:");
					unity_greeter_show_prompt_cb (self, _tmp14_, LIGHTDM_PROMPT_TYPE_SECRET);
					break;
				}
			}
		} else if (_tmp7_ == ((0 != _tmp6_label7) ? _tmp6_label7 : (_tmp6_label7 = g_quark_from_static_string ("wide-info-prompt")))) {
			switch (0) {
				default:
				{
					const gchar* _tmp15_ = NULL;
					unity_greeter_show_message_cb (self, "Welcome to Unity Greeter, the greeteriest greeter that ever did appear" \
" in these fine lands", LIGHTDM_MESSAGE_TYPE_INFO);
					_tmp15_ = _ ("Password:");
					unity_greeter_show_prompt_cb (self, _tmp15_, LIGHTDM_PROMPT_TYPE_SECRET);
					break;
				}
			}
		} else if (_tmp7_ == ((0 != _tmp6_label8) ? _tmp6_label8 : (_tmp6_label8 = g_quark_from_static_string ("multi-info-prompt")))) {
			switch (0) {
				default:
				{
					const gchar* _tmp16_ = NULL;
					unity_greeter_show_message_cb (self, "Welcome to Unity Greeter", LIGHTDM_MESSAGE_TYPE_INFO);
					unity_greeter_show_message_cb (self, "This is an error", LIGHTDM_MESSAGE_TYPE_ERROR);
					unity_greeter_show_message_cb (self, "You should have seen three messages", LIGHTDM_MESSAGE_TYPE_INFO);
					_tmp16_ = _ ("Password:");
					unity_greeter_show_prompt_cb (self, _tmp16_, LIGHTDM_PROMPT_TYPE_SECRET);
					break;
				}
			}
		} else if (_tmp7_ == ((0 != _tmp6_label9) ? _tmp6_label9 : (_tmp6_label9 = g_quark_from_static_string ("two-prompts")))) {
			switch (0) {
				default:
				{
					const gchar* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					_tmp17_ = _ ("Favorite Color (blue):");
					unity_greeter_show_prompt_cb (self, _tmp17_, LIGHTDM_PROMPT_TYPE_QUESTION);
					_tmp18_ = _ ("Password:");
					unity_greeter_show_prompt_cb (self, _tmp18_, LIGHTDM_PROMPT_TYPE_SECRET);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					const gchar* _tmp19_ = NULL;
					_tmp19_ = _ ("Password:");
					unity_greeter_show_prompt_cb (self, _tmp19_, LIGHTDM_PROMPT_TYPE_SECRET);
					break;
				}
			}
		}
	} else {
		UserList* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp20_ = self->user_list;
		_tmp21_ = user_list_get_selected (_tmp20_);
		_tmp22_ = _tmp21_;
		if (g_strcmp0 (_tmp22_, "*other") == 0) {
			LightDMGreeter* _tmp23_;
			_tmp23_ = self->priv->greeter;
			lightdm_greeter_authenticate (_tmp23_, NULL);
		} else {
			UserList* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			_tmp24_ = self->user_list;
			_tmp25_ = user_list_get_selected (_tmp24_);
			_tmp26_ = _tmp25_;
			if (g_strcmp0 (_tmp26_, "*guest") == 0) {
				LightDMGreeter* _tmp27_;
				_tmp27_ = self->priv->greeter;
				lightdm_greeter_authenticate_as_guest (_tmp27_);
			} else {
				LightDMGreeter* _tmp28_;
				UserList* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				_tmp28_ = self->priv->greeter;
				_tmp29_ = self->user_list;
				_tmp30_ = user_list_get_selected (_tmp29_);
				_tmp31_ = _tmp30_;
				lightdm_greeter_authenticate (_tmp28_, _tmp31_);
			}
		}
	}
}


static gpointer _prompt_ref0 (gpointer self) {
	return self ? prompt_ref (self) : NULL;
}


static void unity_greeter_respond_to_prompt_cb (UnityGreeter* self, const gchar* text) {
	GList* _tmp0_;
	GList* _tmp1_ = NULL;
	Prompt* next_prompt;
	GList* _tmp2_;
	guint _tmp3_ = 0U;
	gboolean _tmp8_;
	Prompt* _tmp42_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->active_prompts;
	_tmp1_ = g_list_first (_tmp0_);
	self->priv->active_prompts = g_list_remove_link (self->priv->active_prompts, _tmp1_);
	next_prompt = NULL;
	_tmp2_ = self->priv->active_prompts;
	_tmp3_ = g_list_length (_tmp2_);
	if (_tmp3_ > ((guint) 0)) {
		GList* _tmp4_;
		gconstpointer _tmp5_ = NULL;
		Prompt* _tmp6_;
		Prompt* _tmp7_;
		_tmp4_ = self->priv->active_prompts;
		_tmp5_ = g_list_nth_data (_tmp4_, (guint) 0);
		_tmp6_ = _prompt_ref0 ((Prompt*) _tmp5_);
		_prompt_unref0 (next_prompt);
		next_prompt = _tmp6_;
		_tmp7_ = next_prompt;
		self->priv->active_prompts = g_list_remove (self->priv->active_prompts, _tmp7_);
	}
	_tmp8_ = unity_greeter_test_mode;
	if (_tmp8_) {
		const gchar* _tmp9_;
		UserList* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		GQuark _tmp15_ = 0U;
		static GQuark _tmp14_label0 = 0;
		static GQuark _tmp14_label1 = 0;
		static GQuark _tmp14_label2 = 0;
		static GQuark _tmp14_label3 = 0;
		static GQuark _tmp14_label4 = 0;
		static GQuark _tmp14_label5 = 0;
		_tmp9_ = text;
		g_debug ("unity-greeter.vala:615: response %s", _tmp9_);
		_tmp10_ = self->user_list;
		_tmp11_ = user_list_get_selected (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp15_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
		if (_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("*other")))) {
			switch (0) {
				default:
				{
					const gchar* _tmp16_;
					_tmp16_ = self->priv->test_username;
					if (_tmp16_ == NULL) {
						const gchar* _tmp17_;
						const gchar* _tmp18_;
						gchar* _tmp19_;
						const gchar* _tmp20_ = NULL;
						_tmp17_ = text;
						g_debug ("unity-greeter.vala:621: username=%s", _tmp17_);
						_tmp18_ = text;
						_tmp19_ = g_strdup (_tmp18_);
						_g_free0 (self->priv->test_username);
						self->priv->test_username = _tmp19_;
						_tmp20_ = _ ("Password:");
						unity_greeter_show_prompt_cb (self, _tmp20_, LIGHTDM_PROMPT_TYPE_SECRET);
					} else {
						const gchar* _tmp21_;
						_tmp21_ = text;
						self->priv->test_is_authenticated = g_strcmp0 (_tmp21_, "password") == 0;
						unity_greeter_authentication_complete_cb (self);
					}
					break;
				}
			}
		} else if (_tmp15_ == ((0 != _tmp14_label1) ? _tmp14_label1 : (_tmp14_label1 = g_quark_from_static_string ("two-factor")))) {
			switch (0) {
				default:
				{
					gboolean _tmp22_;
					_tmp22_ = self->priv->test_prompted_sso;
					if (!_tmp22_) {
						const gchar* _tmp23_;
						_tmp23_ = text;
						if (g_strcmp0 (_tmp23_, "password") == 0) {
							g_debug ("unity-greeter.vala:636: prompt otp");
							self->priv->test_prompted_sso = TRUE;
							unity_greeter_show_prompt_cb (self, "OTP:", LIGHTDM_PROMPT_TYPE_QUESTION);
						} else {
							self->priv->test_is_authenticated = FALSE;
							unity_greeter_authentication_complete_cb (self);
						}
					} else {
						const gchar* _tmp24_;
						_tmp24_ = text;
						self->priv->test_is_authenticated = g_strcmp0 (_tmp24_, "otp") == 0;
						unity_greeter_authentication_complete_cb (self);
					}
					break;
				}
			}
		} else if (_tmp15_ == ((0 != _tmp14_label2) ? _tmp14_label2 : (_tmp14_label2 = g_quark_from_static_string ("two-prompts")))) {
			switch (0) {
				default:
				{
					const gchar* _tmp25_;
					_tmp25_ = self->priv->test_two_prompts_first;
					if (_tmp25_ == NULL) {
						const gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp26_ = text;
						_tmp27_ = g_strdup (_tmp26_);
						_g_free0 (self->priv->test_two_prompts_first);
						self->priv->test_two_prompts_first = _tmp27_;
					} else {
						gboolean _tmp28_ = FALSE;
						const gchar* _tmp29_;
						gboolean _tmp31_;
						_tmp29_ = self->priv->test_two_prompts_first;
						if (g_strcmp0 (_tmp29_, "blue") == 0) {
							const gchar* _tmp30_;
							_tmp30_ = text;
							_tmp28_ = g_strcmp0 (_tmp30_, "password") == 0;
						} else {
							_tmp28_ = FALSE;
						}
						_tmp31_ = _tmp28_;
						self->priv->test_is_authenticated = _tmp31_;
						unity_greeter_authentication_complete_cb (self);
					}
					break;
				}
			}
		} else if (_tmp15_ == ((0 != _tmp14_label3) ? _tmp14_label3 : (_tmp14_label3 = g_quark_from_static_string ("change-password")))) {
			switch (0) {
				default:
				{
					const gchar* _tmp32_;
					_tmp32_ = self->priv->test_new_password;
					if (_tmp32_ != NULL) {
						const gchar* _tmp33_;
						const gchar* _tmp34_;
						_tmp33_ = text;
						_tmp34_ = self->priv->test_new_password;
						self->priv->test_is_authenticated = g_strcmp0 (_tmp33_, _tmp34_) == 0;
						unity_greeter_authentication_complete_cb (self);
					} else {
						gboolean _tmp35_;
						_tmp35_ = self->priv->test_request_new_password;
						if (_tmp35_) {
							const gchar* _tmp36_;
							gchar* _tmp37_;
							_tmp36_ = text;
							_tmp37_ = g_strdup (_tmp36_);
							_g_free0 (self->priv->test_new_password);
							self->priv->test_new_password = _tmp37_;
							unity_greeter_show_prompt_cb (self, "Retype new UNIX password: ", LIGHTDM_PROMPT_TYPE_SECRET);
						} else {
							const gchar* _tmp38_;
							_tmp38_ = text;
							if (g_strcmp0 (_tmp38_, "password") != 0) {
								self->priv->test_is_authenticated = FALSE;
								unity_greeter_authentication_complete_cb (self);
							} else {
								self->priv->test_request_new_password = TRUE;
								unity_greeter_show_message_cb (self, "You are required to change your password immediately (root enforced)", LIGHTDM_MESSAGE_TYPE_ERROR);
								unity_greeter_show_prompt_cb (self, "Enter new UNIX password: ", LIGHTDM_PROMPT_TYPE_SECRET);
							}
						}
					}
					break;
				}
			}
		} else if (_tmp15_ == ((0 != _tmp14_label4) ? _tmp14_label4 : (_tmp14_label4 = g_quark_from_static_string ("no-response")))) {
			switch (0) {
				default:
				{
					break;
				}
			}
		} else if (_tmp15_ == ((0 != _tmp14_label5) ? _tmp14_label5 : (_tmp14_label5 = g_quark_from_static_string ("locked")))) {
			switch (0) {
				default:
				{
					self->priv->test_is_authenticated = FALSE;
					unity_greeter_show_message_cb (self, "Account is locked", LIGHTDM_MESSAGE_TYPE_ERROR);
					unity_greeter_authentication_complete_cb (self);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					const gchar* _tmp39_;
					_tmp39_ = text;
					self->priv->test_is_authenticated = g_strcmp0 (_tmp39_, "password") == 0;
					unity_greeter_authentication_complete_cb (self);
					break;
				}
			}
		}
	} else {
		LightDMGreeter* _tmp40_;
		const gchar* _tmp41_;
		_tmp40_ = self->priv->greeter;
		_tmp41_ = text;
		lightdm_greeter_respond (_tmp40_, _tmp41_);
	}
	_tmp42_ = next_prompt;
	if (_tmp42_ != NULL) {
		Prompt* _tmp43_;
		const gchar* _tmp44_;
		Prompt* _tmp45_;
		LightDMPromptType _tmp46_;
		self->priv->clear_messages = FALSE;
		_tmp43_ = next_prompt;
		_tmp44_ = _tmp43_->text;
		_tmp45_ = next_prompt;
		_tmp46_ = _tmp45_->type;
		unity_greeter_set_prompt (self, _tmp44_, _tmp46_);
	}
	_prompt_unref0 (next_prompt);
}


static void unity_greeter_start_session_cb (UnityGreeter* self) {
	gboolean is_authenticated;
	gboolean _tmp0_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	is_authenticated = FALSE;
	_tmp0_ = unity_greeter_test_mode;
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->test_is_authenticated;
		is_authenticated = _tmp1_;
	} else {
		LightDMGreeter* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->greeter;
		_tmp3_ = lightdm_greeter_get_is_authenticated (_tmp2_);
		_tmp4_ = _tmp3_;
		is_authenticated = _tmp4_;
	}
	_tmp5_ = is_authenticated;
	if (_tmp5_) {
		unity_greeter_authentication_complete_cb (self);
	} else {
		UserList* _tmp6_;
		_tmp6_ = self->user_list;
		user_list_clear_messages (_tmp6_);
		unity_greeter_start_authentication (self);
	}
}


static GdkFilterReturn unity_greeter_focus_upon_map (UnityGreeter* self, GdkXEvent* gxevent, GdkEvent* event) {
	GdkFilterReturn result = 0;
	GdkXEvent* _tmp0_;
	XEvent* xevent;
	XEvent* _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (gxevent != NULL, 0);
	g_return_val_if_fail (event != NULL, 0);
	_tmp0_ = gxevent;
	xevent = (XEvent*) _tmp0_;
	_tmp1_ = xevent;
	_tmp2_ = (*_tmp1_).type;
	if (_tmp2_ == ((gint) MapNotify)) {
		XEvent* _tmp3_;
		XMapEvent _tmp4_;
		Display* _tmp5_;
		GdkDisplay* _tmp6_ = NULL;
		GdkDisplay* _tmp7_;
		GdkDisplay* display;
		XEvent* _tmp8_;
		XMapEvent _tmp9_;
		Window _tmp10_;
		Window xwin;
		GdkDisplay* _tmp11_;
		Window _tmp12_;
		GdkWindow* _tmp13_ = NULL;
		GdkWindow* _tmp14_;
		GdkWindow* win;
		Window keyboard_xid;
		MainWindow* _tmp15_;
		MenuBar* _tmp16_;
		GtkWindow* _tmp17_;
		GtkWindow* _tmp18_;
		gboolean _tmp25_ = FALSE;
		Window _tmp26_;
		Window _tmp27_;
		gboolean _tmp30_;
		_tmp3_ = xevent;
		_tmp4_ = (*_tmp3_).xmap;
		_tmp5_ = _tmp4_.display;
		_tmp6_ = gdk_x11_lookup_xdisplay (_tmp5_);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		display = _tmp7_;
		_tmp8_ = xevent;
		_tmp9_ = (*_tmp8_).xmap;
		_tmp10_ = _tmp9_.window;
		xwin = _tmp10_;
		_tmp11_ = display;
		_tmp12_ = xwin;
		_tmp13_ = gdk_x11_window_foreign_new_for_display (_tmp11_, _tmp12_);
		_tmp14_ = _g_object_ref0 (_tmp13_);
		win = _tmp14_;
		keyboard_xid = (Window) 0;
		_tmp15_ = self->priv->main_window;
		_tmp16_ = _tmp15_->menubar;
		_tmp17_ = menu_bar_get_keyboard_window (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_ != NULL) {
			MainWindow* _tmp19_;
			MenuBar* _tmp20_;
			GtkWindow* _tmp21_;
			GtkWindow* _tmp22_;
			GdkWindow* _tmp23_ = NULL;
			Window _tmp24_ = 0;
			_tmp19_ = self->priv->main_window;
			_tmp20_ = _tmp19_->menubar;
			_tmp21_ = menu_bar_get_keyboard_window (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = gtk_widget_get_window ((GtkWidget*) _tmp22_);
			_tmp24_ = gdk_x11_window_get_xid (_tmp23_);
			keyboard_xid = _tmp24_;
		}
		_tmp26_ = xwin;
		_tmp27_ = keyboard_xid;
		if (_tmp26_ != _tmp27_) {
			GdkWindow* _tmp28_;
			GdkWindowTypeHint _tmp29_ = 0;
			_tmp28_ = win;
			_tmp29_ = gdk_window_get_type_hint (_tmp28_);
			_tmp25_ = _tmp29_ != GDK_WINDOW_TYPE_HINT_NOTIFICATION;
		} else {
			_tmp25_ = FALSE;
		}
		_tmp30_ = _tmp25_;
		if (_tmp30_) {
			GdkWindow* _tmp31_;
			MainWindow* _tmp32_;
			MenuBar* _tmp33_;
			GtkWindow* _tmp34_;
			GtkWindow* _tmp35_;
			_tmp31_ = win;
			gdk_window_focus (_tmp31_, (guint32) GDK_CURRENT_TIME);
			_tmp32_ = self->priv->main_window;
			_tmp33_ = _tmp32_->menubar;
			_tmp34_ = menu_bar_get_keyboard_window (_tmp33_);
			_tmp35_ = _tmp34_;
			if (_tmp35_ != NULL) {
				MainWindow* _tmp36_;
				MenuBar* _tmp37_;
				GtkWindow* _tmp38_;
				GtkWindow* _tmp39_;
				GdkWindow* _tmp40_ = NULL;
				_tmp36_ = self->priv->main_window;
				_tmp37_ = _tmp36_->menubar;
				_tmp38_ = menu_bar_get_keyboard_window (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = gtk_widget_get_window ((GtkWidget*) _tmp39_);
				gdk_window_raise (_tmp40_);
			}
		}
		_g_object_unref0 (win);
		_g_object_unref0 (display);
	} else {
		XEvent* _tmp41_;
		gint _tmp42_;
		_tmp41_ = xevent;
		_tmp42_ = (*_tmp41_).type;
		if (_tmp42_ == ((gint) UnmapNotify)) {
			Window xwin = 0;
			gint revert_to = 0;
			XEvent* _tmp43_;
			XUnmapEvent _tmp44_;
			Display* _tmp45_;
			Window _tmp46_ = 0;
			gint _tmp47_ = 0;
			gint _tmp48_;
			_tmp43_ = xevent;
			_tmp44_ = (*_tmp43_).xunmap;
			_tmp45_ = _tmp44_.display;
			XGetInputFocus (_tmp45_, &_tmp46_, &_tmp47_);
			xwin = _tmp46_;
			revert_to = _tmp47_;
			_tmp48_ = revert_to;
			if (_tmp48_ == ((gint) RevertToNone)) {
				MainWindow* _tmp49_;
				GdkWindow* _tmp50_ = NULL;
				MainWindow* _tmp51_;
				MenuBar* _tmp52_;
				GtkWindow* _tmp53_;
				GtkWindow* _tmp54_;
				_tmp49_ = self->priv->main_window;
				_tmp50_ = gtk_widget_get_window ((GtkWidget*) _tmp49_);
				gdk_window_focus (_tmp50_, (guint32) GDK_CURRENT_TIME);
				_tmp51_ = self->priv->main_window;
				_tmp52_ = _tmp51_->menubar;
				_tmp53_ = menu_bar_get_keyboard_window (_tmp52_);
				_tmp54_ = _tmp53_;
				if (_tmp54_ != NULL) {
					MainWindow* _tmp55_;
					MenuBar* _tmp56_;
					GtkWindow* _tmp57_;
					GtkWindow* _tmp58_;
					GdkWindow* _tmp59_ = NULL;
					_tmp55_ = self->priv->main_window;
					_tmp56_ = _tmp55_->menubar;
					_tmp57_ = menu_bar_get_keyboard_window (_tmp56_);
					_tmp58_ = _tmp57_;
					_tmp59_ = gtk_widget_get_window ((GtkWidget*) _tmp58_);
					gdk_window_raise (_tmp59_);
				}
			}
		}
	}
	result = GDK_FILTER_CONTINUE;
	return result;
}


static GdkFilterReturn _unity_greeter_focus_upon_map_gdk_filter_func (GdkXEvent* xevent, GdkEvent* event, gpointer self) {
	GdkFilterReturn result;
	result = unity_greeter_focus_upon_map (self, xevent, event);
	return result;
}


static void unity_greeter_start_fake_wm (UnityGreeter* self) {
	GdkWindow* _tmp0_ = NULL;
	GdkWindow* _tmp1_;
	GdkWindow* root;
	GdkEventMask _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_get_default_root_window ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	root = _tmp1_;
	_tmp2_ = gdk_window_get_events (root);
	gdk_window_set_events (root, _tmp2_ | GDK_SUBSTRUCTURE_MASK);
	gdk_window_add_filter (root, _unity_greeter_focus_upon_map_gdk_filter_func, self);
	_g_object_unref0 (root);
}


static cairo_surface_t* unity_greeter_create_root_surface (GdkScreen* screen) {
	cairo_surface_t* result = NULL;
	GdkScreen* _tmp0_;
	GdkVisual* _tmp1_ = NULL;
	GdkVisual* _tmp2_;
	GdkVisual* visual;
	GdkScreen* _tmp3_;
	GdkDisplay* _tmp4_ = NULL;
	Display* _tmp5_ = NULL;
	Display* display;
	GdkScreen* _tmp6_;
	GdkWindow* _tmp7_ = NULL;
	Window _tmp8_ = 0;
	GdkScreen* _tmp9_;
	gint _tmp10_ = 0;
	GdkScreen* _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint pixmap;
	Visual* _tmp15_ = NULL;
	GdkScreen* _tmp16_;
	gint _tmp17_ = 0;
	GdkScreen* _tmp18_;
	gint _tmp19_ = 0;
	cairo_surface_t* _tmp20_;
	cairo_surface_t* surface;
	g_return_val_if_fail (screen != NULL, NULL);
	_tmp0_ = screen;
	_tmp1_ = gdk_screen_get_system_visual (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	visual = _tmp2_;
	_tmp3_ = screen;
	_tmp4_ = gdk_screen_get_display (_tmp3_);
	_tmp5_ = gdk_x11_display_get_xdisplay (_tmp4_);
	display = _tmp5_;
	_tmp6_ = screen;
	_tmp7_ = gdk_screen_get_root_window (_tmp6_);
	_tmp8_ = gdk_x11_window_get_xid (_tmp7_);
	_tmp9_ = screen;
	_tmp10_ = gdk_screen_width ();
	_tmp11_ = screen;
	_tmp12_ = gdk_screen_height ();
	_tmp13_ = gdk_visual_get_depth (visual);
	_tmp14_ = XCreatePixmap (display, (Drawable) _tmp8_, (guint) _tmp10_, (guint) _tmp12_, (guint) _tmp13_);
	pixmap = _tmp14_;
	_tmp15_ = gdk_x11_visual_get_xvisual (visual);
	_tmp16_ = screen;
	_tmp17_ = gdk_screen_width ();
	_tmp18_ = screen;
	_tmp19_ = gdk_screen_height ();
	_tmp20_ = cairo_xlib_surface_create (display, pixmap, _tmp15_, _tmp17_, _tmp19_);
	surface = _tmp20_;
	result = surface;
	_g_object_unref0 (visual);
	return result;
}


static void unity_greeter_refresh_background (UnityGreeter* self, GdkScreen* screen, cairo_surface_t* surface) {
	GdkScreen* _tmp0_;
	GdkDisplay* _tmp1_ = NULL;
	Display* _tmp2_ = NULL;
	Display* display;
	cairo_surface_t* _tmp3_;
	GdkScreen* _tmp4_;
	GdkWindow* _tmp5_ = NULL;
	Window _tmp6_ = 0;
	cairo_surface_t* _tmp7_;
	gint _tmp8_ = 0;
	GdkScreen* _tmp9_;
	GdkWindow* _tmp10_ = NULL;
	Window _tmp11_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	g_return_if_fail (surface != NULL);
	gdk_flush ();
	_tmp0_ = screen;
	_tmp1_ = gdk_screen_get_display (_tmp0_);
	_tmp2_ = gdk_x11_display_get_xdisplay (_tmp1_);
	display = _tmp2_;
	_tmp3_ = surface;
	cairo_surface_flush (_tmp3_);
	_tmp4_ = screen;
	_tmp5_ = gdk_screen_get_root_window (_tmp4_);
	_tmp6_ = gdk_x11_window_get_xid (_tmp5_);
	_tmp7_ = surface;
	_tmp8_ = cairo_xlib_surface_get_drawable (_tmp7_);
	XSetWindowBackgroundPixmap (display, _tmp6_, _tmp8_);
	_tmp9_ = screen;
	_tmp10_ = gdk_screen_get_root_window (_tmp9_);
	_tmp11_ = gdk_x11_window_get_xid (_tmp10_);
	XClearWindow (display, _tmp11_);
}


static void unity_greeter_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message) {
	gchar* prefix = NULL;
	GLogLevelFlags _tmp0_;
	FILE* _tmp8_;
	GTimer* _tmp9_;
	gdouble _tmp10_ = 0.0;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (message != NULL);
	_tmp0_ = log_level;
	switch (_tmp0_ & G_LOG_LEVEL_MASK) {
		case G_LOG_LEVEL_ERROR:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("ERROR:");
			_g_free0 (prefix);
			prefix = _tmp1_;
			break;
		}
		case G_LOG_LEVEL_CRITICAL:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("CRITICAL:");
			_g_free0 (prefix);
			prefix = _tmp2_;
			break;
		}
		case G_LOG_LEVEL_WARNING:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("WARNING:");
			_g_free0 (prefix);
			prefix = _tmp3_;
			break;
		}
		case G_LOG_LEVEL_MESSAGE:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("MESSAGE:");
			_g_free0 (prefix);
			prefix = _tmp4_;
			break;
		}
		case G_LOG_LEVEL_INFO:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("INFO:");
			_g_free0 (prefix);
			prefix = _tmp5_;
			break;
		}
		case G_LOG_LEVEL_DEBUG:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("DEBUG:");
			_g_free0 (prefix);
			prefix = _tmp6_;
			break;
		}
		default:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("LOG:");
			_g_free0 (prefix);
			prefix = _tmp7_;
			break;
		}
	}
	_tmp8_ = stderr;
	_tmp9_ = unity_greeter_log_timer;
	_tmp10_ = g_timer_elapsed (_tmp9_, NULL);
	_tmp11_ = prefix;
	_tmp12_ = message;
	fprintf (_tmp8_, "[%+.2fs] %s %s\n", _tmp10_, _tmp11_, _tmp12_);
	_g_free0 (prefix);
}


static void _unity_greeter_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	unity_greeter_log_cb (log_domain, log_levels, message);
}


gint unity_greeter_main (gchar** args, int args_length1) {
	gint result = 0;
	GPid atspi_pid;
	GTimer* _tmp6_;
	uid_t _tmp7_ = {0};
	const gchar* _tmp8_ = NULL;
	GdkWindow* _tmp9_ = NULL;
	GdkCursor* _tmp10_;
	GdkCursor* _tmp11_;
	GdkScreen* _tmp12_ = NULL;
	cairo_surface_t* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GOptionContext* _tmp15_;
	GOptionContext* c;
	GOptionContext* _tmp16_;
	GOptionContext* _tmp17_;
	GOptionGroup* _tmp18_ = NULL;
	gboolean _tmp28_;
	gboolean _tmp30_;
	GtkSettings* _tmp31_ = NULL;
	GtkSettings* _tmp32_;
	GtkSettings* settings;
	gchar* _tmp33_ = NULL;
	gchar* value;
	const gchar* _tmp34_;
	gchar* _tmp37_ = NULL;
	const gchar* _tmp38_;
	gchar* _tmp41_ = NULL;
	const gchar* _tmp42_;
	gdouble _tmp45_ = 0.0;
	gdouble double_value;
	gdouble _tmp46_;
	gboolean _tmp49_ = FALSE;
	gboolean boolean_value;
	GtkSettings* _tmp50_;
	gboolean _tmp51_;
	gchar* _tmp52_ = NULL;
	const gchar* _tmp53_;
	gchar* _tmp56_ = NULL;
	const gchar* _tmp57_;
	UnityGreeter* _tmp60_;
	UnityGreeter* greeter;
	UnityGreeter* _tmp61_;
	gchar** _tmp62_ = NULL;
	gchar** exec;
	gint exec_length1;
	gint _exec_size_;
	gchar** _tmp63_;
	gint _tmp63__length1;
	gchar* _tmp64_;
	gchar* _tmp65_;
	GPid _tmp69_;
	GError * _inner_error_ = NULL;
	g_unsetenv ("UBUNTU_MENUPROXY");
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_setenv ("GTK_MODULES", "atk-bridge", FALSE);
	atspi_pid = (GPid) 0;
	{
		gchar** argv = NULL;
		gint argv_length1 = 0;
		gint _argv_size_ = 0;
		gchar** _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gchar** _tmp2_;
		gint _tmp2__length1;
		GPid _tmp3_ = 0;
		g_shell_parse_argv ("/usr/lib/at-spi2-core/at-spi-bus-launcher --launch-immediately", &_tmp1_, &_tmp0_, &_inner_error_);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		argv = _tmp0_;
		argv_length1 = _tmp1_;
		_argv_size_ = argv_length1;
		if (_inner_error_ != NULL) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			goto __catch18_g_error;
		}
		_tmp2_ = argv;
		_tmp2__length1 = argv_length1;
		g_spawn_async (NULL, _tmp2_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp3_, &_inner_error_);
		atspi_pid = _tmp3_;
		if (_inner_error_ != NULL) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			goto __catch18_g_error;
		}
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("unity-greeter.vala:887: Error starting the at-spi registry: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally18:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	gtk_init (&args_length1, &args);
	_tmp6_ = g_timer_new ();
	_g_timer_destroy0 (unity_greeter_log_timer);
	unity_greeter_log_timer = _tmp6_;
	g_log_set_default_handler (_unity_greeter_log_cb_glog_func, NULL);
	_tmp7_ = getuid ();
	_tmp8_ = g_getenv ("LANG");
	g_debug ("unity-greeter.vala:895: Starting unity-greeter %s UID=%d LANG=%s", VERSION, (gint) _tmp7_, _tmp8_);
	g_debug ("unity-greeter.vala:898: Setting cursor");
	_tmp9_ = gdk_get_default_root_window ();
	_tmp10_ = gdk_cursor_new (GDK_LEFT_PTR);
	_tmp11_ = _tmp10_;
	gdk_window_set_cursor (_tmp9_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	g_debug ("unity-greeter.vala:902: Creating background surface");
	_tmp12_ = gdk_screen_get_default ();
	_tmp13_ = unity_greeter_create_root_surface (_tmp12_);
	_cairo_surface_destroy0 (unity_greeter_background_surface);
	unity_greeter_background_surface = _tmp13_;
	g_debug ("unity-greeter.vala:905: Loading command line options");
	_tmp14_ = _ ("- Unity Greeter");
	_tmp15_ = g_option_context_new (_tmp14_);
	c = _tmp15_;
	_tmp16_ = c;
	g_option_context_add_main_entries (_tmp16_, UNITY_GREETER_options, GETTEXT_PACKAGE);
	_tmp17_ = c;
	_tmp18_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp17_, _tmp18_);
	{
		GOptionContext* _tmp19_;
		_tmp19_ = c;
		g_option_context_parse (_tmp19_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		FILE* _tmp20_;
		GError* _tmp21_;
		const gchar* _tmp22_;
		FILE* _tmp23_;
		const gchar* _tmp24_ = NULL;
		gchar** _tmp25_;
		gint _tmp25__length1;
		const gchar* _tmp26_;
		FILE* _tmp27_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = stderr;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		fprintf (_tmp20_, "%s\n", _tmp22_);
		_tmp23_ = stderr;
		_tmp24_ = _ ("Run '%s --help' to see a full list of available command line options.");
		_tmp25_ = args;
		_tmp25__length1 = args_length1;
		_tmp26_ = _tmp25_[0];
		fprintf (_tmp23_, _tmp24_, _tmp26_);
		_tmp27_ = stderr;
		fprintf (_tmp27_, "\n");
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (c);
		return result;
	}
	__finally19:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (c);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp28_ = unity_greeter_show_version;
	if (_tmp28_) {
		FILE* _tmp29_;
		_tmp29_ = stderr;
		fprintf (_tmp29_, "unity-greeter %s\n", VERSION);
		result = EXIT_SUCCESS;
		_g_option_context_free0 (c);
		return result;
	}
	_tmp30_ = unity_greeter_test_mode;
	if (_tmp30_) {
		g_debug ("unity-greeter.vala:930: Running in test mode");
	}
	g_debug ("unity-greeter.vala:933: Setting GTK+ settings");
	_tmp31_ = gtk_settings_get_default ();
	_tmp32_ = _g_object_ref0 (_tmp31_);
	settings = _tmp32_;
	_tmp33_ = ug_settings_get_string (UG_SETTINGS_KEY_THEME_NAME);
	value = _tmp33_;
	_tmp34_ = value;
	if (g_strcmp0 (_tmp34_, "") != 0) {
		GtkSettings* _tmp35_;
		const gchar* _tmp36_;
		_tmp35_ = settings;
		_tmp36_ = value;
		g_object_set ((GObject*) _tmp35_, "gtk-theme-name", _tmp36_, NULL, NULL);
	}
	_tmp37_ = ug_settings_get_string (UG_SETTINGS_KEY_ICON_THEME_NAME);
	_g_free0 (value);
	value = _tmp37_;
	_tmp38_ = value;
	if (g_strcmp0 (_tmp38_, "") != 0) {
		GtkSettings* _tmp39_;
		const gchar* _tmp40_;
		_tmp39_ = settings;
		_tmp40_ = value;
		g_object_set ((GObject*) _tmp39_, "gtk-icon-theme-name", _tmp40_, NULL, NULL);
	}
	_tmp41_ = ug_settings_get_string (UG_SETTINGS_KEY_FONT_NAME);
	_g_free0 (value);
	value = _tmp41_;
	_tmp42_ = value;
	if (g_strcmp0 (_tmp42_, "") != 0) {
		GtkSettings* _tmp43_;
		const gchar* _tmp44_;
		_tmp43_ = settings;
		_tmp44_ = value;
		g_object_set ((GObject*) _tmp43_, "gtk-font-name", _tmp44_, NULL, NULL);
	}
	_tmp45_ = ug_settings_get_double (UG_SETTINGS_KEY_XFT_DPI);
	double_value = _tmp45_;
	_tmp46_ = double_value;
	if (_tmp46_ != 0.0) {
		GtkSettings* _tmp47_;
		gdouble _tmp48_;
		_tmp47_ = settings;
		_tmp48_ = double_value;
		g_object_set ((GObject*) _tmp47_, "gtk-xft-dpi", (gint) (1024 * _tmp48_), NULL, NULL);
	}
	_tmp49_ = ug_settings_get_boolean (UG_SETTINGS_KEY_XFT_ANTIALIAS);
	boolean_value = _tmp49_;
	_tmp50_ = settings;
	_tmp51_ = boolean_value;
	g_object_set ((GObject*) _tmp50_, "gtk-xft-antialias", _tmp51_, NULL, NULL);
	_tmp52_ = ug_settings_get_string (UG_SETTINGS_KEY_XFT_HINTSTYLE);
	_g_free0 (value);
	value = _tmp52_;
	_tmp53_ = value;
	if (g_strcmp0 (_tmp53_, "") != 0) {
		GtkSettings* _tmp54_;
		const gchar* _tmp55_;
		_tmp54_ = settings;
		_tmp55_ = value;
		g_object_set ((GObject*) _tmp54_, "gtk-xft-hintstyle", _tmp55_, NULL, NULL);
	}
	_tmp56_ = ug_settings_get_string (UG_SETTINGS_KEY_XFT_RGBA);
	_g_free0 (value);
	value = _tmp56_;
	_tmp57_ = value;
	if (g_strcmp0 (_tmp57_, "") != 0) {
		GtkSettings* _tmp58_;
		const gchar* _tmp59_;
		_tmp58_ = settings;
		_tmp59_ = value;
		g_object_set ((GObject*) _tmp58_, "gtk-xft-rgba", _tmp59_, NULL, NULL);
	}
	g_debug ("unity-greeter.vala:956: Creating Unity Greeter");
	_tmp60_ = unity_greeter_new ();
	greeter = _tmp60_;
	g_debug ("unity-greeter.vala:959: Showing greeter");
	_tmp61_ = greeter;
	unity_greeter_show (_tmp61_);
	_tmp62_ = g_new0 (gchar*, 1 + 1);
	exec = _tmp62_;
	exec_length1 = 1;
	_exec_size_ = exec_length1;
	_tmp63_ = exec;
	_tmp63__length1 = exec_length1;
	_tmp64_ = g_strdup ("/usr/lib/nux/unity_support_test");
	_g_free0 (_tmp63_[0]);
	_tmp63_[0] = _tmp64_;
	_tmp65_ = _tmp63_[0];
	{
		gchar** _tmp66_;
		gint _tmp66__length1;
		_tmp66_ = exec;
		_tmp66__length1 = exec_length1;
		g_spawn_async (NULL, _tmp66_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch20_g_spawn_error;
			}
			exec = (_vala_array_free (exec, exec_length1, (GDestroyNotify) g_free), NULL);
			_unity_greeter_unref0 (greeter);
			_g_free0 (value);
			_g_object_unref0 (settings);
			_g_option_context_free0 (c);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally20;
	__catch20_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp67_;
		const gchar* _tmp68_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp67_ = e;
		_tmp68_ = _tmp67_->message;
		g_warning ("unity-greeter.vala:969: Failed to spawn unity-support-test tool for pr" \
"e-caching: %s", _tmp68_);
		_g_error_free0 (e);
	}
	__finally20:
	if (_inner_error_ != NULL) {
		exec = (_vala_array_free (exec, exec_length1, (GDestroyNotify) g_free), NULL);
		_unity_greeter_unref0 (greeter);
		_g_free0 (value);
		_g_object_unref0 (settings);
		_g_option_context_free0 (c);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	g_debug ("unity-greeter.vala:972: Starting main loop");
	gtk_main ();
	_tmp69_ = atspi_pid;
	if (_tmp69_ != ((GPid) 0)) {
		GPid _tmp70_;
		gint status = 0;
		GPid _tmp71_;
		gint _tmp72_ = 0;
		_tmp70_ = atspi_pid;
		kill ((pid_t) _tmp70_, SIGKILL);
		_tmp71_ = atspi_pid;
		waitpid ((pid_t) _tmp71_, &_tmp72_, 0);
		status = _tmp72_;
		atspi_pid = (GPid) 0;
	}
	result = EXIT_SUCCESS;
	exec = (_vala_array_free (exec, exec_length1, (GDestroyNotify) g_free), NULL);
	_unity_greeter_unref0 (greeter);
	_g_free0 (value);
	_g_object_unref0 (settings);
	_g_option_context_free0 (c);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return unity_greeter_main (argv, argc);
}


static void value_unity_greeter_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_unity_greeter_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_greeter_unref (value->data[0].v_pointer);
	}
}


static void value_unity_greeter_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_greeter_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_unity_greeter_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_unity_greeter_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityGreeter* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_greeter_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_unity_greeter_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityGreeter** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_greeter_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_unity_greeter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecUnityGreeter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_UNITY_GREETER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_unity_greeter (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNITY_GREETER), NULL);
	return value->data[0].v_pointer;
}


void value_set_unity_greeter (GValue* value, gpointer v_object) {
	UnityGreeter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNITY_GREETER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UNITY_GREETER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_greeter_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_greeter_unref (old);
	}
}


void value_take_unity_greeter (GValue* value, gpointer v_object) {
	UnityGreeter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNITY_GREETER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UNITY_GREETER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_greeter_unref (old);
	}
}


static void unity_greeter_class_init (UnityGreeterClass * klass) {
	unity_greeter_parent_class = g_type_class_peek_parent (klass);
	UNITY_GREETER_CLASS (klass)->finalize = unity_greeter_finalize;
	g_type_class_add_private (klass, sizeof (UnityGreeterPrivate));
}


static void unity_greeter_instance_init (UnityGreeter * self) {
	self->priv = UNITY_GREETER_GET_PRIVATE (self);
	self->priv->prompted = FALSE;
	self->priv->clear_messages = FALSE;
	self->priv->authenticate_user = NULL;
	self->priv->n_test_entries = 0;
	self->priv->test_username = NULL;
	self->priv->test_prompted_sso = FALSE;
	self->priv->test_two_prompts_first = NULL;
	self->priv->test_request_new_password = FALSE;
	self->priv->test_new_password = NULL;
	self->priv->test_is_authenticated = FALSE;
	self->ref_count = 1;
}


static void unity_greeter_finalize (UnityGreeter* obj) {
	UnityGreeter * self;
	self = UNITY_GREETER (obj);
	_g_free0 (self->priv->state_file);
	_g_key_file_free0 (self->priv->state);
	_g_object_unref0 (self->priv->settings_daemon);
	_g_object_unref0 (self->priv->main_window);
	_g_object_unref0 (self->user_list);
	_g_object_unref0 (self->priv->greeter);
	__g_list_free__prompt_unref0_0 (self->priv->active_prompts);
	_g_free0 (self->priv->authenticate_user);
	__g_list_free__g_free0_0 (self->priv->test_backgrounds);
	_g_free0 (self->priv->test_username);
	_g_free0 (self->priv->test_two_prompts_first);
	_g_free0 (self->priv->test_new_password);
	_ca_context_destroy0 (self->priv->canberra_context);
}


GType unity_greeter_get_type (void) {
	static volatile gsize unity_greeter_type_id__volatile = 0;
	if (g_once_init_enter (&unity_greeter_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_unity_greeter_init, value_unity_greeter_free_value, value_unity_greeter_copy_value, value_unity_greeter_peek_pointer, "p", value_unity_greeter_collect_value, "p", value_unity_greeter_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityGreeterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_greeter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityGreeter), 0, (GInstanceInitFunc) unity_greeter_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_greeter_type_id;
		unity_greeter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityGreeter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_greeter_type_id__volatile, unity_greeter_type_id);
	}
	return unity_greeter_type_id__volatile;
}


gpointer unity_greeter_ref (gpointer instance) {
	UnityGreeter* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_greeter_unref (gpointer instance) {
	UnityGreeter* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_GREETER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


Prompt* prompt_construct (GType object_type, const gchar* text, LightDMPromptType type) {
	Prompt* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	LightDMPromptType _tmp2_;
	g_return_val_if_fail (text != NULL, NULL);
	self = (Prompt*) g_type_create_instance (object_type);
	_tmp0_ = text;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->text);
	self->text = _tmp1_;
	_tmp2_ = type;
	self->type = _tmp2_;
	return self;
}


Prompt* prompt_new (const gchar* text, LightDMPromptType type) {
	return prompt_construct (TYPE_PROMPT, text, type);
}


static void value_prompt_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_prompt_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		prompt_unref (value->data[0].v_pointer);
	}
}


static void value_prompt_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = prompt_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_prompt_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_prompt_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Prompt* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = prompt_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_prompt_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Prompt** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = prompt_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_prompt (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPrompt* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PROMPT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_prompt (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROMPT), NULL);
	return value->data[0].v_pointer;
}


void value_set_prompt (GValue* value, gpointer v_object) {
	Prompt* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROMPT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROMPT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		prompt_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		prompt_unref (old);
	}
}


void value_take_prompt (GValue* value, gpointer v_object) {
	Prompt* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROMPT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROMPT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		prompt_unref (old);
	}
}


static void prompt_class_init (PromptClass * klass) {
	prompt_parent_class = g_type_class_peek_parent (klass);
	PROMPT_CLASS (klass)->finalize = prompt_finalize;
}


static void prompt_instance_init (Prompt * self) {
	self->ref_count = 1;
}


static void prompt_finalize (Prompt* obj) {
	Prompt * self;
	self = PROMPT (obj);
	_g_free0 (self->text);
}


GType prompt_get_type (void) {
	static volatile gsize prompt_type_id__volatile = 0;
	if (g_once_init_enter (&prompt_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_prompt_init, value_prompt_free_value, value_prompt_copy_value, value_prompt_peek_pointer, "p", value_prompt_collect_value, "p", value_prompt_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PromptClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prompt_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Prompt), 0, (GInstanceInitFunc) prompt_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType prompt_type_id;
		prompt_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Prompt", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&prompt_type_id__volatile, prompt_type_id);
	}
	return prompt_type_id__volatile;
}


gpointer prompt_ref (gpointer instance) {
	Prompt* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void prompt_unref (gpointer instance) {
	Prompt* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PROMPT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


void test_entry_copy (const TestEntry* self, TestEntry* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	_tmp0_ = (*self).username;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).username);
	(*dest).username = _tmp1_;
	_tmp2_ = (*self).real_name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).real_name);
	(*dest).real_name = _tmp3_;
	_tmp4_ = (*self).background;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).background);
	(*dest).background = _tmp5_;
	_tmp6_ = (*self).layouts;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).layouts);
	(*dest).layouts = _tmp7_;
	_tmp8_ = (*self).is_active;
	(*dest).is_active = _tmp8_;
	_tmp9_ = (*self).has_messages;
	(*dest).has_messages = _tmp9_;
	_tmp10_ = (*self).session;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 ((*dest).session);
	(*dest).session = _tmp11_;
}


void test_entry_destroy (TestEntry* self) {
	_g_free0 ((*self).username);
	_g_free0 ((*self).real_name);
	_g_free0 ((*self).background);
	_g_free0 ((*self).layouts);
	_g_free0 ((*self).session);
}


TestEntry* test_entry_dup (const TestEntry* self) {
	TestEntry* dup;
	dup = g_new0 (TestEntry, 1);
	test_entry_copy (self, dup);
	return dup;
}


void test_entry_free (TestEntry* self) {
	test_entry_destroy (self);
	g_free (self);
}


GType test_entry_get_type (void) {
	static volatile gsize test_entry_type_id__volatile = 0;
	if (g_once_init_enter (&test_entry_type_id__volatile)) {
		GType test_entry_type_id;
		test_entry_type_id = g_boxed_type_register_static ("TestEntry", (GBoxedCopyFunc) test_entry_dup, (GBoxedFreeFunc) test_entry_free);
		g_once_init_leave (&test_entry_type_id__volatile, test_entry_type_id);
	}
	return test_entry_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



