# -*- coding: utf-8 -*-

# Authors: Natalia B. Bidart <natalia.bidart@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""A button that opens links in the web."""

from PyQt4 import QtGui, QtCore

from twisted.internet import defer

from ubuntuone.controlpanel import cache
from ubuntuone.controlpanel.gui import qt, sign_url, UBUNTUONE_LINK


class GoToWebButton(cache.Cache, QtGui.QPushButton):
    """The GoToWebButton widget"""

    def __init__(self, *args, **kwargs):
        """Initialize the UI of the widget."""
        super(GoToWebButton, self).__init__(*args, **kwargs)
        self.uri = None
        self.setIcon(qt.icon_from_name('external_icon_white'))
        self.setLayoutDirection(QtCore.Qt.RightToLeft)
        self.clicked.connect(self.on_clicked)
        self.setCursor(QtGui.QCursor(QtCore.Qt.PointingHandCursor))

    @defer.inlineCallbacks
    @QtCore.pyqtSlot()
    def on_clicked(self):
        """Open self.uri if not None, do nothing otherwise."""
        if self.uri is not None:

            credentials = None
            if self.uri.startswith(UBUNTUONE_LINK):
                credentials = yield self.backend.get_credentials()

            uri = self.uri
            if credentials:
                uri = sign_url(uri, credentials)

            qt.uri_hook(uri)
