# -*- coding: utf-8 -*-

# Authors: Alejandro J. Cura <alecu@canonical.com>
#          Natalia B. Bidart <natalia.bidart@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""The user interface for the control panel for Ubuntu One."""

from twisted.internet import defer

from ubuntuone.controlpanel.logger import setup_logging, log_call
from ubuntuone.controlpanel.gui import (
    EDIT_ACCOUNT_LINK,
    EDIT_PROFILE_LINK,
)
from ubuntuone.controlpanel.gui.qt.ubuntuonebin import UbuntuOneBin
from ubuntuone.controlpanel.gui.qt.ui import account_ui


logger = setup_logging('qt.account')


class AccountPanel(UbuntuOneBin):
    """The Account Tab Panel widget"""

    ui_class = account_ui
    logger = logger

    def _setup(self):
        """Do some extra setupping for the UI."""
        super(AccountPanel, self)._setup()
        self.ui.edit_profile_button.uri = EDIT_PROFILE_LINK
        self.ui.edit_services_button.uri = EDIT_ACCOUNT_LINK

    # pylint: disable=E0202
    @defer.inlineCallbacks
    def load(self):
        """Load info."""
        self.is_processing = True
        info = yield self.backend.account_info()
        self.process_info(info)

    @log_call(logger.debug)
    def process_info(self, info):
        """Process and display the account info."""
        self.ui.name_label.setText(info["name"])
        self.ui.email_label.setText(info["email"])
        self.ui.services_description_label.setText(info["type"])

        self.is_processing = False
