# -*- coding: utf-8 -*-
#
# Copyright 2012 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Tests for the share file widget."""

import os

from PyQt4 import QtGui, QtCore

from ubuntuone.platform import expand_user

from ubuntuone.controlpanel.gui.qt import share_file as gui
from ubuntuone.controlpanel.gui.qt.tests import (
    BaseTestCase,
    FakeDesktopService,
)

# Access to a protected member
# Instance of 'ControlBackend' has no '_called' member
# pylint: disable=W0212, E1103


class ShareFileWidgetTestCase(BaseTestCase):
    """Test the ShareFileWidget class."""

    innerclass_ui = gui.share_file_ui
    innerclass_name = "Ui_Form"
    class_ui = gui.ShareFileWidget
    file_path = u'/home/ñandú/Ubuntu One/my_file.txt'
    kwargs = {'file_path': file_path}
    logger = gui.logger

    def test_init(self):
        """The share file widget initialization."""
        self.assertEqual(self.ui.file_path, self.file_path)
        self.assertEqual(self.ui.ui.lbl_filename.text(),
            os.path.basename(self.file_path))
        self.assertEqual(self.ui.ui.lbl_path.text(), self.file_path)

    def test_open_file(self):
        """Test that open file is called properly."""
        fake_desktop_service = FakeDesktopService()
        self.patch(QtGui, "QDesktopServices", fake_desktop_service)
        self.ui.ui.btn_open.click()

        expected = QtCore.QUrl('file://%s' % self.file_path)
        self.assertEqual(expected, fake_desktop_service.opened_url)

    def test_disable_link(self):
        """Test the disable link action."""
        data = []

        def fake_change_access(path, access):
            """Fake change access type callback."""
            data.append(path)
            data.append(access)

        self.ui.linkDisabled.connect(self._set_called)
        self.patch(self.ui.backend, "change_public_access",
            fake_change_access)
        self.ui.ui.btn_disable.click()

        expected = [expand_user(
            self.file_path.encode('utf-8')).decode('utf-8'), False]
        self.assertEqual(data, expected)
        self.assertEqual(self._called, ((), {}))
