#!/usr/bin/env python
# setup.py - Build system for Ubuntu One Control Panel package
#
# Author: Natalia B. Bidart <natalia.bidart@canonical.com>
#
# Copyright 2010 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Setup.py: build, distribute, clean."""

import os
import sys

try:
    import DistUtilsExtra.auto
except ImportError:
    print >> sys.stderr, 'To build this program you need '\
                         'https://launchpad.net/python-distutils-extra'
    sys.exit(1)
assert DistUtilsExtra.auto.__version__ >= '2.18', \
       'needs DistUtilsExtra.auto >= 2.18'

POT_FILE = 'po/ubuntuone-control-panel.pot'
SERVICE_FILE = 'com.ubuntuone.controlpanel.service'
GUI_SERVICE_FILE = 'com.ubuntuone.controlpanel.gui.service'
MESSAGE_ENTRY = 'ubuntuone-control-panel'
CONSTANTS = 'ubuntuone/controlpanel/constants.py'

CLEANFILES = [
    SERVICE_FILE, GUI_SERVICE_FILE, MESSAGE_ENTRY, CONSTANTS, POT_FILE,
    'MANIFEST']


def replace_prefix(prefix):
    """Replace every '@prefix@' with prefix within 'filename' content."""
    # replace .service file, DATA_DIR constant
    for filename in (SERVICE_FILE, GUI_SERVICE_FILE, MESSAGE_ENTRY, CONSTANTS):
        with open(filename + '.in') as in_file:
            content = in_file.read()
            with open(filename, 'w') as out_file:
                out_file.write(content.replace('@prefix@', prefix))


class ControlPanelInstall(DistUtilsExtra.auto.install_auto):
    """Class to install proper files."""

    def run(self):
        """Do the install.

        Read from *.service.in and generate .service files with reeplacing
        @prefix@ by self.prefix.

        """
        replace_prefix(self.prefix)
        DistUtilsExtra.auto.install_auto.run(self)


class ControlPanelClean(DistUtilsExtra.auto.clean_build_tree):
    """Class to clean up after the build."""

    def run(self):
        """Clean up the built files."""
        for built_file in CLEANFILES:
            if os.path.exists(built_file):
                os.unlink(built_file)

        DistUtilsExtra.auto.clean_build_tree.run(self)


DistUtilsExtra.auto.setup(
    name='ubuntuone-control-panel',
    version='1.0.0',
    license='GPL v3',
    author='Natalia Bidart',
    author_email='natalia.bidart@canonical.com',
    description='Ubuntu One Control Panel',
    long_description='Application to manage a Ubuntu One account. Provides a'\
                     'DBus service to query/modify all the Ubuntu One bits.',
    url='https://launchpad.net/ubuntuone-control-panel',
    packages=[
        'ubuntuone', 'ubuntuone.controlpanel', 'ubuntuone.controlpanel.gtk'],
    extra_path='ubuntuone-control-panel',
    data_files=[
        ('lib/ubuntuone-control-panel',
         ['bin/ubuntuone-control-panel-backend']),
        ('share/dbus-1/services/', [SERVICE_FILE, GUI_SERVICE_FILE]),
        ('share/indicators/messages/applications/', [MESSAGE_ENTRY]),
    ],
    cmdclass={
        'install': ControlPanelInstall,
        'clean': ControlPanelClean,
    },
)
