# ubuntuone.platform.windows.vm_helper- vm helpers for windows.
#
# Author: Guillermo Gonzalez <guillermo.gonzalez@canonical.com>
#
# Copyright 2010 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""vm helpers for windows."""


def create_shares_link(source, dest):
    """Create the shares symlink."""
    # do nothing, we don't have a symlink on windows.
    return False


def get_udf_path_name(path):
    """Return (path, name) from path.

    path must be a path inside the user home direactory, if it's not
    a ValueError is raised.
    """
    # TODO: make this windows compatible, for the moment do the same as
    # linux.
    from ubuntuone.platform.linux import vm_helper
    return vm_helper.get_udf_path_name(path)


def get_udf_path(suggested_path):
    """Build the udf path using the suggested_path."""
    # Unicode boundary! the name is Unicode in protocol and server,
    # but here we use bytes for paths
    from ubuntuone.platform.linux import vm_helper
    return vm_helper.get_udf_path(suggested_path)


def get_share_path(share_name, visible_name):
    """Builds the root path of a share using the share information."""
    # Unicode boundary! the name is Unicode in protocol and server,
    # but here we use bytes for paths
    from ubuntuone.platform.linux import vm_helper
    return vm_helper.get_share_path(share_name, visible_name)


class VMMetadataUpgraderMixIn(object):
    """Mixin for metadata upgrades."""

    def _guess_metadata_version(self):
        """Guess the metadata version based on current metadata and layout.

        Fallbacks to md_version = None if can't guess it.
        """
        md_version = None
        return md_version

    def _upgrade_metadata_None(self, md_version):
        """Handle the case of a maybe broken metadata version file."""
        # as we don't have any previous metadata versions, just update
        # the .version file
        self.update_metadata_version()
