/*
 * ubuntuone-nautilus.c - Nautilus extensions for Ubuntu One
 *
 * Authors: Tim Cole <tim.cole@canonical.com>
 *          Rodney Dawes <rodney.dawes@canonical.com>
 *          Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2009-2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __UBUNTUONE_NAUTILUS_H__
#define __UBUNTUONE_NAUTILUS_H__

#include <dbus/dbus-glib.h>
#include <libsyncdaemon/syncdaemon-daemon.h>
#include <gtk/gtk.h>

#define UBUNTUONE_TYPE_NAUTILUS  (ubuntuone_nautilus_get_type ())
#define UBUNTUONE_NAUTILUS(o)    (G_TYPE_CHECK_INSTANCE_CAST ((o), UBUNTUONE_TYPE_NAUTILUS, UbuntuOneNautilus))

/* Magical struct for passing data in callbacks */
typedef struct _CBData CBData;

typedef struct {
	GObject parent_slot;

	SyncdaemonDaemon * syncdaemon;

	/* Are we connected? */
	gboolean connected;

	/* The managed directory root */
	gchar * managed;

	/* Avoid calling get_rootdir and get_folders lots of times */
	gboolean gotroot;
	gboolean gotudfs;
	gboolean gotpubs;

	/* Lists of ul/dl/shares for setting emblems */
	GHashTable * uploads;
	GHashTable * downloads;
	GHashTable * shares;

	/* Lists of public files and user defined folders */
	GHashTable * public;
	GHashTable * udfs;
  
	/* Lists of sync/unsync'd files */
	GHashTable * updated;
	GHashTable * needsupdating;

	/* List of files that are observed for changes */
	GHashTable * observed;

	/* Extra data we need to free on finalization */
	CBData * cb_data;
} UbuntuOneNautilus;

typedef struct {
	GObjectClass parent_slot;
} UbuntuOneNautilusClass;

struct _CBData {
	UbuntuOneNautilus * uon;
	gchar * path;
	GtkWidget * parent;

	/* Whether to make a file public or private */
	gboolean make_public;
};

GType ubuntuone_nautilus_get_type (void);

/* Utility functions */
gboolean ubuntuone_is_storagefs (UbuntuOneNautilus * uon,
				 const char * path,
				 gboolean * is_root);
gboolean ubuntuone_nautilus_check_shares_and_public_files (UbuntuOneNautilus *uon,
							   SyncdaemonFolderInfo *folder_info,
							   GtkWidget *widget);

void     ubuntuone_show_error_dialog (UbuntuOneNautilus *uon, const gchar *title, const gchar *error_message, ...);

#endif
