/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2009 Canonical Services Ltd (www.canonical.com)
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "u1-contacts-picker.h"

static void
dialog_response_cb (GtkDialog *dialog, gint response_id, gpointer data)
{
	GtkWidget *picker = GTK_WIDGET (data);

	if (response_id == GTK_RESPONSE_OK) {
		GSList *selection, *l;
		GtkWidget *msg_dialog;
		GString *str = NULL;

		selection = u1_contacts_picker_get_selected_emails (U1_CONTACTS_PICKER (picker));
		for (l = selection; l != NULL; l = l->next) {
			if (str == NULL) {
				str = g_string_new ("Selected items:\n\t");
				str = g_string_append (str, (const gchar *) l->data);
			} else {
				str = g_string_append (str, "\n\t");
				str = g_string_append (str, (const gchar *) l->data);
			}
		}

		u1_contacts_picker_free_selection_list (selection);

		/* Display selection to the user */
		if (str != NULL) {
			msg_dialog = gtk_message_dialog_new (GTK_WINDOW (dialog),
							     0,
							     GTK_MESSAGE_INFO,
							     GTK_BUTTONS_OK,
							     "%s", str->str);
			g_string_free (str, FALSE);
		} else {
			msg_dialog = gtk_message_dialog_new (GTK_WINDOW (dialog),
							     0,
							     GTK_MESSAGE_INFO,
							     GTK_BUTTONS_OK,
							     "Nothing has been selected");
		}

		gtk_dialog_run (GTK_DIALOG (msg_dialog));
	}

	gtk_main_quit ();
}

int
main (int argc, char *argv[])
{
	GtkWidget *window, *picker;

	gtk_init (&argc, &argv);
	g_thread_init (NULL);

	/* Create the main window */
	window = gtk_dialog_new_with_buttons ("Test contacts picker",
					      NULL,
					      0,
					      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					      GTK_STOCK_OK, GTK_RESPONSE_OK,
					      NULL);
	gtk_dialog_set_default_response (GTK_DIALOG (window), GTK_RESPONSE_OK);

	picker = u1_contacts_picker_new ();
	gtk_widget_show (picker);
	gtk_box_pack_start (GTK_BOX (gtk_dialog_get_content_area (GTK_DIALOG (window))), picker, TRUE, TRUE, 6);

	g_signal_connect (G_OBJECT (window), "response", G_CALLBACK (dialog_response_cb), picker);
	
	/* Run the application */
	gtk_widget_show (window);
	gtk_widget_set_size_request (window, 400, 250);
	gtk_main ();

	return 0;
}
