<?

	// theme icon list
	global $iconlist;

	/**
	 * Initialize and cleanup debugging functions.
	 */
	function initializeDebug() {
		// clean up the icon list
		global $iconlist;
		$iconlist = array();
		
		// clean existing debug logs
		global $theme;
		unlink($theme.'.html');
	}
	
	/**
	 * Add a single icon to the debug list.
	 */
	function debugIcon($category, $icon, $size, $file) {
		global $iconlist;
		
		// check for duplicates first
		$dupe = false;
		foreach($iconlist as $iconinfo) {
			$iicat = $iconinfo[0];
			$iiicon = $iconinfo[1];
			$iisize = $iconinfo[2];
			$iifile = $iconinfo[3];
			
			if(
				($iicat == $category) && ($iiicon == $icon) &&
				($iisize == $size) && ($iifile == $file)) {
				$dupe = true;
				break;
			}
		}
		
		if(!$dupe) {
			$iconlist[] =
				array($category, $icon, $size, $file);
		}
	}
	
	/**
	 * End debugging, write the log.
	 */
	function finishDebug() {
		// create logfile
		global $theme;
		$fp = fopen($theme.'.html', 'w');
		
		// write header
		$themeuc = ucfirst($theme);
		$title = "Ubuntu Firefox $themeuc Theme";
		fwrite($fp,	"<html><head><title>$title</title>\n");
		fwrite($fp, "<style type='text/css'>\n");
		fwrite($fp, "tr.missing td {background-color: #FCC}\n");
		fwrite($fp, "tr.custom td {background-color: #FF9}\n");
		fwrite($fp, "tr.svg td {background-color: #DDF}\n");
		fwrite($fp, "th, td {font-size: small}\n");
		fwrite($fp, "</style></head>\n");
		fwrite($fp, "<body><h1>$title</h1>\n");
		fwrite($fp, "<h2>Missing and unthemed icons</h2>\n");
		
		// write icon list table header
		fwrite($fp, "<table>\n");
		fwrite($fp, trow(array(
			"Category", "Icon", "Size", "Filename", "Type" 
		), 'th'));
		
		// problem counters
		$unthemedcount = 0;
		$customcount = 0;
		$scalablecount = 0;
		
		// loop through icons
		global $iconlist;
		foreach($iconlist as $iconinfo) {
			$category = $iconinfo[0];
			$icon = $iconinfo[1];
			$size = $iconinfo[2];
			$file = $iconinfo[3];
			
			$issvg = isSvg($file);
			$iscustom = isCustom($file);
			$isthemed = isThemed($file);
			
			$type = $issvg ? "SVG" : "PNG";
			$custom = $iscustom ? "" : "!";

			if($iscustom) {
				$trclass = "custom";
				$customcount++;
			} else if(!$isthemed) {
				$trclass = "missing";
				$unthemedcount++;
			} else if($issvg) {
				$trclass = "svg";
				$scalablecount++;
			} else {
				$trclass = "";				
			}

			if($trclass != "") {
				$tratt = "class=\"$trclass\"";
			} else {
				$tratt = '';
			}
			
			// only write out unthemed icons
			if(!$isthemed || $issvg) {
				fwrite($fp, trow(array(
					$category, $icon, $size, $file, $type
				), 'td', $tratt));
			}
		}
		
		// write icon list table footer		
		fwrite($fp, "</table>\n");
		
		// write summary
		fwrite($fp, "<hr />\n<h2>Build summary</h2>\n");
		fwrite($fp, "$unthemedcount unthemed icon(s) (red)<br />\n");
		fwrite($fp, "$customcount custom icon(s) (yellow)<br />\n");
		fwrite($fp, "$scalablecount possibly fuzzy icon(s) (blue)<br />\n");
		
		// write footer
		$datetime = date("F j, Y, g:i a");
		fwrite($fp, "<hr />\nGenerated on $datetime\n</body></html>");
		fclose($fp);
	}

	/**
	 * Automatically generate HTML table rows.
	 */
	function trow($contents, $tag = 'td', $tratt = '') {
		$result = "";	
	
		foreach($contents as $cell) {
			$result = $result."<$tag>$cell</$tag>";
		}
		
		return "<tr $tratt>$result</tr>\n";
	}
   
?>