
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#ifdef TSCLIENT_DEBUG
#define DEBUG 1
#else
#define DEBUG 0
#endif

#define TSC_WM_COMPLEX 0
#define TSC_WM_COMPACT 1
#define MAX_ARGVS 16
#define MAX_ARGV_LEN 255

#define HOOKUP_OBJECT(component,widget,name) \
  gtk_object_set_data_full (GTK_OBJECT (component), name, \
    gtk_widget_ref (widget), (GtkDestroyNotify) gtk_widget_unref)

/*
 * This function returns a widget in a component created by Glade.
 * Call it with the toplevel widget in the component (i.e. a window/dialog),
 * or alternatively any widget in the component, and the name of the widget
 * you want returned.
 */
GtkWidget* lookup_widget (GtkWidget *widget, const gchar *widget_name);

gchar* find_pixmap_file (const gchar *filename);

/* Use this function to set the directory containing installed pixmaps. */
void add_pixmap_directory (const gchar *directory);

/* This is used to create the pixmaps used in the interface. */
GtkWidget* create_pixmap (GtkWidget *widget, const gchar *filename);

/* This is used to create the pixbufs used in the interface. */
GdkPixbuf* create_pixbuf (const gchar *filename);

GtkWidget *tsc_option_menu_factory (gchar**vmnemonic);

int tsc_check_files ();

gchar *tsc_home_path ();

int tsc_launch_remote (rdp_file *rdp_in, int launch_async);

void tsc_error_message (gchar *message);

void tsc_about_dialog ();

void tsc_quick_pick_activate (GtkMenuItem *menuitem, gpointer user_data);

void tsc_set_protocol_widgets (GtkWidget *main_win, gint protocol);
