#!/usr/bin/python

import dbus
import dbus.service
import dbus.glib
import os
import string
import subprocess
import signal

class SCPObject(dbus.service.Object):

    def __init__(self, bus_name, object_path="/SCPObject"):
        dbus.service.Object.__init__(self, bus_name, object_path)

    @dbus.service.signal("com.ubuntu.StudentControlPanel.Comm", signature="aas")
    def GotSignal(self, message):
        pass

class backend:
	def __init__(self):
		self.plugin_list = []
		system_bus = dbus.SystemBus()
		name = dbus.service.BusName("com.ubuntu.StudentControlPanel", bus=system_bus)
		self.dbus_iface = SCPObject(name)
		self.ssh_command = 'sudo -u pete ssh -l pete -S /tmp/tcm_w00t_socket '

	def open_forever_socket(self, remote):
		return_data_proc = subprocess.Popen([self.ssh_command + remote + ' sudo scp-remote --forever'], shell=True, stdout=subprocess.PIPE)
		

	def poll_userlist(self, ufilter = None, filtering = False, remote = None):
		if remote:
			ulist = []
#			ulist.append(["8540","john","192.168.16.5"])
			ulist.append(["14822","pete","192.168.16.5"])
		else:
	        	"""
            Returns a matrix of pid and user@host for open inbound ssh based LTSP sessions:
            ([pid0], [user0], [host0]), ([pid1], [user1], [host1]), ...)"""

		ulist = []
		listtmp = subprocess.Popen(['ps eaxww|grep "bash --login -c"|grep "LTSP_CLIENT"|grep PPID|grep -v grep'],shell=True, stdout=subprocess.PIPE)
		list = listtmp.stdout.readlines()
		for line in list:
			pidtmp = subprocess.Popen(['grep PPid /proc/'+line.split()[0]+'/status'],shell=True,stdout=subprocess.PIPE)
			pid = pidtmp.stdout.read().split()[1]
			for elem in line.split():
				if elem.startswith('USER='):
					user = elem.lstrip('USER=')
				elif elem.startswith('SSH_CLIENT='):
					host = elem.lstrip('SSH_CLIENT=')
			ulist.append([pid, user, host])
		#return ulist
		"""
	The code below is used to testing on a non LTSP machine, it is used 
	to give false information, pretending the normal logon is a real login,
	the pid is the pid of the ssh-agent process, change it if you like :)
			
			ulist = []
			ulist.append(["8540","john","192.168.16.90"])
			ulist.append(["14822","pete","192.168.16.92"])
		"""

		nulist = []
		if filtering:
			for user in ulist:
				for filt in ufilter:
					if filt == user[1]:
						nulist.append(user)
		else:
			nulist = ulist

		return nulist

	def poll_proclist(self, user, remote = None):
		"""
		return the users procs
		"""
		procs = []
		if remote:
			return_data_proc = subprocess.Popen([self.ssh_command + remote + ' sudo scp-remote --return_process ' + user], shell=True, stdout=subprocess.PIPE)
			return_data = return_data_proc.stdout.readlines()
			for proc in return_data:
				command = proc.split(",")
				procs.append(command)
		else:
			procs = []
			proclisttmp = subprocess.Popen(['ps --no-headers -o pid,cmd:60,%mem,%cpu,nice -U '+user], shell=True, stdout=subprocess.PIPE)
			proclist = proclisttmp.stdout.readlines()
			for proc in proclist:
				comm = proc.rstrip().split()[1]
				if not comm.startswith('ssh') and not comm.startswith('dbus') and not comm.startswith('bash') and not comm.startswith('-') and not comm.startswith('grep') and not comm.startswith('ps') and not comm.startswith('scp'):
					command=proc.rstrip().split()
					command[1]=str(command[1].split('/')[-1])
					command[2]=command[-3]
					command[3]=command[-2]
					command[4]=command[-1]
					procs.append(command)
		return procs

	def get_lock(self, user):
		return "True"

	def kill_process(self, process, user, remote = None):
		if remote:
			return_data_proc = subprocess.Popen([self.ssh_command + remote + ' sudo scp-remote --kill '+process+ ' --users '+user], shell=True, stdout=subprocess.PIPE)
			print return_data_proc.stdout.readlines()
		else:
			listutmp = subprocess.Popen(['ps aux| grep "' + process + '"| grep "' + user + '"| grep -v grep'], shell=True, stdout=subprocess.PIPE)	
			listu = listutmp.stdout.read().split()[1]
			self.dbus_iface.GotSignal([[user],["kill"],[listu]])

	def lockdown_user(self, user, remote = None):
		if remote:
			print "Remote"
		else:
			subprocess.Popen(['sudo', 'pessulus', '-u', user, '-p', 'xml:readwrite:/home/' + user + '/.gconf/', '-m', 
'xml:readwrite:/var/lib/gconf/users/gconf.xml.mandatory/'])

	def lock(self, users, remote = None):
		if remote:
			return_data_proc = subprocess.Popen([self.ssh_command + remote + ' sudo scp-remote --lock --users '+",".join(users)], shell=True, stdout=subprocess.PIPE)
			print return_data_proc.stdout.readlines()
		else:
			self.dbus_iface.GotSignal([users,["lock"]])

	def unlock(self, users, remote = None):
		if remote:
			return_data_proc = subprocess.Popen([self.ssh_command + remote + ' sudo scp-remote --unlock --users '+",".join(users)], shell=True, stdout=subprocess.PIPE)
			print return_data_proc.stdout.readlines()
		else:
			self.dbus_iface.GotSignal([users,["unlock"]])

	def start_process(self, users, command, remote = None):
		if remote:
			return_data_proc = subprocess.Popen([self.ssh_command + remote + ' sudo scp-remote --exec ' + command + ' --users '+",".join(users)], shell=True, stdout=subprocess.PIPE)
			print return_data_proc.stdout.readlines()
		else:
			self.dbus_iface.GotSignal([users,["exec"],[command]])

	def share(self, users, ip, remote = None):
		if remote:
			return_data_proc = subprocess.Popen([self.ssh_command + remote + ' sudo scp-remote --exec "vncviewer -viewonly -passwd /etc/tcmpasswd" --users ' + users[0]], shell=True, stdout=subprocess.PIPE)
		else:
			self.dbus_iface.GotSignal([users,["exec"],["vncviewer "+ip+" -viewonly -passwd /etc/tcmpasswd"]])

	def control(self, users, ip, remote = None):
		True

	def send_message(self, users, message, remote = None):
		if remote:
			return_data_proc = subprocess.Popen([self.ssh_command + remote + ' sudo scp-remote --message ' + message + ' --users '+",".join(users)], shell=True, stdout=subprocess.PIPE)
			print return_data_proc.stdout.readlines()
		else:
			self.dbus_iface.GotSignal([users,["mess"],[message]])

	def logout_pid(self, pid, remote = None):
		if remote:
			return_data_proc = subprocess.Popen([self.ssh_command + remote + ' sudo scp-remote --disconnect ' + pid], shell=True, stdout=subprocess.PIPE)
			print return_data_proc.stdout.readlines()
		else:
			os.kill(pid, signal.SIGKILL)

        def return_config(self):
		try:
			f=open("/usr/share/student-control-panel/users.conf","r")
		except:
			print "Error opening config file, ignoring"
			return {}
		return f.readlines()
		

	def readconfig(self, remote = None):
		if remote:
			return_data_proc = subprocess.Popen([self.ssh_command + remote + ' sudo scp-remote --return_groups'], shell=True, stdout=subprocess.PIPE)
			data = return_data_proc.stdout.readlines()
		else:
			data = self.return_config()
		gdata = {}
		for line in data:
			if line == "\n":
				continue
			if not line.lstrip().startswith("#"):
				line = line.strip("\n")
				if not line.endswith("="):
					group, users = line.strip("\n").split("=")
					group = group.lstrip().rstrip()
					gdata[(group)]=[]
					user_list = users.split(",")
					for user in user_list:
						gdata[(group)].append(user)
				else:
					group = line.strip("=")
					group = group.lstrip().rstrip()
					gdata[(group)]=[]

		return gdata

	def writeconfig(self, gdatas, remote = None):
		if remote:
			return_data_proc = subprocess.Popen([self.ssh_command + remote + ' sudo scp-remote --return_groups'], shell=True, stdout=subprocess.PIPE)
			data = return_data_proc.stdout.readlines()
		else:
			data = self.return_config()
		gdata = gdatas.copy()
		fdata = []
		for line in data:
			if line.lstrip().startswith("#"):
				fdata.append(line)
			elif line == ("\n"):
				fdata.append(line)
			else:				
				line = line.strip("\n")
				if not line.endswith("="):
					group, users = line.strip("\n").split("=")
					group = group.lstrip().rstrip()
				else:
					group = line.strip("=")
					group = group.lstrip().rstrip()
				if gdata.has_key(group):
					fdata.append(group + "=" + ",".join(gdata[(group)])+"\n")
					gdata.pop(group)

		for group in gdata.keys():
			fdata.append(group + "=" + ",".join(gdata[(group)])+"\n")

		if remote:
			return_data_proc = subprocess.Popen([self.ssh_command + remote + ' sudo scp-remote --write_groups'], shell=True, stdout=subprocess.PIPE, stdin=subprocess.PIPE)
			fdata.append("Bl0rk\n")
			return_data_proc.stdin.writelines(fdata)
		else:
			data = self.write_config(fdata)

		return fdata

	def funny_write(self):
		test = ""
		output = []
		while test != ("Bl0rk"):
			output.append(test)
			test = raw_input()
		self.write_config(output)

	def write_config(self, fdata):
		try:
			f=open("/usr/share/student-control-panel/users.conf","w")
		except:
			print "Error opening config file, ignoring"
			return

		f.writelines(fdata)
		f.close()
		
	def check_proc(self, pid):
		if pid in gtop.proclist():
			print True
			return True
		print False
		return False

def check_uid():
	if os.getuid() == 0:
		return True
	return False
